/*
 * $Id:DefaultInputAdapterContext.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister;

import java.util.HashMap;
import java.util.Map;

import net.sf.jame.core.extension.ExtensionConfig;

/**
 * @author Andrea Medeghini
 */
public class DefaultInputAdapterContext implements InputAdapterContext {
	private static final long serialVersionUID = 1L;
	private final Map<String, Object> attributes = new HashMap<String, Object>();
	private final ExtensionConfig config;

	/**
	 * @param config
	 */
	public DefaultInputAdapterContext(final ExtensionConfig config) {
		this.config = config;
	}

	/**
	 * @see net.sf.jame.twister.swing.InputAdapterContext#getFinalConfig()
	 */
	public ExtensionConfig getConfig() {
		return config;
	}

	/**
	 * @see net.sf.jame.twister.swing.InputAdapterContext#setAttribute(java.lang.String, java.lang.Object)
	 */
	public void setAttribute(final String name, final Object value) {
		attributes.put(name, value);
	}

	/**
	 * @see net.sf.jame.twister.swing.InputAdapterContext#getAttribute(java.lang.String)
	 */
	public Object getAttribute(final String name) {
		return attributes.get(name);
	}

	/**
	 * @see net.sf.jame.twister.InputAdapterContext#removeAttribute(java.lang.String)
	 */
	public void removeAttribute(final String name) {
		attributes.remove(name);
	}
}
