/*
 * $Id:SpeedElementXMLImporter.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.common;

import java.util.StringTokenizer;

import net.sf.jame.core.config.ValueConfigElementXMLImporter;
import net.sf.jame.twister.DoubleVector4D;
import net.sf.jame.twister.Speed;

/**
 * @author Andrea Medeghini
 */
public class SpeedElementXMLImporter extends ValueConfigElementXMLImporter<Speed, SpeedElement> {
	/**
	 * @see net.sf.jame.core.config.ValueConfigElementXMLImporter#parseValue(java.lang.String)
	 */
	@Override
	protected Speed parseValue(final String value) {
		final StringTokenizer tknz = new StringTokenizer(value, ";");
		if (tknz.hasMoreTokens()) {
			final DoubleVector4D position = DoubleVector4D.valueOf(tknz.nextToken());
			if (tknz.hasMoreTokens()) {
				final DoubleVector4D rotation = DoubleVector4D.valueOf(tknz.nextToken());
				return new Speed(position, rotation);
			}
		}
		throw new RuntimeException("Invalid format: " + value);
	}

	/**
	 * @see net.sf.jame.core.config.ValueConfigElementXMLImporter#createDefaultConfigElement()
	 */
	@Override
	protected SpeedElement createDefaultConfigElement() {
		return new SpeedElement(new Speed(new DoubleVector4D(0, 0, 100, 1), new DoubleVector4D(0, 0, 100, 0)));
	}
}
