/*
 * $Id:MotionBlurRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.extensions.frame.filter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;

import net.sf.jame.twister.ImageTile;
import net.sf.jame.twister.frame.filter.extension.FrameFilterExtensionRuntime;
import net.sf.jame.twister.renderer.Padding;
import net.sf.jame.twister.renderer.Surface;

/**
 * @author Andrea Medeghini
 */
public class MotionBlurRuntime extends FrameFilterExtensionRuntime<MotionBlurConfig> {
	private final Padding padding = new Padding(0, 0, 0, 0);
	private int alpha;

	/**
	 * @see net.sf.jame.twister.frame.filter.extension.FrameFilterExtensionRuntime#getPadding()
	 */
	@Override
	public Padding getPadding() {
		return padding;
	}

	/**
	 * @see net.sf.jame.twister.frame.filter.extension.FrameFilterExtensionRuntime#renderImage(net.sf.jame.twister.renderer.Surface, net.sf.jame.twister.renderer.Surface, net.sf.jame.twister.renderer.Surface)
	 */
	@Override
	public void renderImage(final Surface src, final Surface dst, final Surface prev) {
		final Graphics2D g2d = dst.getGraphics2D();
		g2d.setComposite(AlphaComposite.SrcOver);
		g2d.drawImage(src.getImage(), 0, 0, null);
		if (alpha > 0) {
			g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha / 100f));
			g2d.drawImage(prev.getImage(), 0, 0, null);
		}
		// g2d.dispose();
	}

	/**
	 * @see net.sf.jame.twister.frame.layer.filter.extension.LayerFilterExtensionRuntime#setTile(net.sf.jame.twister.ImageTile)
	 */
	@Override
	public void setTile(final ImageTile tile) {
	}

	/**
	 * @see net.sf.jame.twister.frame.filter.extension.FrameFilterExtensionRuntime#prepareFilter(boolean)
	 */
	@Override
	public void prepareFilter(final boolean isDynamic) {
		if (isDynamic) {
			alpha = getConfig().getOpacity();
		}
		else {
			if (alpha > 0) {
				alpha -= 1;
			}
		}
		fireChanged();
	}
}
