/*
 * $Id:EffectElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.test.effect;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.test.AbstractConfigurableExtensionConfigElementTest;
import net.sf.jame.twister.TwisterRegistry;
import net.sf.jame.twister.effect.EffectExtensionReferenceNodeValue;
import net.sf.jame.twister.effect.extension.EffectExtensionConfig;
import net.sf.jame.twister.extensions.effect.FireConfig;
import net.sf.jame.twister.extensions.effect.WaterConfig;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElement;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLExporter;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLImporter;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class EffectElementTest extends AbstractConfigurableExtensionConfigElementTest<EffectExtensionConfig> {
	@Override
	protected Node createElementNode() {
		return new ConfigurableExtensionReferenceNode<EffectExtensionConfig>("reference", getConfigElement()) {
			@Override
			protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<EffectExtensionConfig> value) {
				return new EffectExtensionReferenceNodeValue(value);
			}
		};
	}

	@Override
	protected ConfigurableExtensionConfigElement<EffectExtensionConfig> createConfigElement(final ConfigurableExtensionReference<EffectExtensionConfig> defaultValue) {
		final ConfigurableExtensionConfigElement<EffectExtensionConfig> configElement = new ConfigurableExtensionConfigElement<EffectExtensionConfig>();
		configElement.setReference(defaultValue);
		return configElement;
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLExporter<EffectExtensionConfig> createXMLExporter() {
		return new ConfigurableExtensionConfigElementXMLExporter<EffectExtensionConfig>();
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLImporter<EffectExtensionConfig> createXMLImporter() {
		return new ConfigurableExtensionConfigElementXMLImporter<EffectExtensionConfig>(TwisterRegistry.getInstance().getEffectRegistry());
	}

	@Override
	protected ConfigurableExtensionReference<EffectExtensionConfig> getFirstReference() {
		final ConfigurableExtensionReference<EffectExtensionConfig> reference = new ConfigurableExtensionReference<EffectExtensionConfig>("twister.effect.fire", "Fire", new FireConfig());
		return reference;
	}

	@Override
	protected ConfigurableExtensionReference<EffectExtensionConfig> getSecondReference() {
		final ConfigurableExtensionReference<EffectExtensionConfig> reference = new ConfigurableExtensionReference<EffectExtensionConfig>("twister.effect.water", "Water", new WaterConfig());
		return reference;
	}

	@Override
	@Test
	public void testSetReference() {
		super.testSetReference();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}
}
