#include <string>
#include <sstream>
#include <iostream>

using std::cout;
using std::string;
using std::ostringstream;

OSErr GetMyBundleFSRef(FSRefPtr fsRefPtr) 
{
	ProcessSerialNumber currentProcess = { 0, kCurrentProcess }; 
	return GetProcessBundleLocation(&currentProcess, fsRefPtr); 
}   

template <class T>
string ToString(const T &arg) 
{
	ostringstream out;
	out << arg;
	return out.str();
}

int main(int argc, char* argv[])
{
	UInt8 pathName[1024];
	FSRef fsRef; 
    OSErr err;
    err = GetMyBundleFSRef(&fsRef);
	OSStatus status;
	status = FSRefMakePath(&fsRef, pathName, 1024);
	string prefix = ToString("cd \"");
	string suffix = ToString("\"; cd ..; sh JAME.sh");
	string path = ToString(pathName);
	ostringstream out;
	out << prefix;
	out << path;
	out << suffix;
	cout << out.str();	
	system(out.str().c_str());
    return 0;
}
