/*
 * Decompiled with CFR 0.152.
 */
package jaxcentFramework;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import jaxcentFramework.JaxcentClassloader;
import jaxcentFramework.JaxcentConfig;
import jaxcentFramework.JaxcentConnection;
import jaxcentFramework.JaxcentFramework;
import jaxcentFramework.JaxcentUrlInfo;

public class JaxcentContext {
    File configFile;
    long lastmod = -1L;
    String configError = null;
    int conid = 101;
    JaxcentClassloader classLoader = null;
    Hashtable urlMap;
    Method eventMethod;
    Method pageLoadMethod;
    Method pageLoadDoneMethod;
    Method pageUnloadMethod;
    Method responseMethod;
    Method errorMethod;
    Method dataMethod;
    Method onFormDataMethod;
    Method autoFormDataMethod;
    Method onPageRequestMethod;
    JaxcentFramework framework;
    Hashtable connections = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Hashtable;

    public JaxcentContext(File file, JaxcentFramework jaxcentFramework) {
        this.configFile = file;
        this.framework = jaxcentFramework;
        this.refresh();
    }

    public void refresh() {
        if (this.lastmod == this.configFile.lastModified()) {
            return;
        }
        this.lastmod = this.configFile.lastModified();
        JaxcentConfig jaxcentConfig = new JaxcentConfig();
        jaxcentConfig.parseConfigFile(this.configFile);
        this.configError = jaxcentConfig.getConfigError();
        if (this.configError != null) {
            return;
        }
        this.classLoader = new JaxcentClassloader(this.framework.getClassPath(), this.framework.getClassLoader());
        this.urlMap = jaxcentConfig.getUrlmap();
        this.loadClasses();
    }

    boolean displayMessage() {
        return true;
    }

    public String getConfigError() {
        return this.configError;
    }

    public void printUrlMap(StringBuffer stringBuffer) {
        if (this.urlMap == null || this.urlMap.size() == 0) {
            return;
        }
        try {
            stringBuffer.append("Current URL Map\r\n");
            stringBuffer.append("===============\r\n");
            stringBuffer.append("\r\n");
            Enumeration enumeration = this.urlMap.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                JaxcentUrlInfo jaxcentUrlInfo = (JaxcentUrlInfo)this.urlMap.get(string);
                stringBuffer.append("  ");
                stringBuffer.append(jaxcentUrlInfo.path);
                for (n = jaxcentUrlInfo.path.length(); n < 40; ++n) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(' ');
                stringBuffer.append(jaxcentUrlInfo.className);
                if (jaxcentUrlInfo.autoSessionData || jaxcentUrlInfo.useSession) {
                    for (n = jaxcentUrlInfo.className.length(); n < 40; ++n) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(' ');
                    if (jaxcentUrlInfo.autoSessionData) {
                        stringBuffer.append("auto-session-data");
                    } else {
                        stringBuffer.append("use-session");
                    }
                }
                stringBuffer.append("\r\n");
                if (jaxcentUrlInfo.err == null) continue;
                stringBuffer.append("    **** " + jaxcentUrlInfo.err + " ****\r\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JaxcentConnection newConnection(String string, String string2, String string3, Object object, String[] stringArray) {
        int n;
        String string4 = string;
        JaxcentUrlInfo jaxcentUrlInfo = (JaxcentUrlInfo)this.urlMap.get(string = string.trim().toLowerCase());
        if (jaxcentUrlInfo == null && (n = string.indexOf(63)) > 0) {
            string = string.substring(0, n);
            jaxcentUrlInfo = (JaxcentUrlInfo)this.urlMap.get(string);
        }
        if (jaxcentUrlInfo == null) {
            stringArray[0] = "URL " + string + " is not configured in the URL map";
            return null;
        }
        if (jaxcentUrlInfo.cinfo != null && jaxcentUrlInfo.cinfo.classSource != null && jaxcentUrlInfo.cinfo.classSource.lastModified() != jaxcentUrlInfo.cinfo.timestamp || jaxcentUrlInfo.cls == null) {
            this.classLoader = new JaxcentClassloader(this.framework.getClassPath(), this.framework.getClassLoader());
            this.loadClasses();
            jaxcentUrlInfo = (JaxcentUrlInfo)this.urlMap.get(string);
        }
        if (jaxcentUrlInfo.err != null) {
            stringArray[0] = "URL " + string + " Error: " + jaxcentUrlInfo.err;
            return null;
        }
        if (jaxcentUrlInfo.cls == null) {
            stringArray[0] = "No class found for " + string + " in the URL map";
            return null;
        }
        try {
            JaxcentConnection jaxcentConnection = new JaxcentConnection(this, object, jaxcentUrlInfo, string4, string2, string3);
            jaxcentConnection.id = this.newId(jaxcentConnection);
            return jaxcentConnection;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            stringArray[0] = "Error loading Jaxcent Class for " + string + ": " + throwable.toString();
            return null;
        }
    }

    synchronized int newId(JaxcentConnection jaxcentConnection) {
        this.connections.put(new Integer(this.conid), jaxcentConnection);
        return this.conid++;
    }

    public JaxcentConnection getConnection(String string) {
        try {
            return (JaxcentConnection)this.connections.get(Integer.valueOf(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void disconnect(JaxcentConnection jaxcentConnection) {
        jaxcentConnection.onDisconnect();
        this.connections.remove(new Integer(jaxcentConnection.id));
    }

    boolean hasDefaultConstructor(Class clazz) {
        try {
            Constructor constructor = clazz.getConstructor(null);
            return constructor != null && (constructor.getModifiers() & 1) != 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    void loadClasses() {
        Object object;
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass("jaxcent.JaxcentPage");
        }
        catch (Exception exception) {
            this.configError = "Jaxcent Configuration Error: Could not load class \"jaxcent.JaxcentPage\": " + exception.toString();
            return;
        }
        try {
            this.eventMethod = clazz.getDeclaredMethod("onPageEvent", Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String);
            this.pageLoadMethod = clazz.getDeclaredMethod("onPageLoad", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = JaxcentContext.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            this.responseMethod = clazz.getDeclaredMethod("onPageResponse", class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String);
            this.errorMethod = clazz.getDeclaredMethod("onPageError", class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String);
            this.dataMethod = clazz.getDeclaredMethod("onPageData", class$java$lang$Object == null ? (class$java$lang$Object = JaxcentContext.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = JaxcentContext.class$("java.lang.Object")) : class$java$lang$Object, class$java$util$Hashtable == null ? (class$java$util$Hashtable = JaxcentContext.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE, class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String);
            this.pageLoadDoneMethod = clazz.getDeclaredMethod("onPageLoadDone", null);
            this.pageUnloadMethod = clazz.getDeclaredMethod("onPageUnload", null);
            this.onFormDataMethod = clazz.getDeclaredMethod("onFormData", class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String);
            this.autoFormDataMethod = clazz.getDeclaredMethod("autoFormData", class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String, class$java$util$Hashtable == null ? (class$java$util$Hashtable = JaxcentContext.class$("java.util.Hashtable")) : class$java$util$Hashtable);
            this.onPageRequestMethod = clazz.getDeclaredMethod("onPageRequest", class$java$lang$String == null ? (class$java$lang$String = JaxcentContext.class$("java.lang.String")) : class$java$lang$String);
            this.eventMethod.setAccessible(true);
            this.pageLoadMethod.setAccessible(true);
            this.responseMethod.setAccessible(true);
            this.errorMethod.setAccessible(true);
            this.dataMethod.setAccessible(true);
            this.autoFormDataMethod.setAccessible(true);
            this.pageLoadDoneMethod.setAccessible(true);
            this.pageUnloadMethod.setAccessible(true);
            this.onFormDataMethod.setAccessible(true);
            this.onPageRequestMethod.setAccessible(true);
            object = clazz.getDeclaredField("QUERY_TIMEOUT");
            ((Field)object).setAccessible(true);
            ((Field)object).setLong(null, this.framework.getQueryTimeout());
        }
        catch (Throwable throwable) {
            this.configError = "Jaxcent Configuration Error: Class \"jaxcent.JaxcentPage\" is not accessible";
            throwable.printStackTrace();
            return;
        }
        object = this.urlMap.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            JaxcentUrlInfo jaxcentUrlInfo = (JaxcentUrlInfo)this.urlMap.get(string);
            jaxcentUrlInfo.err = null;
            String string2 = jaxcentUrlInfo.className;
            try {
                jaxcentUrlInfo.cls = this.classLoader.loadClass(string2, true);
                jaxcentUrlInfo.cinfo = this.classLoader.getClassInfo(string2);
                if (!clazz.isAssignableFrom(jaxcentUrlInfo.cls)) {
                    jaxcentUrlInfo.err = "Configured class \"" + string2 + "\" is not derived from jaxcent.JaxcentPage";
                    continue;
                }
                if (this.hasDefaultConstructor(jaxcentUrlInfo.cls)) continue;
                jaxcentUrlInfo.err = "Configured class \"" + string2 + "\" does not have a public default constructor (constructor with no args)";
            }
            catch (Throwable throwable) {
                jaxcentUrlInfo.err = "Could not load configured class \"" + string2 + "\": " + throwable.toString();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

