package sample;

import jaxcent.*;
import java.text.*;

/**
  * Jaxcent sample.
  *
  * Responds to JavaScript calls.  Expected calls are "zoom" and "click".
  * This application doesn't do any processing with "zoom" and simply
  * echoes the click to the client.  A mapping application may
  * change the image SRC when the zoom factor approaches various
  * levels, and/or may do specialized processing eg looking up
  * databases, upon clicks.
  */

public class MapSample extends jaxcent.JaxcentPage {

    // All the processing in this class is to handle client messages!

    protected void onJavaScriptRequest(java.lang.String cmd, java.lang.String[] args)
    {
        if ( cmd.equals( "zoom" )) {
            System.out.println( "Current zoom level is " + args[0] );
        } else if ( cmd.equals( "click" )) {
            // Parse the arguments which are floating numbers between 0 - 1
            // specifying the position in map.
            float xpos = Float.parseFloat( args[0] );
            float ypos = Float.parseFloat( args[1] );
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits( 4 );
            showMessageDialog( "Map position: " + numberFormat.format( xpos ) +
                                    ", " + numberFormat.format( ypos ));
        }
    }
}
