/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.internal.ArrayQueue;
import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ArrayNotificationBuffer
implements NotificationBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 1000;
    public static final String BUFFER_SIZE_PROPERTY = "jmx.remote.x.buffer.size";
    private boolean disposed = false;
    private static final HashMap mbsToBuffer = new HashMap(1);
    private final Collection sharers = new HashSet(1);
    private final NotificationListener queryBufferListener = new BufferListener();
    private final NotificationListener creationBufferListener = new BufferListener();
    private static final QueryExp broadcasterQuery = new BroadcasterQuery();
    private static final NotificationFilter creationFilter;
    private final NotificationListener creationListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            logger.debug("creationListener", "handleNotification called");
            ArrayNotificationBuffer.this.createdNotification((MBeanServerNotification)notif);
        }
    };
    private static final ClassLogger logger;
    private static final ObjectName delegateName;
    private final MBeanServer mBeanServer;
    private final ArrayQueue queue;
    private int queueSize;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private boolean destroyed;
    static final String broadcasterClass;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;

    public static synchronized NotificationBuffer getNotificationBuffer(MBeanServer mbs, Map env) {
        int defaultQueueSize = 1000;
        try {
            String s = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ArrayNotificationBuffer.BUFFER_SIZE_PROPERTY);
                }
            });
            if (s != null) {
                defaultQueueSize = Integer.parseInt(s);
            }
        }
        catch (RuntimeException e) {
            logger.warning("ServerNotifForwarder", "Can't use System property jmx.remote.x.buffer.size: " + e);
            logger.debug("ServerNotifForwarder", e);
        }
        int queueSize = defaultQueueSize;
        try {
            queueSize = (int)EnvHelp.getIntegerAttribute(env, BUFFER_SIZE_PROPERTY, defaultQueueSize, 0L, Integer.MAX_VALUE);
        }
        catch (RuntimeException e) {
            logger.warning("ServerNotifForwarder", "Can't determine queuesize (using default): " + e);
            logger.debug("ServerNotifForwarder", e);
        }
        ArrayNotificationBuffer buf = (ArrayNotificationBuffer)mbsToBuffer.get(mbs);
        if (buf == null) {
            buf = new ArrayNotificationBuffer(mbs, queueSize);
            mbsToBuffer.put(mbs, buf);
        }
        ArrayNotificationBuffer arrayNotificationBuffer = buf;
        arrayNotificationBuffer.getClass();
        return arrayNotificationBuffer.new ShareBuffer(queueSize);
    }

    public static synchronized void removeNotificationBuffer(MBeanServer mbs) {
        mbsToBuffer.remove(mbs);
    }

    synchronized void addSharer(ShareBuffer sharer) {
        if (sharer.getSize() > this.queueSize) {
            this.resize(sharer.getSize());
        }
        this.sharers.add(sharer);
    }

    synchronized void removeSharer(ShareBuffer sharer) {
        this.sharers.remove(sharer);
        if (this.sharers.isEmpty()) {
            this.dispose();
        } else {
            int max = 0;
            Iterator it = this.sharers.iterator();
            while (it.hasNext()) {
                ShareBuffer buf = (ShareBuffer)it.next();
                int bufsize = buf.getSize();
                if (bufsize <= max) continue;
                max = bufsize;
            }
            if (max < this.queueSize) {
                this.resize(max);
            }
        }
    }

    private void resize(int newSize) {
        if (newSize == this.queueSize) {
            return;
        }
        while (this.queue.size() > newSize) {
            this.dropNotification();
        }
        this.queue.resize(newSize);
        this.queueSize = newSize;
    }

    private ArrayNotificationBuffer(MBeanServer mbs, int queueSize) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "queueSize=" + queueSize);
        }
        if (mbs == null || queueSize < 1) {
            throw new IllegalArgumentException("Bad args");
        }
        this.mBeanServer = mbs;
        this.queueSize = queueSize;
        this.queue = new ArrayQueue(queueSize);
        this.nextSequenceNumber = this.earliestSequenceNumber = System.currentTimeMillis();
        this.createListeners();
        logger.trace("Constructor", "ends");
    }

    private synchronized boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        logger.trace("dispose", "starts");
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            ArrayNotificationBuffer.removeNotificationBuffer(this.mBeanServer);
            this.disposed = true;
            this.notifyAll();
        }
        this.destroyListeners();
        logger.trace("dispose", "ends");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResult fetchNotifications(Set listeners, long startSequenceNumber, long timeout, int maxNotifications) throws InterruptedException {
        logger.trace("fetchNotifications", "starts");
        if (startSequenceNumber < 0L || this.isDisposed()) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
            }
        }
        if (listeners == null || startSequenceNumber < 0L || timeout < 0L || maxNotifications < 0) {
            logger.trace("fetchNotifications", "Bad args");
            throw new IllegalArgumentException("Bad args to fetch");
        }
        if (logger.debugOn()) {
            logger.trace("fetchNotifications", "listener-length=" + listeners.size() + "; startSeq=" + startSequenceNumber + "; timeout=" + timeout + "; max=" + maxNotifications);
        }
        if (startSequenceNumber > this.nextSequenceNumber()) {
            String msg = "Start sequence number too big: " + startSequenceNumber + " > " + this.nextSequenceNumber();
            logger.trace("fetchNotifications", msg);
            throw new IllegalArgumentException(msg);
        }
        long endTime = System.currentTimeMillis() + timeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "endTime=" + endTime);
        }
        long earliestSeq = -1L;
        long nextSeq = startSequenceNumber;
        ArrayList notifs = new ArrayList();
        while (true) {
            NamedNotification candidate;
            logger.debug("fetchNotifications", "main loop starts");
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                if (earliestSeq < 0L) {
                    earliestSeq = this.earliestSequenceNumber();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "earliestSeq=" + earliestSeq);
                    }
                    if (nextSeq < earliestSeq) {
                        nextSeq = earliestSeq;
                        logger.debug("fetchNotifications", "nextSeq=earliestSeq");
                    }
                } else {
                    earliestSeq = this.earliestSequenceNumber();
                }
                if (nextSeq < earliestSeq) {
                    logger.trace("fetchNotifications", "nextSeq=" + nextSeq + " < " + "earliestSeq=" + earliestSeq + " so may have lost notifs");
                    break;
                }
                if (nextSeq < this.nextSequenceNumber()) {
                    candidate = this.notificationAt(nextSeq);
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "candidate: " + candidate);
                        logger.debug("fetchNotifications", "nextSeq now " + nextSeq);
                    }
                } else {
                    if (notifs.size() > 0) {
                        logger.debug("fetchNotifications", "no more notifs but have some so don't wait");
                        break;
                    }
                    long toWait = endTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        logger.debug("fetchNotifications", "timeout");
                        break;
                    }
                    if (this.isDisposed()) {
                        if (logger.debugOn()) {
                            logger.debug("fetchNotifications", "dispose callled, no wait");
                        }
                        return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
                    }
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "wait(" + toWait + ")");
                    }
                    this.wait(toWait);
                    continue;
                }
            }
            ObjectName name = candidate.getObjectName();
            Notification notif = candidate.getNotification();
            ArrayList<TargetedNotification> matchedNotifs = new ArrayList<TargetedNotification>();
            logger.debug("fetchNotifications", "applying filters to candidate");
            Set set = listeners;
            synchronized (set) {
                Iterator it = listeners.iterator();
                while (it.hasNext()) {
                    ListenerInfo li = (ListenerInfo)it.next();
                    ObjectName pattern = li.getObjectName();
                    NotificationFilter filter = li.getNotificationFilter();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "pattern=<" + pattern + ">; filter=" + filter);
                    }
                    if (!pattern.apply(name)) continue;
                    logger.debug("fetchNotifications", "pattern matches");
                    if (filter != null && !filter.isNotificationEnabled(notif)) continue;
                    logger.debug("fetchNotifications", "filter matches");
                    Integer listenerID = li.getListenerID();
                    TargetedNotification tn = new TargetedNotification(notif, listenerID);
                    matchedNotifs.add(tn);
                }
            }
            if (matchedNotifs.size() > 0) {
                if (maxNotifications <= 0) {
                    logger.debug("fetchNotifications", "reached maxNotifications");
                    break;
                }
                --maxNotifications;
                if (logger.debugOn()) {
                    logger.debug("fetchNotifications", "add: " + matchedNotifs);
                }
                notifs.addAll(matchedNotifs);
            }
            ++nextSeq;
        }
        int nnotifs = notifs.size();
        TargetedNotification[] resultNotifs = new TargetedNotification[nnotifs];
        notifs.toArray(resultNotifs);
        NotificationResult nr = new NotificationResult(earliestSeq, nextSeq, resultNotifs);
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", nr.toString());
        }
        logger.trace("fetchNotifications", "ends");
        return nr;
    }

    synchronized long earliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    synchronized long nextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    synchronized void addNotification(NamedNotification notif) {
        if (logger.traceOn()) {
            logger.trace("addNotification", notif.toString());
        }
        while (this.queue.size() >= this.queueSize) {
            this.dropNotification();
            if (!logger.debugOn()) continue;
            logger.debug("addNotification", "dropped oldest notif, earliestSeq=" + this.earliestSequenceNumber);
        }
        this.queue.add(notif);
        ++this.nextSequenceNumber;
        if (logger.debugOn()) {
            logger.debug("addNotification", "nextSeq=" + this.nextSequenceNumber);
        }
        this.notifyAll();
    }

    private void dropNotification() {
        this.queue.remove(0);
        ++this.earliestSequenceNumber;
    }

    synchronized NamedNotification notificationAt(long seqNo) {
        long index = seqNo - this.earliestSequenceNumber;
        if (index < 0L || index > Integer.MAX_VALUE) {
            String msg = "Bad sequence number: " + seqNo + " (earliest " + this.earliestSequenceNumber + ")";
            logger.trace("notificationAt", msg);
            throw new IllegalArgumentException(msg);
        }
        return (NamedNotification)this.queue.get((int)index);
    }

    private synchronized void createListeners() {
        Set names;
        logger.debug("createListeners", "starts");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(delegateName, ArrayNotificationBuffer.this.creationListener, creationFilter, null);
                    return null;
                }
            });
            logger.debug("createListeners", "added creationListener");
        }
        catch (Exception pe) {
            Exception e = ArrayNotificationBuffer.extractException(pe);
            String msg = "Can't add listener to MBean server delegate: ";
            IllegalArgumentException re = new IllegalArgumentException("Can't add listener to MBean server delegate: " + e);
            EnvHelp.initCause(re, e);
            logger.fine("createListeners", "Can't add listener to MBean server delegate: " + e);
            logger.debug("createListeners", e);
            throw re;
        }
        try {
            names = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ArrayNotificationBuffer.this.mBeanServer.queryNames(null, broadcasterQuery);
                }
            });
        }
        catch (RuntimeException e) {
            logger.fine("createListeners", "Failed to query names: " + e);
            logger.debug("createListeners", e);
            throw e;
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            this.addBufferListener(name, this.queryBufferListener);
        }
        logger.debug("createListeners", "ends");
    }

    private void addBufferListener(final ObjectName name, final NotificationListener bufferListener) {
        if (logger.debugOn()) {
            logger.debug("addBufferListener", "" + name);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(name, bufferListener, null, (Object)name);
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.trace("addBufferListener", ArrayNotificationBuffer.extractException(e));
        }
    }

    private synchronized void createdNotification(MBeanServerNotification n) {
        if (this.destroyed) {
            logger.trace("createNotification", "NotificationBuffer was destroyed");
            return;
        }
        String shouldEqual = "JMX.mbean.registered";
        if (!n.getType().equals("JMX.mbean.registered")) {
            logger.warning("createNotification", "bad type: " + n.getType());
            return;
        }
        final ObjectName name = n.getMBeanName();
        if (logger.debugOn()) {
            logger.debug("createdNotification", "for: " + name);
        }
        try {
            Boolean instanceOf = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return new Boolean(ArrayNotificationBuffer.this.mBeanServer.isInstanceOf(name, broadcasterClass));
                }
            });
            if (!instanceOf.booleanValue()) {
                logger.debug("createdNotification", "not a NotificationBroadcaster");
                return;
            }
        }
        catch (Exception e) {
            logger.trace("createdNotification", ArrayNotificationBuffer.extractException(e));
            return;
        }
        this.addBufferListener(name, this.creationBufferListener);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException, ListenerNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(name, ArrayNotificationBuffer.this.queryBufferListener);
                    return null;
                }
            });
            logger.trace("createdNotification", "remove queryBufferListener worked!");
        }
        catch (PrivilegedActionException pe) {
            Exception e = ArrayNotificationBuffer.extractException(pe);
            if (e instanceof ListenerNotFoundException) {
                logger.debug("createdNotification", "remove queryBufferListener got ListenerNotFoundException as expected");
            }
            logger.trace("createdNotification", e);
        }
    }

    private synchronized void destroyListeners() {
        logger.debug("destroyListeners", "starts");
        this.destroyed = true;
        Set names = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ArrayNotificationBuffer.this.mBeanServer.queryNames(null, broadcasterQuery);
            }
        });
        Iterator it = names.iterator();
        while (it.hasNext()) {
            final ObjectName name = (ObjectName)it.next();
            if (logger.debugOn()) {
                logger.debug("destroyListeners", "remove listener from " + name);
            }
            for (int i = 0; i < 2; ++i) {
                boolean creation = i == 0;
                final NotificationListener listener = creation ? this.creationBufferListener : this.queryBufferListener;
                String what = creation ? "creationBufferListener" : "queryBufferListener";
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws InstanceNotFoundException, ListenerNotFoundException {
                            ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(name, listener);
                            return null;
                        }
                    });
                    if (!logger.debugOn()) continue;
                    logger.debug("destroyListeners", "removed " + what);
                    continue;
                }
                catch (PrivilegedActionException pe) {
                    Exception e = ArrayNotificationBuffer.extractException(pe);
                    if (e instanceof ListenerNotFoundException) {
                        if (!logger.debugOn()) continue;
                        logger.debug("destroyListeners", "ListenerNotFoundException for " + what + " (normal)");
                        continue;
                    }
                    logger.trace("destroyListeners", e);
                }
            }
        }
        logger.debug("destroyListeners", "ends");
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("JMX.mbean.registered");
        creationFilter = nfs;
        logger = new ClassLogger("javax.management.remote.misc", "ArrayNotificationBuffer");
        try {
            delegateName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            RuntimeException re = new RuntimeException("Can't create delegate name: " + e);
            EnvHelp.initCause(re, e);
            logger.error("<init>", "Can't create delegate name: " + e);
            logger.debug("<init>", e);
            throw re;
        }
        broadcasterClass = (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = ArrayNotificationBuffer.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName();
    }

    private static class BroadcasterQuery
    extends QueryEval
    implements QueryExp {
        private BroadcasterQuery() {
        }

        public boolean apply(ObjectName name) {
            MBeanServer mbs = QueryEval.getMBeanServer();
            try {
                Boolean isBroadcaster = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(this, mbs, name){
                    private final /* synthetic */ MBeanServer val$mbs;
                    private final /* synthetic */ ObjectName val$name;
                    private final /* synthetic */ BroadcasterQuery this$0;
                    {
                        this.this$0 = this$0;
                        this.val$mbs = val$mbs;
                        this.val$name = val$name;
                    }

                    public Object run() throws InstanceNotFoundException {
                        return new Boolean(this.val$mbs.isInstanceOf(this.val$name, broadcasterClass));
                    }
                });
                if (logger.debugOn()) {
                    logger.debug("BroadcasterQuery", name + " -> " + isBroadcaster);
                }
                return isBroadcaster;
            }
            catch (PrivilegedActionException pe) {
                logger.debug("BroadcasterQuery", ArrayNotificationBuffer.extractException(pe));
                return false;
            }
        }
    }

    private class BufferListener
    implements NotificationListener {
        private BufferListener() {
        }

        public void handleNotification(Notification notif, Object handback) {
            if (logger.debugOn()) {
                logger.debug("BufferListener.handleNotification", "notif=" + notif + "; handback=" + handback);
            }
            ObjectName name = (ObjectName)handback;
            ArrayNotificationBuffer.this.addNotification(new NamedNotification(name, notif));
        }
    }

    private static class NamedNotification {
        private final ObjectName sender;
        private final Notification notification;

        NamedNotification(ObjectName sender, Notification notif) {
            this.sender = sender;
            this.notification = notif;
        }

        ObjectName getObjectName() {
            return this.sender;
        }

        Notification getNotification() {
            return this.notification;
        }

        public String toString() {
            return "NamedNotification(" + this.sender + ", " + this.notification + ")";
        }
    }

    private class ShareBuffer
    implements NotificationBuffer {
        private final int size;

        ShareBuffer(int size) {
            this.size = size;
            ArrayNotificationBuffer.this.addSharer(this);
        }

        public NotificationResult fetchNotifications(Set listeners, long startSequenceNumber, long timeout, int maxNotifications) throws InterruptedException {
            ArrayNotificationBuffer buf = ArrayNotificationBuffer.this;
            return buf.fetchNotifications(listeners, startSequenceNumber, timeout, maxNotifications);
        }

        public void dispose() {
            ArrayNotificationBuffer.this.removeSharer(this);
        }

        int getSize() {
            return this.size;
        }
    }
}

