/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ArrayNotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.security.JMXPasswordAuthenticator;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;

public abstract class RMIServerImpl
implements RMIServer {
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIServerImpl");
    private final List clientList = new ArrayList();
    private ClassLoader cl;
    private MBeanServer mbeanServer;
    private final Map env;
    private RMIConnectorServer connServer;
    private static int connectionIdNumber;
    private NotificationBuffer notifBuffer;

    public RMIServerImpl(Map env) {
        Map map = this.env = env == null ? Collections.EMPTY_MAP : env;
        if (logger.debugOn()) {
            logger.trace("RMIServerImpl", "class=" + this.getClass().getName());
        }
    }

    void setRMIConnectorServer(RMIConnectorServer connServer) throws IOException {
        this.connServer = connServer;
    }

    protected abstract void export() throws IOException;

    public abstract Remote toStub() throws IOException;

    public synchronized void setDefaultClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public synchronized ClassLoader getDefaultClassLoader() {
        return this.cl;
    }

    public synchronized void setMBeanServer(MBeanServer mbs) {
        this.mbeanServer = mbs;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getVersion() {
        return "1.0 jmxremote-1_0_1_03-jdmk-5_1-FCS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIConnection newClient(Object credentials) throws IOException {
        String passwordFile;
        boolean tracing = logger.traceOn();
        if (tracing) {
            logger.trace("newClient", "making new client");
        }
        if (this.getMBeanServer() == null) {
            throw new IllegalStateException("Not attached to an MBean server");
        }
        Subject subject = null;
        JMXAuthenticator authenticator = (JMXAuthenticator)this.env.get("jmx.remote.authenticator");
        if (authenticator == null && (passwordFile = (String)this.env.get("jmx.remote.x.password.file")) != null) {
            authenticator = new JMXPasswordAuthenticator(passwordFile);
        }
        if (authenticator != null) {
            if (tracing) {
                logger.trace("newClient", "got authenticator: " + authenticator.getClass().getName());
            }
            try {
                subject = authenticator.authenticate(credentials);
            }
            catch (SecurityException e) {
                logger.trace("newClient", "Authentication failed: " + e);
                throw e;
            }
        }
        if (tracing) {
            if (subject != null) {
                logger.trace("newClient", "subject is not null");
            } else {
                logger.trace("newClient", "no subject");
            }
        }
        String connectionId = RMIServerImpl.makeConnectionId(this.getProtocol(), subject);
        if (tracing) {
            logger.trace("newClient", "making new connection: " + connectionId);
        }
        RMIConnection client = this.makeClient(connectionId, subject);
        this.connServer.connectionOpened(connectionId, "Connection opened", null);
        this.dropDeadReferences();
        WeakReference<RMIConnection> wr = new WeakReference<RMIConnection>(client);
        List list = this.clientList;
        synchronized (list) {
            this.clientList.add(wr);
        }
        if (tracing) {
            logger.trace("newClient", "new connection done: " + connectionId);
        }
        return client;
    }

    protected abstract RMIConnection makeClient(String var1, Subject var2) throws IOException;

    protected abstract void closeClient(RMIConnection var1) throws IOException;

    protected abstract String getProtocol();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientClosed(RMIConnection client) throws IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.trace("clientClosed", "client=" + client);
        }
        if (client == null) {
            throw new NullPointerException("Null client");
        }
        List list = this.clientList;
        synchronized (list) {
            this.dropDeadReferences();
            Iterator it = this.clientList.iterator();
            while (it.hasNext()) {
                WeakReference wr = (WeakReference)it.next();
                if (wr.get() != client) continue;
                it.remove();
                break;
            }
        }
        if (debug) {
            logger.trace("clientClosed", "closing client.");
        }
        this.closeClient(client);
        if (debug) {
            logger.trace("clientClosed", "sending notif");
        }
        this.connServer.connectionClosed(client.getConnectionId(), "Client connection closed", null);
        if (debug) {
            logger.trace("clientClosed", "done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        boolean tracing = logger.traceOn();
        boolean debug = logger.debugOn();
        if (tracing) {
            logger.trace("close", "closing");
        }
        IOException ioException = null;
        try {
            if (debug) {
                logger.debug("close", "closing Server");
            }
            this.closeServer();
        }
        catch (IOException e) {
            if (tracing) {
                logger.trace("close", "Failed to close server: " + e);
            }
            if (debug) {
                logger.debug("close", e);
            }
            ioException = e;
        }
        if (debug) {
            logger.debug("close", "closing Clients");
        }
        while (true) {
            List list = this.clientList;
            synchronized (list) {
                if (debug) {
                    logger.debug("close", "droping dead references");
                }
                this.dropDeadReferences();
                if (debug) {
                    logger.debug("close", "client count: " + this.clientList.size());
                }
                if (this.clientList.size() == 0) {
                    break;
                }
                Iterator it = this.clientList.iterator();
                while (it.hasNext()) {
                    WeakReference wr = (WeakReference)it.next();
                    RMIConnection client = (RMIConnection)wr.get();
                    it.remove();
                    if (client == null) continue;
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        if (tracing) {
                            logger.trace("close", "Failed to close client: " + e);
                        }
                        if (debug) {
                            logger.debug("close", e);
                        }
                        if (ioException != null) break;
                        ioException = e;
                    }
                    break;
                }
            }
        }
        if (this.notifBuffer != null) {
            this.notifBuffer.dispose();
        }
        if (ioException != null) {
            if (tracing) {
                logger.trace("close", "close failed.");
            }
            throw ioException;
        }
        if (tracing) {
            logger.trace("close", "closed.");
        }
    }

    protected abstract void closeServer() throws IOException;

    private static synchronized String makeConnectionId(String protocol, Subject subject) {
        ++connectionIdNumber;
        String clientHost = "";
        try {
            clientHost = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException e) {
            logger.trace("makeConnectionId", "getClientHost", e);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(protocol).append(":");
        if (clientHost.length() > 0) {
            buf.append("//").append(clientHost);
        }
        buf.append(" ");
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            String sep = "";
            Iterator<Principal> it = principals.iterator();
            while (it.hasNext()) {
                Principal p = it.next();
                String name = p.getName().replace(' ', '_').replace(';', ':');
                buf.append(sep).append(name);
                sep = ";";
            }
        }
        buf.append(" ").append(connectionIdNumber);
        if (logger.traceOn()) {
            logger.trace("newConnectionId", "connectionId=" + buf);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDeadReferences() {
        List list = this.clientList;
        synchronized (list) {
            Iterator it = this.clientList.iterator();
            while (it.hasNext()) {
                WeakReference wr = (WeakReference)it.next();
                if (wr.get() != null) continue;
                it.remove();
            }
        }
    }

    synchronized NotificationBuffer getNotifBuffer() {
        if (this.notifBuffer == null) {
            this.notifBuffer = ArrayNotificationBuffer.getNotificationBuffer(this.mbeanServer, this.env);
        }
        return this.notifBuffer;
    }
}

