/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.examples.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Box;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public class BalloonManager {
    private static boolean useDropShadow() {
        return WindowUtils.isWindowAlphaSupported() && !System.getProperty("os.name").startsWith("Mac");
    }

    public static Popup getBalloon(Component owner, final Component content, int x, int y) {
        final Point origin = owner == null ? new Point(0, 0) : (owner.isShowing() ? owner.getLocationOnScreen() : owner.getLocation());
        final Window parent = owner != null ? SwingUtilities.getWindowAncestor(owner) : null;
        origin.translate(x, y);
        return new Popup(){
            private BubbleWindow w;

            public void show() {
                this.w = new BubbleWindow(parent, content);
                this.w.pack();
                Point where = new Point(origin);
                where.translate(-this.w.getWidth() / 3, -this.w.getHeight());
                this.w.setAnchorLocation(where.x, where.y);
                this.w.setVisible(true);
            }

            public void hide() {
                this.w.setVisible(false);
                this.w.dispose();
            }
        };
    }

    private static final class BubbleWindow
    extends JWindow {
        private final int Y_OFFSET = 50;
        private final int ARC = 25;
        private Point offset;
        private Area mask;
        private Dimension maskSize;
        private ComponentListener moveTracker = new ComponentAdapter(this){
            private final /* synthetic */ BubbleWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void componentMoved(ComponentEvent e) {
                Point where = e.getComponent().isShowing() ? e.getComponent().getLocationOnScreen() : e.getComponent().getLocation();
                this.this$0.setLocation(where.x - BubbleWindow.access$300((BubbleWindow)this.this$0).x, where.y - BubbleWindow.access$300((BubbleWindow)this.this$0).y);
            }
        };

        public BubbleWindow(Window owner, Component content) {
            super(owner);
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
            this.getContentPane().setBackground(Color.white);
            this.getContentPane().add(content, "Center");
            this.getContentPane().add(Box.createVerticalStrut(50), "South");
            owner.addComponentListener(this.moveTracker);
            this.setSize(this.getPreferredSize());
            this.mask = new Area(this.getMask(this.getWidth(), this.getHeight()));
            this.maskSize = this.getSize();
            WindowUtils.setWindowMask((Window)this, this.mask);
            if (BalloonManager.useDropShadow()) {
                new DropShadow((Window)this, this.mask);
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            Dimension size = new Dimension(w, h);
            if (this.mask != null && !size.equals(this.maskSize)) {
                this.mask.subtract(this.mask);
                this.mask.add(new Area(this.getMask(w, h)));
                this.maskSize = size;
            }
        }

        public void setAnchorLocation(int x, int y) {
            super.setLocation(x, y);
            Window owner = this.getOwner();
            if (owner != null) {
                Point ref = owner.isShowing() ? owner.getLocationOnScreen() : owner.getLocation();
                this.offset = new Point(ref.x - x, ref.y - y);
            }
        }

        public void dispose() {
            super.dispose();
            this.getOwner().removeComponentListener(this.moveTracker);
        }

        private Shape getMask(int w, int h) {
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(0.0f, 0.0f, w, h - 50, 25.0f, 25.0f);
            Area area = new Area(shape);
            GeneralPath path = new GeneralPath();
            path.moveTo(w / 3, h - 1);
            path.lineTo(w / 2, h - 1 - 50);
            path.lineTo(w * 2 / 3, h - 1 - 50);
            path.closePath();
            area.add(new Area(path));
            return area;
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height += 50;
            return size;
        }

        static /* synthetic */ Point access$300(BubbleWindow x0) {
            return x0.offset;
        }
    }

    private static class DropShadow
    extends JWindow {
        private static final float SHADOW_ALPHA = 0.25f;
        private static final float YSCALE = 0.8f;
        private static final double ANGLE = 0.2617993877991494;
        private static final Point OFFSET = new Point(8, 8);
        private static final Color COLOR = new Color(0, 0, 0, 50);
        private Shape parentMask;
        private ComponentListener listener;

        public DropShadow(Window parent, Shape mask) {
            super(parent);
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
            Point where = parent.isShowing() ? parent.getLocationOnScreen() : parent.getLocation();
            this.setLocation(where.x + DropShadow.OFFSET.x, where.y + DropShadow.OFFSET.y);
            this.setBackground(COLOR);
            this.getContentPane().setBackground(COLOR);
            this.parentMask = mask;
            this.listener = new ComponentAdapter(this){
                private final /* synthetic */ DropShadow this$0;
                {
                    this.this$0 = this$0;
                }

                public void componentMoved(ComponentEvent e) {
                    Point where = this.this$0.getOwner().isShowing() ? this.this$0.getOwner().getLocationOnScreen() : this.this$0.getOwner().getLocation();
                    this.this$0.setLocation(where.x + DropShadow.access$000().x, where.y + DropShadow.access$000().y);
                }

                public void componentResized(ComponentEvent e) {
                    Component c = e.getComponent();
                    int extra = c.getWidth() + (int)Math.sin(0.2617993877991494) * c.getHeight();
                    this.this$0.setSize(c.getWidth() + extra, c.getHeight());
                    WindowUtils.setWindowMask((Window)this.this$0, DropShadow.access$100(this.this$0));
                }

                public void componentShown(ComponentEvent e) {
                    if (!this.this$0.isVisible()) {
                        this.this$0.pack();
                        this.this$0.setVisible(true);
                    }
                }
            };
            parent.addComponentListener(this.listener);
            this.addWindowListener(new WindowAdapter(this, parent){
                private final /* synthetic */ Window val$parent;
                private final /* synthetic */ DropShadow this$0;
                {
                    this.this$0 = this$0;
                    this.val$parent = val$parent;
                }

                public void windowClosed(WindowEvent e) {
                    if (DropShadow.access$200(this.this$0) != null) {
                        this.val$parent.removeComponentListener(DropShadow.access$200(this.this$0));
                        DropShadow.access$202(this.this$0, null);
                    }
                }
            });
            WindowUtils.setWindowMask((Window)this, this.getMask());
            WindowUtils.setWindowAlpha(this, 0.25f);
            if (parent.isVisible()) {
                this.pack();
                this.setVisible(true);
            }
        }

        public void paint(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics.create();
            g.setPaint(new GradientPaint(0.0f, this.getHeight() / 2, new Color(0, 0, 0, 0), this.getWidth(), this.getHeight() / 2, new Color(0, 0, 0, 255)));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.dispose();
        }

        public Dimension getPreferredSize() {
            Dimension size = this.getOwner().getPreferredSize();
            size.width += 100;
            size.height += 100;
            return size;
        }

        private Shape getMask() {
            Area area = new Area(this.parentMask);
            Area clip = new Area(this.parentMask);
            AffineTransform tx = new AffineTransform();
            tx.translate(Math.sin(0.2617993877991494) * (double)this.getOwner().getHeight(), 0.0);
            tx.shear(-Math.tan(0.2617993877991494), 0.0);
            tx.scale(1.0, 0.8f);
            tx.translate(0.0, 0.19999999f * (float)this.getOwner().getHeight());
            area.transform(tx);
            tx = new AffineTransform();
            tx.translate(-DropShadow.OFFSET.x, -DropShadow.OFFSET.y);
            clip.transform(tx);
            area.subtract(clip);
            return area;
        }

        static /* synthetic */ Point access$000() {
            return OFFSET;
        }

        static /* synthetic */ Shape access$100(DropShadow x0) {
            return x0.getMask();
        }

        static /* synthetic */ ComponentListener access$200(DropShadow x0) {
            return x0.listener;
        }

        static /* synthetic */ ComponentListener access$202(DropShadow x0, ComponentListener x1) {
            x0.listener = x1;
            return x0.listener;
        }
    }
}

