/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.examples.RasterRangesUtils;
import com.sun.jna.examples.WindowUtils;
import com.sun.jna.examples.unix.X11;
import com.sun.jna.examples.win32.GDI32;
import com.sun.jna.examples.win32.User32;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WindowUtils {
    public static boolean doPaint;
    private static final String TRANSPARENT_OLD_BG = "transparent-old-bg";
    private static final String TRANSPARENT_OLD_OPAQUE = "transparent-old-opaque";
    private static final String TRANSPARENT_ALPHA = "transparent-alpha";
    public static final Shape MASK_NONE;

    public static void whenDisplayable(Window w, final Runnable action) {
        if (w.isDisplayable() && (!Holder.requiresVisible || w.isVisible())) {
            action.run();
        } else if (Holder.requiresVisible) {
            w.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    e.getWindow().removeWindowListener(this);
                    action.run();
                }

                public void windowClosed(WindowEvent e) {
                    e.getWindow().removeWindowListener(this);
                }
            });
        } else {
            w.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L && e.getComponent().isDisplayable()) {
                        e.getComponent().removeHierarchyListener(this);
                        action.run();
                    }
                }
            });
        }
    }

    private static NativeWindowUtils getInstance() {
        return Holder.INSTANCE;
    }

    public static void setWindowMask(Window w, Shape mask) {
        WindowUtils.getInstance().setWindowMask(w, mask);
    }

    public static void setWindowMask(Window w, Icon mask) {
        WindowUtils.getInstance().setWindowMask(w, mask);
    }

    public static boolean isWindowAlphaSupported() {
        return WindowUtils.getInstance().isWindowAlphaSupported();
    }

    public static GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        return WindowUtils.getInstance().getAlphaCompatibleGraphicsConfiguration();
    }

    public static void setWindowAlpha(Window w, float alpha) {
        WindowUtils.getInstance().setWindowAlpha(w, Math.max(0.0f, Math.min(alpha, 1.0f)));
    }

    public static void setWindowTransparent(Window w, boolean transparent) {
        WindowUtils.getInstance().setWindowTransparent(w, transparent);
    }

    static {
        MASK_NONE = null;
    }

    private static class X11WindowUtils
    extends NativeWindowUtils {
        private boolean didCheck;
        private int[] alphaVisuals = new int[0];
        private static final long OPAQUE = 0xFFFFFFFFL;
        private static final String OPACITY = "_NET_WM_WINDOW_OPACITY";

        private X11WindowUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int createBitmap(Pointer dpy, int win, Window w, Raster raster) {
            X11 x11 = X11.INSTANCE;
            Rectangle bounds = raster.getBounds();
            int width = bounds.x + bounds.width;
            int height = bounds.y + bounds.height;
            int pm = x11.XCreatePixmap(dpy, win, width, height, 1);
            Pointer gc = x11.XCreateGC(dpy, pm, 0, null);
            if (gc == null) {
                return 0;
            }
            x11.XSetForeground(dpy, gc, 0);
            x11.XFillRectangle(dpy, pm, gc, 0, 0, width, height);
            boolean UNMASKED = true;
            x11.XSetForeground(dpy, gc, 1);
            X11.XWindowAttributes atts = new X11.XWindowAttributes();
            int status = x11.XGetWindowAttributes(dpy, win, atts);
            if (status == 0) {
                return 0;
            }
            try {
                RasterRangesUtils.outputOccupiedRanges(raster, new RasterRangesUtils.RangesOutput(this, x11, dpy, pm, gc){
                    private final /* synthetic */ X11 val$x11;
                    private final /* synthetic */ Pointer val$dpy;
                    private final /* synthetic */ int val$pm;
                    private final /* synthetic */ Pointer val$gc;
                    private final /* synthetic */ X11WindowUtils this$0;
                    {
                        this.this$0 = this$0;
                        this.val$x11 = val$x11;
                        this.val$dpy = val$dpy;
                        this.val$pm = val$pm;
                        this.val$gc = val$gc;
                    }

                    public boolean outputRange(int x, int y, int w, int h) {
                        return this.val$x11.XFillRectangle(this.val$dpy, this.val$pm, this.val$gc, x, y, w, h) != 0;
                    }
                });
            }
            finally {
                x11.XFreeGC(dpy, gc);
            }
            return pm;
        }

        public boolean isWindowAlphaSupported() {
            if (!this.didCheck) {
                this.didCheck = true;
                this.alphaVisuals = this.getAlphaVisuals();
            }
            return this.alphaVisuals.length > 0;
        }

        public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
            if (this.isWindowAlphaSupported()) {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = env.getScreenDevices();
                for (int i = 0; i < devices.length; ++i) {
                    GraphicsConfiguration[] configs = devices[i].getConfigurations();
                    for (int j = 0; j < configs.length; ++j) {
                        try {
                            Object o = configs[j].getClass().getMethod("getVisual", null).invoke((Object)configs[j], null);
                            int visual = (Integer)o;
                            for (int k = 0; k < this.alphaVisuals.length; ++k) {
                                if (visual != this.alphaVisuals[k]) continue;
                                return configs[j];
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return super.getAlphaCompatibleGraphicsConfiguration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[] getAlphaVisuals() {
            Pointer dpy;
            X11 x11;
            block9: {
                Structure info;
                block7: {
                    int[] nArray;
                    block8: {
                        x11 = X11.INSTANCE;
                        dpy = x11.XOpenDisplay(null);
                        if (dpy == null) {
                            return new int[0];
                        }
                        info = null;
                        try {
                            int screen = x11.XDefaultScreen(dpy);
                            X11.XVisualInfo template = new X11.XVisualInfo();
                            template.screen = screen;
                            template.depth = 32;
                            template.clazz = 4;
                            int mask = 14;
                            IntByReference pcount = new IntByReference();
                            info = x11.XGetVisualInfo(dpy, mask, template, pcount);
                            if (info == null) break block7;
                            ArrayList<Integer> list = new ArrayList<Integer>();
                            X11.XVisualInfo[] infos = (X11.XVisualInfo[])info.toArray(new X11.XVisualInfo[pcount.getValue()]);
                            for (int i = 0; i < infos.length; ++i) {
                                X11.Xrender.XRenderPictFormat format = X11.Xrender.INSTANCE.XRenderFindVisualFormat(dpy, infos[i].visual);
                                if (format.type != 1 || format.direct.alphaMask == 0) continue;
                                list.add(new Integer(infos[i].visualID));
                            }
                            int[] ids = new int[list.size()];
                            for (int i = 0; i < list.size(); ++i) {
                                ids[i] = (Integer)list.get(i);
                            }
                            nArray = ids;
                            Object var13_15 = null;
                            if (info == null) break block8;
                            x11.XFree(info.getPointer());
                        }
                        catch (Throwable throwable) {
                            Object var13_17 = null;
                            if (info != null) {
                                x11.XFree(info.getPointer());
                            }
                            x11.XCloseDisplay(dpy);
                            throw throwable;
                        }
                    }
                    x11.XCloseDisplay(dpy);
                    return nArray;
                }
                Object var13_16 = null;
                if (info == null) break block9;
                x11.XFree(info.getPointer());
                {
                }
            }
            x11.XCloseDisplay(dpy);
            return new int[0];
        }

        public int getDrawable(Window w) {
            return (int)Native.getWindowID(w);
        }

        public void setWindowAlpha(Window w, float alpha) {
            Runnable action = new Runnable(this, w, alpha){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ float val$alpha;
                private final /* synthetic */ X11WindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$alpha = val$alpha;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    X11 x11 = X11.INSTANCE;
                    Pointer dpy = x11.XOpenDisplay(null);
                    if (dpy == null) {
                        return;
                    }
                    try {
                        int win = this.this$0.getDrawable(this.val$w);
                        if (this.val$alpha == 1.0f) {
                            x11.XDeleteProperty(dpy, win, x11.XInternAtom(dpy, "_NET_WM_WINDOW_OPACITY", false));
                        } else {
                            int opacity = (int)((long)(this.val$alpha * 4.2949673E9f) & 0xFFFFFFFFFFFFFFFFL);
                            IntByReference patom = new IntByReference(opacity);
                            x11.XChangeProperty(dpy, win, x11.XInternAtom(dpy, "_NET_WM_WINDOW_OPACITY", false), 6, 32, 0, patom.getPointer(), 1);
                        }
                    }
                    finally {
                        x11.XCloseDisplay(dpy);
                    }
                }
            };
            WindowUtils.whenDisplayable(w, action);
        }

        public void setWindowTransparent(Window w, boolean transparent) {
            boolean isTransparent;
            if (!(w instanceof RootPaneContainer)) {
                throw new IllegalArgumentException("Window must be a RootPaneContainer");
            }
            if (!this.isWindowAlphaSupported()) {
                System.err.println("Window alpha not supported");
                return;
            }
            if (!w.getGraphicsConfiguration().equals(this.getAlphaCompatibleGraphicsConfiguration())) {
                throw new IllegalArgumentException("Window GraphicsConfiguration does not support transparency");
            }
            boolean bl = isTransparent = w.getBackground() != null && w.getBackground().getAlpha() == 0;
            if (!(transparent ^ isTransparent)) {
                return;
            }
            WindowUtils.whenDisplayable(w, new Runnable(this, w, transparent){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ boolean val$transparent;
                private final /* synthetic */ X11WindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$transparent = val$transparent;
                }

                public void run() {
                    JRootPane root = ((RootPaneContainer)((Object)this.val$w)).getRootPane();
                    Container content = root.getContentPane();
                    if (content instanceof X11TransparentContent) {
                        ((X11TransparentContent)content).setTransparent(this.val$transparent);
                    } else if (this.val$transparent) {
                        root.setContentPane(this.this$0.new X11TransparentContent(content));
                    }
                    this.this$0.setLayersTransparent(this.val$w, this.val$transparent);
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$transparent);
                }
            });
        }

        public void setWindowMask(Window w, Raster raster) {
            Runnable action = new Runnable(this, w, raster){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ Raster val$raster;
                private final /* synthetic */ X11WindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$raster = val$raster;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Pointer dpy;
                    X11 x11;
                    block6: {
                        x11 = X11.INSTANCE;
                        X11.Xext ext = X11.Xext.INSTANCE;
                        dpy = x11.XOpenDisplay(null);
                        if (dpy == null) {
                            return;
                        }
                        int pm = 0;
                        try {
                            int win = this.this$0.getDrawable(this.val$w);
                            if (this.val$raster == null || (pm = X11WindowUtils.access$800(this.this$0, dpy, win, this.val$w, this.val$raster)) == 0) {
                                ext.XShapeCombineMask(dpy, win, 0, 0, 0, 0, 0);
                            } else {
                                ext.XShapeCombineMask(dpy, win, 0, 0, 0, pm, 0);
                            }
                            Object var7_6 = null;
                            if (pm == 0) break block6;
                            x11.XFreePixmap(dpy, pm);
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            if (pm != 0) {
                                x11.XFreePixmap(dpy, pm);
                            }
                            x11.XCloseDisplay(dpy);
                            throw throwable;
                        }
                        {
                        }
                    }
                    x11.XCloseDisplay(dpy);
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$raster != null);
                }
            };
            WindowUtils.whenDisplayable(w, action);
        }

        static /* synthetic */ int access$800(X11WindowUtils x0, Pointer x1, int x2, Window x3, Raster x4) {
            return x0.createBitmap(x1, x2, x3, x4);
        }

        private class X11TransparentContent
        extends JPanel {
            private boolean transparent;

            public X11TransparentContent(Container oldContent) {
                super(new BorderLayout());
                this.add((Component)oldContent, "Center");
                this.setTransparent(true);
                if (oldContent instanceof JPanel) {
                    ((JComponent)oldContent).setOpaque(false);
                }
            }

            public void setTransparent(boolean transparent) {
                this.transparent = transparent;
                this.setOpaque(!transparent);
                this.repaint();
            }

            public void paint(Graphics gr) {
                if (this.transparent) {
                    int w = this.getWidth();
                    int h = this.getHeight();
                    if (w > 0 && h > 0) {
                        BufferedImage buf = new BufferedImage(w, h, 2);
                        Graphics2D g = buf.createGraphics();
                        g.setComposite(AlphaComposite.Clear);
                        g.fillRect(0, 0, w, h);
                        g.setComposite(AlphaComposite.SrcOver);
                        super.paint(g);
                        g = (Graphics2D)gr.create();
                        g.setComposite(AlphaComposite.Src);
                        g.drawImage(buf, 0, 0, w, h, null);
                        g.dispose();
                    }
                } else {
                    super.paint(gr);
                }
            }
        }
    }

    private static class MacWindowUtils
    extends NativeWindowUtils {
        private MacWindowUtils() {
        }

        private Shape shapeFromRaster(Raster raster) {
            Area area = new Area(new Rectangle(0, 0, 0, 0));
            RasterRangesUtils.outputOccupiedRanges(raster, new RasterRangesUtils.RangesOutput(this, area){
                private final /* synthetic */ Area val$area;
                private final /* synthetic */ MacWindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$area = val$area;
                }

                public boolean outputRange(int x, int y, int w, int h) {
                    this.val$area.add(new Area(new Rectangle(x, y, w, h)));
                    return true;
                }
            });
            return area;
        }

        public boolean isWindowAlphaSupported() {
            return true;
        }

        private OSXTransparentContent installTransparentContent(Window w) {
            OSXTransparentContent content;
            if (w instanceof RootPaneContainer) {
                RootPaneContainer rpc = (RootPaneContainer)((Object)w);
                Container oldContent = rpc.getContentPane();
                if (oldContent instanceof OSXTransparentContent) {
                    content = (OSXTransparentContent)oldContent;
                } else {
                    content = new OSXTransparentContent(oldContent);
                    rpc.setContentPane(content);
                }
            } else {
                Component oldContent;
                Component component = oldContent = w.getComponentCount() > 0 ? w.getComponent(0) : null;
                if (oldContent instanceof OSXTransparentContent) {
                    content = (OSXTransparentContent)oldContent;
                } else {
                    content = new OSXTransparentContent(oldContent);
                    w.add(content);
                }
            }
            return content;
        }

        public void setWindowTransparent(Window w, boolean transparent) {
            boolean isTransparent;
            boolean bl = isTransparent = w.getBackground() != null && w.getBackground().getAlpha() == 0;
            if (!(transparent ^ isTransparent)) {
                return;
            }
            this.installTransparentContent(w);
            this.setBackgroundTransparent(w, transparent);
            this.setLayersTransparent(w, transparent);
        }

        public void setWindowAlpha(Window w, float alpha) {
            WindowUtils.whenDisplayable(w, new Runnable(this, w, alpha){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ float val$alpha;
                private final /* synthetic */ MacWindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$alpha = val$alpha;
                }

                public void run() {
                    ComponentPeer peer = this.val$w.getPeer();
                    try {
                        peer.getClass().getMethod("setAlpha", Float.TYPE).invoke((Object)peer, new Float(this.val$alpha));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        public void setWindowMask(Window w, Raster raster) {
            if (raster != null) {
                this.setWindowMask(w, this.shapeFromRaster(raster));
            } else {
                this.setWindowMask(w, new Rectangle(0, 0, w.getWidth(), w.getHeight()));
            }
        }

        private void setBackgroundTransparent(Window w, boolean transparent) {
            if (transparent) {
                w.setBackground(new Color(0, 0, 0, 0));
            } else {
                w.setBackground(new Window(w.getOwner()).getBackground());
            }
        }

        public void setWindowMask(Window w, Shape shape) {
            OSXTransparentContent content = this.installTransparentContent(w);
            content.setMask(shape);
            this.setBackgroundTransparent(w, shape != MASK_NONE);
        }

        static class OSXTransparentContent
        extends JPanel {
            private Shape shape;

            public OSXTransparentContent() {
                this((Component)null);
            }

            public OSXTransparentContent(Component oldContent) {
                super(new BorderLayout());
                if (oldContent != null) {
                    this.add(oldContent, "Center");
                }
            }

            public void setMask(Shape shape) {
                this.shape = shape;
                this.repaint();
            }

            public void paint(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics.create();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.dispose();
                if (this.shape != null) {
                    g = (Graphics2D)graphics.create();
                    g.setClip(this.shape);
                    super.paint(g);
                    g.dispose();
                } else {
                    super.paint(graphics);
                }
            }
        }
    }

    private static class W32WindowUtils
    extends NativeWindowUtils {
        private W32WindowUtils() {
        }

        public Pointer getHWnd(Window w) {
            return Native.getWindowPointer(w);
        }

        public boolean isWindowAlphaSupported() {
            return Boolean.getBoolean("sun.java2d.noddraw");
        }

        private boolean isTransparent(Window w) {
            if (w instanceof RootPaneContainer) {
                JRootPane root = ((RootPaneContainer)((Object)w)).getRootPane();
                return root.getClientProperty(WindowUtils.TRANSPARENT_OLD_BG) != null;
            }
            return false;
        }

        private void storeAlpha(Window w, byte alpha) {
            if (w instanceof RootPaneContainer) {
                JRootPane root = ((RootPaneContainer)((Object)w)).getRootPane();
                Byte b = alpha == -1 ? null : new Byte(alpha);
                root.putClientProperty(WindowUtils.TRANSPARENT_ALPHA, b);
            }
        }

        private byte getAlpha(Window w) {
            JRootPane root;
            Byte b;
            if (w instanceof RootPaneContainer && (b = (Byte)(root = ((RootPaneContainer)((Object)w)).getRootPane()).getClientProperty(WindowUtils.TRANSPARENT_ALPHA)) != null) {
                return b;
            }
            return -1;
        }

        public void setWindowAlpha(Window w, float alpha) {
            if (!this.isWindowAlphaSupported()) {
                System.err.println("Window alpha not supported");
                return;
            }
            WindowUtils.whenDisplayable(w, new Runnable(this, w, alpha){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ float val$alpha;
                private final /* synthetic */ W32WindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$alpha = val$alpha;
                }

                public void run() {
                    Pointer hWnd = this.this$0.getHWnd(this.val$w);
                    User32 user = User32.INSTANCE;
                    int flags = user.GetWindowLong(hWnd, -20);
                    byte level = (byte)((int)(255.0f * this.val$alpha) & 0xFF);
                    if (W32WindowUtils.access$300(this.this$0, this.val$w)) {
                        User32.BLENDFUNCTION blend = new User32.BLENDFUNCTION();
                        blend.SourceConstantAlpha = level;
                        blend.AlphaFormat = 1;
                        user.UpdateLayeredWindow(hWnd, null, null, null, null, null, 0, blend, 2);
                    } else if (this.val$alpha == 1.0f) {
                        user.SetWindowLong(hWnd, -20, flags &= 0xFFF7FFFF);
                    } else {
                        user.SetWindowLong(hWnd, -20, flags |= 0x80000);
                        user.SetLayeredWindowAttributes(hWnd, 0, level, 2);
                    }
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$alpha != 1.0f);
                    W32WindowUtils.access$400(this.this$0, this.val$w, level);
                }
            });
        }

        public void setWindowTransparent(Window w, boolean transparent) {
            boolean isTransparent;
            if (!(w instanceof RootPaneContainer)) {
                throw new IllegalArgumentException("Window must be a RootPaneContainer");
            }
            if (!this.isWindowAlphaSupported()) {
                System.err.println("Window alpha not supported");
                return;
            }
            boolean bl = isTransparent = w.getBackground() != null && w.getBackground().getAlpha() == 0;
            if (!(transparent ^ isTransparent)) {
                return;
            }
            WindowUtils.whenDisplayable(w, new Runnable(this, w, transparent){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ boolean val$transparent;
                private final /* synthetic */ W32WindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$transparent = val$transparent;
                }

                public void run() {
                    User32 user = User32.INSTANCE;
                    Pointer hWnd = this.this$0.getHWnd(this.val$w);
                    int flags = user.GetWindowLong(hWnd, -20);
                    JRootPane root = ((RootPaneContainer)((Object)this.val$w)).getRootPane();
                    JLayeredPane lp = root.getLayeredPane();
                    if (this.val$transparent && !W32WindowUtils.access$300(this.this$0, this.val$w)) {
                        user.SetWindowLong(hWnd, -20, flags |= 0x80000);
                        lp.add((Component)this.this$0.new W32RepaintTrigger(), JLayeredPane.DRAG_LAYER);
                    } else if (!this.val$transparent && W32WindowUtils.access$300(this.this$0, this.val$w)) {
                        user.SetWindowLong(hWnd, -20, flags &= 0xFFF7FFFF);
                        RepaintTrigger.remove(lp);
                    }
                    this.this$0.setLayersTransparent(this.val$w, this.val$transparent);
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$transparent);
                }
            });
        }

        public void setWindowMask(Window w, Raster raster) {
            WindowUtils.whenDisplayable(w, new Runnable(this, w, raster){
                private final /* synthetic */ Window val$w;
                private final /* synthetic */ Raster val$raster;
                private final /* synthetic */ W32WindowUtils this$0;
                {
                    this.this$0 = this$0;
                    this.val$w = val$w;
                    this.val$raster = val$raster;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GDI32 gdi = GDI32.INSTANCE;
                    User32 user = User32.INSTANCE;
                    Pointer hWnd = this.this$0.getHWnd(this.val$w);
                    Pointer result = gdi.CreateRectRgn(0, 0, 0, 0);
                    try {
                        if (this.val$raster == null) {
                            gdi.SetRectRgn(result, 0, 0, this.val$w.getWidth(), this.val$w.getHeight());
                        } else {
                            Pointer tempRgn = gdi.CreateRectRgn(0, 0, 0, 0);
                            try {
                                RasterRangesUtils.outputOccupiedRanges(this.val$raster, new RasterRangesUtils.RangesOutput(this, tempRgn, result){
                                    private final /* synthetic */ Pointer val$tempRgn;
                                    private final /* synthetic */ Pointer val$result;
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$tempRgn = val$tempRgn;
                                        this.val$result = val$result;
                                    }

                                    public boolean outputRange(int x, int y, int w, int h) {
                                        GDI32 gdi = GDI32.INSTANCE;
                                        gdi.SetRectRgn(this.val$tempRgn, x, y, x + w, y + h);
                                        return gdi.CombineRgn(this.val$result, this.val$result, this.val$tempRgn, 2) != 0;
                                    }
                                });
                            }
                            finally {
                                gdi.DeleteObject(tempRgn);
                            }
                        }
                        user.SetWindowRgn(hWnd, result, true);
                    }
                    finally {
                        gdi.DeleteObject(result);
                    }
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$raster != null);
                }
            });
        }

        static /* synthetic */ boolean access$300(W32WindowUtils x0, Window x1) {
            return x0.isTransparent(x1);
        }

        static /* synthetic */ void access$400(W32WindowUtils x0, Window x1, byte x2) {
            x0.storeAlpha(x1, x2);
        }

        private class W32RepaintTrigger
        extends RepaintTrigger {
            private W32RepaintTrigger() {
            }

            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(x, y, w, h);
                if (w > 0 && h > 0) {
                    SwingUtilities.getWindowAncestor(this).toFront();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                GDI32 gdi = GDI32.INSTANCE;
                User32 user = User32.INSTANCE;
                Window win = SwingUtilities.getWindowAncestor(this);
                int w = win.getWidth();
                int h = win.getHeight();
                Pointer screenDC = user.GetDC(null);
                Pointer memDC = gdi.CreateCompatibleDC(screenDC);
                Pointer hBitmap = null;
                Pointer oldBitmap = null;
                try {
                    BufferedImage buf = new BufferedImage(w, h, 3);
                    Graphics2D g = buf.createGraphics();
                    g.setComposite(AlphaComposite.Clear);
                    g.fillRect(0, 0, w, h);
                    g.setComposite(AlphaComposite.SrcOver);
                    Point origin = SwingUtilities.convertPoint(this.getParent(), 0, 0, win);
                    this.getParent().paint(g.create(origin.x, origin.y, this.getWidth(), this.getHeight()));
                    GDI32.BITMAPINFO bmi = new GDI32.BITMAPINFO();
                    bmi.bmiHeader.biWidth = w;
                    bmi.bmiHeader.biHeight = h;
                    bmi.bmiHeader.biPlanes = 1;
                    bmi.bmiHeader.biBitCount = (short)32;
                    bmi.bmiHeader.biCompression = 0;
                    bmi.bmiHeader.biSizeImage = w * h * 4;
                    PointerByReference ppbits = new PointerByReference();
                    hBitmap = gdi.CreateDIBSection(memDC, bmi, 0, ppbits, null, 0);
                    oldBitmap = gdi.SelectObject(memDC, hBitmap);
                    Pointer pbits = ppbits.getValue();
                    Raster raster = buf.getData();
                    int[] pixel = new int[4];
                    int[] bits = new int[w * h];
                    for (int row = 0; row < h; ++row) {
                        for (int col = 0; col < w; ++col) {
                            raster.getPixel(col, h - row - 1, pixel);
                            int alpha = (pixel[3] & 0xFF) << 24;
                            int red = pixel[2] & 0xFF;
                            int green = (pixel[1] & 0xFF) << 8;
                            int blue = (pixel[0] & 0xFF) << 16;
                            bits[col + row * w] = alpha | red | green | blue;
                        }
                    }
                    pbits.write(0, bits, 0, bits.length);
                    User32.SIZE size = new User32.SIZE();
                    size.cx = w;
                    size.cy = h;
                    User32.POINT srcLoc = new User32.POINT();
                    User32.BLENDFUNCTION blend = new User32.BLENDFUNCTION();
                    User32.POINT loc = new User32.POINT();
                    loc.x = win.getX();
                    loc.y = win.getY();
                    Pointer hWnd = Native.getWindowPointer(win);
                    ByteByReference bref = new ByteByReference();
                    IntByReference iref = new IntByReference();
                    byte level = W32WindowUtils.this.getAlpha(win);
                    if (user.GetLayeredWindowAttributes(hWnd, null, bref, iref) && (iref.getValue() & 2) != 0) {
                        level = bref.getValue();
                    }
                    blend.SourceConstantAlpha = level;
                    blend.AlphaFormat = 1;
                    user.UpdateLayeredWindow(hWnd, screenDC, loc, size, memDC, srcLoc, 0, blend, 2);
                    Object var28_33 = null;
                    user.ReleaseDC(null, screenDC);
                }
                catch (Throwable throwable) {
                    Object var28_34 = null;
                    user.ReleaseDC(null, screenDC);
                    if (hBitmap != null) {
                        gdi.SelectObject(memDC, oldBitmap);
                        gdi.DeleteObject(hBitmap);
                    }
                    gdi.DeleteDC(memDC);
                    throw throwable;
                }
                if (hBitmap != null) {
                    gdi.SelectObject(memDC, oldBitmap);
                    gdi.DeleteObject(hBitmap);
                }
                gdi.DeleteDC(memDC);
            }
        }
    }

    private static class Holder {
        public static boolean requiresVisible;
        public static final NativeWindowUtils INSTANCE;

        private Holder() {
        }

        static {
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                INSTANCE = new W32WindowUtils();
            } else if (os.startsWith("Mac")) {
                INSTANCE = new MacWindowUtils();
            } else if (os.startsWith("Linux") || os.startsWith("SunOS")) {
                INSTANCE = new X11WindowUtils();
                requiresVisible = System.getProperty("java.version").matches("^1\\.4\\..*");
            } else {
                throw new UnsupportedOperationException("No support for " + os);
            }
        }
    }

    public static abstract class NativeWindowUtils {
        public void setWindowAlpha(Window w, float alpha) {
        }

        public boolean isWindowAlphaSupported() {
            return false;
        }

        public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice dev = env.getDefaultScreenDevice();
            return dev.getDefaultConfiguration();
        }

        public void setWindowTransparent(Window w, boolean transparent) {
        }

        protected void setLayersTransparent(Window w, boolean transparent) {
            Color bg;
            Color color = bg = transparent ? new Color(0, 0, 0, 0) : null;
            if (w instanceof RootPaneContainer) {
                JComponent content;
                RootPaneContainer rpc = (RootPaneContainer)((Object)w);
                JRootPane root = rpc.getRootPane();
                JLayeredPane lp = root.getLayeredPane();
                Container c = root.getContentPane();
                JComponent jComponent = content = c instanceof JComponent ? (JComponent)c : null;
                if (transparent) {
                    lp.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, lp.isOpaque());
                    lp.setOpaque(false);
                    root.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, root.isOpaque());
                    root.setOpaque(false);
                    if (content != null) {
                        content.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, content.isOpaque());
                        content.setOpaque(false);
                    }
                    root.putClientProperty(WindowUtils.TRANSPARENT_OLD_BG, root.getParent().getBackground());
                } else {
                    lp.setOpaque(Boolean.TRUE.equals(lp.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    root.setOpaque(Boolean.TRUE.equals(root.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    if (content != null) {
                        content.setOpaque(Boolean.TRUE.equals(content.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    }
                    bg = (Color)root.getClientProperty(WindowUtils.TRANSPARENT_OLD_BG);
                }
            }
            w.setBackground(bg);
        }

        public abstract void setWindowMask(Window var1, Raster var2);

        public void setWindowMask(Window w, Shape mask) {
            Raster raster = null;
            if (mask != MASK_NONE) {
                Rectangle bounds = mask.getBounds();
                if (bounds.width > 0 && bounds.height > 0) {
                    BufferedImage bitmap = new BufferedImage(bounds.x + bounds.width, bounds.y + bounds.height, 12);
                    Graphics2D g = bitmap.createGraphics();
                    g.setColor(Color.black);
                    g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    g.setColor(Color.white);
                    g.fill(mask);
                    raster = bitmap.getData();
                }
            }
            this.setWindowMask(w, raster);
        }

        public void setWindowMask(Window w, Icon mask) {
            WritableRaster raster = null;
            if (mask != null) {
                Rectangle bounds = new Rectangle(0, 0, mask.getIconWidth(), mask.getIconHeight());
                BufferedImage clip = new BufferedImage(bounds.width, bounds.height, 2);
                Graphics2D g = clip.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, bounds.width, bounds.height);
                g.setComposite(AlphaComposite.SrcOver);
                mask.paintIcon(w, g, 0, 0);
                raster = clip.getAlphaRaster();
            }
            this.setWindowMask(w, raster);
        }

        protected void setForceHeavyweightPopups(Window w, boolean force) {
            if (!(w instanceof HeavyweightForcer)) {
                Window[] owned = w.getOwnedWindows();
                for (int i = 0; i < owned.length; ++i) {
                    if (!(owned[i] instanceof HeavyweightForcer)) continue;
                    owned[i].dispose();
                }
                if (force) {
                    new HeavyweightForcer(w);
                }
            }
        }
    }

    private static abstract class RepaintTrigger
    extends JComponent {
        private Listener listener = this.createListener();
        private boolean painting;

        private RepaintTrigger() {
        }

        public void addNotify() {
            super.addNotify();
            Window w = SwingUtilities.getWindowAncestor(this);
            this.setSize(this.getParent().getSize());
            w.addComponentListener(this.listener);
            w.addWindowListener(this.listener);
        }

        public void removeNotify() {
            Window w = SwingUtilities.getWindowAncestor(this);
            w.removeComponentListener(this.listener);
            w.removeWindowListener(this.listener);
            super.removeNotify();
        }

        protected void paintComponent(Graphics g) {
            if (!this.painting) {
                this.painting = true;
                this.update();
                this.painting = false;
            }
        }

        protected Listener createListener() {
            return new Listener();
        }

        protected abstract void update();

        public static void remove(Container c) {
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (!(c.getComponent(i) instanceof RepaintTrigger)) continue;
                c.remove(i);
                return;
            }
        }

        protected class Listener
        extends WindowAdapter
        implements ComponentListener,
        HierarchyListener {
            protected Listener() {
            }

            public void windowOpened(WindowEvent e) {
                RepaintTrigger.this.repaint();
            }

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                RepaintTrigger.this.setSize(RepaintTrigger.this.getParent().getSize());
                RepaintTrigger.this.repaint();
            }

            public void componentShown(ComponentEvent e) {
                RepaintTrigger.this.repaint();
            }

            public void hierarchyChanged(HierarchyEvent e) {
                RepaintTrigger.this.repaint();
            }
        }
    }

    private static class HeavyweightForcer
    extends Window {
        private boolean packed;

        public HeavyweightForcer(Window parent) {
            super(parent);
            this.pack();
            this.packed = true;
        }

        public boolean isVisible() {
            return this.packed;
        }

        public Rectangle getBounds() {
            return this.getOwner().getBounds();
        }
    }
}

