/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;

abstract class BaseMetaDataImpl
implements MetaData {
    private static final String dbgTag = "BaseMetaDataImpl";

    BaseMetaDataImpl() {
    }

    public abstract MBeanInfo getMBeanInfo(Object var1) throws IntrospectionException;

    public abstract Object getAttribute(Object var1, String var2) throws MBeanException, AttributeNotFoundException, ReflectionException;

    public abstract AttributeList getAttributes(Object var1, String[] var2) throws ReflectionException;

    public abstract AttributeList setAttributes(Object var1, AttributeList var2) throws ReflectionException;

    public abstract Object setAttribute(Object var1, Attribute var2) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException;

    public abstract Object invoke(Object var1, String var2, Object[] var3, String[] var4) throws MBeanException, ReflectionException;

    public ObjectName preRegisterInvoker(Object moi, ObjectName name, MBeanServer mbs) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName newName;
        if (!(moi instanceof MBeanRegistration)) {
            return name;
        }
        try {
            newName = ((MBeanRegistration)moi).preRegister(mbs, name);
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in preRegister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in preRegister method");
        }
        catch (MBeanRegistrationException r) {
            throw r;
        }
        catch (Exception ex) {
            throw new MBeanRegistrationException(ex, "Exception thrown in preRegister method");
        }
        if (newName != null) {
            return newName;
        }
        return name;
    }

    public void postRegisterInvoker(Object moi, boolean registrationDone) {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)moi).postRegister(new Boolean(registrationDone));
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in postRegister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in postRegister method");
        }
    }

    public void preDeregisterInvoker(Object moi) throws MBeanRegistrationException {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)moi).preDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in preDeregister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in preDeregister method");
        }
        catch (MBeanRegistrationException t) {
            throw t;
        }
        catch (Exception ex) {
            throw new MBeanRegistrationException(ex, "Exception thrown in preDeregister method");
        }
    }

    public void postDeregisterInvoker(Object moi) {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)moi).postDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in postDeregister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in postDeregister method");
        }
    }

    public String getMBeanClassName(Object moi) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo mbi;
        try {
            mbi = this.getMBeanInfo(moi);
        }
        catch (SecurityException x) {
            throw x;
        }
        catch (IntrospectionException x) {
            throw x;
        }
        catch (Exception x) {
            throw new NotCompliantMBeanException("Can't obtain MBeanInfo from DynamicMBean: " + x);
        }
        if (mbi == null) {
            throw new NotCompliantMBeanException("The MBeanInfo returned is null");
        }
        String className = mbi.getClassName();
        if (className == null) {
            throw new IntrospectionException("The class Name returned is null");
        }
        return className;
    }

    public boolean isInstanceOf(Object instance, String className) throws ReflectionException {
        try {
            String cn = this.getMBeanClassName(instance);
            if (cn.equals(className)) {
                return true;
            }
            try {
                ClassLoader cl = instance.getClass().getClassLoader();
                Class classNameClass = this.findClass(className, cl);
                if (classNameClass == null) {
                    return false;
                }
                if (classNameClass.isInstance(instance)) {
                    return true;
                }
                Class instanceClass = this.findClass(cn, cl);
                if (instanceClass == null) {
                    return false;
                }
                return classNameClass.isAssignableFrom(instanceClass);
            }
            catch (Exception x) {
                BaseMetaDataImpl.debugX("isInstanceOf", x);
                return false;
            }
        }
        catch (IntrospectionException x) {
            BaseMetaDataImpl.debugX("isInstanceOf", x);
            throw new ReflectionException(x, x.getMessage());
        }
        catch (NotCompliantMBeanException x) {
            BaseMetaDataImpl.debugX("isInstanceOf", x);
            throw new ReflectionException(x, x.getMessage());
        }
    }

    protected Class findClass(String className, ClassLoader loader) throws ReflectionException {
        try {
            if (loader == null) {
                return Class.forName(className);
            }
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x, x.getMessage());
        }
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        BaseMetaDataImpl.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        BaseMetaDataImpl.debug(dbgTag, func, info);
    }

    private static void debugX(String func, Throwable e) {
        if (BaseMetaDataImpl.isDebugOn()) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            String stack = s.toString();
            BaseMetaDataImpl.debug(dbgTag, func, "Exception caught in " + func + "(): " + e);
            BaseMetaDataImpl.debug(dbgTag, func, stack);
        }
    }
}

