/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DynamicMetaDataImpl;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.mbeanserver.StandardMetaDataImpl;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class MetaDataImpl
implements MetaData {
    private static final String dbgTag = "MetaDataImpl";
    private final DynamicMetaDataImpl dynamic;
    private final StandardMetaDataImpl standard;
    protected final MBeanInstantiator instantiator;
    static /* synthetic */ Class class$javax$management$DynamicMBean;

    public MetaDataImpl(MBeanInstantiator instantiator) {
        if (instantiator == null) {
            throw new IllegalArgumentException("instantiator must not be null.");
        }
        this.instantiator = instantiator;
        this.dynamic = new PrivateDynamicMeta();
        this.standard = new PrivateStandardMeta();
    }

    protected MetaData getMetaData(Class c) {
        if ((class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = MetaDataImpl.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(c)) {
            return this.dynamic;
        }
        return this.standard;
    }

    protected MetaData getMetaData(Object moi) {
        if (moi instanceof DynamicMBean) {
            return this.dynamic;
        }
        return this.standard;
    }

    public synchronized void testCompliance(Class c) throws NotCompliantMBeanException {
        MetaData meta = this.getMetaData(c);
        meta.testCompliance(c);
    }

    public Class getMBeanInterfaceFromClass(Class c) {
        return this.standard.getMBeanInterfaceFromClass(c);
    }

    public MBeanInfo getMBeanInfoFromClass(Class beanClass) throws IntrospectionException, NotCompliantMBeanException {
        return this.standard.getMBeanInfoFromClass(beanClass);
    }

    public final String getMBeanClassName(Object moi) throws IntrospectionException, NotCompliantMBeanException {
        MetaData meta = this.getMetaData(moi);
        return meta.getMBeanClassName(moi);
    }

    public final MBeanInfo getMBeanInfo(Object moi) throws IntrospectionException {
        MetaData meta = this.getMetaData(moi);
        return meta.getMBeanInfo(moi);
    }

    public final Object getAttribute(Object instance, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        MetaData meta = this.getMetaData(instance);
        return meta.getAttribute(instance, attribute);
    }

    public final AttributeList getAttributes(Object instance, String[] attributes) throws ReflectionException {
        MetaData meta = this.getMetaData(instance);
        return meta.getAttributes(instance, attributes);
    }

    public final AttributeList setAttributes(Object instance, AttributeList attributes) throws ReflectionException {
        MetaData meta = this.getMetaData(instance);
        return meta.setAttributes(instance, attributes);
    }

    public final Object setAttribute(Object instance, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MetaData meta = this.getMetaData(instance);
        return meta.setAttribute(instance, attribute);
    }

    public final Object invoke(Object instance, String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            IllegalArgumentException r = new IllegalArgumentException("Operation name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occured trying to invoke the operation on the MBean");
        }
        MetaData meta = this.getMetaData(instance);
        return meta.invoke(instance, operationName, params, signature);
    }

    public boolean isInstanceOf(Object instance, String className) throws ReflectionException {
        MetaData meta = this.getMetaData(instance);
        return meta.isInstanceOf(instance, className);
    }

    public ObjectName preRegisterInvoker(Object moi, ObjectName name, MBeanServer mbs) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (!(moi instanceof MBeanRegistration)) {
            return name;
        }
        MetaData meta = this.getMetaData(moi);
        return meta.preRegisterInvoker(moi, name, mbs);
    }

    public void postRegisterInvoker(Object moi, boolean registrationDone) {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        MetaData meta = this.getMetaData(moi);
        meta.postRegisterInvoker(moi, registrationDone);
    }

    public void preDeregisterInvoker(Object moi) throws MBeanRegistrationException {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        MetaData meta = this.getMetaData(moi);
        meta.preDeregisterInvoker(moi);
    }

    public void postDeregisterInvoker(Object moi) {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        MetaData meta = this.getMetaData(moi);
        meta.postDeregisterInvoker(moi);
    }

    protected Class findClass(String className, ClassLoader loader) throws ReflectionException {
        return this.instantiator.findClass(className, loader);
    }

    protected Class[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        return signature == null ? null : this.instantiator.findSignatureClasses(signature, loader);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        MetaDataImpl.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        MetaDataImpl.debug(dbgTag, func, info);
    }

    private static void debugX(String func, Throwable e) {
        if (MetaDataImpl.isDebugOn()) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            String stack = s.toString();
            MetaDataImpl.debug(dbgTag, func, "Exception caught in " + func + "(): " + e);
            MetaDataImpl.debug(dbgTag, func, stack);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PrivateDynamicMeta
    extends DynamicMetaDataImpl {
        PrivateDynamicMeta() {
        }

        protected Class findClass(String className, ClassLoader loader) throws ReflectionException {
            return MetaDataImpl.this.findClass(className, loader);
        }

        protected Class[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
            return MetaDataImpl.this.findSignatureClasses(signature, loader);
        }
    }

    private final class PrivateStandardMeta
    extends StandardMetaDataImpl {
        PrivateStandardMeta() {
        }

        protected Class findClass(String className, ClassLoader loader) throws ReflectionException {
            return MetaDataImpl.this.findClass(className, loader);
        }

        protected Class[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
            return MetaDataImpl.this.findSignatureClasses(signature, loader);
        }
    }
}

