/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.trace;

import com.sun.jmx.trace.TraceDestination;
import com.sun.jmx.trace.TraceManager;
import com.sun.jmx.trace.TraceTags;

public final class Trace
implements TraceTags {
    private static TraceDestination out = Trace.initDestination();

    private Trace() {
    }

    private static TraceDestination initDestination() {
        try {
            Class.forName("java.util.logging.LogManager");
            return new TraceManager();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static synchronized void setDestination(TraceDestination output) {
        out = output;
    }

    public static boolean isSelected(int level, int type) {
        TraceDestination output = Trace.out();
        if (output != null) {
            return output.isSelected(level, type);
        }
        return false;
    }

    public static boolean send(int level, int type, String className, String methodName, String info) {
        TraceDestination output = Trace.out();
        if (output == null) {
            return false;
        }
        if (!output.isSelected(level, type)) {
            return false;
        }
        return output.send(level, type, className, methodName, info);
    }

    public static boolean send(int level, int type, String className, String methodName, Throwable exception) {
        TraceDestination output = Trace.out();
        if (output == null) {
            return false;
        }
        if (!output.isSelected(level, type)) {
            return false;
        }
        return output.send(level, type, className, methodName, exception);
    }

    public static void warning(String loggerName, String msg) {
        TraceDestination output = Trace.out();
        if (output instanceof TraceManager) {
            ((TraceManager)output).warning(loggerName, msg);
        } else if (output != null) {
            output.send(1, 16, null, null, msg);
        }
    }

    public static void fine(String loggerName, String msg) {
        TraceDestination output = Trace.out();
        if (output instanceof TraceManager) {
            ((TraceManager)output).fine(loggerName, msg);
        } else if (output != null) {
            output.send(1, 16, null, null, msg);
        }
    }

    private static synchronized TraceDestination out() {
        return out;
    }
}

