/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class NotificationFilterSupport
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = 6579080007561786969L;
    private List enabledTypes = new Vector();

    public synchronized boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        if (type == null) {
            return false;
        }
        try {
            Iterator i = this.enabledTypes.iterator();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                if (!type.startsWith(prefix)) continue;
                return true;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    public synchronized void enableType(String prefix) throws IllegalArgumentException {
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        if (!this.enabledTypes.contains(prefix)) {
            this.enabledTypes.add(prefix);
        }
    }

    public synchronized void disableType(String prefix) {
        this.enabledTypes.remove(prefix);
    }

    public synchronized void disableAllTypes() {
        this.enabledTypes.clear();
    }

    public synchronized Vector getEnabledTypes() {
        return (Vector)this.enabledTypes;
    }
}

