/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.trace.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.loading.MLetContent;

class MLetParser {
    private int c;
    private static String tag = "mlet";
    private String dbgTag = "MLetParser";

    public void skipSpace(Reader in) throws IOException {
        while (this.c >= 0 && (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13)) {
            this.c = in.read();
        }
    }

    public String scanIdentifier(Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (this.c >= 97 && this.c <= 122 || this.c >= 65 && this.c <= 90 || this.c >= 48 && this.c <= 57 || this.c == 95) {
            buf.append((char)this.c);
            this.c = in.read();
        }
        return buf.toString();
    }

    public Hashtable scanTag(Reader in) throws IOException {
        Hashtable<String, String> atts = new Hashtable<String, String>();
        this.skipSpace(in);
        while (this.c >= 0 && this.c != 62) {
            String att = this.scanIdentifier(in);
            String val = "";
            this.skipSpace(in);
            if (this.c == 61) {
                int quote = -1;
                this.c = in.read();
                this.skipSpace(in);
                if (this.c == 39 || this.c == 34) {
                    quote = this.c;
                    this.c = in.read();
                }
                StringBuffer buf = new StringBuffer();
                while (this.c > 0 && (quote < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || quote >= 0 && this.c != quote)) {
                    buf.append((char)this.c);
                    this.c = in.read();
                }
                if (this.c == quote) {
                    this.c = in.read();
                }
                this.skipSpace(in);
                val = buf.toString();
            }
            atts.put(att.toLowerCase(), val);
            this.skipSpace(in);
        }
        return atts;
    }

    public Vector parse(URL url) throws IOException {
        Vector<MLetContent> mlets;
        BufferedReader in;
        block16: {
            String mth = "parse";
            String requiresNameWarning = "<param name=... value=...> tag requires name parameter.";
            String paramOutsideWarning = "<param> tag outside <mlet> ... </mlet>.";
            String requiresCodeWarning = "<mlet> tag requires either code or object parameter.";
            String requiresJarsWarning = "<mlet> tag requires archive parameter.";
            URLConnection conn = url.openConnection();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            url = conn.getURL();
            mlets = new Vector<MLetContent>();
            Hashtable atts = null;
            Vector<String> types = new Vector<String>();
            Vector<String> values = new Vector<String>();
            while (true) {
                String nm;
                this.c = ((Reader)in).read();
                if (this.c == -1) break block16;
                if (this.c != 60) continue;
                this.c = ((Reader)in).read();
                if (this.c == 47) {
                    this.c = ((Reader)in).read();
                    nm = this.scanIdentifier(in);
                    if (!nm.equalsIgnoreCase(tag)) continue;
                    if (atts != null) {
                        if (types.size() == values.size() && !types.isEmpty() && !values.isEmpty()) {
                            atts.put("types", types.clone());
                            atts.put("values", values.clone());
                        }
                        mlets.addElement(new MLetContent(url, atts));
                    }
                    atts = null;
                    types.removeAllElements();
                    values.removeAllElements();
                    continue;
                }
                nm = this.scanIdentifier(in);
                if (nm.equalsIgnoreCase("arg")) {
                    Hashtable t = this.scanTag(in);
                    String att = (String)t.get("type");
                    if (att == null) {
                        if (this.isTraceOn()) {
                            this.trace(mth, requiresNameWarning);
                        }
                        return null;
                    }
                    if (atts == null) {
                        if (this.isTraceOn()) {
                            this.trace(mth, paramOutsideWarning);
                        }
                        return null;
                    }
                    types.addElement(att);
                    String val = (String)t.get("value");
                    if (val == null) {
                        if (this.isTraceOn()) {
                            this.trace(mth, requiresNameWarning);
                        }
                        return null;
                    }
                    if (atts != null) {
                        values.addElement(val);
                        continue;
                    }
                    if (this.isTraceOn()) {
                        this.trace(mth, paramOutsideWarning);
                    }
                    return null;
                }
                if (!nm.equalsIgnoreCase(tag)) continue;
                atts = this.scanTag(in);
                if (atts.get("code") == null && atts.get("object") == null) {
                    if (this.isTraceOn()) {
                        this.trace(mth, requiresCodeWarning);
                    }
                    atts = null;
                    return null;
                }
                if (atts.get("archive") == null) break;
            }
            if (this.isTraceOn()) {
                this.trace(mth, requiresJarsWarning);
            }
            atts = null;
            return null;
        }
        ((Reader)in).close();
        return mlets;
    }

    public Vector parseURL(String urlname) {
        Vector mlet_list = null;
        try {
            URL url = null;
            if (urlname.indexOf(58) <= 1) {
                String userDir = System.getProperty("user.dir");
                String prot = userDir.charAt(0) == '/' || userDir.charAt(0) == File.separatorChar ? "file:" : "file:/";
                url = new URL(prot + userDir.replace(File.separatorChar, '/') + "/");
                url = new URL(url, urlname);
            } else {
                url = new URL(urlname);
            }
            mlet_list = this.parse(url);
        }
        catch (MalformedURLException e) {
            if (this.isTraceOn()) {
                this.trace("parseURL", "Bad URL: " + urlname + " ( " + e.getMessage() + " )");
            }
            return null;
        }
        catch (IOException e) {
            if (this.isTraceOn()) {
                this.trace("parseURL", "I/O exception while reading: " + urlname + " ( " + e.getMessage() + " )");
            }
            return null;
        }
        return mlet_list;
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 2);
    }

    private void trace(String clz, String func, String info) {
        Trace.send(1, 2, clz, func, info);
    }

    private void trace(String func, String info) {
        this.trace(this.dbgTag, func, info);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 2);
    }

    private void debug(String clz, String func, String info) {
        Trace.send(2, 2, clz, func, info);
    }

    private void debug(String func, String info) {
        this.debug(this.dbgTag, func, info);
    }
}

