/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import junitx.framework.TestAccessException;

public class TestedClass {
    private final Class _class;
    private final Map _methods = new TreeMap();
    private final Map _constructors = new TreeMap();

    public TestedClass(Class aClass) {
        this._class = aClass;
        this.createMethodMap();
        this.createConstructorMap();
    }

    public Class getTestedClass() {
        return this._class;
    }

    public String getPkgName() {
        String className = this._class.toString().substring(6);
        int pos = className.lastIndexOf(".");
        if (pos < 0) {
            return null;
        }
        return className.substring(0, pos);
    }

    private String createMethodKey(String aMethodName, Class[] anArgTypeArray) {
        StringBuffer key = new StringBuffer();
        String arg = null;
        boolean pos = false;
        key.append(aMethodName);
        for (int a = 0; a < anArgTypeArray.length; ++a) {
            key.append("_");
            arg = anArgTypeArray[a].getName();
            key.append(arg);
        }
        return key.toString();
    }

    private Class[] objToClassArray(Object[] anArray) {
        if (anArray == null) {
            return new Class[0];
        }
        Class[] classes = new Class[anArray.length];
        for (int i = 0; i < anArray.length; ++i) {
            classes[i] = anArray[i].getClass();
        }
        return classes;
    }

    public Method getMethod(String aMethodKey) {
        return (Method)this._methods.get(aMethodKey);
    }

    public Method getMethod(String aMethodName, Object[] anArgArray) throws TestAccessException {
        try {
            return this.getTestedClass().getDeclaredMethod(aMethodName, this.objToClassArray(anArgArray));
        }
        catch (Exception e) {
            throw new TestAccessException("cannot access method " + aMethodName, e);
        }
    }

    public Constructor getConstructor(Object[] anArgArray) throws TestAccessException {
        try {
            return this.getTestedClass().getDeclaredConstructor(this.objToClassArray(anArgArray));
        }
        catch (Exception e) {
            throw new TestAccessException("cannot find constructor", e);
        }
    }

    public Constructor getConstructor(String aConstructorName) {
        return (Constructor)this._constructors.get(aConstructorName);
    }

    private void createMethodMap() {
        int m;
        Method[] methods1 = this.getTestedClass().getDeclaredMethods();
        Method[] methods2 = this.getTestedClass().getMethods();
        for (m = 0; m < methods1.length; ++m) {
            this._methods.put(this.createMethodKey(methods1[m].getName(), methods1[m].getParameterTypes()), methods1[m]);
        }
        for (m = 0; m < methods2.length; ++m) {
            this._methods.put(this.createMethodKey(methods2[m].getName(), methods2[m].getParameterTypes()), methods2[m]);
        }
        for (Class superclass = this.getTestedClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            Method[] superMethods = superclass.getDeclaredMethods();
            for (int m2 = 0; m2 < superMethods.length; ++m2) {
                if ((superMethods[m2].getModifiers() & 4) == 0) continue;
                this._methods.put(this.createMethodKey(superMethods[m2].getName(), superMethods[m2].getParameterTypes()), superMethods[m2]);
            }
        }
    }

    private void createConstructorMap() {
        Constructor<?>[] constructors = this.getTestedClass().getDeclaredConstructors();
        for (int c = 0; c < constructors.length; ++c) {
            this._constructors.put(this.createMethodKey("", constructors[c].getParameterTypes()), constructors[c]);
        }
    }

    public Field getField(String aFieldName) throws TestAccessException {
        try {
            return this.getTestedClass().getDeclaredField(aFieldName);
        }
        catch (Exception e) {
            throw new TestAccessException("cannot access field " + aFieldName, e);
        }
    }

    public void dumpKeys() {
        Iterator constructorKeys = this._constructors.keySet().iterator();
        Iterator methodKeys = this._methods.keySet().iterator();
        System.out.println(this.getTestedClass().getName() + " constructors:");
        while (constructorKeys.hasNext()) {
            System.out.println("    " + (String)constructorKeys.next());
        }
        System.out.println("\n" + this.getTestedClass().getName() + " methods:");
        while (methodKeys.hasNext()) {
            System.out.println("    " + (String)methodKeys.next());
        }
    }
}

