/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMNormalizer;
import org.apache.xerces.dom.DOMValidationConfiguration;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeListCache;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ShadowedSymbolTable;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DocumentLS;

public class CoreDocumentImpl
extends ParentNode
implements Document,
DocumentLS {
    static final long serialVersionUID = 0L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    transient NodeListCache fFreeNLCache;
    protected String encoding;
    protected String actualEncoding;
    protected String version;
    protected boolean standalone;
    protected String fDocumentURI;
    protected final DOMErrorHandlerWrapper fErrorHandlerWrapper = new DOMErrorHandlerWrapper();
    protected Hashtable userData;
    protected Hashtable identifiers;
    protected short features = 0;
    protected static final short NSPROCESSING = 1;
    protected static final short DTNORMALIZATION = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short DEFAULTS = 16;
    protected static final short SPLITCDATA = 32;
    protected static final short COMMENTS = 64;
    protected static final short VALIDATION = 128;
    protected DOMNormalizer domNormalizer = null;
    protected DOMValidationConfiguration fConfiguration = null;
    protected ShadowedSymbolTable fSymbolTable = null;
    protected XMLEntityResolver fEntityResolver = null;
    protected Grammar fGrammar = null;
    protected static int[] kidOK = new int[13];
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;

    public CoreDocumentImpl() {
        this(false);
    }

    public CoreDocumentImpl(boolean grammarAccess) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = grammarAccess;
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x40);
        this.features = (short)(this.features | 2);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        this.features = (short)(this.features | 0x20);
    }

    public CoreDocumentImpl(DocumentType doctype) {
        this(doctype, false);
    }

    public CoreDocumentImpl(DocumentType doctype, boolean grammarAccess) {
        this(grammarAccess);
        if (doctype != null) {
            try {
                DocumentTypeImpl doctypeImpl = (DocumentTypeImpl)doctype;
            }
            catch (ClassCastException e) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            doctypeImpl.ownerDocument = this;
            this.appendChild(doctype);
        }
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Node cloneNode(boolean deep) {
        CoreDocumentImpl newdoc = new CoreDocumentImpl();
        this.callUserDataHandlers(this, newdoc, (short)1);
        this.cloneNode(newdoc, deep);
        return newdoc;
    }

    protected void cloneNode(CoreDocumentImpl newdoc, boolean deep) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (deep) {
            Hashtable reversedIdentifiers = null;
            if (this.identifiers != null) {
                reversedIdentifiers = new Hashtable();
                Enumeration elementIds = this.identifiers.keys();
                while (elementIds.hasMoreElements()) {
                    Object elementId = elementIds.nextElement();
                    reversedIdentifiers.put(this.identifiers.get(elementId), elementId);
                }
            }
            ChildNode kid = this.firstChild;
            while (kid != null) {
                newdoc.appendChild(newdoc.importNode(kid, true, true, reversedIdentifiers));
                kid = kid.nextSibling;
            }
        }
        newdoc.allowGrammarAccess = this.allowGrammarAccess;
        newdoc.errorChecking = this.errorChecking;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        short type = newChild.getNodeType();
        if (this.errorChecking && (type == 1 && this.docElement != null || type == 10 && this.docType != null)) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        if (newChild.getOwnerDocument() == null && newChild instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)newChild).ownerDocument = this;
        }
        super.insertBefore(newChild, refChild);
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        super.removeChild(oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = null;
        } else if (type == 10) {
            this.docType = null;
        }
        return oldChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (newChild.getOwnerDocument() == null && newChild instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)newChild).ownerDocument = this;
        }
        super.replaceChild(newChild, oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return oldChild;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Attr createAttribute(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String tagName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(tagName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementImpl(this, tagName);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityReferenceImpl(this, name);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(target)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    public void setErrorChecking(boolean check) {
        this.errorChecking = check;
    }

    public void setStrictErrorChecking(boolean check) {
        this.errorChecking = check;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    public String getActualEncoding() {
        return this.actualEncoding;
    }

    public void setActualEncoding(String value) {
        this.actualEncoding = value;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setStandalone(boolean value) {
        this.standalone = value;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fErrorHandlerWrapper.getErrorHandler();
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.fErrorHandlerWrapper.setErrorHandler(errorHandler);
    }

    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        if (n.getOwnerDocument() != this) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        switch (n.getNodeType()) {
            case 1: {
                ElementImpl el = (ElementImpl)n;
                if (el instanceof ElementNSImpl) {
                    ((ElementNSImpl)el).rename(namespaceURI, name);
                } else if (namespaceURI == null) {
                    el.rename(name);
                } else {
                    ElementNSImpl nel = new ElementNSImpl(this, namespaceURI, name);
                    this.copyEventListeners(el, nel);
                    Hashtable data = this.removeUserDataTable(el);
                    Node parent = el.getParentNode();
                    Node nextSib = el.getNextSibling();
                    if (parent != null) {
                        parent.removeChild(el);
                    }
                    Node child = el.getFirstChild();
                    while (child != null) {
                        el.removeChild(child);
                        nel.appendChild(child);
                        child = el.getFirstChild();
                    }
                    nel.moveSpecifiedAttributes(el);
                    this.setUserDataTable(nel, data);
                    this.callUserDataHandlers(el, nel, (short)4);
                    if (parent != null) {
                        parent.insertBefore(nel, nextSib);
                    }
                    el = nel;
                }
                this.renamedElement((Element)n, el);
                return el;
            }
            case 2: {
                AttrImpl at = (AttrImpl)n;
                Element el = at.getOwnerElement();
                if (el != null) {
                    el.removeAttributeNode(at);
                }
                if (n instanceof AttrNSImpl) {
                    ((AttrNSImpl)at).rename(namespaceURI, name);
                    if (el != null) {
                        el.setAttributeNodeNS(at);
                    }
                } else if (namespaceURI == null) {
                    at.rename(name);
                    if (el != null) {
                        el.setAttributeNode(at);
                    }
                } else {
                    AttrNSImpl nat = new AttrNSImpl(this, namespaceURI, name);
                    this.copyEventListeners(at, nat);
                    Hashtable data = this.removeUserDataTable(at);
                    Node child = at.getFirstChild();
                    while (child != null) {
                        at.removeChild(child);
                        nat.appendChild(child);
                        child = at.getFirstChild();
                    }
                    this.setUserDataTable(nat, data);
                    this.callUserDataHandlers(at, nat, (short)4);
                    if (el != null) {
                        el.setAttributeNode(nat);
                    }
                    at = nat;
                }
                this.renamedAttrNode((Attr)n, at);
                return at;
            }
        }
        throw new DOMException(9, "cannot rename this type of node.");
    }

    public void normalizeDocument() {
        if (this.isNormalized() && !this.isNormalizeDocRequired()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.domNormalizer == null) {
            this.domNormalizer = new DOMNormalizer();
        }
        if ((this.features & 0x80) != 0) {
            if (this.fConfiguration == null) {
                this.fConfiguration = new DOMValidationConfiguration(this.fSymbolTable);
            }
            if (this.fErrorHandlerWrapper.getErrorHandler() != null) {
                this.fConfiguration.setErrorHandler(this.fErrorHandlerWrapper);
            }
            this.fConfiguration.reset();
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.domNormalizer.setValidationHandler(CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema"));
            if (this.fGrammar != null) {
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.domNormalizer);
            }
        } else {
            this.domNormalizer.setValidationHandler(null);
        }
        this.domNormalizer.reset(this.fConfiguration);
        this.domNormalizer.normalizeDocument(this);
        if ((this.features & 0x80) != 0) {
            CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema");
        }
        this.isNormalized(true);
    }

    protected boolean isNormalizeDocRequired() {
        return true;
    }

    public void setNamespaceProcessing(boolean value) {
        this.features = value ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    public void setNormalizationFeature(String name, boolean state) throws DOMException {
        if (name.equals("comments")) {
            this.features = state ? (short)(this.features | 0x40) : (short)(this.features & 0xFFFFFFBF);
        } else if (name.equals("datatype-normalization")) {
            this.features = state ? (short)(this.features | 2) : (short)(this.features & 0xFFFFFFFD);
        } else if (name.equals("cdata-sections")) {
            this.features = state ? (short)(this.features | 8) : (short)(this.features & 0xFFFFFFF7);
        } else if (name.equals("entities")) {
            this.features = state ? (short)(this.features | 4) : (short)(this.features & 0xFFFFFFFB);
        } else if (name.equals("discard-default-content")) {
            this.features = state ? (short)(this.features | 0x10) : (short)(this.features & 0xFFFFFFEF);
        } else if (name.equals("split-cdata-sections")) {
            this.features = state ? (short)(this.features | 0x20) : (short)(this.features & 0xFFFFFFDF);
        } else if (name.equals("validate")) {
            this.features = state ? (short)(this.features | 0x80) : (short)(this.features & 0xFFFFFF7F);
        } else if (name.equals("infoset") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate-if-schema")) {
            if (state) {
                throw new DOMException(9, "Feature \"" + name + "\" cannot be set to \"" + state + "\"");
            }
        } else if (name.equals("namespace-declarations") || name.equals("whitespace-in-element-content")) {
            if (!state) {
                throw new DOMException(9, "Feature \"" + name + "\" cannot be set to \"" + state + "\"");
            }
        } else {
            throw new DOMException(8, "Feature \"" + name + "\" not recognized");
        }
    }

    public boolean getNormalizationFeature(String name) throws DOMException {
        if (name.equals("comments")) {
            return (this.features & 0x40) != 0;
        }
        if (name.equals("datatype-normalization")) {
            return (this.features & 2) != 0;
        }
        if (name.equals("cdata-sections")) {
            return (this.features & 8) != 0;
        }
        if (name.equals("entities")) {
            return (this.features & 4) != 0;
        }
        if (name.equals("discard-default-content")) {
            return (this.features & 0x10) != 0;
        }
        if (name.equals("split-cdata-sections")) {
            return (this.features & 0x20) != 0;
        }
        if (name.equals("infoset") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate") || name.equals("validate-if-schema")) {
            return false;
        }
        if (name.equals("namespace-declarations") || name.equals("whitespace-in-element-content")) {
            return true;
        }
        throw new DOMException(8, "Feature \"" + name + "\" not recognized");
    }

    public boolean canSetNormalizationFeature(String name, boolean state) {
        if (name.equals("comments") || name.equals("datatype-normalization") || name.equals("cdata-sections") || name.equals("entities") || name.equals("discard-default-content") || name.equals("split-cdata-sections")) {
            return true;
        }
        if (name.equals("infoset") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate") || name.equals("validate-if-schema")) {
            return !state;
        }
        if (name.equals("namespace-declarations") || name.equals("whitespace-in-element-content")) {
            return state;
        }
        throw new DOMException(8, "Feature \"" + name + "\" not recognized");
    }

    public String getBaseURI() {
        return this.fDocumentURI;
    }

    public void setDocumentURI(String documentURI) {
        this.fDocumentURI = documentURI;
    }

    public boolean getAsync() {
        return false;
    }

    public void setAsync(boolean async) {
        if (async) {
            throw new DOMException(9, "Asynchronous mode is not supported");
        }
    }

    public void abort() {
    }

    public boolean load(String uri) {
        return false;
    }

    public boolean loadXML(String source) {
        return false;
    }

    public String saveXML(Node snode) throws DOMException {
        if (snode != null && this.getOwnerDocument() != snode.getOwnerDocument()) {
            throw new DOMException(4, "Node " + snode.getNodeName() + " does not belongs to this Document.");
        }
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)DOMImplementationImpl.getDOMImplementation());
        DOMWriter xmlWriter = domImplLS.createDOMWriter();
        if (snode == null) {
            snode = this;
        }
        return xmlWriter.writeToString(snode);
    }

    void setMutationEvents(boolean set) {
    }

    boolean getMutationEvents() {
        return false;
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new DocumentTypeImpl(this, qualifiedName, publicID, systemID);
    }

    public Entity createEntity(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityImpl(this, name);
    }

    public Notation createNotation(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new NotationImpl(this, name);
    }

    public ElementDefinitionImpl createElementDefinition(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementDefinitionImpl(this, name);
    }

    public Node importNode(Node source, boolean deep) throws DOMException {
        return this.importNode(source, deep, false, null);
    }

    private Node importNode(Node source, boolean deep, boolean cloningDoc, Hashtable reversedIdentifiers) throws DOMException {
        Node newnode = null;
        short type = source.getNodeType();
        switch (type) {
            case 1: {
                Object elementId;
                boolean domLevel20 = source.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Element newElement = !domLevel20 || source.getLocalName() == null ? this.createElement(source.getNodeName()) : this.createElementNS(source.getNamespaceURI(), source.getNodeName());
                NamedNodeMap sourceAttrs = source.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    int index = 0;
                    while (index < length) {
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (attr.getSpecified()) {
                            Attr newAttr = (Attr)this.importNode(attr, true, false, reversedIdentifiers);
                            if (!domLevel20 || attr.getLocalName() == null) {
                                newElement.setAttributeNode(newAttr);
                            } else {
                                newElement.setAttributeNodeNS(newAttr);
                            }
                        }
                        ++index;
                    }
                }
                if (reversedIdentifiers != null && (elementId = reversedIdentifiers.get(source)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new Hashtable();
                    }
                    this.identifiers.put(elementId, newElement);
                }
                newnode = newElement;
                break;
            }
            case 2: {
                newnode = source.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") ? (source.getLocalName() == null ? this.createAttribute(source.getNodeName()) : this.createAttributeNS(source.getNamespaceURI(), source.getNodeName())) : this.createAttribute(source.getNodeName());
                if (source instanceof AttrImpl) {
                    AttrImpl attr = (AttrImpl)source;
                    if (attr.hasStringValue()) {
                        AttrImpl newattr = (AttrImpl)newnode;
                        newattr.setValue(attr.getValue());
                        deep = false;
                        break;
                    }
                    deep = true;
                    break;
                }
                if (source.getFirstChild() == null) {
                    newnode.setNodeValue(source.getNodeValue());
                    deep = false;
                    break;
                }
                deep = true;
                break;
            }
            case 3: {
                newnode = this.createTextNode(source.getNodeValue());
                break;
            }
            case 4: {
                newnode = this.createCDATASection(source.getNodeValue());
                break;
            }
            case 5: {
                newnode = this.createEntityReference(source.getNodeName());
                deep = false;
                break;
            }
            case 6: {
                Entity srcentity = (Entity)source;
                EntityImpl newentity = (EntityImpl)this.createEntity(source.getNodeName());
                newentity.setPublicId(srcentity.getPublicId());
                newentity.setSystemId(srcentity.getSystemId());
                newentity.setNotationName(srcentity.getNotationName());
                newentity.isReadOnly(false);
                newnode = newentity;
                break;
            }
            case 7: {
                newnode = this.createProcessingInstruction(source.getNodeName(), source.getNodeValue());
                break;
            }
            case 8: {
                newnode = this.createComment(source.getNodeValue());
                break;
            }
            case 10: {
                int i;
                if (!cloningDoc) {
                    throw new DOMException(9, "Node type being imported is not supported");
                }
                DocumentType srcdoctype = (DocumentType)source;
                DocumentTypeImpl newdoctype = (DocumentTypeImpl)this.createDocumentType(srcdoctype.getNodeName(), srcdoctype.getPublicId(), srcdoctype.getSystemId());
                NamedNodeMap smap = srcdoctype.getEntities();
                NamedNodeMap tmap = newdoctype.getEntities();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        tmap.setNamedItem(this.importNode(smap.item(i), true, false, reversedIdentifiers));
                        ++i;
                    }
                }
                smap = srcdoctype.getNotations();
                tmap = newdoctype.getNotations();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        tmap.setNamedItem(this.importNode(smap.item(i), true, false, reversedIdentifiers));
                        ++i;
                    }
                }
                newnode = newdoctype;
                break;
            }
            case 11: {
                newnode = this.createDocumentFragment();
                break;
            }
            case 12: {
                Notation srcnotation = (Notation)source;
                NotationImpl newnotation = (NotationImpl)this.createNotation(source.getNodeName());
                newnotation.setPublicId(srcnotation.getPublicId());
                newnotation.setSystemId(srcnotation.getSystemId());
                newnode = newnotation;
                break;
            }
            default: {
                throw new DOMException(9, "Node type being imported is not supported");
            }
        }
        this.callUserDataHandlers(source, newnode, (short)2);
        if (deep) {
            Node srckid = source.getFirstChild();
            while (srckid != null) {
                newnode.appendChild(this.importNode(srckid, true, false, reversedIdentifiers));
                srckid = srckid.getNextSibling();
            }
        }
        if (newnode.getNodeType() == 6) {
            ((NodeImpl)newnode).setReadOnly(true, true);
        }
        return newnode;
    }

    /*
     * WARNING - void declaration
     */
    public Node adoptNode(Node source) {
        NodeImpl node;
        try {
            node = (NodeImpl)source;
        }
        catch (ClassCastException e) {
            return null;
        }
        switch (node.getNodeType()) {
            case 2: {
                AttrImpl attr = (AttrImpl)node;
                attr.getOwnerElement().removeAttributeNode(attr);
                attr.isSpecified(true);
                attr.setOwnerDocument(this);
                break;
            }
            case 9: 
            case 10: {
                throw new DOMException(9, "cannot adopt this type of node.");
            }
            case 5: {
                NamedNodeMap entities;
                Node entityNode;
                Node child;
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                while ((child = node.getFirstChild()) != null) {
                    void var4_8;
                    node.removeChild((Node)var4_8);
                }
                node.setOwnerDocument(this);
                if (this.docType == null || (entityNode = (entities = this.docType.getEntities()).getNamedItem(node.getNodeName())) == null) break;
                EntityImpl entity = (EntityImpl)entityNode;
                child = entityNode.getFirstChild();
                while (child != null) {
                    Node childClone = child.cloneNode(true);
                    node.appendChild(childClone);
                    child = child.getNextSibling();
                }
                break;
            }
            case 1: {
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                node.setOwnerDocument(this);
                ((ElementImpl)node).reconcileDefaultAttributes();
                break;
            }
            default: {
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                node.setOwnerDocument(this);
            }
        }
        return node;
    }

    public Element getElementById(String elementId) {
        return this.getIdentifier(elementId);
    }

    public void putIdentifier(String idName, Element element) {
        if (element == null) {
            this.removeIdentifier(idName);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(idName, element);
    }

    public Element getIdentifier(String idName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(idName);
    }

    public void removeIdentifier(String idName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(idName);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementNSImpl(this, namespaceURI, qualifiedName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return new ElementNSImpl(this, namespaceURI, qualifiedName, localpart);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrNSImpl(this, namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName, String localName) throws DOMException {
        return new AttrNSImpl(this, namespaceURI, qualifiedName, localName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DeepNodeListImpl(this, namespaceURI, localName);
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl newdoc = (CoreDocumentImpl)super.clone();
        newdoc.docType = null;
        newdoc.docElement = null;
        return newdoc;
    }

    public static boolean isXMLName(String s) {
        if (s == null) {
            return false;
        }
        return XMLChar.isValidName(s);
    }

    protected boolean isKidOK(Node parent, Node child) {
        if (this.allowGrammarAccess && parent.getNodeType() == 10) {
            return child.getNodeType() == 1;
        }
        return 0 != (kidOK[parent.getNodeType()] & 1 << child.getNodeType());
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    NodeListCache getNodeListCache(ParentNode owner) {
        if (this.fFreeNLCache == null) {
            return new NodeListCache(owner);
        }
        NodeListCache c = this.fFreeNLCache;
        this.fFreeNLCache = this.fFreeNLCache.next;
        c.fChild = null;
        c.fChildIndex = -1;
        c.fLength = -1;
        if (c.fOwner != null) {
            c.fOwner.fNodeListCache = null;
        }
        c.fOwner = owner;
        return c;
    }

    void freeNodeListCache(NodeListCache c) {
        c.next = this.fFreeNLCache;
        this.fFreeNLCache = c;
    }

    public Object setUserData(Node n, String key, Object data, UserDataHandler handler) {
        Hashtable<String, UserDataRecord> t;
        if (data == null) {
            Object o;
            Hashtable t2;
            if (this.userData != null && (t2 = (Hashtable)this.userData.get(n)) != null && (o = t2.remove(key)) != null) {
                UserDataRecord r = (UserDataRecord)o;
                return r.fData;
            }
            return null;
        }
        if (this.userData == null) {
            this.userData = new Hashtable();
            t = new Hashtable<String, UserDataRecord>();
            this.userData.put(n, t);
        } else {
            t = (Hashtable<String, UserDataRecord>)this.userData.get(n);
            if (t == null) {
                t = new Hashtable();
                this.userData.put(n, t);
            }
        }
        UserDataRecord o = t.put(key, new UserDataRecord(data, handler));
        if (o != null) {
            UserDataRecord r = o;
            return r.fData;
        }
        return null;
    }

    public Object getUserData(Node n, String key) {
        if (this.userData == null) {
            return null;
        }
        Hashtable t = (Hashtable)this.userData.get(n);
        if (t == null) {
            return null;
        }
        Object o = t.get(key);
        if (o != null) {
            UserDataRecord r = (UserDataRecord)o;
            return r.fData;
        }
        return null;
    }

    Hashtable removeUserDataTable(Node n) {
        if (this.userData == null) {
            return null;
        }
        return (Hashtable)this.userData.get(n);
    }

    void setUserDataTable(Node n, Hashtable data) {
        if (data != null) {
            this.userData.put(n, data);
        }
    }

    void callUserDataHandlers(Node n, Node c, short operation) {
        if (this.userData == null) {
            return;
        }
        Hashtable t = (Hashtable)this.userData.get(n);
        if (t == null || t.isEmpty()) {
            return;
        }
        Enumeration keys = t.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            UserDataRecord r = (UserDataRecord)t.get(key);
            if (r.fHandler == null) continue;
            r.fHandler.handle(operation, key, r.fData, n, c);
        }
    }

    public void finalize() {
        if (this.userData == null) {
            return;
        }
        Enumeration nodes = this.userData.keys();
        while (nodes.hasMoreElements()) {
            Object node = nodes.nextElement();
            Hashtable t = (Hashtable)this.userData.get(node);
            if (t == null || t.isEmpty()) continue;
            Enumeration keys = t.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                UserDataRecord r = (UserDataRecord)t.get(key);
                if (r.fHandler == null) continue;
                r.fHandler.handle((short)3, key, r.fData, null, null);
            }
        }
    }

    public void copyConfigurationProperties(XMLParserConfiguration config) {
        this.fSymbolTable = new ShadowedSymbolTable((SymbolTable)config.getProperty("http://apache.org/xml/properties/internal/symbol-table"));
        this.fEntityResolver = config.getEntityResolver();
        XMLGrammarPool pool = (XMLGrammarPool)config.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        if (pool != null && this.docType == null) {
            String string = this.docElement.getNamespaceURI();
        }
    }

    protected void setUserData(NodeImpl n, Object data) {
        this.setUserData(n, "XERCES1DOMUSERDATA", data, null);
    }

    protected Object getUserData(NodeImpl n) {
        return this.getUserData(n, "XERCES1DOMUSERDATA");
    }

    protected void addEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
    }

    protected void removeEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
    }

    protected void copyEventListeners(NodeImpl src, NodeImpl tgt) {
    }

    protected boolean dispatchEvent(NodeImpl node, Event event) {
        return false;
    }

    void replacedText(NodeImpl node) {
    }

    void deletedText(NodeImpl node, int offset, int count) {
    }

    void insertedText(NodeImpl node, int offset, int count) {
    }

    void modifyingCharacterData(NodeImpl node) {
    }

    void modifiedCharacterData(NodeImpl node, String oldvalue, String value) {
    }

    void insertingNode(NodeImpl node, boolean replace) {
    }

    void insertedNode(NodeImpl node, NodeImpl newInternal, boolean replace) {
    }

    void removingNode(NodeImpl node, NodeImpl oldChild, boolean replace) {
    }

    void removedNode(NodeImpl node, boolean replace) {
    }

    void replacingNode(NodeImpl node) {
    }

    void replacedNode(NodeImpl node) {
    }

    void modifiedAttrValue(AttrImpl attr, String oldvalue) {
    }

    void setAttrNode(AttrImpl attr, AttrImpl previous) {
    }

    void removedAttrNode(AttrImpl attr, NodeImpl oldOwner, String name) {
    }

    void renamedAttrNode(Attr oldAt, Attr newAt) {
    }

    void renamedElement(Element oldEl, Element newEl) {
    }

    static {
        CoreDocumentImpl.kidOK[9] = 1410;
        CoreDocumentImpl.kidOK[1] = 442;
        CoreDocumentImpl.kidOK[5] = 442;
        CoreDocumentImpl.kidOK[6] = 442;
        CoreDocumentImpl.kidOK[11] = 442;
        CoreDocumentImpl.kidOK[2] = 40;
        CoreDocumentImpl.kidOK[12] = 0;
        CoreDocumentImpl.kidOK[4] = 0;
        CoreDocumentImpl.kidOK[3] = 0;
        CoreDocumentImpl.kidOK[8] = 0;
        CoreDocumentImpl.kidOK[7] = 0;
        CoreDocumentImpl.kidOK[10] = 0;
    }

    class UserDataRecord
    implements Serializable {
        Object fData;
        UserDataHandler fHandler;

        UserDataRecord(Object data, UserDataHandler handler) {
            this.fData = data;
            this.fHandler = handler;
        }
    }
}

