/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class DoubleDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2032;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return DoubleDV.dValueOf(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "double"});
        }
    }

    public int compare(Object value1, Object value2) {
        return this.compareDoubles((Double)value1, (Double)value2);
    }

    private static Double dValueOf(String s) throws NumberFormatException {
        Double d;
        try {
            d = Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equals("INF")) {
                d = new Double(Double.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                d = new Double(Double.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                d = new Double(Double.NaN);
            }
            throw nfe;
        }
        return d;
    }

    private int compareDoubles(Double value, Double anotherValue) {
        long anotherBits;
        double anotherVal;
        double thisVal = value;
        if (thisVal < (anotherVal = anotherValue.doubleValue())) {
            return -1;
        }
        if (thisVal > anotherVal) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(thisVal);
        return thisBits == (anotherBits = Double.doubleToLongBits(anotherVal)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }
}

