/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Structure {
    private static final boolean REVERSE_FIELDS;
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    protected static final int CALCULATE_SIZE = -1;
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private int structAlignment;
    private Map structFields = new LinkedHashMap();
    private Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;

    protected Structure() {
        this(-1);
    }

    protected Structure(int size) {
        this(size, 0);
    }

    protected Structure(int size, int alignment) {
        this.setAlignType(alignment);
        this.setTypeMapper(null);
        this.allocateMemory(size);
    }

    Map fields() {
        return this.structFields;
    }

    protected void setTypeMapper(TypeMapper mapper) {
        Class<?> declaring;
        if (mapper == null && (declaring = this.getClass().getDeclaringClass()) != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        this.typeMapper = mapper;
        this.size = -1;
        this.memory = null;
    }

    protected void setAlignType(int alignType) {
        if (alignType == 0) {
            Class<?> declaring = this.getClass().getDeclaringClass();
            if (declaring != null) {
                alignType = Native.getStructureAlignment(declaring);
            }
            if (alignType == 0) {
                alignType = Platform.isWindows() ? 3 : 2;
            }
        }
        this.alignType = alignType;
        this.size = -1;
        this.memory = null;
    }

    protected void allocateMemory() {
        this.allocateMemory(this.calculateSize());
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void useMemory(Pointer m, int offset) {
        this.memory = m.share(offset, this.size());
    }

    protected Pointer getMemory() {
        return this.memory;
    }

    protected void allocateMemory(int size) {
        if (size == -1) {
            size = this.calculateSize();
        } else if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than zero: " + size);
        }
        if (size != -1) {
            this.memory = new Memory(size);
            this.memory.clear(size);
            this.size = size;
        }
    }

    public int size() {
        if (this.size == -1) {
            this.allocateMemory();
        }
        return this.size;
    }

    public void clear() {
        this.memory.clear(this.size);
    }

    public Pointer getPointer() {
        return this.memory;
    }

    public void read() {
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            this.readField((StructField)i.next());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readField(StructField structField) {
        Pointer p;
        int offset = structField.offset;
        Class nativeType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            nativeType = readConverter.nativeType();
        }
        Object result = null;
        if (Structure.class.isAssignableFrom(nativeType)) {
            Structure s = null;
            try {
                s = (Structure)structField.field.get(this);
                s.useMemory(this.memory, offset);
                s.read();
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            result = s;
        } else if (nativeType == Byte.TYPE || nativeType == Byte.class) {
            result = new Byte(this.memory.getByte(offset));
        } else if (nativeType == Short.TYPE || nativeType == Short.class) {
            result = new Short(this.memory.getShort(offset));
        } else if (nativeType == Character.TYPE || nativeType == Character.class) {
            result = new Character(this.memory.getChar(offset));
        } else if (nativeType == Integer.TYPE || nativeType == Integer.class) {
            result = new Integer(this.memory.getInt(offset));
        } else if (nativeType == Long.TYPE || nativeType == Long.class) {
            result = new Long(this.memory.getLong(offset));
        } else if (nativeType == NativeLong.class) {
            result = this.memory.getNativeLong(offset);
        } else if (nativeType == Float.TYPE || nativeType == Float.class) {
            result = new Float(this.memory.getFloat(offset));
        } else if (nativeType == Double.TYPE || nativeType == Double.class) {
            result = new Double(this.memory.getDouble(offset));
        } else if (Pointer.class.isAssignableFrom(nativeType)) {
            result = this.memory.getPointer(offset);
        } else if (nativeType == String.class) {
            p = this.memory.getPointer(offset);
            result = p != null ? p.getString(0) : null;
        } else if (nativeType == WString.class) {
            p = this.memory.getPointer(offset);
            result = p != null ? new WString(p.getString(0, true)) : null;
        } else {
            if (Callback.class.isAssignableFrom(nativeType)) {
                return;
            }
            if (!nativeType.isArray()) throw new IllegalArgumentException("Unsupported field type \"" + nativeType + "\"");
            Class<?> cls = nativeType.getComponentType();
            int length = 0;
            try {
                Object o = structField.field.get(this);
                if (o == null) {
                    throw new IllegalStateException("Structure array field not initialized");
                }
                length = Array.getLength(o);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (cls == Byte.TYPE) {
                result = this.memory.getByteArray(offset, length);
            } else if (cls == Short.TYPE) {
                result = this.memory.getShortArray(offset, length);
            } else if (cls == Character.TYPE) {
                result = this.memory.getCharArray(offset, length);
            } else if (cls == Integer.TYPE) {
                result = this.memory.getIntArray(offset, length);
            } else if (cls == Long.TYPE) {
                result = this.memory.getLongArray(offset, length);
            } else if (cls == Float.TYPE) {
                result = this.memory.getFloatArray(offset, length);
            } else {
                if (cls != Double.TYPE) throw new IllegalArgumentException("Array of " + cls + " not supported");
                result = this.memory.getDoubleArray(offset, length);
            }
        }
        if (readConverter != null) {
            result = readConverter.fromNative(result, structField.context);
        }
        try {
            structField.field.set(this, result);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception setting field \"" + structField.name + "\"", e);
        }
    }

    public void write() {
        if (this.size == -1) {
            this.allocateMemory();
        }
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            this.writeField((StructField)i.next());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeField(StructField structField) {
        int offset = structField.offset;
        Object value = null;
        try {
            value = structField.field.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception reading field \"" + structField.name + "\"", e);
        }
        Class nativeType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            Class clazz = nativeType = (value = converter.toNative(value)) != null ? value.getClass() : Pointer.class;
        }
        if (String.class == nativeType || WString.class == nativeType) {
            boolean wide;
            boolean bl = wide = nativeType == WString.class;
            if (value != null) {
                NativeString nativeString = new NativeString(value.toString(), wide);
                this.nativeStrings.put(structField.name, nativeString);
                value = nativeString.getPointer();
            } else {
                value = null;
            }
        }
        if (nativeType == Byte.TYPE || nativeType == Byte.class) {
            this.memory.setByte(offset, (Byte)value);
            return;
        } else if (nativeType == Short.TYPE || nativeType == Short.class) {
            this.memory.setShort(offset, (Short)value);
            return;
        } else if (nativeType == Character.TYPE || nativeType == Character.class) {
            this.memory.setChar(offset, ((Character)value).charValue());
            return;
        } else if (nativeType == Integer.TYPE || nativeType == Integer.class) {
            this.memory.setInt(offset, (Integer)value);
            return;
        } else if (nativeType == Long.TYPE || nativeType == Long.class) {
            this.memory.setLong(offset, (Long)value);
            return;
        } else if (nativeType == NativeLong.class) {
            this.memory.setNativeLong(offset, (NativeLong)value);
            return;
        } else if (nativeType == Float.TYPE || nativeType == Float.class) {
            this.memory.setFloat(offset, ((Float)value).floatValue());
            return;
        } else if (nativeType == Double.TYPE || nativeType == Double.class) {
            this.memory.setDouble(offset, (Double)value);
            return;
        } else if (Pointer.class.isAssignableFrom(nativeType)) {
            this.memory.setPointer(offset, (Pointer)value);
            return;
        } else if (nativeType == String.class) {
            this.memory.setPointer(offset, (Pointer)value);
            return;
        } else if (nativeType == WString.class) {
            this.memory.setPointer(offset, (Pointer)value);
            return;
        } else if (nativeType.isArray()) {
            Class<?> cls = nativeType.getComponentType();
            if (cls == Byte.TYPE) {
                byte[] byArray = (byte[])value;
                this.memory.write(offset, byArray, 0, byArray.length);
                return;
            } else if (cls == Short.TYPE) {
                short[] sArray = (short[])value;
                this.memory.write(offset, sArray, 0, sArray.length);
                return;
            } else if (cls == Character.TYPE) {
                char[] cArray = (char[])value;
                this.memory.write(offset, cArray, 0, cArray.length);
                return;
            } else if (cls == Integer.TYPE) {
                int[] nArray = (int[])value;
                this.memory.write(offset, nArray, 0, nArray.length);
                return;
            } else if (cls == Long.TYPE) {
                long[] lArray = (long[])value;
                this.memory.write(offset, lArray, 0, lArray.length);
                return;
            } else if (cls == Float.TYPE) {
                float[] fArray = (float[])value;
                this.memory.write(offset, fArray, 0, fArray.length);
                return;
            } else {
                if (cls != Double.TYPE) throw new IllegalArgumentException("Inline array of " + cls + " not supported");
                double[] dArray = (double[])value;
                this.memory.write(offset, dArray, 0, dArray.length);
            }
            return;
        } else if (Structure.class.isAssignableFrom(nativeType)) {
            Structure s = (Structure)value;
            s.useMemory(this.memory, offset);
            s.write();
            return;
        } else {
            if (!Callback.class.isAssignableFrom(nativeType)) throw new IllegalArgumentException("Field \"" + structField.name + "\" was declared as an " + "unsupported type \"" + nativeType + "\"");
            Pointer p = null;
            if (value != null) {
                CallbackReference callbackReference = CallbackReference.getInstance((Callback)value);
                p = callbackReference.getTrampoline();
            }
            this.memory.setPointer(offset, p);
        }
    }

    int calculateSize() {
        int i;
        this.structAlignment = 1;
        int calculatedSize = 0;
        Field[] fields = this.getClass().getFields();
        if (REVERSE_FIELDS) {
            for (i = 0; i < fields.length / 2; ++i) {
                int idx = fields.length - 1 - i;
                Field tmp = fields[i];
                fields[i] = fields[idx];
                fields[idx] = tmp;
            }
        }
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 8) != 0) continue;
            Class type = field.getType();
            StructField structField = new StructField();
            structField.field = field;
            structField.name = field.getName();
            structField.type = type;
            int fieldAlignment = 1;
            try {
                Object value = field.get(this);
                if (value == null) {
                    if ((class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(type)) {
                        try {
                            value = type.newInstance();
                            field.set(this, value);
                        }
                        catch (InstantiationException e) {
                            String msg = "Can't determine size of  nested structure: " + e.getMessage();
                            throw new IllegalArgumentException(msg);
                        }
                    } else if ((class$com$sun$jna$NativeLong == null ? Structure.class$("com.sun.jna.NativeLong") : class$com$sun$jna$NativeLong) == type) {
                        value = new NativeLong(0L);
                        field.set(this, value);
                    } else if (type.isArray()) {
                        return -1;
                    }
                }
                Class nativeType = type;
                if (this.typeMapper != null) {
                    ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type);
                    FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type);
                    if (writeConverter != null && readConverter != null) {
                        nativeType = (value = writeConverter.toNative(value)) != null ? value.getClass() : (class$com$sun$jna$Pointer == null ? Structure.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer);
                        structField.writeConverter = writeConverter;
                        structField.readConverter = readConverter;
                        structField.context = new StructureReadContext(type, this);
                    } else if (writeConverter != null || readConverter != null) {
                        String msg = "Structures require bidirectional type conversion for " + type;
                        throw new IllegalArgumentException(msg);
                    }
                }
                structField.size = this.getNativeSize(nativeType, value);
                fieldAlignment = this.getNativeAlignment(nativeType, value, i == 0);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
            if (calculatedSize % fieldAlignment != 0) {
                calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
            }
            structField.offset = calculatedSize;
            calculatedSize += structField.size;
            this.structFields.put(structField.name, structField);
        }
        if (calculatedSize > 0) {
            return this.calculateAlignedSize(calculatedSize);
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown size (ensure " + "all fields are public)");
    }

    int calculateAlignedSize(int calculatedSize) {
        if (this.alignType != 1 && calculatedSize % this.structAlignment != 0) {
            calculatedSize += this.structAlignment - calculatedSize % this.structAlignment;
        }
        return calculatedSize;
    }

    protected int getNativeAlignment(Class type, Object value, boolean firstElement) {
        int alignment = 1;
        int size = this.getNativeSize(type, value);
        if (type.isPrimitive() || Long.class == type || Integer.class == type || NativeLong.class == type || Short.class == type || Character.class == type || Byte.class == type || Float.class == type || Double.class == type) {
            alignment = size;
        } else if (Pointer.class.isAssignableFrom(type) || Callback.class.isAssignableFrom(type) || WString.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            alignment = Pointer.SIZE;
        } else if (Structure.class.isAssignableFrom(type)) {
            alignment = ((Structure)value).structAlignment;
        } else if (type.isArray()) {
            alignment = this.getNativeAlignment(type.getComponentType(), null, firstElement);
        } else {
            throw new IllegalArgumentException("Type " + type + " has unknown " + "native alignment");
        }
        if (this.alignType == 1) {
            return 1;
        }
        if (this.alignType == 3) {
            return Math.min(8, alignment);
        }
        if (!(this.alignType != 2 || firstElement && "ppc".equals(System.getProperty("os.arch")))) {
            return Math.min(4, alignment);
        }
        return alignment;
    }

    protected int getNativeSize(Class cls) {
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Pointer.WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (NativeLong.class.isAssignableFrom(cls)) {
            return Pointer.LONG_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return Pointer.SIZE;
        }
        throw new IllegalArgumentException("Native type undefined for " + cls);
    }

    protected int getNativeSize(Class type, Object value) {
        if (Structure.class.isAssignableFrom(type)) {
            Structure s = (Structure)value;
            return s.size();
        }
        if (type.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * this.getNativeSize(type.getComponentType(), o);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed in structure: " + this);
        }
        return this.getNativeSize(type);
    }

    public String toString() {
        String LS = System.getProperty("line.separator");
        String name = this.getClass().getName() + "(" + this.getPointer() + ")";
        String contents = "";
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            contents = contents + "  " + i.next();
            contents = contents + LS;
        }
        byte[] buf = this.getPointer().getByteArray(0, this.size());
        int BYTES_PER_ROW = 4;
        contents = contents + "memory dump" + LS;
        for (int i2 = 0; i2 < buf.length; ++i2) {
            if (i2 % 4 == 0) {
                contents = contents + "[";
            }
            if (buf[i2] >= 0 && buf[i2] < 16) {
                contents = contents + "0";
            }
            contents = contents + Integer.toHexString(buf[i2] & 0xFF);
            if (i2 % 4 != 3 || i2 >= buf.length - 1) continue;
            contents = contents + "]" + LS;
        }
        contents = contents + "]";
        return name + LS + contents;
    }

    public Structure[] toArray(Structure[] array) {
        if (this.memory instanceof Memory) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.getSize() < requiredSize) {
                m = new Memory(requiredSize);
                m.clear();
                this.useMemory(m);
            }
        }
        array[0] = this;
        int size = this.size();
        for (int i = 1; i < array.length; ++i) {
            try {
                array[i] = (Structure)this.getClass().newInstance();
                array[i].useMemory(this.memory.share(i * size, size));
                array[i].read();
                continue;
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Error instantiating " + this.getClass() + ": " + e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Not allowed to instantiate " + this.getClass() + ": " + e);
            }
        }
        return array;
    }

    public Structure[] toArray(int size) {
        return this.toArray(new Structure[size]);
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.getClass() == this.getClass() && ((Structure)o).getPointer().equals(this.getPointer());
    }

    public int hashCode() {
        return this.getPointer().hashCode();
    }

    static {
        Field[] fields = MemberOrder.class.getFields();
        REVERSE_FIELDS = "last".equals(fields[0].getName());
        if (!"middle".equals(fields[1].getName())) {
            throw new Error("This VM does not store fields in a predictable order");
        }
    }

    class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        StructField() {
        }

        public String toString() {
            Object value = "<unavailable>";
            try {
                value = this.field.get(Structure.this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.type + " " + this.name + "@" + Integer.toHexString(this.offset) + "=" + value;
        }
    }

    private static class MemberOrder {
        public int first;
        public int middle;
        public int last;

        private MemberOrder() {
        }
    }
}

