/*
 * SketchBSample.java
 *
 * Created on 10. novembre 2006, 16:32
 */

package org.jdiffchaser.samples.sketchbook.version2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SketchBSample extends javax.swing.JFrame {

    private static JFrame instance;     

    private static final Stroke PEN_STROKE = new BasicStroke(10.0f, 
                                                             BasicStroke.CAP_ROUND,
                                                             BasicStroke.JOIN_ROUND);
    
    private class PaintAdapter implements MouseMotionListener, MouseListener{
        
        private int x, y = 0;
        private PaintPanel paintPanel;
        
        public PaintAdapter(PaintPanel paintPanel){
            super();
            this.paintPanel = paintPanel;
            this.paintPanel.addMouseListener(this);
            this.paintPanel.addMouseMotionListener(this);
        }
        
        public void mouseMoved(MouseEvent e) {
        }
        
        public void mouseDragged(MouseEvent e) {
            Graphics2D g2d = (Graphics2D) this.paintPanel.getBufferGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                                 RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.BLUE);
            g2d.setStroke(PEN_STROKE);
            g2d.drawLine(x, y , e.getX(), e.getY());
            x = e.getX();
            y = e.getY();
            this.paintPanel.repaint();
        }
        public void mousePressed(MouseEvent e) {
            x = e.getX();
            y = e.getY();            
        }
        
        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
    
    /** Creates new form LoginExample */
    public SketchBSample() {
        initComponents();
        setSize(800, 600);
        instance = this; //needed by jdiffchaser to have frame access
        PaintAdapter painter = new PaintAdapter((PaintPanel)this.paintPanel);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        paintPanel = new PaintPanel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        jMenuItem3 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Paint example");
        paintPanel.setBackground(new java.awt.Color(255, 255, 255));
        getContentPane().add(paintPanel, java.awt.BorderLayout.CENTER);

        jMenu1.setText("File");
        jMenuItem1.setText("New");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });

        jMenu1.add(jMenuItem1);

        jMenuItem2.setText("Exit");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });

        jMenu1.add(jMenuItem2);

        jMenuBar1.add(jMenu1);

        jMenu2.setText("Help");
        jMenuItem3.setText("About...");
        jMenuItem3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem3ActionPerformed(evt);
            }
        });

        jMenu2.add(jMenuItem3);

        jMenuBar1.add(jMenu2);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItem3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem3ActionPerformed
        JOptionPane.showConfirmDialog(this, "This is SketchBook " + getVersion() + " about box", 
                                      "About...", JOptionPane.OK_OPTION);
    }//GEN-LAST:event_jMenuItem3ActionPerformed

    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed
        System.exit(0);
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        ((PaintPanel)this.paintPanel).erase();
        this.paintPanel.repaint();
    }//GEN-LAST:event_jMenuItem1ActionPerformed
    
    public static JFrame getFrame(){
        return instance;
    }    
    
    public static String getVersion(){
        return " v 2.0 ";
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SketchBSample().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JPanel paintPanel;
    // End of variables declaration//GEN-END:variables
    
}
