/*
 * This file is part of jDiffChaser.
 *
 *  jDiffChaser is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  jDiffChaser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with jDiffChaser; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.jdiffchaser.scenarihandling;
import org.jdiffchaser.imgprocessing.IgnoredBgPattern;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;

public class ScreenshotPanel extends JPanel{

    private BufferedImage image;
    private BufferedImage patternImage;
    private IgnoredAreaMouseMotionAdapter ignoredAreaAdapter;

    public ScreenshotPanel(BufferedImage image, boolean editable){
        this.image = image;
        patternImage = IgnoredBgPattern.createImage(image.getWidth(), image.getHeight());        
        this.setSize(image.getWidth(), image.getHeight());
        this.setMaximumSize(new Dimension(image.getWidth(), image.getHeight()));
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));

        if(editable){
            ignoredAreaAdapter = new IgnoredAreaMouseMotionAdapter(this);

            this.addMouseListener(ignoredAreaAdapter);
            this.addMouseMotionListener(ignoredAreaAdapter);
        }
    }

    public void setImage(BufferedImage image){
        this.image = image;
    }

    public void paint(Graphics g){
        super.paint(g);

        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), this);
        if(ignoredAreaAdapter!=null){
            if(ignoredAreaAdapter.getIgnoredZones()!=null){
                g.setColor(Color.ORANGE);
                for(int i=0; i<ignoredAreaAdapter.getIgnoredZones().size(); i++){
                    Rectangle recToCopy = (Rectangle)ignoredAreaAdapter.getIgnoredZones().get(i);
                    Image subImage = patternImage.getSubimage(recToCopy.x, 
                                                              recToCopy.y, 
                                                              recToCopy.width, 
                                                              recToCopy.height);
                    g.drawImage(subImage, recToCopy.x, recToCopy.y, recToCopy.width, recToCopy.height, this);
                }
            }
            if(ignoredAreaAdapter.getCurrentIgnoredZone()!=null){
                g.setColor(Color.CYAN);
                ((Graphics2D)g).draw(ignoredAreaAdapter.getCurrentIgnoredZone());
            }
        }
    }
    
    public void resetIgnoredAreas(){
        ignoredAreaAdapter.reset();
    }
    
    public List getIgnoredZones(){
        return this.ignoredAreaAdapter.getIgnoredZones();
    }
}

