/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.delaunay.twoD;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayBoundaryVertex;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayEdge;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayList;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayLoop;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class Jun2dDelaunayProcessor
extends JunAbstractObject {
    public static final double DECIMAL_8 = 1.0E-8;
    public static final double DECIMAL_12 = 1.0E-12;
    protected Jun2dDelaunayList loops;
    protected Jun2dDelaunayList vertices;
    protected Jun2dDelaunayList edges;
    protected Jun2dBoundingBox bounds;
    protected boolean constrained;

    public Jun2dDelaunayProcessor() {
    }

    public Jun2dDelaunayProcessor(Jun2dBoundingBox jun2dBoundingBox) {
        this.setBounds_(jun2dBoundingBox);
        this.initialize();
    }

    public static Jun2dDelaunayProcessor Bounds_(Jun2dBoundingBox jun2dBoundingBox) {
        return new Jun2dDelaunayProcessor(jun2dBoundingBox);
    }

    public static Jun2dDelaunayProcessor FromPoints_(JunPoint[] junPointArray) {
        double d;
        double d2;
        double d3 = d2 = junPointArray[0].x();
        double d4 = d = junPointArray[0].y();
        for (int i = 0; i < junPointArray.length; ++i) {
            double d5 = junPointArray[i].x();
            double d6 = junPointArray[i].y();
            if (d5 < d2) {
                d2 = d5;
            }
            if (d3 < d5) {
                d3 = d5;
            }
            if (d6 < d) {
                d = d6;
            }
            if (!(d4 < d6)) continue;
            d4 = d6;
        }
        double d7 = (d3 - d2) / 4.0;
        double d8 = (d4 - d) / 4.0;
        Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(d2 - d7, d - d8), new Jun2dPoint(d3 + d7, d4 + d8)));
        for (int i = 0; i < junPointArray.length; ++i) {
            jun2dDelaunayProcessor.insertPoint_(junPointArray[i]);
        }
        return jun2dDelaunayProcessor;
    }

    public static Jun2dDelaunayProcessor FromPolygon_(JunPoint[] junPointArray) {
        double d;
        double d2;
        double d3 = d2 = junPointArray[0].x();
        double d4 = d = junPointArray[0].y();
        for (int i = 0; i < junPointArray.length; ++i) {
            double d5 = junPointArray[i].x();
            double d6 = junPointArray[i].y();
            if (d5 < d2) {
                d2 = d5;
            }
            if (d3 < d5) {
                d3 = d5;
            }
            if (d6 < d) {
                d = d6;
            }
            if (!(d4 < d6)) continue;
            d4 = d6;
        }
        double d7 = (d3 - d2) / 4.0;
        double d8 = (d4 - d) / 4.0;
        Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(d2 - d7, d - d8), new Jun2dPoint(d3 + d7, d4 + d8)));
        jun2dDelaunayProcessor.insertPolygon_(junPointArray);
        return jun2dDelaunayProcessor;
    }

    public static Jun2dBoundingBox DefaultBounds() {
        return Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(-1.0E-4, -1.0E-4), new Jun2dPoint(1.0E-4, 1.0E-4));
    }

    public static Hashtable _IdentityDictionary() {
        return new Hashtable(){
            Vector keys = Jun2dDelaunayProcessor._IdentitySet();
            Vector values = new Vector();

            public Object put(Object object, Object object2) {
                int n = this.keys.indexOf(object);
                if (n < 0) {
                    this.keys.addElement(object);
                    this.values.addElement(object2);
                } else {
                    this.values.setElementAt(object2, n);
                }
                return null;
            }

            public Object get(Object object) {
                int n = this.keys.indexOf(object);
                if (n < 0) {
                    return null;
                }
                return this.values.elementAt(n);
            }

            public Enumeration keys() {
                return this.keys.elements();
            }
        };
    }

    public static Vector _IdentitySet() {
        return new Vector(){

            public int indexOf(Object object) {
                for (int i = 0; i < this.elementCount; ++i) {
                    if (this.elementData[i] != object) continue;
                    return i;
                }
                return -1;
            }

            public void addElement(Object object) {
                if (this.indexOf(object) < 0) {
                    super.addElement(object);
                }
            }
        };
    }

    protected void initialize() {
        if (this.bounds == null) {
            this.bounds = this.DefaultBounds();
        }
        this.vertices = new Jun2dDelaunayList();
        this.edges = new Jun2dDelaunayList();
        this.loops = new Jun2dDelaunayList();
        Jun2dDelaunayBoundaryVertex jun2dDelaunayBoundaryVertex = this.newBoundaryVertexAtX_y_(this.bounds.origin().x(), this.bounds.origin().y());
        Jun2dDelaunayBoundaryVertex jun2dDelaunayBoundaryVertex2 = this.newBoundaryVertexAtX_y_(this.bounds.corner().x(), this.bounds.origin().y());
        Jun2dDelaunayBoundaryVertex jun2dDelaunayBoundaryVertex3 = this.newBoundaryVertexAtX_y_(this.bounds.corner().x(), this.bounds.corner().y());
        Jun2dDelaunayBoundaryVertex jun2dDelaunayBoundaryVertex4 = this.newBoundaryVertexAtX_y_(this.bounds.origin().x(), this.bounds.corner().y());
        Jun2dDelaunayLoop jun2dDelaunayLoop = this.newLoop();
        Jun2dDelaunayLoop jun2dDelaunayLoop2 = this.newLoop();
        Jun2dDelaunayEdge jun2dDelaunayEdge = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge2 = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge3 = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge4 = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge5 = this.newEdge();
        jun2dDelaunayEdge.vertex1_(jun2dDelaunayBoundaryVertex);
        jun2dDelaunayEdge.vertex2_(jun2dDelaunayBoundaryVertex2);
        jun2dDelaunayEdge2.vertex1_(jun2dDelaunayBoundaryVertex2);
        jun2dDelaunayEdge2.vertex2_(jun2dDelaunayBoundaryVertex3);
        jun2dDelaunayEdge3.vertex1_(jun2dDelaunayBoundaryVertex3);
        jun2dDelaunayEdge3.vertex2_(jun2dDelaunayBoundaryVertex4);
        jun2dDelaunayEdge4.vertex1_(jun2dDelaunayBoundaryVertex4);
        jun2dDelaunayEdge4.vertex2_(jun2dDelaunayBoundaryVertex);
        jun2dDelaunayEdge5.vertex1_(jun2dDelaunayBoundaryVertex);
        jun2dDelaunayEdge5.vertex2_(jun2dDelaunayBoundaryVertex3);
        jun2dDelaunayEdge.halfEdge12().next_(jun2dDelaunayEdge2.halfEdge12());
        jun2dDelaunayEdge2.halfEdge12().next_(jun2dDelaunayEdge5.halfEdge21());
        jun2dDelaunayEdge5.halfEdge21().next_(jun2dDelaunayEdge.halfEdge12());
        jun2dDelaunayEdge3.halfEdge12().next_(jun2dDelaunayEdge4.halfEdge12());
        jun2dDelaunayEdge4.halfEdge12().next_(jun2dDelaunayEdge5.halfEdge12());
        jun2dDelaunayEdge5.halfEdge12().next_(jun2dDelaunayEdge3.halfEdge12());
        jun2dDelaunayEdge.halfEdge21().next_(jun2dDelaunayEdge4.halfEdge21());
        jun2dDelaunayEdge2.halfEdge21().next_(jun2dDelaunayEdge.halfEdge21());
        jun2dDelaunayEdge3.halfEdge21().next_(jun2dDelaunayEdge2.halfEdge21());
        jun2dDelaunayEdge4.halfEdge21().next_(jun2dDelaunayEdge3.halfEdge21());
        jun2dDelaunayEdge.loop12_(jun2dDelaunayLoop);
        jun2dDelaunayEdge2.loop12_(jun2dDelaunayLoop);
        jun2dDelaunayEdge5.loop21_(jun2dDelaunayLoop);
        jun2dDelaunayEdge3.loop12_(jun2dDelaunayLoop2);
        jun2dDelaunayEdge4.loop12_(jun2dDelaunayLoop2);
        jun2dDelaunayEdge5.loop12_(jun2dDelaunayLoop2);
        jun2dDelaunayLoop.halfEdge_(jun2dDelaunayEdge.halfEdge12());
        jun2dDelaunayLoop2.halfEdge_(jun2dDelaunayEdge4.halfEdge12());
        jun2dDelaunayBoundaryVertex.halfEdge_(jun2dDelaunayEdge.halfEdge21());
        jun2dDelaunayBoundaryVertex2.halfEdge_(jun2dDelaunayEdge2.halfEdge21());
        jun2dDelaunayBoundaryVertex3.halfEdge_(jun2dDelaunayEdge3.halfEdge21());
        jun2dDelaunayBoundaryVertex4.halfEdge_(jun2dDelaunayEdge4.halfEdge21());
        this.constrained = false;
    }

    public JunPoint[][] insideTriangles() {
        final ArrayList arrayList = new ArrayList();
        this.insideTrianglesDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(new JunPoint[]{(JunPoint)((Object)object), (JunPoint)((Object)object2), (JunPoint)((Object)object3)});
                return null;
            }
        });
        return (JunPoint[][])arrayList.toArray((T[])new JunPoint[arrayList.size()][]);
    }

    public Jun2dDelaunayLoop loopAt_(JunPoint junPoint) {
        return this.loopAtX_y_(junPoint.x(), junPoint.y());
    }

    public JunPoint[] triangleAt_(JunPoint junPoint) {
        JunPoint[] junPointArray;
        Jun2dDelaunayLoop jun2dDelaunayLoop = this.loopAt_(junPoint);
        if (jun2dDelaunayLoop != null) {
            JunPoint[] junPointArray2 = new JunPoint[3];
            junPointArray2[0] = jun2dDelaunayLoop.point1();
            junPointArray2[1] = jun2dDelaunayLoop.point2();
            junPointArray = junPointArray2;
            junPointArray2[2] = jun2dDelaunayLoop.point3();
        } else {
            junPointArray = null;
        }
        return junPointArray;
    }

    public JunPoint[][] triangles() {
        final ArrayList arrayList = new ArrayList();
        this.trianglesDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(new JunPoint[]{(JunPoint)((Object)object), (JunPoint)((Object)object2), (JunPoint)((Object)object3)});
                return null;
            }
        });
        return (JunPoint[][])arrayList.toArray((T[])new JunPoint[arrayList.size()][]);
    }

    public Jun2dDelaunayVertex vertexAt_(JunPoint junPoint) {
        return this.nearestVertexFromX_y_(junPoint.x(), junPoint.y());
    }

    public void displayOn_(final Graphics graphics) {
        this.edges.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayEdge jun2dDelaunayEdge = (Jun2dDelaunayEdge)((Object)object);
                jun2dDelaunayEdge.displayOn_(graphics);
                return null;
            }
        });
    }

    public Jun2dDelaunayBoundaryVertex newBoundaryVertexAtX_y_(double d, double d2) {
        return (Jun2dDelaunayBoundaryVertex)this.vertices.add_(new Jun2dDelaunayBoundaryVertex(d, d2));
    }

    public Jun2dDelaunayEdge newEdge() {
        return (Jun2dDelaunayEdge)this.edges.add_(new Jun2dDelaunayEdge());
    }

    public Jun2dDelaunayLoop newLoop() {
        return (Jun2dDelaunayLoop)this.loops.add_(new Jun2dDelaunayLoop());
    }

    public Jun2dDelaunayVertex newVertex() {
        return (Jun2dDelaunayVertex)this.vertices.add_(new Jun2dDelaunayVertex());
    }

    public Jun2dDelaunayVertex newVertexAtX_y_(double d, double d2) {
        return (Jun2dDelaunayVertex)this.vertices.add_(new Jun2dDelaunayVertex(d, d2));
    }

    public Jun2dDelaunayVertex newVertexAtX_y_z_(double d, double d2, double d3) {
        return (Jun2dDelaunayVertex)this.vertices.add_(new Jun2dDelaunayVertex(d, d2, d3));
    }

    public void convexHullTrianglesDo_(final StBlockClosure stBlockClosure) {
        this.loops.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)object);
                if (!jun2dDelaunayLoop.hasBoundaryVertex()) {
                    stBlockClosure.value_value_value_((Object)jun2dDelaunayLoop.point1(), (Object)jun2dDelaunayLoop.point2(), (Object)jun2dDelaunayLoop.point3());
                }
                return null;
            }
        });
    }

    public void insideTrianglesDo_(StBlockClosure stBlockClosure) {
        Object object;
        final Hashtable hashtable = Jun2dDelaunayProcessor._IdentityDictionary();
        final StValueHolder stValueHolder = new StValueHolder((Object)Jun2dDelaunayProcessor._IdentitySet());
        this.vertices.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                if (jun2dDelaunayVertex.isBoundaryVertex()) {
                    jun2dDelaunayVertex.loopsDo_(new StBlockClosure(){

                        public Object value_(Object object) {
                            Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)object);
                            hashtable.put(jun2dDelaunayLoop, new Integer(0));
                            ((Vector)stValueHolder.value()).addElement(jun2dDelaunayLoop);
                            return null;
                        }
                    });
                }
                return null;
            }
        });
        while (!((Vector)stValueHolder.value()).isEmpty()) {
            object = Jun2dDelaunayProcessor._IdentitySet();
            for (int i = 0; i < ((Vector)stValueHolder.value()).size(); ++i) {
                Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)((Vector)stValueHolder.value()).elementAt(i));
                final int n = (Integer)hashtable.get((Object)jun2dDelaunayLoop);
                jun2dDelaunayLoop.halfEdgesDo_(new StBlockClosure((Vector)object){
                    private final /* synthetic */ Vector val$updatedLoops;
                    {
                        this.val$updatedLoops = vector;
                    }

                    public Object value_(Object object) {
                        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                        Jun2dDelaunayLoop jun2dDelaunayLoop = jun2dDelaunayHalfEdge.pair().loop();
                        if (jun2dDelaunayLoop != null) {
                            int n3 = jun2dDelaunayHalfEdge.edge().isConstrained() ? n + 1 : n;
                            Integer n2 = (Integer)hashtable.get((Object)jun2dDelaunayLoop);
                            if (n2 == null || n3 < n2) {
                                hashtable.put(jun2dDelaunayLoop, new Integer(n3));
                                this.val$updatedLoops.addElement(jun2dDelaunayLoop);
                            }
                        }
                        return null;
                    }
                });
            }
            stValueHolder.value_(object);
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)object.nextElement());
            int n = ((Number)hashtable.get((Object)jun2dDelaunayLoop)).intValue();
            if (n % 2 == 0) continue;
            stBlockClosure.value_value_value_((Object)jun2dDelaunayLoop.point1(), (Object)jun2dDelaunayLoop.point2(), (Object)jun2dDelaunayLoop.point3());
        }
    }

    public void trianglesDo_(final StBlockClosure stBlockClosure) {
        this.loops.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)object);
                stBlockClosure.value_value_value_((Object)jun2dDelaunayLoop.point1(), (Object)jun2dDelaunayLoop.point2(), (Object)jun2dDelaunayLoop.point3());
                return null;
            }
        });
    }

    public void insertEdgeFrom_to_(JunPoint junPoint, JunPoint junPoint2) {
        Jun2dDelaunayVertex jun2dDelaunayVertex = this.insertPoint_(junPoint);
        Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.insertPoint_(junPoint2);
        Jun2dDelaunayEdge jun2dDelaunayEdge = new Jun2dDelaunayEdge();
        jun2dDelaunayEdge.vertex1_(jun2dDelaunayVertex);
        jun2dDelaunayEdge.vertex2_(jun2dDelaunayVertex2);
        this.insertEdge_(jun2dDelaunayEdge);
    }

    public Jun2dDelaunayVertex insertPoint_(JunPoint junPoint) {
        Jun2dDelaunayVertex jun2dDelaunayVertex = new Jun2dDelaunayVertex(junPoint);
        return this.insertVertex_(jun2dDelaunayVertex);
    }

    public void insertPoints_(JunPoint[] junPointArray) {
        for (int i = 0; i < junPointArray.length; ++i) {
            this.insertPoint_(junPointArray[i]);
        }
    }

    public void insertPolygon_(JunPoint[] junPointArray) {
        this.insertPolygon_interim_(junPointArray, null);
    }

    public void insertPolygon_interim_(JunPoint[] junPointArray, StBlockClosure stBlockClosure) {
        Jun2dDelaunayVertex jun2dDelaunayVertex = this.insertPoint_(junPointArray[junPointArray.length - 1]);
        for (int i = 0; i < junPointArray.length; ++i) {
            JunPoint junPoint = junPointArray[i];
            Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.insertPoint_(junPoint);
            if (jun2dDelaunayVertex2 != null && jun2dDelaunayVertex != null) {
                Jun2dDelaunayEdge jun2dDelaunayEdge = new Jun2dDelaunayEdge();
                jun2dDelaunayEdge.vertex1_(jun2dDelaunayVertex2);
                jun2dDelaunayEdge.vertex2_(jun2dDelaunayVertex);
                this.basicInsertEdge_(jun2dDelaunayEdge);
                if (stBlockClosure != null) {
                    stBlockClosure.value_((Object)this);
                }
            }
            jun2dDelaunayVertex = jun2dDelaunayVertex2;
        }
    }

    public void basicInsertEdge_(Jun2dDelaunayEdge jun2dDelaunayEdge) {
        this.constrained = true;
        this.makeWayFrom_to_(jun2dDelaunayEdge.vertex1(), jun2dDelaunayEdge.vertex2());
    }

    public Jun2dDelaunayVertex basicInsertVertex_onLoop_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayLoop jun2dDelaunayLoop) {
        final Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = jun2dDelaunayLoop.halfEdge();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge.next();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge3 = jun2dDelaunayHalfEdge2.next();
        Jun2dDelaunayEdge jun2dDelaunayEdge = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge2 = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge3 = this.newEdge();
        final Jun2dDelaunayLoop jun2dDelaunayLoop2 = this.newLoop();
        final Jun2dDelaunayLoop jun2dDelaunayLoop3 = this.newLoop();
        jun2dDelaunayEdge.vertex1_(jun2dDelaunayHalfEdge.vertex());
        jun2dDelaunayEdge.vertex2_(jun2dDelaunayVertex);
        jun2dDelaunayEdge2.vertex1_(jun2dDelaunayHalfEdge2.vertex());
        jun2dDelaunayEdge2.vertex2_(jun2dDelaunayVertex);
        jun2dDelaunayEdge3.vertex1_(jun2dDelaunayHalfEdge3.vertex());
        jun2dDelaunayEdge3.vertex2_(jun2dDelaunayVertex);
        jun2dDelaunayVertex.halfEdge_(jun2dDelaunayEdge3.halfEdge12());
        jun2dDelaunayHalfEdge.next_(jun2dDelaunayEdge.halfEdge12());
        jun2dDelaunayEdge.halfEdge12().next_(jun2dDelaunayEdge3.halfEdge21());
        jun2dDelaunayEdge3.halfEdge21().next_(jun2dDelaunayHalfEdge);
        jun2dDelaunayHalfEdge2.next_(jun2dDelaunayEdge2.halfEdge12());
        jun2dDelaunayEdge2.halfEdge12().next_(jun2dDelaunayEdge.halfEdge21());
        jun2dDelaunayEdge.halfEdge21().next_(jun2dDelaunayHalfEdge2);
        jun2dDelaunayHalfEdge3.next_(jun2dDelaunayEdge3.halfEdge12());
        jun2dDelaunayEdge3.halfEdge12().next_(jun2dDelaunayEdge2.halfEdge21());
        jun2dDelaunayEdge2.halfEdge21().next_(jun2dDelaunayHalfEdge3);
        jun2dDelaunayHalfEdge.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge2.loop_(jun2dDelaunayHalfEdge.loop());
                return null;
            }
        });
        jun2dDelaunayHalfEdge2.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.loop_(jun2dDelaunayLoop2);
                return null;
            }
        });
        jun2dDelaunayHalfEdge3.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.loop_(jun2dDelaunayLoop3);
                return null;
            }
        });
        jun2dDelaunayHalfEdge.loop().halfEdge_(jun2dDelaunayHalfEdge);
        jun2dDelaunayHalfEdge2.loop().halfEdge_(jun2dDelaunayHalfEdge2);
        jun2dDelaunayHalfEdge3.loop().halfEdge_(jun2dDelaunayHalfEdge3);
        this.vertices.add_(jun2dDelaunayVertex);
        if (jun2dDelaunayHalfEdge.edge().isConstrained() && jun2dDelaunayHalfEdge.areaWith_(jun2dDelaunayVertex) < 1.0E-12) {
            jun2dDelaunayHalfEdge.edge().enableArrange();
            jun2dDelaunayHalfEdge.next().edge().disableArrange();
            jun2dDelaunayHalfEdge.prev().edge().disableArrange();
            jun2dDelaunayHalfEdge.edge().basicArrange();
        }
        if (jun2dDelaunayHalfEdge2.edge().isConstrained() && jun2dDelaunayHalfEdge2.areaWith_(jun2dDelaunayVertex) < 1.0E-12) {
            jun2dDelaunayHalfEdge2.edge().enableArrange();
            jun2dDelaunayHalfEdge2.next().edge().disableArrange();
            jun2dDelaunayHalfEdge2.prev().edge().disableArrange();
            jun2dDelaunayHalfEdge2.edge().basicArrange();
        }
        if (jun2dDelaunayHalfEdge3.edge().isConstrained() && jun2dDelaunayHalfEdge3.areaWith_(jun2dDelaunayVertex) < 1.0E-12) {
            jun2dDelaunayHalfEdge3.edge().enableArrange();
            jun2dDelaunayHalfEdge3.next().edge().disableArrange();
            jun2dDelaunayHalfEdge3.prev().edge().disableArrange();
            jun2dDelaunayHalfEdge3.edge().basicArrange();
        }
        jun2dDelaunayHalfEdge.edge().setDirty();
        jun2dDelaunayHalfEdge2.edge().setDirty();
        jun2dDelaunayHalfEdge3.edge().setDirty();
        return jun2dDelaunayVertex;
    }

    public void insertEdge_(Jun2dDelaunayEdge jun2dDelaunayEdge) {
        jun2dDelaunayEdge.vertex1_(this.insertVertex_(jun2dDelaunayEdge.vertex1()));
        jun2dDelaunayEdge.vertex2_(this.insertVertex_(jun2dDelaunayEdge.vertex2()));
        this.basicInsertEdge_(jun2dDelaunayEdge);
    }

    public Jun2dDelaunayVertex insertVertex_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        double d;
        double d2 = jun2dDelaunayVertex.x();
        Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.nearestVertexFromX_y_(d2, d = jun2dDelaunayVertex.y());
        if (jun2dDelaunayVertex2.containsX_y_(d2, d)) {
            return jun2dDelaunayVertex2;
        }
        Jun2dDelaunayLoop jun2dDelaunayLoop = this.loopAtX_y_(d2, d);
        if (jun2dDelaunayLoop != null) {
            return this.insertVertex_onLoop_(jun2dDelaunayVertex, jun2dDelaunayLoop);
        }
        return null;
    }

    public Jun2dDelaunayVertex insertVertex_onLoop_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayLoop jun2dDelaunayLoop) {
        final Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = jun2dDelaunayLoop.halfEdge();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge.next();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge3 = jun2dDelaunayHalfEdge2.next();
        Jun2dDelaunayEdge jun2dDelaunayEdge = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge2 = this.newEdge();
        Jun2dDelaunayEdge jun2dDelaunayEdge3 = this.newEdge();
        final Jun2dDelaunayLoop jun2dDelaunayLoop2 = this.newLoop();
        final Jun2dDelaunayLoop jun2dDelaunayLoop3 = this.newLoop();
        jun2dDelaunayEdge.vertex1_(jun2dDelaunayHalfEdge.vertex());
        jun2dDelaunayEdge.vertex2_(jun2dDelaunayVertex);
        jun2dDelaunayEdge2.vertex1_(jun2dDelaunayHalfEdge2.vertex());
        jun2dDelaunayEdge2.vertex2_(jun2dDelaunayVertex);
        jun2dDelaunayEdge3.vertex1_(jun2dDelaunayHalfEdge3.vertex());
        jun2dDelaunayEdge3.vertex2_(jun2dDelaunayVertex);
        jun2dDelaunayVertex.halfEdge_(jun2dDelaunayEdge3.halfEdge12());
        jun2dDelaunayHalfEdge.next_(jun2dDelaunayEdge.halfEdge12());
        jun2dDelaunayEdge.halfEdge12().next_(jun2dDelaunayEdge3.halfEdge21());
        jun2dDelaunayEdge3.halfEdge21().next_(jun2dDelaunayHalfEdge);
        jun2dDelaunayHalfEdge2.next_(jun2dDelaunayEdge2.halfEdge12());
        jun2dDelaunayEdge2.halfEdge12().next_(jun2dDelaunayEdge.halfEdge21());
        jun2dDelaunayEdge.halfEdge21().next_(jun2dDelaunayHalfEdge2);
        jun2dDelaunayHalfEdge3.next_(jun2dDelaunayEdge3.halfEdge12());
        jun2dDelaunayEdge3.halfEdge12().next_(jun2dDelaunayEdge2.halfEdge21());
        jun2dDelaunayEdge2.halfEdge21().next_(jun2dDelaunayHalfEdge3);
        jun2dDelaunayHalfEdge.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge2.loop_(jun2dDelaunayHalfEdge.loop());
                return null;
            }
        });
        jun2dDelaunayHalfEdge2.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.loop_(jun2dDelaunayLoop2);
                return null;
            }
        });
        jun2dDelaunayHalfEdge3.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.loop_(jun2dDelaunayLoop3);
                return null;
            }
        });
        jun2dDelaunayHalfEdge.loop().halfEdge_(jun2dDelaunayHalfEdge);
        jun2dDelaunayHalfEdge2.loop().halfEdge_(jun2dDelaunayHalfEdge2);
        jun2dDelaunayHalfEdge3.loop().halfEdge_(jun2dDelaunayHalfEdge3);
        this.vertices.add_(jun2dDelaunayVertex);
        if (jun2dDelaunayHalfEdge.edge().isConstrained() && jun2dDelaunayHalfEdge.areaWith_(jun2dDelaunayVertex) < 1.0E-8) {
            jun2dDelaunayHalfEdge.edge().enableArrange();
            jun2dDelaunayHalfEdge.next().edge().disableArrange();
            jun2dDelaunayHalfEdge.prev().edge().disableArrange();
        }
        if (jun2dDelaunayHalfEdge2.edge().isConstrained() && jun2dDelaunayHalfEdge2.areaWith_(jun2dDelaunayVertex) < 1.0E-8) {
            jun2dDelaunayHalfEdge2.edge().enableArrange();
            jun2dDelaunayHalfEdge2.next().edge().disableArrange();
            jun2dDelaunayHalfEdge2.prev().edge().disableArrange();
        }
        if (jun2dDelaunayHalfEdge3.edge().isConstrained() && jun2dDelaunayHalfEdge3.areaWith_(jun2dDelaunayVertex) < 1.0E-8) {
            jun2dDelaunayHalfEdge3.edge().enableArrange();
            jun2dDelaunayHalfEdge3.next().edge().disableArrange();
            jun2dDelaunayHalfEdge3.prev().edge().disableArrange();
        }
        jun2dDelaunayHalfEdge.edge().setDirty();
        jun2dDelaunayHalfEdge2.edge().setDirty();
        jun2dDelaunayHalfEdge3.edge().setDirty();
        jun2dDelaunayHalfEdge.edge().recursiveArrange();
        jun2dDelaunayHalfEdge2.edge().recursiveArrange();
        jun2dDelaunayHalfEdge3.edge().recursiveArrange();
        return jun2dDelaunayVertex;
    }

    public Jun2dDelaunayVertex makeCheckpointFrom_to_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        if (jun2dDelaunayVertex.halfEdgeToward_(jun2dDelaunayVertex2) != null) {
            return jun2dDelaunayVertex2;
        }
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = this.intersectingHalfEdgeFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2);
        if (jun2dDelaunayHalfEdge == null) {
            return null;
        }
        while (true) {
            if (!(jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge.pair()).edge().isArrangeable()) {
                Jun2dDelaunayVertex jun2dDelaunayVertex3 = jun2dDelaunayHalfEdge.edge().intersectionWithLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2);
                this.insertVertex_onLoop_(jun2dDelaunayVertex3, jun2dDelaunayHalfEdge.loop());
                return jun2dDelaunayVertex3;
            }
            if (jun2dDelaunayHalfEdge.next().vertex().isOnLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2)) {
                return jun2dDelaunayVertex2;
            }
            if (jun2dDelaunayHalfEdge.next().intersectsWithLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2)) {
                jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge.next();
                continue;
            }
            if (!jun2dDelaunayHalfEdge.prev().intersectsWithLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2)) break;
            jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge.prev();
        }
        return null;
    }

    public Jun2dDelaunayVertex makeStepFrom_to_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        Jun2dDelaunayVertex jun2dDelaunayVertex3 = jun2dDelaunayVertex;
        Jun2dDelaunayVertex jun2dDelaunayVertex4 = this.makeCheckpointFrom_to_(jun2dDelaunayVertex3, jun2dDelaunayVertex2);
        if (jun2dDelaunayVertex4 == null) {
            return null;
        }
        Vector vector = Jun2dDelaunayProcessor._IdentitySet();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = jun2dDelaunayVertex3.halfEdgeTo_(jun2dDelaunayVertex4);
        while (jun2dDelaunayHalfEdge == null) {
            jun2dDelaunayHalfEdge = this.intersectingHalfEdgeFrom_to_(jun2dDelaunayVertex3, jun2dDelaunayVertex4);
            if (jun2dDelaunayHalfEdge == null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Jun2dDelaunayEdge jun2dDelaunayEdge = (Jun2dDelaunayEdge)((Object)vector.elementAt(i));
                    jun2dDelaunayEdge.recursiveArrange();
                }
                return null;
            }
            jun2dDelaunayHalfEdge.edge().enableArrange();
            jun2dDelaunayHalfEdge.edge().basicArrange();
            jun2dDelaunayHalfEdge.edge().setDirty();
            vector.addElement(jun2dDelaunayHalfEdge.edge());
            jun2dDelaunayHalfEdge.next().edge().setDirty();
            vector.addElement(jun2dDelaunayHalfEdge.next().edge());
            jun2dDelaunayHalfEdge.prev().edge().setDirty();
            vector.addElement(jun2dDelaunayHalfEdge.prev().edge());
            jun2dDelaunayHalfEdge.pair().next().edge().setDirty();
            vector.addElement(jun2dDelaunayHalfEdge.pair().next().edge());
            jun2dDelaunayHalfEdge.pair().prev().edge().setDirty();
            vector.addElement(jun2dDelaunayHalfEdge.pair().prev().edge());
            jun2dDelaunayHalfEdge = jun2dDelaunayVertex3.halfEdgeTo_(jun2dDelaunayVertex4);
        }
        jun2dDelaunayHalfEdge.edge().disableArrange();
        for (int i = 0; i < vector.size(); ++i) {
            Jun2dDelaunayEdge jun2dDelaunayEdge = (Jun2dDelaunayEdge)((Object)vector.elementAt(i));
            jun2dDelaunayEdge.recursiveArrange();
        }
        return jun2dDelaunayVertex4;
    }

    public void makeWayFrom_to_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        Jun2dDelaunayVertex jun2dDelaunayVertex3 = jun2dDelaunayVertex;
        Jun2dDelaunayVertex jun2dDelaunayVertex4;
        while ((jun2dDelaunayVertex4 = this.makeStepFrom_to_(jun2dDelaunayVertex3, jun2dDelaunayVertex2)) != null && jun2dDelaunayVertex4 != jun2dDelaunayVertex2) {
            jun2dDelaunayVertex3 = jun2dDelaunayVertex4;
        }
        return;
    }

    protected void checkLoops() {
        this.loops.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)object);
                if (jun2dDelaunayLoop.area() < 0.0) {
                    throw SmalltalkException.Halt((String)"checkLoops");
                }
                return null;
            }
        });
    }

    protected Jun2dDelaunayList edges() {
        return this.edges;
    }

    protected Jun2dDelaunayLoop exhaustSearchForLoopAtX_y_(final double d, final double d2) {
        return (Jun2dDelaunayLoop)((Object)this.loops.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)((Object)object);
                if (jun2dDelaunayLoop.containsX_y_(d, d2)) {
                    return jun2dDelaunayLoop;
                }
                return null;
            }
        }));
    }

    protected Jun2dDelaunayVertex exhaustSearchNearestVertexFromX_y_(final double d, final double d2) {
        final StValueHolder stValueHolder = new StValueHolder();
        final StValueHolder stValueHolder2 = new StValueHolder();
        stValueHolder.value_((Object)this.vertices.first());
        stValueHolder2.value_(((Jun2dDelaunayVertex)((Object)stValueHolder.value())).squaredDistanceFromX_y_(d, d2));
        this.vertices.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                double d3 = jun2dDelaunayVertex.squaredDistanceFromX_y_(d, d2);
                if (d3 < stValueHolder2._doubleValue()) {
                    stValueHolder2.value_(d3);
                    stValueHolder.value_((Object)jun2dDelaunayVertex);
                }
                return null;
            }
        });
        return (Jun2dDelaunayVertex)((Object)stValueHolder.value());
    }

    protected Jun2dDelaunayHalfEdge intersectingHalfEdgeFrom_to_(final Jun2dDelaunayVertex jun2dDelaunayVertex, final Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        return (Jun2dDelaunayHalfEdge)((Object)jun2dDelaunayVertex.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayHalfEdge.prev().intersectsWithLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2)) {
                    return jun2dDelaunayHalfEdge.prev();
                }
                return null;
            }
        }));
    }

    protected Jun2dDelaunayLoop loopAtX_y_(double d, double d2) {
        return this.topologicalSearchForLoopAtX_y_(d, d2);
    }

    protected double margin() {
        return 1.0;
    }

    protected Jun2dDelaunayEdge nearestEdgeFromX_y_(final double d, final double d2) {
        final StValueHolder stValueHolder = new StValueHolder();
        final StValueHolder stValueHolder2 = new StValueHolder();
        stValueHolder.value_((Object)this.edges.first());
        stValueHolder2.value_((Object)new Double(((Jun2dDelaunayEdge)this.edges.first()).squaredDistanceFromX_y_(d, d2)));
        this.edges.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayEdge jun2dDelaunayEdge = (Jun2dDelaunayEdge)((Object)object);
                double d3 = jun2dDelaunayEdge.squaredDistanceFromX_y_(d, d2);
                if (d3 < stValueHolder2._doubleValue()) {
                    stValueHolder2.value_(d3);
                    stValueHolder.value_((Object)jun2dDelaunayEdge);
                }
                return null;
            }
        });
        return (Jun2dDelaunayEdge)((Object)stValueHolder.value());
    }

    protected Jun2dDelaunayVertex nearestVertexFromX_y_(double d, double d2) {
        if (this.constrained) {
            return this.exhaustSearchNearestVertexFromX_y_(d, d2);
        }
        return this.topologicalSearchNearestVertexFromX_y_(d, d2);
    }

    protected void setBounds_(Jun2dBoundingBox jun2dBoundingBox) {
        this.bounds = jun2dBoundingBox;
    }

    protected Jun2dDelaunayLoop topologicalSearchForLoopAtX_y_(final double d, final double d2) {
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Jun2dDelaunayVertex jun2dDelaunayVertex = jun2dDelaunayHalfEdge.pair().vertex();
                Jun2dDelaunayVertex jun2dDelaunayVertex2 = jun2dDelaunayHalfEdge.vertex();
                return new Double((jun2dDelaunayVertex.x() - d) * (jun2dDelaunayVertex2.y() - d2) - (jun2dDelaunayVertex.y() - d2) * (jun2dDelaunayVertex2.x() - d));
            }
        };
        Jun2dDelaunayLoop jun2dDelaunayLoop = (Jun2dDelaunayLoop)this.loops.first();
        do {
            Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = jun2dDelaunayLoop.halfEdge();
            Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge.next();
            Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge3 = jun2dDelaunayHalfEdge2.next();
            double d3 = (Double)stBlockClosure.value_((Object)jun2dDelaunayHalfEdge);
            double d4 = (Double)stBlockClosure.value_((Object)jun2dDelaunayHalfEdge2);
            double d5 = (Double)stBlockClosure.value_((Object)jun2dDelaunayHalfEdge3);
            if (jun2dDelaunayLoop.area() < 0.0) {
                return null;
            }
            if (!(d3 < 0.0 || d4 < 0.0 || d5 < 0.0)) {
                return jun2dDelaunayLoop;
            }
            jun2dDelaunayLoop = jun2dDelaunayHalfEdge.pair().loop();
            double d6 = d3;
            if (d4 < d6) {
                d6 = d4;
                jun2dDelaunayLoop = jun2dDelaunayHalfEdge2.pair().loop();
            }
            if (!(d5 < d6)) continue;
            jun2dDelaunayLoop = jun2dDelaunayHalfEdge3.pair().loop();
        } while (jun2dDelaunayLoop != null);
        return null;
    }

    protected Jun2dDelaunayVertex topologicalSearchNearestVertexFromX_y_(final double d, final double d2) {
        Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)this.vertices.first();
        while (true) {
            final StValueHolder stValueHolder = new StValueHolder();
            final StValueHolder stValueHolder2 = new StValueHolder();
            stValueHolder.value_(jun2dDelaunayVertex.squaredDistanceFromX_y_(d, d2));
            stValueHolder2.value_(null);
            jun2dDelaunayVertex.neighborsDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                    double d3 = jun2dDelaunayVertex.squaredDistanceFromX_y_(d, d2);
                    if (d3 < stValueHolder._doubleValue()) {
                        stValueHolder.value_(d3);
                        stValueHolder2.value_((Object)jun2dDelaunayVertex);
                    }
                    return null;
                }
            });
            if (stValueHolder2.value() == null) {
                return jun2dDelaunayVertex;
            }
            jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)stValueHolder2.value());
        }
    }
}

