/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.delaunay.twoD;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayEdge;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayLoop;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class Jun2dDelaunayVertex
extends Jun2dDelaunayElement {
    protected double x = Double.NaN;
    protected double y = Double.NaN;
    protected double z = Double.NaN;
    protected Jun2dDelaunayHalfEdge halfEdge;

    public Jun2dDelaunayVertex() {
    }

    public Jun2dDelaunayVertex(double d, double d2) {
        this.setX_(d);
        this.setY_(d2);
    }

    public Jun2dDelaunayVertex(double d, double d2, double d3) {
        this.setX_(d);
        this.setY_(d2);
        this.setZ_(d3);
    }

    public Jun2dDelaunayVertex(JunPoint junPoint) {
        JunPoint junPoint2;
        if (junPoint instanceof Jun2dPoint) {
            junPoint2 = (Jun2dPoint)junPoint;
            this.setX_(((Jun2dPoint)junPoint2).x());
            this.setY_(((Jun2dPoint)junPoint2).y());
        }
        if (junPoint instanceof Jun3dPoint) {
            junPoint2 = (Jun3dPoint)junPoint;
            this.setX_(((Jun3dPoint)junPoint2).x());
            this.setY_(((Jun3dPoint)junPoint2).y());
            this.setZ_(((Jun3dPoint)junPoint2).z());
        }
    }

    public double angleWith_with_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        return Math.acos(this.cosOfAngleWith_with_(jun2dDelaunayVertex, jun2dDelaunayVertex2));
    }

    public double areaWith_with_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        return (jun2dDelaunayVertex.x() - this.x) * (jun2dDelaunayVertex2.y() - this.y) - (jun2dDelaunayVertex2.x() - this.x) * (jun2dDelaunayVertex.y() - this.y);
    }

    public Jun2dPoint asJun2dPoint() {
        return new Jun2dPoint(this.x, this.y);
    }

    public Jun3dPoint asJun3dPoint() {
        return new Jun3dPoint(this.x, this.y, this.z == Double.NaN ? 0.0 : this.z);
    }

    public boolean contains_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return Math.pow(jun2dDelaunayVertex.x() - this.x, 2.0) + Math.pow(jun2dDelaunayVertex.y() - this.y, 2.0) < 1.0E-12;
    }

    public boolean containsX_y_(double d, double d2) {
        return Math.pow(d - this.x, 2.0) + Math.pow(d2 - this.y, 2.0) < 1.0E-12;
    }

    public double cosOfAngleWith_with_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        double d = this.squaredDistance_(jun2dDelaunayVertex);
        double d2 = this.squaredDistance_(jun2dDelaunayVertex2);
        double d3 = (jun2dDelaunayVertex.x() - this.x) * (jun2dDelaunayVertex2.x() - this.x) + (jun2dDelaunayVertex.y() - this.y) * (jun2dDelaunayVertex2.y() - this.y);
        return Math.min(Math.max(d3 / Math.sqrt(d * d2), -1.0), 1.0);
    }

    public double distance_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return Math.sqrt(this.squaredDistance_(jun2dDelaunayVertex));
    }

    public double dotProduct_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return this.x * jun2dDelaunayVertex.x() + this.y * jun2dDelaunayVertex.y();
    }

    public Object edgesDo_(final StBlockClosure stBlockClosure) {
        return this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Object object2 = stBlockClosure.value_((Object)jun2dDelaunayHalfEdge.edge);
                if (object2 != null) {
                    return object2;
                }
                return null;
            }
        });
    }

    public Jun2dDelaunayEdge edgeTo_(final Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return (Jun2dDelaunayEdge)((Object)this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayVertex == jun2dDelaunayHalfEdge.pair().vertex()) {
                    return jun2dDelaunayHalfEdge.edge;
                }
                return null;
            }
        }));
    }

    public Jun2dDelaunayHalfEdge halfEdge() {
        return this.halfEdge;
    }

    public void halfEdge_(Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge) {
        this.halfEdge = jun2dDelaunayHalfEdge;
    }

    public Object halfEdgesDo_(StBlockClosure stBlockClosure) {
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge;
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = this.halfEdge;
        do {
            jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge2.next().pair();
            Object object = stBlockClosure.value_((Object)jun2dDelaunayHalfEdge2);
            if (object == null) continue;
            return object;
        } while ((jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge) != this.halfEdge);
        return null;
    }

    public boolean isBoundaryVertex() {
        return false;
    }

    public Object loopsDo_(final StBlockClosure stBlockClosure) {
        return this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Object object2;
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Jun2dDelaunayLoop jun2dDelaunayLoop = jun2dDelaunayHalfEdge.loop();
                if (jun2dDelaunayLoop != null && (object2 = stBlockClosure.value_((Object)jun2dDelaunayLoop)) != null) {
                    return object2;
                }
                return null;
            }
        });
    }

    public Object neighborsDo_(final StBlockClosure stBlockClosure) {
        return this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Object object2 = stBlockClosure.value_((Object)jun2dDelaunayHalfEdge.pair().vertex());
                if (object2 != null) {
                    return object2;
                }
                return null;
            }
        });
    }

    public JunPoint point() {
        if (Double.isNaN(this.z)) {
            return new Jun2dPoint(this.x, this.y);
        }
        return new Jun3dPoint(this.x, this.y, this.z);
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("Vertex(");
        writer.write(Double.toString(this.x));
        writer.write("@");
        writer.write(Double.toString(this.y));
        writer.write(")");
    }

    public double product_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return this.x * jun2dDelaunayVertex.y() - this.y * jun2dDelaunayVertex.x();
    }

    public double squaredDistance_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return this.squaredDistanceFromX_y_(jun2dDelaunayVertex.x(), jun2dDelaunayVertex.y());
    }

    public double squaredDistanceFromX_y_(double d, double d2) {
        return Math.pow(this.x - d, 2.0) + Math.pow(this.y - d2, 2.0);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    protected Jun2dDelaunayHalfEdge detectHalfEdgeOfLoop_(final Jun2dDelaunayLoop jun2dDelaunayLoop) {
        return (Jun2dDelaunayHalfEdge)((Object)this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayHalfEdge.loop() == jun2dDelaunayLoop) {
                    return jun2dDelaunayHalfEdge;
                }
                return null;
            }
        }));
    }

    protected Jun2dDelaunayHalfEdge detectHalfEdgeOfLoopContainsX_y_(final double d, final double d2) {
        return (Jun2dDelaunayHalfEdge)((Object)this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayHalfEdge.loop().containsX_y_(d, d2)) {
                    return jun2dDelaunayHalfEdge;
                }
                return null;
            }
        }));
    }

    protected Jun2dDelaunayHalfEdge halfEdgeTo_(final Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return (Jun2dDelaunayHalfEdge)((Object)this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayVertex == jun2dDelaunayHalfEdge.pair().vertex()) {
                    return jun2dDelaunayHalfEdge.pair();
                }
                return null;
            }
        }));
    }

    protected Jun2dDelaunayHalfEdge halfEdgeToward_(final Jun2dDelaunayVertex jun2dDelaunayVertex) {
        double d = this.distance_(jun2dDelaunayVertex);
        final double d2 = (jun2dDelaunayVertex.x() - this.x) / d;
        final double d3 = (jun2dDelaunayVertex.y() - this.y) / d;
        return (Jun2dDelaunayHalfEdge)((Object)this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                double d;
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Jun2dDelaunayVertex jun2dDelaunayVertex2 = jun2dDelaunayHalfEdge.pair().vertex();
                double d22 = Jun2dDelaunayVertex.this.distance_(jun2dDelaunayVertex2);
                double d32 = (jun2dDelaunayVertex2.x() - Jun2dDelaunayVertex.this.x) / d22;
                double d4 = (jun2dDelaunayVertex2.y() - Jun2dDelaunayVertex.this.y) / d22;
                if (jun2dDelaunayHalfEdge.pair().vertex() == jun2dDelaunayVertex) {
                    return jun2dDelaunayHalfEdge;
                }
                if (Math.abs(d2 * d4 - d32 * d3) < 1.0E-12 && -1.0E-12 <= (d = d2 * d32 + d3 * d4) && d <= 1.000000000001) {
                    return jun2dDelaunayHalfEdge;
                }
                return null;
            }
        }));
    }

    protected boolean isOnLineSegmentFrom_to_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        double d;
        if (this == jun2dDelaunayVertex || this == jun2dDelaunayVertex2) {
            return true;
        }
        double d2 = jun2dDelaunayVertex.distance_(jun2dDelaunayVertex2);
        double d3 = (jun2dDelaunayVertex2.x() - jun2dDelaunayVertex.x()) / d2;
        double d4 = (jun2dDelaunayVertex2.y() - jun2dDelaunayVertex.y()) / d2;
        double d5 = jun2dDelaunayVertex.distance_(this);
        double d6 = (this.x() - jun2dDelaunayVertex.x()) / d5;
        double d7 = (this.y() - jun2dDelaunayVertex.y()) / d5;
        return Math.abs(d3 * d7 - d6 * d4) < 1.0E-12 && 0.0 <= (d = d3 * d6 + d4 * d7) && d <= 1.0;
    }

    protected Jun2dDelaunayEdge nearestEdgeFromX_y_(double d, double d2) {
        return this.nearestHalfEdgeFromX_y_(d, d2).edge();
    }

    protected Jun2dDelaunayHalfEdge nearestHalfEdgeFromX_y_(final double d, final double d2) {
        final StValueHolder stValueHolder = new StValueHolder();
        final StValueHolder stValueHolder2 = new StValueHolder();
        stValueHolder.value_((Object)this.halfEdge);
        stValueHolder2.value_(this.halfEdge.edge().squaredDistanceFromX_y_(d, d2));
        this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                double d3;
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayHalfEdge != Jun2dDelaunayVertex.this.halfEdge && (d3 = jun2dDelaunayHalfEdge.edge().squaredDistanceFromX_y_(d, d2)) < stValueHolder2._doubleValue()) {
                    stValueHolder2.value_(d3);
                    stValueHolder.value_((Object)jun2dDelaunayHalfEdge);
                }
                return null;
            }
        });
        return (Jun2dDelaunayHalfEdge)((Object)stValueHolder.value());
    }

    protected Jun2dDelaunayVertex nearestNeighborFromX_y_(final double d, final double d2) {
        final StValueHolder stValueHolder = new StValueHolder();
        final StValueHolder stValueHolder2 = new StValueHolder();
        stValueHolder.value_((Object)this);
        stValueHolder2.value_(Math.pow(this.x - d, 2.0) + Math.pow(this.y - d2, 2.0));
        this.neighborsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                double d3 = Math.pow(jun2dDelaunayVertex.x() - d, 2.0) + Math.pow(jun2dDelaunayVertex.y() - d2, 2.0);
                if (d3 < stValueHolder2._doubleValue()) {
                    stValueHolder2.value_(d3);
                    stValueHolder.value_((Object)jun2dDelaunayVertex);
                }
                return null;
            }
        });
        return (Jun2dDelaunayVertex)((Object)stValueHolder.value());
    }

    protected void setX_(double d) {
        this.x = d;
    }

    protected void setY_(double d) {
        this.y = d;
    }

    protected void setZ_(double d) {
        this.z = d;
    }
}

