/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.abstracts;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.coordinate.JunCoordinateSystem;
import jp.co.sra.jun.geometry.coordinate.JunLocalGeometry;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public abstract class JunGeometry
extends JunAbstractObject {
    public static final double ACCURACY = 1.0E-12;
    public static final double DoublePi = Math.PI * 2;
    public static final double HalfPi = 1.5707963267948966;
    public static final double QuarterPi = 0.7853981633974483;

    private static Class LocalGeometryClass() {
        return JunLocalGeometry.class;
    }

    public static final double Accuracy() {
        return 1.0E-12;
    }

    public static final double DoublePi() {
        return Math.PI * 2;
    }

    public static final double HalfPi() {
        return 1.5707963267948966;
    }

    public static final double Pi() {
        return Math.PI;
    }

    public static final double QuarterPi() {
        return 0.7853981633974483;
    }

    public static Jun3dPoint HemispherePoint_center_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return JunGeometry.HemispherePoint_center_on_(jun3dPoint, jun3dPoint2, new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0)));
    }

    public static Jun3dPoint HemispherePoint_center_on_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunPlane junPlane) {
        return jun3dPoint2.to_(junPlane.nearestPointFromPoint_(jun3dPoint)).normalized().atT_(junPlane.distanceFromPoint_(jun3dPoint2));
    }

    public static Jun3dPoint MobiusRadius_normalizedTheta_stripRadius_normalizedRadius_(double d, double d2, double d3, double d4) {
        JunAngle junAngle = JunAngle.FromRad_(JunGeometry.DoublePi() * d2);
        JunAngle junAngle2 = junAngle.multipliedBy_(0.5);
        double d5 = (d + d3 * junAngle2.cos()) * junAngle.cos();
        double d6 = (d + d3 * junAngle2.cos()) * junAngle.sin();
        double d7 = d3 * junAngle2.sin();
        if (Math.abs(d5) < JunGeometry.Accuracy()) {
            d5 = 0.0;
        }
        if (Math.abs(d6) < JunGeometry.Accuracy()) {
            d6 = 0.0;
        }
        if (Math.abs(d7) < JunGeometry.Accuracy()) {
            d7 = 0.0;
        }
        Jun3dPoint jun3dPoint = new Jun3dPoint(d5, d6, d7);
        d5 = d * junAngle.cos();
        d6 = d * junAngle.sin();
        if (Math.abs(d5) < JunGeometry.Accuracy()) {
            d5 = 0.0;
        }
        if (Math.abs(d6) < JunGeometry.Accuracy()) {
            d6 = 0.0;
        }
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(d5, d6, 0.0);
        return jun3dPoint2.to_(jun3dPoint).atT_(d4);
    }

    public static Jun3dPoint[][] SewPoints_withPoints_reverseFlag_(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2, boolean bl) {
        ArrayList<Jun3dPoint[]> arrayList = new ArrayList<Jun3dPoint[]>((jun3dPointArray.length - 1) * 2);
        for (int i = 0; i < jun3dPointArray.length - 1; ++i) {
            int n = i;
            int n2 = i + 1;
            Jun3dPoint jun3dPoint = jun3dPointArray[n];
            Jun3dPoint jun3dPoint2 = jun3dPointArray2[n];
            Jun3dPoint jun3dPoint3 = jun3dPointArray[n2];
            Jun3dPoint jun3dPoint4 = jun3dPointArray2[n2];
            Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[]{jun3dPoint, jun3dPoint2, jun3dPoint3};
            Jun3dPoint[] jun3dPointArray4 = new Jun3dPoint[]{jun3dPoint2, jun3dPoint4, jun3dPoint3};
            if (!bl) {
                jun3dPointArray3 = new Jun3dPoint[]{jun3dPoint3, jun3dPoint2, jun3dPoint};
                jun3dPointArray4 = new Jun3dPoint[]{jun3dPoint3, jun3dPoint4, jun3dPoint2};
            }
            arrayList.add(jun3dPointArray3);
            arrayList.add(jun3dPointArray4);
        }
        return (Jun3dPoint[][])arrayList.toArray((T[])new Jun3dPoint[arrayList.size()][]);
    }

    public static Jun3dPoint TorusRadius_normalizedTheta_tubeRadius_normalizedPhi_(double d, double d2, double d3, double d4) {
        JunAngle junAngle = JunAngle.FromRad_(JunGeometry.DoublePi() * d2);
        JunAngle junAngle2 = JunAngle.FromRad_(JunGeometry.DoublePi() * d4);
        double d5 = (d + d3 * junAngle2.cos()) * junAngle.cos();
        double d6 = (d + d3 * junAngle2.cos()) * junAngle.sin();
        double d7 = d3 * junAngle2.sin();
        if (Math.abs(d5) < JunGeometry.Accuracy()) {
            d5 = 0.0;
        }
        if (Math.abs(d6) < JunGeometry.Accuracy()) {
            d6 = 0.0;
        }
        if (Math.abs(d7) < JunGeometry.Accuracy()) {
            d7 = 0.0;
        }
        Jun3dPoint jun3dPoint = new Jun3dPoint(d5, d6, d7);
        return jun3dPoint;
    }

    protected void initialize() {
        super.initialize();
    }

    public double area() {
        return 0.0;
    }

    public double volume() {
        return 0.0;
    }

    public double accuracy() {
        return JunGeometry.Accuracy();
    }

    public abstract boolean equal_(Object var1);

    public abstract boolean equals(Object var1);

    public Jun2dLine[] asArrayOf2dLines() {
        return new Jun2dLine[0];
    }

    public Jun3dLine[] asArrayOf3dLines() {
        return new Jun3dLine[0];
    }

    public Jun3dTriangle[] asArrayOf3dTriangles() {
        return new Jun3dTriangle[0];
    }

    public JunPlane[] asArrayOfPlanes() {
        return new JunPlane[0];
    }

    public JunGeometry asGlobalGeometry() {
        return this;
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        throw SmalltalkException.SubclassResponsibility();
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectColor_(final Color color) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dObject();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_(color);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectColor_alpha_(final Color color, final float f) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dObject();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                junOpenGL3dObject.paint_(color);
                junOpenGL3dObject.alpha_(f);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectColor_halftone_(final Color color, final double d) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dObject();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                junOpenGL3dObject.paint_(color);
                junOpenGL3dObject.halftone_(d);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectWithPoints() {
        return this.asJunOpenGL3dObject();
    }

    public JunOpenGL3dObject asJunOpenGL3dPolylines() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun3dLine[] jun3dLineArray = this.asArrayOf3dLines();
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(new Jun3dPoint[]{jun3dLineArray[i].first(), jun3dLineArray[i].last()}));
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dPolylinesColor_(final Color color) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dPolylines();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_(color);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dPolylinesColor_halftone_(final Color color, final double d) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dPolylines();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                junOpenGL3dObject.paint_(color);
                junOpenGL3dObject.halftone_(d);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dPolylinesColor_halftone_lineWidth_(final Color color, final double d, final float f) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dPolylines();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                junOpenGL3dObject.paint_(color);
                junOpenGL3dObject.halftone_(d);
                if (junOpenGL3dObject.isPolyline()) {
                    ((JunOpenGL3dPolyline)junOpenGL3dObject).lineWidth_(f);
                }
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dPolylinesColor_lineWidth_(final Color color, final float f) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dPolylines();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                junOpenGL3dObject.paint_(color);
                if (junOpenGL3dObject.isPolyline()) {
                    ((JunOpenGL3dPolyline)junOpenGL3dObject).lineWidth_(f);
                }
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunOpenGL3dObject asJunOpenGL3dPolylinesLineWidth_(final float f) {
        JunOpenGL3dObject junOpenGL3dObject = this.asJunOpenGL3dPolylines();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                if (junOpenGL3dObject.isPolyline()) {
                    ((JunOpenGL3dPolyline)junOpenGL3dObject).lineWidth_(f);
                }
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunLocalGeometry asLocalGeometryIn_(JunCoordinateSystem junCoordinateSystem) {
        JunGeometry junGeometry = junCoordinateSystem.interprete_(this);
        return (JunLocalGeometry)((Object)JunGeometry._New((Class)JunGeometry.LocalGeometryClass(), (Object[])new Object[]{junGeometry, junCoordinateSystem}));
    }

    public double distanceFromPoint_(Jun2dPoint jun2dPoint) {
        throw SmalltalkException.SubclassResponsibility();
    }

    public double distanceFromPoint_(Jun3dPoint jun3dPoint) {
        throw SmalltalkException.SubclassResponsibility();
    }

    public JunGeometry interpretedBy_(JunCoordinateSystem junCoordinateSystem) {
        return this.transform_(junCoordinateSystem._globalInvTransformation());
    }

    public Color defaultColor() {
        return Color.gray;
    }

    public float defaultAlpha() {
        return 0.25f;
    }

    public void printOn_(Writer writer) throws IOException {
        this.storeOn_(writer);
    }

    public boolean is2d() {
        return false;
    }

    public boolean is3d() {
        return false;
    }

    public boolean isAngle() {
        return false;
    }

    public boolean isBoundingBall() {
        return false;
    }

    public boolean isBoundingBalls() {
        return false;
    }

    public boolean isBoundingBox() {
        return false;
    }

    public boolean isBoundingBoxes() {
        return false;
    }

    public boolean isBoundingObject() {
        return false;
    }

    public boolean isBoundingObjects() {
        return false;
    }

    public boolean isCircle() {
        return false;
    }

    public boolean isCircularCone() {
        return false;
    }

    public boolean isCircularCylinder() {
        return false;
    }

    public boolean isCompoundSurface() {
        return false;
    }

    public boolean isCurve() {
        return false;
    }

    public boolean isEqualNumber_to_(double d, double d2) {
        return Math.abs(d - d2) < this.accuracy();
    }

    public boolean isEqualPoint_to_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return jun3dPoint.distance_(jun3dPoint2) < this.accuracy();
    }

    public boolean isEqualPoint_to_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        return jun2dPoint.distance_(jun2dPoint2) < this.accuracy();
    }

    public boolean isGeometry() {
        return true;
    }

    public boolean isGlocalGeometry() {
        return true;
    }

    public boolean isLine() {
        return false;
    }

    public boolean isLines() {
        return false;
    }

    public boolean isPlane() {
        return false;
    }

    public boolean isPoint() {
        return false;
    }

    public boolean isPolygon() {
        return false;
    }

    public boolean isPolyline() {
        return false;
    }

    public boolean isPolylines() {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean isSphere() {
        return false;
    }

    public boolean isSurface() {
        return false;
    }

    public boolean isTetrahedron() {
        return false;
    }

    public boolean isTopology() {
        return false;
    }

    public boolean isTriangle() {
        return false;
    }

    public boolean isTriangles() {
        return false;
    }

    public JunGeometry transform_(JunTransformation junTransformation) {
        throw SmalltalkException.SubclassResponsibility();
    }

    public JunOpenGLDisplayModel show() {
        return this.asJunOpenGL3dObject().show();
    }

    public JunOpenGLDisplayModel showWithArrows() {
        JunOpenGL3dObject junOpenGL3dObject = this.is2d() ? JunOpenGL3dObject.XyArrows() : JunOpenGL3dObject.XyzArrows();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = this.asJunOpenGL3dObject().asCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        return junOpenGL3dCompoundObject.show();
    }

    public JunOpenGLDisplayModel showWithAxes() {
        return this.asJunOpenGL3dObject().showWithAxes();
    }

    public JunOpenGLDisplayModel showWithUnitArrows() {
        JunOpenGL3dObject junOpenGL3dObject = this.is2d() ? JunOpenGL3dObject.XyUnitArrows() : JunOpenGL3dObject.XyzUnitArrows();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = this.asJunOpenGL3dObject().asCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        return junOpenGL3dCompoundObject.show();
    }

    public JunOpenGLDisplayModel showWithUnitAxes() {
        return this.asJunOpenGL3dObject().showWithUnitAxes();
    }

    public static class HashEqualitySet
    extends HashSet {
        public HashEqualitySet() {
        }

        public HashEqualitySet(int n) {
            super(n);
        }

        public boolean add(JunGeometry junGeometry) {
            if (this.contains(junGeometry)) {
                return false;
            }
            return super.add(junGeometry);
        }

        public boolean addAll(JunGeometry[] junGeometryArray) {
            boolean bl = false;
            for (int i = 0; i < junGeometryArray.length; ++i) {
                if (!this.add(junGeometryArray[i])) continue;
                bl = true;
            }
            return bl;
        }

        public boolean contains(JunGeometry junGeometry) {
            Iterator iterator = this.iterator();
            if (junGeometry == null) {
                while (iterator.hasNext()) {
                    JunGeometry junGeometry2 = (JunGeometry)((Object)iterator.next());
                    if (junGeometry2 != null) continue;
                    return true;
                }
            } else {
                while (iterator.hasNext()) {
                    JunGeometry junGeometry3 = (JunGeometry)((Object)iterator.next());
                    if (!junGeometry.equal_((Object)junGeometry3)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class HashEqualityDictionary
    extends HashMap {
        public HashEqualityDictionary() {
        }

        public HashEqualityDictionary(int n) {
            super(n);
        }

        public HashEqualityDictionary(Map map) {
            super(map);
        }

        public Object get(JunGeometry junGeometry) {
            Object v = super.get((Object)junGeometry);
            if (v != null) {
                return v;
            }
            Iterator iterator = this.keySet().iterator();
            if (junGeometry == null) {
                while (iterator.hasNext()) {
                    JunGeometry junGeometry2 = (JunGeometry)((Object)iterator.next());
                    if (junGeometry2 != null) continue;
                    return super.get((Object)junGeometry2);
                }
            } else {
                while (iterator.hasNext()) {
                    JunGeometry junGeometry3 = (JunGeometry)((Object)iterator.next());
                    if (!junGeometry.equal_((Object)junGeometry3)) continue;
                    return super.get((Object)junGeometry3);
                }
            }
            return null;
        }

        public Object put(JunGeometry junGeometry, Object object) {
            if (this.containsKey(junGeometry)) {
                return this.get(junGeometry);
            }
            return super.put(junGeometry, object);
        }

        public boolean containsKey(JunGeometry junGeometry) {
            Iterator iterator = this.keySet().iterator();
            if (junGeometry == null) {
                while (iterator.hasNext()) {
                    JunGeometry junGeometry2 = (JunGeometry)((Object)iterator.next());
                    if (junGeometry2 != null) continue;
                    return true;
                }
            } else {
                while (iterator.hasNext()) {
                    JunGeometry junGeometry3 = (JunGeometry)((Object)iterator.next());
                    if (!junGeometry.equal_((Object)junGeometry3)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

