/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.basic;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun2dPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;

public class Jun2dPoint
extends JunPoint {
    protected double x;
    protected double y;

    public static Jun2dPoint Coerce_(JunPoint junPoint) {
        return new Jun2dPoint(junPoint.x(), junPoint.y());
    }

    public static Jun2dPoint Coerce_(double d) {
        return new Jun2dPoint(d, d);
    }

    public static Jun2dPoint Unity() {
        return new Jun2dPoint(1.0, 1.0);
    }

    public static Jun2dPoint Zero() {
        return new Jun2dPoint(0.0, 0.0);
    }

    public Jun2dPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Jun2dPoint(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Jun2dPoint(Number number, Number number2) {
        this(number.doubleValue(), number2.doubleValue());
    }

    public Jun2dPoint(JunPoint junPoint) {
        this(junPoint.x(), junPoint.y());
    }

    public static Jun2dPoint FromArray_(double[] dArray) {
        return new Jun2dPoint(dArray[0], dArray[1]);
    }

    public static Jun2dPoint FromPoint_(JunPoint junPoint) {
        return new Jun2dPoint(junPoint);
    }

    public static Jun2dPoint Rho_theta_(double d, double d2) {
        return new Jun2dPoint(d * Math.cos(d2), d * Math.sin(d2));
    }

    public Jun2dBoundingBox boundingBox() {
        return this.asBoundingBox();
    }

    public Jun2dPoint normalUnitVector() {
        return this.unitVector();
    }

    public Jun2dPoint normalVector() {
        return this;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return 0.0;
    }

    public Jun2dPoint abs() {
        return new Jun2dPoint(Math.abs(this.x), Math.abs(this.y));
    }

    public Jun2dPoint dividedBy_(double d) {
        return new Jun2dPoint(this.x / d, this.y / d);
    }

    public Jun2dPoint dividedBy_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(this.x / jun2dPoint.x, this.y / jun2dPoint.y);
    }

    public Jun2dPoint minus_(double d) {
        return new Jun2dPoint(this.x - d, this.y - d);
    }

    public Jun2dPoint minus_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(this.x - jun2dPoint.x, this.y - jun2dPoint.y);
    }

    public Jun2dPoint multipliedBy_(double d) {
        return new Jun2dPoint(this.x * d, this.y * d);
    }

    public Jun2dPoint multipliedBy_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(this.x * jun2dPoint.x, this.y * jun2dPoint.y);
    }

    public Jun2dPoint negated() {
        return Jun2dPoint.Zero().minus_(this);
    }

    public Jun2dPoint plus_(double d) {
        return new Jun2dPoint(this.x + d, this.y + d);
    }

    public JunPoint plus_(JunPoint junPoint) {
        if (junPoint instanceof Jun2dPoint) {
            return this.plus_((Jun2dPoint)junPoint);
        }
        return junPoint.plus_(this);
    }

    public Jun2dPoint plus_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(this.x + jun2dPoint.x, this.y + jun2dPoint.y);
    }

    public Jun2dPoint reciprocal() {
        return Jun2dPoint.Unity().dividedBy_(this);
    }

    public int generality() {
        return 200;
    }

    public boolean equal_(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
        return this.isEqualNumber_to_(this.x, jun2dPoint.x) && this.isEqualNumber_to_(this.y, jun2dPoint.y);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
        return this.x == jun2dPoint.x && this.y == jun2dPoint.y;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int n = (int)(l ^ l >> 32);
        long l2 = Double.doubleToLongBits(this.y);
        int n2 = (int)(l2 ^ l2 >> 32);
        return n >> 2 | n2;
    }

    public boolean isGreaterThan_(Jun2dPoint jun2dPoint) {
        return this.x > jun2dPoint.x && this.y > jun2dPoint.y;
    }

    public boolean isGreaterThanOrEqualTo_(Jun2dPoint jun2dPoint) {
        return this.x >= jun2dPoint.x && this.y >= jun2dPoint.y;
    }

    public boolean isLessThan_(Jun2dPoint jun2dPoint) {
        return this.x < jun2dPoint.x && this.y < jun2dPoint.y;
    }

    public boolean isLessThanOrEqualTo_(Jun2dPoint jun2dPoint) {
        return this.x <= jun2dPoint.x && this.y <= jun2dPoint.y;
    }

    public Jun2dPoint max_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(Math.max(this.x, jun2dPoint.x), Math.max(this.y, jun2dPoint.y));
    }

    public Jun2dPoint min_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(Math.min(this.x, jun2dPoint.x), Math.min(this.y, jun2dPoint.y));
    }

    public Jun2dBoundingBox extent_(Jun2dPoint jun2dPoint) {
        return Jun2dBoundingBox.Origin_extent_(this, jun2dPoint);
    }

    public Point _toPoint() {
        Jun2dPoint jun2dPoint = this.rounded();
        return new Point((int)jun2dPoint.x, (int)jun2dPoint.y);
    }

    public Jun2dPoint as2dPoint() {
        return this;
    }

    public Jun3dPoint as3dPoint() {
        return new Jun3dPoint(this.x(), this.y(), 0.0);
    }

    public double[] asArray() {
        return new double[]{this.x, this.y};
    }

    public Jun2dBoundingBox asBoundingBox() {
        return Jun2dBoundingBox.Origin_corner_(this, this);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dVertex junOpenGL3dVertex = new JunOpenGL3dVertex(new Jun3dPoint(this.x, this.y, 0.0));
        junOpenGL3dVertex.size_(5.0f);
        junOpenGL3dVertex.paint_(this.defaultColor());
        return junOpenGL3dVertex;
    }

    public Jun2dPoint differenceFromPoint_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(jun2dPoint.x - this.x, jun2dPoint.y - this.y);
    }

    public boolean equalFromPoint_(Jun2dPoint jun2dPoint) {
        return jun2dPoint.x == this.x && jun2dPoint.y == this.y;
    }

    public Jun2dPoint productFromPoint_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(jun2dPoint.x * this.x, jun2dPoint.y * this.y);
    }

    public Jun2dPoint quoFromInteger_(int n) {
        return new Jun2dPoint((double)n / this.x, (double)n / this.y).truncated();
    }

    public Jun2dPoint quotientFromPoint_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(jun2dPoint.x / this.x, jun2dPoint.y / this.y);
    }

    public Jun2dPoint sumFromPoint_(Jun2dPoint jun2dPoint) {
        return new Jun2dPoint(jun2dPoint.x + this.x, jun2dPoint.y + this.y);
    }

    public JunAngle angleBetween_and_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        Jun2dPoint jun2dPoint3 = jun2dPoint.minus_(this);
        Jun2dPoint jun2dPoint4 = jun2dPoint2.minus_(this);
        double d = jun2dPoint3.rho();
        double d2 = jun2dPoint4.rho();
        if (d < 1.0E-12 || d2 < 1.0E-12) {
            return JunAngle.Zero();
        }
        double d3 = ((this.y + jun2dPoint.y) * (this.x - jun2dPoint.x) + (jun2dPoint.y + jun2dPoint2.y) * (jun2dPoint.x - jun2dPoint2.x) + (jun2dPoint2.y + this.y) * (jun2dPoint2.x - this.x)) / d / d2;
        d3 = Math.min(Math.max(d3, -1.0), 1.0);
        if (jun2dPoint3.dotProduct_(jun2dPoint4) >= 0.0) {
            return JunAngle.FromRad_(Math.asin(d3));
        }
        if (Math.abs(d3) < 1.0E-12) {
            return JunAngle.FromRad_(Math.PI);
        }
        int n = d3 < 0.0 ? -1 : 1;
        return JunAngle.FromRad_((Math.PI - Math.abs(Math.asin(d3))) * (double)n);
    }

    public Jun2dBoundingBall ball_(double d) {
        return new Jun2dBoundingBall(this, d);
    }

    public Jun2dLine bisector_(Jun2dPoint jun2dPoint) {
        return Jun2dLine.Between_and_(this, jun2dPoint);
    }

    public Jun2dBoundingBox box_(Jun2dPoint jun2dPoint) {
        return Jun2dBoundingBox.Vertex_vertex_(this, jun2dPoint);
    }

    public Jun2dPoint center_(Jun2dPoint jun2dPoint) {
        Jun2dPoint jun2dPoint2 = Jun2dPoint.Coerce_(jun2dPoint);
        return this.plus_(jun2dPoint2.minus_(this).dividedBy_(2.0));
    }

    public Jun2dBoundingBox corner_(Jun2dPoint jun2dPoint) {
        return Jun2dBoundingBox.Origin_corner_(this, jun2dPoint);
    }

    public double distance_(Jun2dPoint jun2dPoint) {
        return this.minus_(jun2dPoint).rho();
    }

    public double dotProduct_(Jun2dPoint jun2dPoint) {
        Jun2dPoint jun2dPoint2 = this.multipliedBy_(jun2dPoint);
        return jun2dPoint2.x + jun2dPoint2.y;
    }

    public Jun2dLine from_(JunPoint junPoint) {
        return new Jun2dLine(junPoint, this);
    }

    public Jun2dPoint grid_(Jun2dPoint jun2dPoint) {
        double d = jun2dPoint.x == 0.0 ? 0.0 : (double)Math.round(this.x / jun2dPoint.x) * jun2dPoint.x;
        double d2 = jun2dPoint.y == 0.0 ? 0.0 : (double)Math.round(this.y / jun2dPoint.y) * jun2dPoint.y;
        return new Jun2dPoint(d, d2);
    }

    public double innerProduct_(Jun2dPoint jun2dPoint) {
        return this.dotProduct_(jun2dPoint);
    }

    public Jun2dPoint length_(double d) {
        double d2 = this.length();
        if (d2 <= 1.0E-12) {
            return this;
        }
        return this.multipliedBy_(d / d2);
    }

    public Jun2dPolyline polyline_with_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        return new Jun2dPolyline(new Jun2dPoint[]{this, jun2dPoint, jun2dPoint2});
    }

    public Jun2dPolyline polyline_with_with_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3) {
        return new Jun2dPolyline(new Jun2dPoint[]{this, jun2dPoint, jun2dPoint2, jun2dPoint3});
    }

    public Jun2dPolyline polyline_with_with_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3, Jun2dPoint jun2dPoint4) {
        return new Jun2dPolyline(new Jun2dPoint[]{this, jun2dPoint, jun2dPoint2, jun2dPoint3, jun2dPoint4});
    }

    public double product_(Jun2dPoint jun2dPoint) {
        return this.x * jun2dPoint.y - this.y * jun2dPoint.x;
    }

    public Jun2dLine to_(JunPoint junPoint) {
        return new Jun2dLine(this, junPoint);
    }

    public Jun2dTriangle triangle_and_(JunPoint junPoint, JunPoint junPoint2) {
        return Jun2dTriangle.On_on_on_(this, junPoint, junPoint2);
    }

    public Jun2dPoint unitVector() {
        return this.length_(1.0);
    }

    public Jun2dPoint vectorProduct_(Jun2dPoint jun2dPoint) {
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(this).vectorProduct_(Jun3dPoint.Coerce_(jun2dPoint));
        return new Jun2dPoint(jun3dPoint.x, jun3dPoint.y);
    }

    public double rho() {
        return Math.sqrt(this.dotProduct_(this));
    }

    public double theta() {
        if (this.x == 0.0) {
            if (this.y == 0.0) {
                return JunAngle.Zero().rad();
            }
            if (this.y >= 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        JunAngle junAngle = JunAngle.FromRad_(Math.atan(this.y / this.x));
        if (this.x >= 0.0) {
            if (this.y >= 0.0) {
                return junAngle.rad();
            }
            return junAngle.plus_(Math.PI * 2).rad();
        }
        return junAngle.plus_(Math.PI).rad();
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(String.valueOf(this.x));
        writer.write(" , ");
        writer.write(String.valueOf(this.y));
        writer.write(41);
    }

    public boolean is2d() {
        return true;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public boolean negative() {
        return this.isLessThan_(Jun2dPoint.Zero());
    }

    public boolean positive() {
        return this.isGreaterThanOrEqualTo_(Jun2dPoint.Zero());
    }

    public int whichSideOf_(Jun2dLine jun2dLine) {
        return jun2dLine.whichSide_(this);
    }

    public Jun2dPoint rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun2dTransformation.Rotate_(junAngle));
    }

    public Jun2dPoint scaledBy_(double d) {
        return this.transform_(Jun2dTransformation.Scale_(d));
    }

    public Jun2dPoint scaledBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Scale_(jun2dPoint));
    }

    public Jun2dPoint transform_(Jun2dTransformation jun2dTransformation) {
        return jun2dTransformation.applyToPoint_(this);
    }

    public Jun2dTransformation transformationToScale() {
        return Jun2dTransformation.Scale_(this);
    }

    public Jun2dTransformation transformationToTranslate() {
        return Jun2dTransformation.Translate_(this);
    }

    public Jun2dPoint translatedBy_(double d) {
        return this.transform_(Jun2dTransformation.Translate_(d));
    }

    public Jun2dPoint translatedBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Translate_(jun2dPoint));
    }

    public Jun2dPoint ceiling() {
        return new Jun2dPoint(Math.ceil(this.x), Math.ceil(this.y));
    }

    public Jun2dPoint floor() {
        return new Jun2dPoint(Math.floor(this.x), Math.floor(this.y));
    }

    public Jun2dPoint rounded() {
        return new Jun2dPoint(Math.round(this.x), Math.round(this.y));
    }

    public Jun2dPoint roundTo_(double d) {
        return this.dividedBy_(d).rounded().multipliedBy_(d);
    }

    public Jun2dPoint roundTo_(Jun2dPoint jun2dPoint) {
        return this.dividedBy_(jun2dPoint).rounded().multipliedBy_(jun2dPoint);
    }

    public Jun2dPoint truncated() {
        double d = this.x >= 0.0 ? Math.ceil(this.x) : Math.floor(this.x);
        double d2 = this.y >= 0.0 ? Math.ceil(this.y) : Math.floor(this.y);
        return new Jun2dPoint(d, d2);
    }
}

