/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.basic;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunAngle
extends JunGeometry
implements Comparable {
    protected static final double _RadiansPerDegree = Math.PI / 180;
    protected double rad;
    protected Double deg = null;
    protected Double sin = null;
    protected Double cos = null;
    protected Double tan = null;

    public static double _DegreesToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static double _RadiansToDegrees(double d) {
        return d / (Math.PI / 180);
    }

    public static final JunAngle FromDeg_(double d) {
        JunAngle junAngle = new JunAngle();
        junAngle.deg_(d);
        return junAngle;
    }

    public static final JunAngle FromRad_(double d) {
        JunAngle junAngle = new JunAngle();
        junAngle.rad_(d);
        return junAngle;
    }

    public static JunAngle DoublePiAngle() {
        return JunAngle.FromDeg_(JunGeometry.DoublePi());
    }

    public static JunAngle HalfPiAngle() {
        return JunAngle.FromDeg_(JunGeometry.HalfPi());
    }

    public static JunAngle PiAngle() {
        return JunAngle.FromDeg_(JunGeometry.Pi());
    }

    public static JunAngle QuarterPiAngle() {
        return JunAngle.FromDeg_(JunGeometry.QuarterPi());
    }

    public static JunAngle Unity() {
        throw SmalltalkException.ShouldNotImplement();
    }

    public static JunAngle Zero() {
        return JunAngle.FromRad_(0.0);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.PieFrom_to_by_radius_(0.0, this.radiansToDegrees(), 5.0, 1.0);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject.reversed());
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        junOpenGL3dCompoundObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_alpha_(JunAngle.this.defaultColor(), JunAngle.this.defaultAlpha());
                return null;
            }
        });
        return junOpenGL3dCompoundObject;
    }

    public int compareTo(Object object) {
        double d = Double.NaN;
        if (object instanceof JunAngle) {
            d = ((JunAngle)object).rad();
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        }
        if (!Double.isNaN(d)) {
            if (this.rad() < d) {
                return -1;
            }
            if (d < this.rad()) {
                return 1;
            }
            return 0;
        }
        return ((Comparable)object).compareTo(new Double(this.rad()));
    }

    public double cos() {
        if (this.cos == null) {
            this.cos = new Double(Math.cos(this.rad));
        }
        return this.cos;
    }

    public double deg() {
        if (this.deg == null) {
            this.deg = new Double(JunAngle._RadiansToDegrees(this.rad));
        }
        return this.deg;
    }

    public void deg_(double d) {
        this.setRad_(JunAngle._DegreesToRadians(d));
    }

    public double degrees() {
        return this.deg();
    }

    public void degrees_(double d) {
        this.deg_(d);
    }

    public JunAngle div_(double d) {
        return JunAngle.FromRad_(this.rad / d);
    }

    public JunAngle dividedBy_(double d) {
        return JunAngle.FromRad_(this.rad / d);
    }

    public JunAngle dividedBy_(JunAngle junAngle) {
        return this.dividedBy_(junAngle.rad());
    }

    public boolean equal_(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JunAngle junAngle = (JunAngle)object;
        return this.isEqualNumber_to_(this.rad, junAngle.rad);
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JunAngle junAngle = (JunAngle)object;
        return this.rad == junAngle.rad;
    }

    public int generality() {
        return 120;
    }

    public boolean isAngle() {
        return true;
    }

    public boolean isZero() {
        return this.rad() == 0.0;
    }

    public JunAngle minus_(double d) {
        return JunAngle.FromRad_(this.rad - d);
    }

    public JunAngle minus_(JunAngle junAngle) {
        return this.minus_(junAngle.rad());
    }

    public JunAngle mul_(double d) {
        return JunAngle.FromRad_(this.rad * d);
    }

    public JunAngle multipliedBy_(double d) {
        return JunAngle.FromRad_(this.rad * d);
    }

    public JunAngle multipliedBy_(JunAngle junAngle) {
        return this.multipliedBy_(junAngle.rad());
    }

    public JunAngle negated() {
        return JunAngle.FromRad_(-this.rad);
    }

    public JunAngle plus_(double d) {
        return JunAngle.FromRad_(this.rad + d);
    }

    public JunAngle plus_(JunAngle junAngle) {
        return this.plus_(junAngle.rad());
    }

    public JunAngle reciprocal() {
        return JunAngle.FromDeg_(1.0 / this.rad());
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" fromDeg: ");
        writer.write(String.valueOf(this.deg()));
        writer.write(41);
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" fromRad: ");
        writer.write(String.valueOf(this.rad()));
        writer.write(41);
    }

    public double rad() {
        return this.rad;
    }

    public double radiansToDegrees() {
        return this.deg();
    }

    public void rad_(double d) {
        this.setRad_(d);
    }

    public double radians() {
        return this.rad();
    }

    public void radians_(double d) {
        this.rad_(d);
    }

    public double sin() {
        if (this.sin == null) {
            this.sin = new Double(Math.sin(this.rad));
        }
        return this.sin;
    }

    public double tan() {
        if (this.tan == null) {
            this.tan = new Double(Math.tan(this.rad));
        }
        return this.tan;
    }

    public Jun2dTransformation transformationToRotate() {
        return Jun2dTransformation.Rotate_(this);
    }

    public Jun3dTransformation transformationToRotate_(Jun3dLine jun3dLine) {
        return jun3dLine.transformationToRotate_(this);
    }

    public Jun3dTransformation transformationToRotateX() {
        return Jun3dTransformation.RotateX_(this);
    }

    public Jun3dTransformation transformationToRotateY() {
        return Jun3dTransformation.RotateY_(this);
    }

    public Jun3dTransformation transformationToRotateZ() {
        return Jun3dTransformation.RotateZ_(this);
    }

    private void setRad_(double d) {
        this.rad = d;
        this.deg = null;
        this.sin = null;
        this.cos = null;
        this.tan = null;
    }
}

