/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boundaries;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBalls;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBoxes;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.smalltalk.SmalltalkException;

public class Jun2dBoundingBox
extends JunBoundingBox {
    public Jun2dBoundingBox() {
    }

    public Jun2dBoundingBox(Rectangle rectangle) {
        this.origin_extent_(new Jun2dPoint(rectangle.x, rectangle.y), new Jun2dPoint(rectangle.width, rectangle.height));
    }

    public Jun2dBoundingBox(Jun2dPoint[] jun2dPointArray) {
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return;
        }
        this.origin_corner_(jun2dPointArray[0], jun2dPointArray[0]);
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            this.add_(jun2dPointArray[i]);
        }
    }

    public static Jun2dBoundingBox Origin_corner_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox();
        jun2dBoundingBox.origin_corner_(jun2dPoint, jun2dPoint2);
        return jun2dBoundingBox;
    }

    public static Jun2dBoundingBox Origin_extent_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox();
        jun2dBoundingBox.origin_extent_(jun2dPoint, jun2dPoint2);
        return jun2dBoundingBox;
    }

    public static Jun2dBoundingBox Vertex_vertex_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox();
        jun2dBoundingBox.vertex_vertex_(jun2dPoint, jun2dPoint2);
        return jun2dBoundingBox;
    }

    public static Jun2dBoundingBox Unity() {
        return Jun2dBoundingBox.Origin_corner_(Jun2dPoint.Zero(), Jun2dPoint.Unity());
    }

    public static Jun2dBoundingBox Zero() {
        return Jun2dBoundingBox.Origin_corner_(Jun2dPoint.Zero(), Jun2dPoint.Zero());
    }

    protected void initialize() {
        super.initialize();
        this._origin(Jun2dPoint.Zero());
        this._corner(Jun2dPoint.Zero());
    }

    public double area() {
        return this.width() * this.height();
    }

    public Jun2dBoundingBall boundingBall() {
        Jun2dPoint jun2dPoint = this.center();
        return new Jun2dBoundingBall(jun2dPoint, this.origin().distance_(jun2dPoint));
    }

    public Jun2dBoundingBox boundingBox() {
        return this;
    }

    public Jun2dPoint center() {
        return this.origin().center_(this.corner());
    }

    public Jun2dPoint corner() {
        return (Jun2dPoint)this._corner();
    }

    public void corner_(Jun2dPoint jun2dPoint) {
        this.origin_corner_(this.origin(), jun2dPoint);
    }

    public double depth() {
        throw SmalltalkException.ShouldNotImplement();
    }

    public Jun2dPoint extent() {
        return this.corner().minus_(this.origin());
    }

    public Jun2dBoundingBall innerBoundingBall() {
        Jun2dPoint jun2dPoint = this.center();
        return new Jun2dBoundingBall(jun2dPoint, Math.min(this.width(), this.height()) / 2.0);
    }

    public Jun2dBoundingBox innerBoundingBox() {
        return this;
    }

    public Jun2dPoint origin() {
        return (Jun2dPoint)this._origin();
    }

    public void origin_(Jun2dPoint jun2dPoint) {
        this.origin_corner_(jun2dPoint, this.corner());
    }

    public void origin_corner_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        this._origin(jun2dPoint);
        this._corner(jun2dPoint2);
    }

    public void origin_extent_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        this.origin_corner_(jun2dPoint, jun2dPoint.plus_(jun2dPoint2));
    }

    public Jun2dBoundingBall outerBoundingBall() {
        return this.boundingBall();
    }

    public Jun2dBoundingBox outerBoundingBox() {
        return this.boundingBox();
    }

    public Jun2dPoint p1() {
        return new Jun2dPoint(this.origin().x(), this.origin().y());
    }

    public Jun2dPoint p2() {
        return new Jun2dPoint(this.corner().x(), this.origin().y());
    }

    public Jun2dPoint p3() {
        return new Jun2dPoint(this.corner().x(), this.corner().y());
    }

    public Jun2dPoint p4() {
        return new Jun2dPoint(this.origin().x(), this.corner().y());
    }

    public Jun2dPoint[] pp1() {
        return new Jun2dPoint[]{this.p1(), this.p2(), this.p3(), this.p4()};
    }

    public Jun2dPoint[][] pps() {
        return new Jun2dPoint[][]{this.pp1()};
    }

    public Jun2dBoundingBalls tetraBoundingBalls() {
        Jun2dBoundingBalls jun2dBoundingBalls = new Jun2dBoundingBalls();
        Jun2dBoundingBoxes jun2dBoundingBoxes = this.tetraBoundingBoxes();
        Jun2dBoundingBox[] jun2dBoundingBoxArray = jun2dBoundingBoxes.boundingBoxes();
        for (int i = 0; i < jun2dBoundingBoxArray.length; ++i) {
            jun2dBoundingBalls.add_(jun2dBoundingBoxArray[i].outerBoundingBall());
        }
        return jun2dBoundingBalls;
    }

    public Jun2dBoundingBoxes tetraBoundingBoxes() {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        Jun2dBoundingBox jun2dBoundingBox = null;
        double d = Double.NaN;
        double d2 = Double.NaN;
        jun2dBoundingBox = Jun2dBoundingBox.Origin_corner_(this.origin(), this.center());
        jun2dBoundingBoxes.add_(jun2dBoundingBox);
        d = this.width() / 2.0;
        jun2dBoundingBoxes.add_(jun2dBoundingBox.translatedBy_(new Jun2dPoint(d, 0.0)));
        d2 = this.height() / 2.0;
        jun2dBoundingBoxes.add_(jun2dBoundingBox.translatedBy_(new Jun2dPoint(d, d2)));
        jun2dBoundingBoxes.add_(jun2dBoundingBox.translatedBy_(new Jun2dPoint(0.0, d2)));
        return jun2dBoundingBoxes;
    }

    public void vertex_vertex_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        this.origin_corner_(jun2dPoint.min_(jun2dPoint2), jun2dPoint.max_(jun2dPoint2));
    }

    public void add_(Jun2dPoint jun2dPoint) {
        if (!this.containsPoint_(jun2dPoint)) {
            Jun2dBoundingBox jun2dBoundingBox = this.merge_(Jun2dBoundingBox.Origin_corner_(jun2dPoint, jun2dPoint));
            this.origin_corner_(jun2dBoundingBox.origin(), jun2dBoundingBox.corner());
        }
    }

    public Jun2dLine[] asArrayOf2dLines() {
        return new Jun2dLine[]{new Jun2dLine(new Jun2dPoint(this.origin().x(), this.origin().y()), new Jun2dPoint(this.corner().x(), this.origin().y())), new Jun2dLine(new Jun2dPoint(this.corner().x(), this.origin().y()), new Jun2dPoint(this.corner().x(), this.corner().y())), new Jun2dLine(new Jun2dPoint(this.corner().x(), this.corner().y()), new Jun2dPoint(this.origin().x(), this.corner().y())), new Jun2dLine(new Jun2dPoint(this.origin().x(), this.corner().y()), new Jun2dPoint(this.origin().x(), this.origin().y()))};
    }

    public JunPlane[] asArrayOfPlanes() {
        Jun2dPoint jun2dPoint = this.origin();
        Jun2dPoint jun2dPoint2 = this.corner();
        JunPlane[] junPlaneArray = new JunPlane[]{new JunPlane(new Jun3dPoint(jun2dPoint.x(), jun2dPoint.y(), 0.0), new Jun3dPoint(jun2dPoint2.x(), jun2dPoint.y(), 0.0), new Jun3dPoint(jun2dPoint.x(), jun2dPoint2.y(), 0.0))};
        return junPlaneArray;
    }

    public Jun2dTriangle[] asArrayOfTriangles() {
        Jun2dPoint jun2dPoint = this.origin();
        Jun2dPoint jun2dPoint2 = this.corner();
        Jun2dTriangle[] jun2dTriangleArray = new Jun2dTriangle[]{Jun2dTriangle.On_on_on_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()), new Jun2dPoint(jun2dPoint2.x(), jun2dPoint.y()), new Jun2dPoint(jun2dPoint.x(), jun2dPoint2.y())), Jun2dTriangle.On_on_on_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()), new Jun2dPoint(jun2dPoint.x(), jun2dPoint2.y()), new Jun2dPoint(jun2dPoint2.x(), jun2dPoint.y()))};
        return jun2dTriangleArray;
    }

    public Jun2dBoundingBox asBoundingBox() {
        return this;
    }

    public Jun2dBoundingBoxes asBoundingBoxes() {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>();
        arrayList.add(this);
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        return jun2dBoundingBoxes;
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[]{new Jun3dPoint(this.origin(), 0.0), new Jun3dPoint(this.corner().x(), this.origin().y(), 0.0), new Jun3dPoint(this.corner(), 0.0), new Jun3dPoint(this.origin().x(), this.corner().y(), 0.0)});
        junOpenGL3dPolygon.paint_alpha_(this.defaultColor(), this.defaultAlpha());
        junOpenGL3dCompoundObject.add_(((JunOpenGL3dObject)junOpenGL3dPolygon).reversed());
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
        return junOpenGL3dCompoundObject;
    }

    public Jun2dPoint[] asPointArray() {
        return new Jun2dPoint[]{this.origin(), new Jun2dPoint(this.corner().x(), this.origin().y()), this.corner(), new Jun2dPoint(this.origin().x(), this.corner().y())};
    }

    public Rectangle asRectangle() {
        Point point = this.origin()._toPoint();
        Point point2 = this.extent()._toPoint();
        return new Rectangle(point.x, point.y, point2.x, point2.y);
    }

    public Rectangle[] asRectangles() {
        return this.asBoundingBoxes().asRectangles();
    }

    public Jun2dBoundingBoxes boxesOutside_(Jun2dBoundingBox jun2dBoundingBox) {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        if (this.intersects_(jun2dBoundingBox)) {
            Jun2dBoundingBox jun2dBoundingBox2;
            double d = Double.NaN;
            if (jun2dBoundingBox.origin().y() > this.origin().y()) {
                d = jun2dBoundingBox.origin().y();
                Jun2dBoundingBox jun2dBoundingBox3 = Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(this.origin()), new Jun2dPoint(this.corner().x(), d));
                jun2dBoundingBoxes.add_(jun2dBoundingBox3);
            } else {
                d = this.origin().y();
            }
            double d2 = Double.NaN;
            if (jun2dBoundingBox.corner().y() < this.corner().y()) {
                d2 = jun2dBoundingBox.corner().y();
                jun2dBoundingBox2 = Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(this.origin().x(), d2), new Jun2dPoint(this.corner()));
                jun2dBoundingBoxes.add_(jun2dBoundingBox2);
            } else {
                d2 = this.corner().y();
            }
            if (jun2dBoundingBox.origin().x() > this.origin().x()) {
                jun2dBoundingBox2 = Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(this.origin().x(), d), new Jun2dPoint(jun2dBoundingBox.origin().x(), d2));
                jun2dBoundingBoxes.add_(jun2dBoundingBox2);
            }
            if (jun2dBoundingBox.corner().x() < this.corner().x()) {
                jun2dBoundingBox2 = Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(jun2dBoundingBox.corner().x(), d), new Jun2dPoint(this.corner().x(), d2));
                jun2dBoundingBoxes.add_(jun2dBoundingBox2);
            }
        } else {
            Jun2dBoundingBox jun2dBoundingBox4 = (Jun2dBoundingBox)this.copy();
            jun2dBoundingBoxes.add_(jun2dBoundingBox4);
        }
        return jun2dBoundingBoxes;
    }

    public Jun2dPoint containedPointFor_(Jun2dPoint jun2dPoint) {
        return jun2dPoint.min_(this.origin()).max_(this.corner());
    }

    public Jun2dBoundingBox expandedBy_(double d) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().minus_(d), this.corner().plus_(d));
    }

    public Jun2dBoundingBox expandedBy_(Jun2dBoundingBox jun2dBoundingBox) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().minus_(jun2dBoundingBox.origin()), this.corner().plus_(jun2dBoundingBox.corner()));
    }

    public Jun2dBoundingBox expandedBy_(Jun2dPoint jun2dPoint) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().minus_(jun2dPoint), this.corner().plus_(jun2dPoint));
    }

    public Jun2dBoundingBox insetBy_(double d) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().plus_(d), this.corner().minus_(d));
    }

    public Jun2dBoundingBox insetBy_(Jun2dBoundingBox jun2dBoundingBox) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().plus_(jun2dBoundingBox.origin()), this.corner().minus_(jun2dBoundingBox.corner()));
    }

    public Jun2dBoundingBox intersect_(Jun2dBoundingBox jun2dBoundingBox) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().max_(jun2dBoundingBox.origin()), this.corner().min_(jun2dBoundingBox.corner()));
    }

    public Jun2dPoint[] intersectingPointsWithLine_(Jun2dLine jun2dLine) {
        Jun2dPoint[] jun2dPointArray;
        Jun2dLine jun2dLine2 = new Jun2dLine(jun2dLine.first(), jun2dLine.last());
        Jun2dPoint jun2dPoint = this.origin();
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(this.origin().x(), this.corner().y());
        Jun2dPoint jun2dPoint3 = this.corner();
        Jun2dPoint jun2dPoint4 = new Jun2dPoint(this.corner().x(), this.origin().y());
        Jun2dLine[] jun2dLineArray = new Jun2dLine[]{new Jun2dLine(jun2dPoint, jun2dPoint2), new Jun2dLine(jun2dPoint2, jun2dPoint3), new Jun2dLine(jun2dPoint3, jun2dPoint4), new Jun2dLine(jun2dPoint4, jun2dPoint)};
        Vector<Jun2dPoint> vector = new Vector<Jun2dPoint>();
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            jun2dPointArray = jun2dLineArray[i];
            if (jun2dPointArray.isParallelWithLine_(jun2dLine2)) {
                double d = jun2dPointArray.distanceFromPoint_(jun2dLine2.first());
                if (!(Math.abs(d) < JunGeometry.Accuracy())) continue;
                vector.add(jun2dPointArray.first());
                vector.add(jun2dPointArray.last());
                continue;
            }
            Jun2dPoint jun2dPoint5 = jun2dPointArray.intersectingPointWithLine_(jun2dLine2);
            if (jun2dPoint5 == null) continue;
            vector.add(jun2dPoint5);
        }
        Vector<Jun2dPoint> vector2 = new Vector<Jun2dPoint>();
        jun2dPointArray = new Jun2dPoint[vector.size()];
        vector.copyInto((Object[])jun2dPointArray);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Jun2dPoint jun2dPoint6 = jun2dPointArray[i];
            for (int j = 0; j < jun2dLineArray.length; ++j) {
                Jun2dLine jun2dLine3 = jun2dLineArray[j];
                if (!jun2dLine3.lineSegmentContainsPoint_(jun2dPoint6)) continue;
                vector2.add(jun2dPoint6);
            }
        }
        Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[vector2.size()];
        vector2.copyInto((Object[])jun2dPointArray2);
        return jun2dPointArray2;
    }

    public Jun2dBoundingBox merge_(Jun2dBoundingBox jun2dBoundingBox) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().min_(jun2dBoundingBox.origin()), this.corner().max_(jun2dBoundingBox.corner()));
    }

    public Jun2dBoundingBox unify() {
        return this;
    }

    public Jun2dBoundingBoxes subdivide() {
        return this.subdivide4();
    }

    public Jun2dBoundingBoxes subdivide2() {
        Jun2dPoint jun2dPoint = this.origin();
        Jun2dPoint jun2dPoint2 = this.corner();
        Jun2dPoint jun2dPoint3 = this.center();
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>(2);
        if (this.height() > this.width()) {
            arrayList.add(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()).box_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint3.y())));
            arrayList.add(new Jun2dPoint(jun2dPoint.x(), jun2dPoint3.y()).box_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y())));
        } else {
            arrayList.add(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()).box_(new Jun2dPoint(jun2dPoint3.x(), jun2dPoint2.y())));
            arrayList.add(new Jun2dPoint(jun2dPoint3.x(), jun2dPoint.y()).box_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y())));
        }
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivide4() {
        Jun2dPoint jun2dPoint = this.origin();
        Jun2dPoint jun2dPoint2 = this.corner();
        Jun2dPoint jun2dPoint3 = this.center();
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>(4);
        arrayList.add(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()).box_(jun2dPoint3));
        arrayList.add(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint.y()).box_(jun2dPoint3));
        arrayList.add(new Jun2dPoint(jun2dPoint.x(), jun2dPoint2.y()).box_(jun2dPoint3));
        arrayList.add(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()).box_(jun2dPoint3));
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivideLevel_(int n) {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>();
        arrayList.add(this);
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        for (int i = 0; i < n; ++i) {
            jun2dBoundingBoxes = jun2dBoundingBoxes.subdivide();
        }
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivide2Level_(int n) {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>();
        arrayList.add(this);
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        for (int i = 0; i < n; ++i) {
            jun2dBoundingBoxes = jun2dBoundingBoxes.subdivide2();
        }
        return jun2dBoundingBoxes;
    }

    public boolean contains_(Jun2dBoundingBox jun2dBoundingBox) {
        return this.origin().isLessThanOrEqualTo_(jun2dBoundingBox.origin()) && jun2dBoundingBox.corner().isLessThanOrEqualTo_(this.corner());
    }

    public boolean containsOrTouchesPoint_(Jun2dPoint jun2dPoint) {
        return this.origin().isLessThanOrEqualTo_(jun2dPoint) && jun2dPoint.isLessThanOrEqualTo_(this.corner());
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        return this.origin().isLessThanOrEqualTo_(jun2dPoint) && jun2dPoint.isLessThan_(this.corner());
    }

    public boolean intersects_(Jun2dBoundingBox jun2dBoundingBox) {
        return this.origin().isLessThan_(jun2dBoundingBox.corner()) && jun2dBoundingBox.origin().isLessThan_(this.corner()) && this.origin().isLessThan_(this.corner()) && jun2dBoundingBox.origin().isLessThan_(jun2dBoundingBox.corner());
    }

    public boolean intersectsOrTouches_(Jun2dBoundingBox jun2dBoundingBox) {
        return this.intersects_(jun2dBoundingBox) || this.touches_(jun2dBoundingBox);
    }

    public boolean touches_(Jun2dBoundingBox jun2dBoundingBox) {
        return this.origin().isLessThanOrEqualTo_(jun2dBoundingBox.corner()) && jun2dBoundingBox.origin().isLessThanOrEqualTo_(this.corner()) && this.origin().isLessThanOrEqualTo_(this.corner()) && jun2dBoundingBox.origin().isLessThanOrEqualTo_(jun2dBoundingBox.corner());
    }

    public boolean touchesPoint_(Jun2dPoint jun2dPoint) {
        return (this.isEqualNumber_to_(this.origin().x(), jun2dPoint.x()) || this.isEqualNumber_to_(this.corner().x(), jun2dPoint.x())) && this.origin().y() <= jun2dPoint.y() && jun2dPoint.y() <= this.corner().y() || (this.isEqualNumber_to_(this.origin().y(), jun2dPoint.y()) || this.isEqualNumber_to_(this.corner().y(), jun2dPoint.y())) && this.origin().x() <= jun2dPoint.x() && jun2dPoint.x() <= this.corner().x();
    }

    public boolean is2d() {
        return true;
    }

    public Jun2dBoundingBox rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun2dTransformation.Rotate_(junAngle));
    }

    public Jun2dBoundingBox scaledBy_(double d) {
        return this.transform_(Jun2dTransformation.Scale_(d));
    }

    public Jun2dBoundingBox scaledBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Scale_(jun2dPoint));
    }

    public Jun2dBoundingBox transform_(Jun2dTransformation jun2dTransformation) {
        return Jun2dBoundingBox.Origin_corner_(this.origin().transform_(jun2dTransformation), this.corner().transform_(jun2dTransformation));
    }

    public Jun2dBoundingBox translatedBy_(double d) {
        return this.transform_(Jun2dTransformation.Translate_(d));
    }

    public Jun2dBoundingBox translatedBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Translate_(jun2dPoint));
    }

    public Jun2dBoundingBox rounded() {
        return Jun2dBoundingBox.Origin_corner_(this.origin().rounded(), this.corner().rounded());
    }

    public Jun2dBoundingBox truncated() {
        return Jun2dBoundingBox.Origin_corner_(this.origin().truncated(), this.corner().truncated());
    }
}

