/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.curves;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.JunPolyline;
import jp.co.sra.jun.geometry.forms.JunFormTriangulation2;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun2dPolyline
extends JunPolyline {
    protected Jun2dPoint[] points;
    protected Jun2dBoundingBox boundingBox;
    protected double[] segmentLengths;

    public Jun2dPolyline(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        this(new Jun2dPoint[]{jun2dPoint, jun2dPoint2});
    }

    public Jun2dPolyline(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3) {
        this(new Jun2dPoint[]{jun2dPoint, jun2dPoint2, jun2dPoint3});
    }

    public Jun2dPolyline(Jun2dPoint[] jun2dPointArray) {
        this.setPoints_(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.points = null;
        this.boundingBox = null;
        this.segmentLengths = null;
    }

    public Jun2dPoint[] points() {
        if (this.points == null) {
            this.points = new Jun2dPoint[0];
        }
        return this.points;
    }

    protected JunPoint[] _points() {
        return this.points();
    }

    public Jun2dPoint pointAt_(int n) {
        return this.points()[n];
    }

    public Jun2dPoint atT_(double d) {
        if (d <= 0.0) {
            return this.pointAt_(0);
        }
        if (1.0 <= d) {
            return this.pointAt_(this.numberOfPoints() - 1);
        }
        double d2 = this.length() * d;
        for (int i = 1; i < this.numberOfPoints(); ++i) {
            double d3 = this.segmentLengths[i - 1];
            double d4 = this.segmentLengths[i];
            if (!(d3 <= d2) || !(d2 <= d4)) continue;
            Jun2dLine jun2dLine = this.pointAt_(i - 1).to_(this.pointAt_(i));
            return jun2dLine.atT_((d2 - d3) / (d4 - d3));
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun2dPoint atX_(double d) {
        Jun2dLine[] jun2dLineArray = this.asArrayOfLines();
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            if (!(jun2dLineArray[i].from().x() <= d) || !(d <= jun2dLineArray[i].to().x())) continue;
            return jun2dLineArray[i].atX_(d);
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun2dPoint atY_(double d) {
        Jun2dLine[] jun2dLineArray = this.asArrayOfLines();
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            if (!(jun2dLineArray[i].from().y() <= d) || !(d <= jun2dLineArray[i].to().y())) continue;
            return jun2dLineArray[i].atY_(d);
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    public Jun2dPoint from() {
        return this.atT_(0.0);
    }

    public Jun2dPoint to() {
        return this.atT_(1.0);
    }

    public int numberOfPoints() {
        return this.size();
    }

    public double length() {
        if (this.segmentLengths == null) {
            double d;
            double[] dArray = new double[this.numberOfPoints()];
            dArray[0] = d = 0.0;
            for (int i = 1; i < this.numberOfPoints(); ++i) {
                dArray[i] = d += this.pointAt_(i - 1).distance_(this.pointAt_(i));
            }
            this.segmentLengths = dArray;
        }
        return this.segmentLengths[this.segmentLengths.length - 1];
    }

    public int size() {
        return this.points().length;
    }

    public Jun2dBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = this.preferredBoundingBox();
        }
        return this.boundingBox;
    }

    protected Jun2dBoundingBox preferredBoundingBox() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        Jun2dPoint[] jun2dPointArray = this.points();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            d = Math.min(d, jun2dPointArray[i].x());
            d2 = Math.min(d2, jun2dPointArray[i].y());
            d3 = Math.max(d3, jun2dPointArray[i].x());
            d4 = Math.max(d4, jun2dPointArray[i].y());
        }
        if (d == Double.MAX_VALUE) {
            d = 0.0;
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = 0.0;
        }
        if (d3 == Double.MIN_VALUE) {
            d3 = 0.0;
        }
        if (d4 == Double.MIN_VALUE) {
            d4 = 0.0;
        }
        return Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(d, d2), new Jun2dPoint(d3, d4));
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dPolyline jun2dPolyline = (Jun2dPolyline)((Object)object);
        if (this.numberOfPoints() != jun2dPolyline.numberOfPoints()) {
            return false;
        }
        for (int i = 0; i < this.numberOfPoints(); ++i) {
            if (this.pointAt_(i).equal_((Object)jun2dPolyline.pointAt_(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dPolyline jun2dPolyline = (Jun2dPolyline)((Object)object);
        if (this.numberOfPoints() != jun2dPolyline.numberOfPoints()) {
            return false;
        }
        for (int i = 0; i < this.numberOfPoints(); ++i) {
            if (this.pointAt_(i).equals((Object)jun2dPolyline.pointAt_(i))) continue;
            return false;
        }
        return true;
    }

    public Jun2dPoint[] as2dPoints() {
        return this.points();
    }

    public Jun3dPoint[] as3dPoints() {
        Jun2dPoint[] jun2dPointArray = this.points();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray[i] = jun2dPointArray[i].as3dPoint();
        }
        return jun3dPointArray;
    }

    public Jun2dLine[] asArrayOfLines() {
        return this.asArrayOf2dLines();
    }

    public Jun2dLine[] asArrayOf2dLines() {
        Jun2dPoint[] jun2dPointArray = this.points();
        Jun2dLine[] jun2dLineArray = new Jun2dLine[jun2dPointArray.length - 1];
        for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
            jun2dLineArray[i] = jun2dPointArray[i].to_(jun2dPointArray[i + 1]);
        }
        return jun2dLineArray;
    }

    public Jun2dPoint[] asArrayOfPoints() {
        return this.points();
    }

    public Jun2dTriangle[] asArrayOfTriangles() {
        return this.asArrayOf2dTriangles();
    }

    public Jun2dTriangle[] asArrayOf2dTriangles() {
        if (this.numberOfPoints() < 3) {
            return new Jun2dTriangle[0];
        }
        Jun2dPoint[] jun2dPointArray = null;
        boolean bl = this.from().equals((Object)this.to());
        if (bl) {
            jun2dPointArray = this.points();
        } else {
            jun2dPointArray = new Jun2dPoint[this.numberOfPoints() + 1];
            System.arraycopy(this.points(), 0, jun2dPointArray, 0, this.numberOfPoints());
            jun2dPointArray[jun2dPointArray.length - 1] = this.from();
        }
        JunFormTriangulation2 junFormTriangulation2 = new JunFormTriangulation2(jun2dPointArray);
        ArrayList<Jun2dTriangle> arrayList = new ArrayList<Jun2dTriangle>();
        Jun2dTriangle[] jun2dTriangleArray = junFormTriangulation2.triangles();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            Jun2dPoint jun2dPoint = jun2dTriangleArray[i].third();
            Jun2dPoint jun2dPoint2 = jun2dTriangleArray[i].second();
            Jun2dPoint jun2dPoint3 = jun2dTriangleArray[i].first();
            if (bl) {
                arrayList.add(Jun2dTriangle.On_on_on_(jun2dPoint, jun2dPoint2, jun2dPoint3));
                continue;
            }
            Jun2dPoint jun2dPoint4 = this.from();
            Jun2dPoint jun2dPoint5 = this.to();
            if (!(!jun2dPoint.equals((Object)jun2dPoint4) && !jun2dPoint2.equals((Object)jun2dPoint4) && !jun2dPoint3.equals((Object)jun2dPoint4) || !jun2dPoint.equals((Object)jun2dPoint5) && !jun2dPoint2.equals((Object)jun2dPoint5) && !jun2dPoint3.equals((Object)jun2dPoint5))) continue;
            arrayList.add(Jun2dTriangle.On_on_on_(jun2dPoint, jun2dPoint2, jun2dPoint3));
        }
        return arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
    }

    public Jun2dPolygon asPolygon() {
        return new Jun2dPolygon(this.points());
    }

    public Jun2dPolyline asPolyline() {
        return this;
    }

    public Jun2dPolyline reversed() {
        Jun2dPoint[] jun2dPointArray = this.points();
        Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[jun2dPointArray.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray2[jun2dPointArray2.length - 1 - i] = jun2dPointArray[i];
        }
        return new Jun2dPolyline(jun2dPointArray2);
    }

    public Jun2dPolyline subdivide() {
        Jun2dPoint[] jun2dPointArray = this.points();
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>(this.size() * 2 - 1);
        for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
            arrayList.add(jun2dPointArray[i]);
            arrayList.add(jun2dPointArray[i].to_(jun2dPointArray[i + 1]).center());
        }
        arrayList.add(jun2dPointArray[jun2dPointArray.length - 1]);
        Jun2dPolyline jun2dPolyline = new Jun2dPolyline(arrayList.toArray(new Jun2dPoint[arrayList.size()]));
        return jun2dPolyline;
    }

    public Jun2dPolyline subdivideLevel_(int n) {
        Jun2dPolyline jun2dPolyline = (Jun2dPolyline)this.copy();
        for (int i = 0; i < n; ++i) {
            jun2dPolyline = jun2dPolyline.subdivide();
        }
        return jun2dPolyline;
    }

    public Jun2dPolyline subdivideAsSpline() {
        return new Jun2dPolyline(this.computeSplinePoints_(this.points()));
    }

    public Jun2dPolyline subdivideAsSplineLevel_(int n) {
        Jun2dPolyline jun2dPolyline = this;
        for (int i = 0; i < n; ++i) {
            jun2dPolyline = jun2dPolyline.subdivideAsSpline();
        }
        return jun2dPolyline;
    }

    public boolean is2d() {
        return true;
    }

    public Jun2dTriangle[] sew_(Jun2dPolyline jun2dPolyline) {
        return this.sew_interim_(jun2dPolyline, null);
    }

    public Jun2dTriangle[] sew_interim_(Jun2dPolyline jun2dPolyline, StBlockClosure stBlockClosure) {
        Jun2dPoint jun2dPoint;
        int n;
        Jun2dPoint jun2dPoint2;
        Jun2dPoint jun2dPoint3;
        int n2;
        ArrayList<Jun2dTriangle> arrayList = new ArrayList<Jun2dTriangle>();
        Jun2dPoint[] jun2dPointArray = jun2dPolyline.points();
        for (n2 = 1; n2 < jun2dPointArray.length; ++n2) {
            jun2dPoint3 = jun2dPointArray[n2 - 1];
            jun2dPoint2 = jun2dPointArray[n2];
            n = this.findIndexOfPoints_from_to_interim_(this.points(), jun2dPoint3, jun2dPoint2, stBlockClosure);
            if (n < 0) continue;
            jun2dPoint = this.pointAt_(n);
            arrayList.add(new Jun2dTriangle(jun2dPoint3, jun2dPoint2, jun2dPoint));
        }
        jun2dPointArray = this.points();
        for (n2 = 1; n2 < jun2dPointArray.length; ++n2) {
            jun2dPoint3 = jun2dPointArray[n2 - 1];
            jun2dPoint2 = jun2dPointArray[n2];
            n = this.findIndexOfPoints_from_to_interim_(jun2dPolyline.points(), jun2dPoint3, jun2dPoint2, stBlockClosure);
            if (n < 0) continue;
            jun2dPoint = jun2dPolyline.pointAt_(n);
            arrayList.add(new Jun2dTriangle(jun2dPoint2, jun2dPoint3, jun2dPoint));
        }
        return arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
    }

    protected int findIndexOfPoints_from_to_interim_(Jun2dPoint[] jun2dPointArray, Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, StBlockClosure stBlockClosure) {
        JunGeometry junGeometry;
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return -1;
        }
        double d = jun2dPoint.distance_(jun2dPoint2);
        TreeMap<JunAngle, double[]> treeMap = new TreeMap<JunAngle, double[]>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d = ((JunAngle)object).rad() - ((JunAngle)object2).rad();
                return d < 0.0 ? 1 : (d > 0.0 ? -1 : 0);
            }
        });
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            junGeometry = jun2dPointArray[i];
            double d2 = ((Jun2dPoint)junGeometry).distance_(jun2dPoint);
            double d3 = ((Jun2dPoint)junGeometry).distance_(jun2dPoint2);
            JunAngle junAngle = jun2dPoint.to_((JunPoint)junGeometry).angleWithLine_(jun2dPoint2.to_((JunPoint)junGeometry));
            double[] dArray = new double[]{d2, d3, i};
            treeMap.put(junAngle, dArray);
            if (stBlockClosure == null) continue;
            stBlockClosure.valueWithArguments_(new Object[]{new Jun2dPoint[]{jun2dPoint, jun2dPoint2, junGeometry}, Jun2dPolyline.$((String)"pending")});
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            junGeometry = (JunAngle)iterator.next();
            double[] dArray = (double[])treeMap.get((Object)junGeometry);
            double d4 = dArray[0];
            double d5 = dArray[1];
            int n = (int)dArray[2];
            if (!(((JunAngle)junGeometry).rad() > Jun2dPolyline.Accuracy()) || !(Math.abs(d + d4 - d5) > Jun2dPolyline.Accuracy()) || !(Math.abs(d + d5 - d4) > Jun2dPolyline.Accuracy())) continue;
            if (stBlockClosure != null) {
                stBlockClosure.valueWithArguments_(new Object[]{new Jun2dPoint[]{jun2dPoint, jun2dPoint2, jun2dPointArray[n]}, Jun2dPolyline.$((String)"decided")});
            }
            return n;
        }
        return -1;
    }

    protected void setPoints_(Jun2dPoint[] jun2dPointArray) {
        this.points = jun2dPointArray;
        this.boundingBox = null;
        this.segmentLengths = null;
    }

    protected Jun2dPoint[] computeSplinePoints_(Jun2dPoint[] jun2dPointArray) {
        int n;
        Jun2dPoint[] jun2dPointArray2;
        int n2;
        int n3 = jun2dPointArray.length;
        if (n3 < 3) {
            Jun2dPoint[] jun2dPointArray3 = new Jun2dPoint[n3];
            System.arraycopy(jun2dPointArray, 0, jun2dPointArray3, 0, n3);
            return jun2dPointArray3;
        }
        int n4 = 0;
        Jun2dPoint[] jun2dPointArray4 = jun2dPointArray;
        if (this.size() > 3 && this.from().equals((Object)this.to())) {
            n4 = 2;
            jun2dPointArray4 = new Jun2dPoint[2 * n4 + n3];
            for (int i = 0; i < n4; ++i) {
                jun2dPointArray4[i] = this.points()[n3 - n4 + i - 1];
                jun2dPointArray4[n3 + n4 + i] = this.points()[i + 1];
            }
            System.arraycopy(jun2dPointArray, 0, jun2dPointArray4, n4, n3);
        }
        Jun2dPoint[][] jun2dPointArrayArray = new Jun2dPoint[3][];
        for (n2 = 0; n2 < jun2dPointArrayArray.length; ++n2) {
            jun2dPointArrayArray[n2] = new Jun2dPoint[jun2dPointArray4.length];
        }
        n2 = jun2dPointArray4.length;
        if (n2 > 2) {
            int n5;
            double[] dArray = new double[n2];
            dArray[0] = 4.0;
            jun2dPointArray2 = new Jun2dPoint[n2];
            jun2dPointArray2[0] = jun2dPointArray4[0].minus_(jun2dPointArray4[1].multipliedBy_(2.0)).plus_(jun2dPointArray4[2]).multipliedBy_(6.0);
            for (n5 = 1; n5 <= n2 - 3; ++n5) {
                dArray[n5] = 4.0 - 1.0 / dArray[n5 - 1];
                jun2dPointArray2[n5] = jun2dPointArray4[n5].minus_(jun2dPointArray4[n5 + 1].multipliedBy_(2.0)).plus_(jun2dPointArray4[n5 + 2]).multipliedBy_(6.0).minus_(jun2dPointArray2[n5 - 1].dividedBy_(dArray[n5 - 1]));
            }
            jun2dPointArrayArray[1][n2 - 2] = jun2dPointArray2[n2 - 3].dividedBy_(dArray[n2 - 3]);
            for (n5 = n2 - 3; n5 >= 1; --n5) {
                jun2dPointArrayArray[1][n5] = jun2dPointArray2[n5 - 1].minus_(jun2dPointArrayArray[1][n5 + 1]).dividedBy_(dArray[n5 - 1]);
            }
        }
        jun2dPointArrayArray[1][0] = Jun2dPoint.Zero();
        jun2dPointArrayArray[1][n2 - 1] = Jun2dPoint.Zero();
        for (n = 0; n <= n2 - 2; ++n) {
            jun2dPointArrayArray[0][n] = jun2dPointArray4[n + 1].minus_(jun2dPointArray4[n]).minus_(jun2dPointArrayArray[1][n].multipliedBy_(2.0).plus_(jun2dPointArrayArray[1][n + 1]).dividedBy_(6.0));
            jun2dPointArrayArray[2][n] = jun2dPointArrayArray[1][n + 1].minus_(jun2dPointArrayArray[1][n]);
        }
        if (n4 > 0) {
            for (n = 0; n < 3; ++n) {
                jun2dPointArray2 = new Jun2dPoint[n3];
                System.arraycopy(jun2dPointArrayArray[n], n4, jun2dPointArray2, 0, n3);
                jun2dPointArrayArray[n] = jun2dPointArray2;
            }
        }
        LinkedList<Jun2dPoint> linkedList = new LinkedList<Jun2dPoint>();
        linkedList.add(this.from());
        for (int i = 0; i < this.size() - 1; ++i) {
            Jun2dPoint jun2dPoint = jun2dPointArray[i];
            Jun2dPoint jun2dPoint2 = jun2dPointArrayArray[0][i];
            Jun2dPoint jun2dPoint3 = jun2dPointArrayArray[1][i].dividedBy_(2.0);
            Jun2dPoint jun2dPoint4 = jun2dPointArrayArray[2][i].dividedBy_(6.0);
            Jun2dPoint jun2dPoint5 = jun2dPointArrayArray[1][i].abs().plus_(jun2dPointArrayArray[1][i + 1].abs());
            int n6 = (int)Math.max(4.0, Math.floor((jun2dPoint5.x() + jun2dPoint5.y()) / 100.0));
            for (int j = 1; j <= n6; ++j) {
                double d = (double)j / (double)n6;
                jun2dPoint5 = jun2dPoint4.multipliedBy_(d).plus_(jun2dPoint3).multipliedBy_(d).plus_(jun2dPoint2).multipliedBy_(d).plus_(jun2dPoint);
                if (jun2dPoint5.equal_(linkedList.getLast())) continue;
                linkedList.add(jun2dPoint5);
            }
            jun2dPoint5 = jun2dPointArray[i + 1];
            if (jun2dPoint5.equal_(linkedList.getLast())) continue;
            linkedList.add(jun2dPoint5);
        }
        return linkedList.toArray(new Jun2dPoint[linkedList.size()]);
    }
}

