/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.curves;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.curves.JunLine;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.smalltalk.SmalltalkException;

public class Jun3dLine
extends JunLine {
    protected double x0;
    protected double y0;
    protected double z0;
    protected double f;
    protected double g;
    protected double h;

    public Jun3dLine(JunPoint junPoint, JunPoint junPoint2) {
        this.from_to_(junPoint, junPoint2);
    }

    public static Jun3dLine Unity() {
        Jun3dLine jun3dLine = new Jun3dLine(Jun3dPoint.Zero(), Jun3dPoint.Unity());
        return jun3dLine.normalizedLine();
    }

    public static final Jun2dLine Zero() {
        throw SmalltalkException.ShouldNotImplement();
    }

    protected JunPoint _from() {
        return this.from();
    }

    protected JunPoint _to() {
        return this.to();
    }

    public Jun3dPoint atT_(double d) {
        return new Jun3dPoint(this.x0 + this.f * d, this.y0 + this.g * d, this.z0 + this.h * d);
    }

    public Jun3dPoint atX_(double d) {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(d, 0.0, 0.0), new Jun3dPoint(d, 1.0, 0.0), new Jun3dPoint(d, 0.0, 1.0));
        return junPlane.intersectingPointWithLine_(this);
    }

    public Jun3dPoint atY_(double d) {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(0.0, d, 0.0), new Jun3dPoint(0.0, d, 1.0), new Jun3dPoint(1.0, d, 0.0));
        return junPlane.intersectingPointWithLine_(this);
    }

    public Jun3dPoint atZ_(double d) {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(0.0, 0.0, d), new Jun3dPoint(1.0, 0.0, d), new Jun3dPoint(0.0, 1.0, d));
        return junPlane.intersectingPointWithLine_(this);
    }

    public Jun3dBoundingBall boundingBall() {
        return this.asBoundingBall();
    }

    public Jun3dBoundingBox boundingBox() {
        return this.asBoundingBox();
    }

    public Jun3dPoint center() {
        return this.atT_(0.5);
    }

    public Jun3dPoint first() {
        return this.from();
    }

    public Jun3dPoint from() {
        return this.atT_(0.0);
    }

    public void from_to_(JunPoint junPoint, JunPoint junPoint2) {
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(junPoint);
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(junPoint2);
        this.x0 = jun3dPoint.x();
        this.y0 = jun3dPoint.y();
        this.z0 = jun3dPoint.z();
        this.f = jun3dPoint2.x() - jun3dPoint.x();
        this.g = jun3dPoint2.y() - jun3dPoint.y();
        this.h = jun3dPoint2.z() - jun3dPoint.z();
    }

    public Jun3dPoint last() {
        return this.to();
    }

    public double length() {
        return this.first().distance_(this.last());
    }

    public Jun3dPoint normalUnitVector() {
        return this.normalizedLine().normalVector();
    }

    public Jun3dPoint normalVector() {
        return this.to().minus_(this.from());
    }

    public double tAtPoint_(Jun3dPoint jun3dPoint) {
        double d = this.f * this.f + this.g * this.g + this.h * this.h;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d2 = jun3dPoint.x() - this.x0;
        double d3 = jun3dPoint.y() - this.y0;
        double d4 = jun3dPoint.z() - this.z0;
        return (this.f * d2 + this.g * d3 + this.h * d4) / d;
    }

    public double tAtX_(double d) {
        if (Math.abs(this.f()) < this.Accuracy()) {
            return Double.NaN;
        }
        return (d - this.x0()) / this.f();
    }

    public double tAtY_(double d) {
        if (Math.abs(this.g()) < this.Accuracy()) {
            return Double.NaN;
        }
        return (d - this.y0()) / this.g();
    }

    public double tAtZ_(double d) {
        if (Math.abs(this.h()) < this.Accuracy()) {
            return Double.NaN;
        }
        return (d - this.z0()) / this.h();
    }

    public Jun3dPoint to() {
        return this.atT_(1.0);
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dLine jun3dLine = (Jun3dLine)((Object)object);
        return this.isEqualNumber_to_(this.x0, jun3dLine.x0) && this.isEqualNumber_to_(this.y0, jun3dLine.y0) && this.isEqualNumber_to_(this.z0, jun3dLine.z0) && this.isEqualNumber_to_(this.f, jun3dLine.f) && this.isEqualNumber_to_(this.g, jun3dLine.g) && this.isEqualNumber_to_(this.h, jun3dLine.h);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dLine jun3dLine = (Jun3dLine)((Object)object);
        return this.x0 == jun3dLine.x0 && this.y0 == jun3dLine.y0 && this.z0 == jun3dLine.z0 && this.f == jun3dLine.f && this.g == jun3dLine.g && this.h == jun3dLine.h;
    }

    public Jun3dPoint[][] asArrays() {
        return new Jun3dPoint[][]{{this.from(), this.to()}};
    }

    public Jun3dLine[] asArrayOfLines() {
        return this.asArrayOf3dLines();
    }

    public Jun3dLine[] asArrayOf3dLines() {
        return new Jun3dLine[]{this};
    }

    public Jun3dBoundingBall asBoundingBall() {
        Jun3dPoint jun3dPoint = this.center();
        double d = jun3dPoint.distance_(this.to());
        return new Jun3dBoundingBall(jun3dPoint, d);
    }

    public Jun3dBoundingBox asBoundingBox() {
        return Jun3dBoundingBox.Vertex_vertex_(this.from(), this.to());
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{this.from(), this.to()};
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
        junOpenGL3dPolyline.lineWidth_(1.0f);
        junOpenGL3dPolyline.paint_(this.defaultColor());
        return junOpenGL3dPolyline;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectWithPoints() {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{this.from(), this.to()};
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        JunOpenGL3dObject junOpenGL3dObject = this.from().asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.red);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGL3dObject junOpenGL3dObject2 = this.to().asJunOpenGL3dObject();
        junOpenGL3dObject2.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        return junOpenGL3dCompoundObject;
    }

    public JunNurbsCurve asNurbsCurve() {
        return JunNurbsCurve.BezierControlPoints_(new Jun3dPoint[]{this.from(), this.center(), this.to()});
    }

    public Point[][] asPointArrays() {
        Jun3dPoint[][] jun3dPointArray = this.asArrays();
        Point[][] pointArray = new Point[jun3dPointArray.length][];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            pointArray[i] = new Point[jun3dPointArray[i].length];
            for (int j = 0; j < jun3dPointArray[i].length; ++j) {
                pointArray[i][j] = jun3dPointArray[i][j].asPoint();
            }
        }
        return pointArray;
    }

    public Jun3dPolyline asPolyline() {
        return new Jun3dPolyline(new Jun3dPoint[]{this.from(), this.to()});
    }

    public Jun3dPoint asUnitVector() {
        return new Jun3dPoint(this.f(), this.g(), this.h()).unitVector();
    }

    public JunAngle angleWithLine_(JunLine junLine) {
        Jun3dLine jun3dLine = junLine instanceof Jun3dLine ? (Jun3dLine)junLine : new Jun3dLine(junLine._from(), junLine._to());
        double d = (this.f() * this.f() + this.g() * this.g() + this.h() * this.h()) * (jun3dLine.f() * jun3dLine.f() + jun3dLine.g() * jun3dLine.g() + jun3dLine.h() * jun3dLine.h());
        if ((d = Math.sqrt(d)) < 1.0E-12) {
            throw SmalltalkException.Error((String)"unexpected line parameters");
        }
        double d2 = this.f() * jun3dLine.f() + this.g() * jun3dLine.g() + this.h() * jun3dLine.h();
        double d3 = Math.min(Math.max(d2 / d, -1.0), 1.0);
        return JunAngle.FromRad_(Math.acos(d3));
    }

    public double distanceFromPoint_(Jun3dPoint jun3dPoint) {
        double d = this.f * this.f + this.g * this.g + this.h * this.h;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d2 = jun3dPoint.x() - this.x0;
        double d3 = jun3dPoint.y() - this.y0;
        double d4 = jun3dPoint.z() - this.z0;
        double d5 = (this.f * d2 + this.g * d3 + this.h * d4) / d;
        Jun3dPoint jun3dPoint2 = this.atT_(d5);
        return jun3dPoint.distance_(jun3dPoint2);
    }

    public Jun3dPoint intersectingPointWithLine_(Jun3dLine jun3dLine) {
        double d;
        double d2;
        double d3;
        block9: {
            block8: {
                double d4;
                double d5;
                double d6 = jun3dLine.f;
                double d7 = jun3dLine.g;
                double d8 = jun3dLine.h;
                double d9 = jun3dLine.x0;
                double d10 = jun3dLine.y0;
                double d11 = jun3dLine.z0;
                double d12 = d6 * this.g - this.f * d7;
                double d13 = d7 * this.h - this.g * d8;
                double d14 = d8 * this.f - this.h * d6;
                double d15 = Math.abs(d12);
                double d16 = Math.abs(d13);
                double d17 = Math.abs(d14);
                if (Math.max(Math.max(d15, d16), d17) < 1.0E-12) {
                    return null;
                }
                if (d15 >= d16 && d15 >= d17) {
                    d5 = (d6 * (d10 - this.y0) - d7 * (d9 - this.x0)) / d12;
                    d4 = Math.abs(d6) > Math.abs(d7) ? (this.f * d5 + this.x0 - d9) / d6 : (this.g * d5 + this.y0 - d10) / d7;
                } else if (d16 >= d17) {
                    d5 = (d7 * (d11 - this.z0) - d8 * (d10 - this.y0)) / d13;
                    d4 = Math.abs(d7) > Math.abs(d8) ? (this.g * d5 + this.y0 - d10) / d7 : (this.h * d5 + this.z0 - d11) / d8;
                } else {
                    d5 = (d8 * (d9 - this.x0) - d6 * (d11 - this.z0)) / d14;
                    d4 = Math.abs(d8) > Math.abs(d6) ? (this.h * d5 + this.z0 - d11) / d8 : (this.f * d5 + this.x0 - d9) / d6;
                }
                d3 = this.f * d5 + this.x0;
                d2 = this.g * d5 + this.y0;
                d = this.h * d5 + this.z0;
                double d18 = d6 * d4 + d9;
                double d19 = d7 * d4 + d10;
                double d20 = d8 * d4 + d11;
                if (Math.abs(d3 - d18) > this.Accuracy()) break block8;
                if (Math.abs(d2 - d19) > this.Accuracy()) break block8;
                if (!(Math.abs(d - d20) > this.Accuracy())) break block9;
            }
            return null;
        }
        return new Jun3dPoint(d3, d2, d);
    }

    public double lineSegmentDistanceFromPoint_(Jun3dPoint jun3dPoint) {
        double d;
        double d2;
        Jun3dPoint jun3dPoint2 = jun3dPoint;
        double d3 = this.f * this.f + this.g * this.g + this.h * this.h;
        if (d3 < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d4 = jun3dPoint2.x() - this.x0;
        double d5 = (this.f * d4 + this.g * (d2 = jun3dPoint2.y() - this.y0) + this.h * (d = jun3dPoint2.z() - this.z0)) / d3;
        Jun3dPoint jun3dPoint3 = d5 < 0.0 ? this.atT_(0.0) : (d5 > 1.0 ? this.atT_(1.0) : this.atT_(d5));
        return jun3dPoint2.distance_(jun3dPoint3);
    }

    public Jun3dPoint lineSegmentNearestPointFromPoint_(Jun3dPoint jun3dPoint) {
        double d;
        double d2;
        double d3 = this.f * this.f + this.g * this.g + this.h * this.h;
        if (d3 < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d4 = jun3dPoint.x() - this.x0;
        double d5 = (this.f * d4 + this.g * (d2 = jun3dPoint.y() - this.y0) + this.h * (d = jun3dPoint.z() - this.z0)) / d3;
        if (d5 < 0.0) {
            d5 = 0.0;
        } else if (d5 > 1.0) {
            d5 = 1.0;
        }
        return this.atT_(d5);
    }

    public Jun3dPoint nearestPointFromLine_(Jun3dLine jun3dLine) {
        Jun3dPoint jun3dPoint = new Jun3dPoint(this.f(), this.g(), this.h()).vectorProduct_(new Jun3dPoint(jun3dLine.f(), jun3dLine.g(), jun3dLine.h()));
        if (jun3dPoint.length() < this.Accuracy()) {
            return null;
        }
        JunPlane junPlane = JunPlane.On_normalVector_(this.from(), jun3dPoint);
        Jun3dLine jun3dLine2 = junPlane.projectionOfLine_(jun3dLine);
        double d = jun3dLine2.f();
        double d2 = jun3dLine2.g();
        double d3 = jun3dLine2.x0();
        double d4 = jun3dLine2.y0();
        double d5 = ((this.x0 - d3) * d2 + (d4 - this.y0) * d) / (d * this.g - this.f * d2);
        return this.atT_(d5);
    }

    public Jun3dPoint nearestPointFromPoint_(Jun3dPoint jun3dPoint) {
        double d = this.f * this.f + this.g * this.g + this.h * this.h;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d2 = jun3dPoint.x() - this.x0;
        double d3 = jun3dPoint.y() - this.y0;
        double d4 = jun3dPoint.z() - this.z0;
        return this.atT_((this.f * d2 + this.g * d3 + this.h * d4) / d);
    }

    public Jun3dLine normalized() {
        return this.normalizedLine();
    }

    public Jun3dLine normalizedLine() {
        Jun3dLine jun3dLine = (Jun3dLine)this.copy();
        double d = this.n();
        jun3dLine.f = this.f * d;
        jun3dLine.g = this.g * d;
        jun3dLine.h = this.h * d;
        return jun3dLine;
    }

    public Jun3dPoint projectionOfPoint_(Jun3dPoint jun3dPoint) {
        return this.atT_(this.tAtPoint_(jun3dPoint));
    }

    public Jun3dLine reflectingLineWithPlane_(JunPlane junPlane) {
        return junPlane.reflectingLineWithLine_(this);
    }

    public Jun3dLine reversed() {
        return new Jun3dLine(this.to(), this.from());
    }

    public double f() {
        return this.f;
    }

    public double g() {
        return this.g;
    }

    public double h() {
        return this.h;
    }

    public double n() {
        double d = this.f * this.f + this.g * this.g + this.h * this.h;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        return 1.0 / Math.sqrt(d);
    }

    public double x0() {
        return this.x0;
    }

    public double y0() {
        return this.y0;
    }

    public double z0() {
        return this.z0;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("3dLine (");
        this.from().printOn_(writer);
        writer.write(" , ");
        this.to().printOn_(writer);
        writer.write(")");
    }

    public Jun3dPolyline subdivide() {
        return new Jun3dPolyline(new Jun3dPoint[]{this.from(), this.center(), this.to()});
    }

    public Jun3dPolyline subdivideLevel_(int n) {
        Jun3dPolyline jun3dPolyline = this.asPolyline();
        for (int i = 0; i < n; ++i) {
            jun3dPolyline = jun3dPolyline.subdivide();
        }
        return jun3dPolyline;
    }

    public boolean containsPoint_(Jun3dPoint jun3dPoint) {
        return this.distanceFromPoint_(jun3dPoint) < 1.0E-12;
    }

    public boolean is3d() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isParallelWithLine_(Jun3dLine jun3dLine) {
        double d = this.angleWithLine_(jun3dLine).deg();
        if (Math.abs(0.0 - d) < this.Accuracy()) return true;
        if (!(Math.abs(180.0 - d) < this.Accuracy())) return false;
        return true;
    }

    public boolean lineSegmentContainsPoint_(Jun3dPoint jun3dPoint) {
        return this.lineSegmentDistanceFromPoint_(jun3dPoint) < 1.0E-12;
    }

    public Jun3dLine rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun3dTransformation.Rotate_(junAngle));
    }

    public Jun3dLine scaledBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public Jun3dLine transform_(Jun3dTransformation jun3dTransformation) {
        return new Jun3dLine(this.from().transform_(jun3dTransformation), this.to().transform_(jun3dTransformation));
    }

    public JunGeometry transform_(JunTransformation junTransformation) {
        return this.transform_((Jun3dTransformation)junTransformation);
    }

    public Jun3dTransformation transformationToRotate_(JunAngle junAngle) {
        return Jun3dTransformation.Rotate_around_(junAngle, this);
    }

    public Jun3dLine translatedBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Translate_(jun3dPoint));
    }
}

