/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.curves;

import java.util.ArrayList;
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.support.JunBSplineFunction;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurve;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.StObject;

public class JunNurbsCurve
extends JunCurve {
    protected Jun3dPoint[] controlPoints = null;
    protected double[] weights;
    protected double[] knotVector;

    public static JunNurbsCurve BezierControlPoints_(Jun3dPoint[] jun3dPointArray) {
        int n = jun3dPointArray.length;
        double[] dArray = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
            dArray[i + n] = 1.0;
        }
        return JunNurbsCurve.BSplineControlPoints_knotVector_(jun3dPointArray, dArray);
    }

    public static JunNurbsCurve BezierControlPoints_weights_(Jun3dPoint[] jun3dPointArray, double[] dArray) {
        int n = jun3dPointArray.length;
        double[] dArray2 = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 0.0;
            dArray2[i + n] = 1.0;
        }
        return JunNurbsCurve.ControlPoints_weights_knotVector_(jun3dPointArray, dArray, dArray2);
    }

    public static JunNurbsCurve BSplineControlPoints_knotVector_(Jun3dPoint[] jun3dPointArray, double[] dArray) {
        int n = jun3dPointArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 1.0;
        }
        return JunNurbsCurve.ControlPoints_weights_knotVector_(jun3dPointArray, dArray2, dArray);
    }

    public static JunNurbsCurve ControlPoints_weights_knotVector_(Jun3dPoint[] jun3dPointArray, double[] dArray, double[] dArray2) {
        return new JunNurbsCurve(jun3dPointArray, dArray, dArray2);
    }

    public JunNurbsCurve(Jun3dPoint[] jun3dPointArray, double[] dArray, double[] dArray2) {
        this.controlPoints_weights_knotVector_(jun3dPointArray, dArray, dArray2);
    }

    public Jun3dPoint[] controlPoints() {
        return this.controlPoints;
    }

    public void controlPoints_(Jun3dPoint[] jun3dPointArray) {
        this.controlPoints = jun3dPointArray;
    }

    public Jun3dPoint controlPointAt_(int n) {
        return this.controlPoints[n];
    }

    public void controlPointAt_put_(int n, Jun3dPoint jun3dPoint) {
        this.controlPoints[n] = jun3dPoint;
    }

    public int controlPointSize() {
        return this.controlPoints.length;
    }

    public double[] weights() {
        return this.weights;
    }

    public void weights_(double[] dArray) {
        this.weights = dArray;
    }

    public double weightAt_(int n) {
        return this.weights[n];
    }

    public double[] knotVector() {
        return this.knotVector;
    }

    public double knotVectorAt_(int n) {
        return this.knotVector[n];
    }

    public int order() {
        return this.knotVector.length - this.controlPoints.length;
    }

    public Jun3dPoint atT_(double d) {
        if (d < 0.0) {
            return null;
        }
        JunBSplineFunction junBSplineFunction = this.bspline();
        Jun3dPoint jun3dPoint = Jun3dPoint.Zero();
        double d2 = 0.0;
        for (int i = 0; i < this.controlPoints.length; ++i) {
            double d3 = junBSplineFunction.i_t_(i, d) * this.weights[i];
            jun3dPoint = jun3dPoint.plus_(this.controlPoints[i].multipliedBy_(d3));
            d2 += d3;
        }
        return d2 == 0.0 ? this.controlPointAt_(this.controlPointSize() - 1) : jun3dPoint.dividedBy_(d2);
    }

    public JunBSplineFunction bspline() {
        return new JunBSplineFunction(this._copyKnotVector(), this.order());
    }

    public boolean equal_(Object object) {
        int n;
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunNurbsCurve junNurbsCurve = (JunNurbsCurve)((Object)object);
        int n2 = this.controlPointSize();
        if (n2 != junNurbsCurve.controlPointSize()) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.controlPointAt_(n).equal_((Object)junNurbsCurve.controlPointAt_(n))) continue;
            return false;
        }
        n2 = this.weights().length;
        if (n2 != junNurbsCurve.weights().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.isEqualNumber_to_(this.weightAt_(n), junNurbsCurve.weightAt_(n))) continue;
            return false;
        }
        n2 = this.knotVector().length;
        if (n2 != junNurbsCurve.knotVector().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.isEqualNumber_to_(this.knotVectorAt_(n), junNurbsCurve.knotVectorAt_(n))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunNurbsCurve junNurbsCurve = (JunNurbsCurve)((Object)object);
        int n2 = this.controlPointSize();
        if (n2 != junNurbsCurve.controlPointSize()) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.controlPointAt_(n).equals((Object)junNurbsCurve.controlPointAt_(n))) continue;
            return false;
        }
        n2 = this.weights().length;
        if (n2 != junNurbsCurve.weights().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.weightAt_(n) == junNurbsCurve.weightAt_(n)) continue;
            return false;
        }
        n2 = this.knotVector().length;
        if (n2 != junNurbsCurve.knotVector().length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.knotVectorAt_(n) == junNurbsCurve.knotVectorAt_(n)) continue;
            return false;
        }
        return true;
    }

    public Jun3dLine[] asArrayOfLines() {
        return super.asArrayOf3dLines();
    }

    public Jun3dLine[] asArrayOf3dLines() {
        ArrayList<Jun3dLine> arrayList = new ArrayList<Jun3dLine>();
        Jun3dPoint[] jun3dPointArray = this.asPointArray();
        if (jun3dPointArray.length > 1) {
            Jun3dPoint jun3dPoint = jun3dPointArray[0];
            for (int i = 1; i < jun3dPointArray.length; ++i) {
                Jun3dPoint jun3dPoint2 = jun3dPointArray[i];
                arrayList.add(jun3dPoint.to_(jun3dPoint2));
                jun3dPoint = jun3dPoint2;
            }
        }
        return arrayList.toArray(new Jun3dLine[arrayList.size()]);
    }

    public JunOpenGL3dNurbsCurve asJunOpenGL3dNurbsCurve() {
        return new JunOpenGL3dNurbsCurve(this._copyControlPoints(), this._copyWeights(), this._copyKnotVector());
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        return this.asJunOpenGL3dNurbsCurve();
    }

    public JunNurbsCurve asNurbsCurve() {
        return this;
    }

    public Jun3dPoint[] asPointArray() {
        return this.asPointArray_(this.controlPointSize() * 4);
    }

    public Jun3dPoint[] asPointArray_(int n) {
        if (n < 0) {
            return null;
        }
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
        for (int i = 0; i <= n; ++i) {
            jun3dPointArray[i] = this.atT_((double)i / (double)n);
        }
        return jun3dPointArray;
    }

    public JunNurbsCurve reversed() {
        int n = this.controlPoints.length;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
        for (int i = 0; i < n; ++i) {
            jun3dPointArray[i] = this.controlPoints[n - i - 1];
        }
        n = this.weights.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.weights[n - i - 1];
        }
        n = this.knotVector.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.knotVector[n - 1] - this.knotVector[n - i];
        }
        return new JunNurbsCurve(jun3dPointArray, dArray, dArray2);
    }

    public StObject postCopy() {
        super.postCopy();
        this.controlPoints = this._copyControlPoints();
        this.weights = this._copyWeights();
        this.knotVector = this._copyKnotVector();
        return this;
    }

    public JunGeometry transform_(JunTransformation junTransformation) {
        JunNurbsCurve junNurbsCurve = (JunNurbsCurve)this.copy();
        for (int i = 0; i < junNurbsCurve.controlPointSize(); ++i) {
            Jun3dPoint jun3dPoint = junNurbsCurve.controlPointAt_(i);
            Jun3dPoint jun3dPoint2 = (Jun3dPoint)jun3dPoint.transform_(junTransformation);
            junNurbsCurve.controlPointAt_put_(i, jun3dPoint2);
        }
        return junNurbsCurve;
    }

    protected void controlPoints_weights_knotVector_(Jun3dPoint[] jun3dPointArray, double[] dArray, double[] dArray2) {
        this.controlPoints = jun3dPointArray;
        this.weights = dArray;
        this.knotVector = dArray2;
    }

    protected Jun3dPoint[] _copyControlPoints() {
        if (this.controlPoints == null) {
            return null;
        }
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[this.controlPoints.length];
        System.arraycopy(this.controlPoints, 0, jun3dPointArray, 0, this.controlPoints.length);
        return jun3dPointArray;
    }

    protected double[] _copyWeights() {
        if (this.weights == null) {
            return null;
        }
        double[] dArray = new double[this.weights.length];
        System.arraycopy(this.weights, 0, dArray, 0, this.weights.length);
        return dArray;
    }

    protected double[] _copyKnotVector() {
        if (this.knotVector == null) {
            return null;
        }
        double[] dArray = new double[this.knotVector.length];
        System.arraycopy(this.knotVector, 0, dArray, 0, this.knotVector.length);
        return dArray;
    }
}

