/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.forms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.forms.JunAbstractFormTriangulation;
import jp.co.sra.jun.geometry.forms.JunForm2dRegion;
import jp.co.sra.jun.geometry.forms.JunFormOperation;
import jp.co.sra.jun.geometry.forms.JunFormTriangulation3;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;

public class JunFormTriangulation
extends JunFormOperation
implements StDisplayable {
    protected JunAbstractFormTriangulation formTriangulation;
    protected Jun2dTriangle[] formTriangles;
    protected double formArea;

    public static Class DefaultTriangulationClass() {
        return JunFormTriangulation3.class;
    }

    protected JunFormTriangulation() {
    }

    public JunFormTriangulation(Jun2dPoint[] jun2dPointArray) {
        this(jun2dPointArray, JunFormTriangulation.DefaultTriangulationClass());
    }

    public JunFormTriangulation(Jun2dPoint[] jun2dPointArray, Class clazz) {
        this();
        JunAbstractFormTriangulation junAbstractFormTriangulation = null;
        try {
            junAbstractFormTriangulation = (JunAbstractFormTriangulation)((Object)clazz.newInstance());
        }
        catch (Exception exception) {
            System.err.println(exception.getStackTrace());
        }
        this.triangulation_(junAbstractFormTriangulation);
        this.points_(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.formTriangulation = null;
        this.formTriangles = null;
        this.formArea = Double.NaN;
    }

    public double area() {
        double d = 0.0;
        Jun2dTriangle[] jun2dTriangleArray = this.triangles();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            d += this.areaOfTriangle_(jun2dTriangleArray[i].points());
        }
        return d;
    }

    public double areaWithSign() {
        double d = 0.0;
        Jun2dTriangle[] jun2dTriangleArray = this.triangles();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            d += this.areaWithSignOfTriangle_(jun2dTriangleArray[i].points());
        }
        return d;
    }

    public Jun2dBoundingBox boundingBox() {
        return this.triangulation().boundingBox();
    }

    public Rectangle bounds() {
        return this.triangulation().bounds();
    }

    public Jun2dPoint[] points() {
        return this.triangulation().points();
    }

    public void points_(Jun2dPoint[] jun2dPointArray) {
        this.triangulation().points_(jun2dPointArray);
        this.formTriangles = null;
        this.formArea = Double.NaN;
    }

    public Jun2dLine[] segments() {
        return this.triangulation().segments();
    }

    public Jun2dTriangle[] triangles() {
        if (this.formTriangles == null) {
            Jun2dTriangle[] jun2dTriangleArray = this.triangulation().triangles();
            ArrayList<Object> arrayList = new ArrayList<Object>(jun2dTriangleArray.length);
            double d = this.defaultAccuracy();
            for (int i = 0; i < jun2dTriangleArray.length; ++i) {
                Jun2dPoint[] jun2dPointArray = jun2dTriangleArray[i].points();
                ArrayList<Jun2dPoint> arrayList2 = new ArrayList<Jun2dPoint>();
                for (int j = 0; j < jun2dPointArray.length; ++j) {
                    int n = -1;
                    Jun2dPoint[] jun2dPointArray2 = this.points();
                    int n2 = 0;
                    while (j < jun2dPointArray2.length) {
                        if (jun2dPointArray2[n2].distance_(jun2dPointArray[j]) < d) {
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                    if (n < 0) {
                        throw new IllegalStateException("unexpected error");
                    }
                    arrayList2.add(this.points()[n]);
                }
                arrayList.add(arrayList2.toArray(new Jun2dPoint[arrayList2.size()]));
            }
            Jun2dPoint[][] jun2dPointArray = (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][]);
            arrayList = new ArrayList(jun2dPointArray.length);
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                arrayList.add((Object)this.rightHandTriangle_(jun2dPointArray[i]));
            }
            this.formTriangles = arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
        }
        return this.formTriangles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage asImage() {
        StImage stImage = new StImage(this.bounds().getSize());
        Graphics graphics = stImage.image().getGraphics();
        try {
            this.displayOn_(graphics);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        return stImage;
    }

    public GeneralPath toGeneralPath() {
        Jun2dPoint[] jun2dPointArray = this.points();
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0, jun2dPointArray.length);
        generalPath.moveTo((float)jun2dPointArray[0].x(), (float)jun2dPointArray[0].y());
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            generalPath.lineTo((float)jun2dPointArray[i].x(), (float)jun2dPointArray[i].y());
        }
        return generalPath;
    }

    public double defaultAccuracy() {
        return this.triangulation().defaultAccuracy();
    }

    public int defaultSoFarZ() {
        return 29999;
    }

    public Class defaultTriangulationClass() {
        return JunFormTriangulation.DefaultTriangulationClass();
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.displayOn_at_triangles_color_(graphics, point, this.triangles(), Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_triangles_color_(Graphics graphics, Point point, Jun2dTriangle[] jun2dTriangleArray, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Point point2 = this.boundingBox().origin()._toPoint();
            Point point3 = this.boundingBox().extent()._toPoint();
            Rectangle rectangle = new Rectangle(point2.x, point2.y, point3.x, point3.y);
            Point point4 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.setColor(Color.white);
            graphics2D.translate(point4.x, point4.y);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            for (int i = 0; i < jun2dTriangleArray.length; ++i) {
                Object object;
                JunForm2dRegion junForm2dRegion;
                if (jun2dTriangleArray[i].first().equals((Object)jun2dTriangleArray[i].last())) {
                    junForm2dRegion = new JunForm2dRegion(jun2dTriangleArray[i].asPointArray());
                } else {
                    object = jun2dTriangleArray[i].asPointArray();
                    Jun2dPoint[] jun2dPointArray = new Jun2dPoint[((Jun2dPoint[])object).length + 1];
                    for (int j = 0; j < ((Jun2dPoint[])object).length; ++j) {
                        jun2dPointArray[j] = object[j];
                    }
                    jun2dPointArray[jun2dPointArray.length - 1] = object[0];
                    junForm2dRegion = new JunForm2dRegion(jun2dPointArray);
                }
                object = junForm2dRegion.toGeneralPath();
                graphics2D.setColor(StColorValue.Blend((Color)color, (Color)Color.white));
                graphics2D.fill((Shape)object);
                graphics2D.setColor(color);
                graphics2D.draw((Shape)object);
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.toGeneralPath());
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    public void displayOn_at_triangles_(Graphics graphics, Point point, Jun2dTriangle[] jun2dTriangleArray) {
        this.displayOn_at_triangles_color_(graphics, point, jun2dTriangleArray, Color.red);
    }

    public boolean containsLineSegment_(Jun2dLine jun2dLine) {
        return this.triangulation().containsLineSegment_(jun2dLine);
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        return this.triangulation().containsPoint_(jun2dPoint);
    }

    protected double areaOfTriangle_(Jun2dPoint[] jun2dPointArray) {
        return Math.abs(this.areaWithSignOfTriangle_(jun2dPointArray));
    }

    protected double areaWithSignOfTriangle_(Jun2dPoint[] jun2dPointArray) {
        Jun2dPoint jun2dPoint = jun2dPointArray[0];
        Jun2dPoint jun2dPoint2 = jun2dPointArray[1];
        Jun2dPoint jun2dPoint3 = jun2dPointArray[2];
        double d = jun2dPoint.x();
        double d2 = jun2dPoint.y();
        double d3 = jun2dPoint2.x();
        double d4 = jun2dPoint2.y();
        double d5 = jun2dPoint3.x();
        double d6 = jun2dPoint3.y();
        double d7 = ((d - d3) * (d2 + d4) + (d3 - d5) * (d4 + d6) + (d5 - d) * (d6 + d2)) * 0.5;
        return d7;
    }

    protected Jun2dTriangle rightHandTriangle_(Jun2dPoint[] jun2dPointArray) {
        Jun2dTriangle jun2dTriangle = null;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray[i] = new Jun3dPoint(jun2dPointArray[i].x(), jun2dPointArray[i].y(), 0.0);
        }
        JunPlane junPlane = new JunPlane(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]);
        jun2dTriangle = 0.0 <= junPlane.valueF_(new Jun3dPoint(0.0, 0.0, this.defaultSoFarZ())) ? new Jun2dTriangle(jun2dPointArray[0], jun2dPointArray[1], jun2dPointArray[2]) : new Jun2dTriangle(jun2dPointArray[2], jun2dPointArray[1], jun2dPointArray[0]);
        return jun2dTriangle;
    }

    protected JunAbstractFormTriangulation triangulation() {
        if (this.formTriangulation == null) {
            this.formTriangulation = (JunAbstractFormTriangulation)((Object)JunFormTriangulation._New((Class)this.defaultTriangulationClass()));
        }
        return this.formTriangulation;
    }

    protected void triangulation_(JunAbstractFormTriangulation junAbstractFormTriangulation) {
        this.formTriangulation = junAbstractFormTriangulation;
    }
}

