/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.solid;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.solid.JunSphere;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunCircularCylinder
extends JunSphere {
    protected double height;

    protected JunCircularCylinder() {
    }

    public JunCircularCylinder(JunPoint junPoint, double d, double d2) {
        this.setCenter_(junPoint);
        this.setRadius_(d);
        this.setHeight_(d2);
    }

    public double area() {
        return Math.PI * 2 * this.radius() * (this.height() + this.radius());
    }

    public double height() {
        return this.height;
    }

    public double volume() {
        return Math.PI * Math.pow(this.radius(), 2.0) * this.height();
    }

    public boolean equal_(Object object) {
        if (!super.equal_(object)) {
            return false;
        }
        JunCircularCylinder junCircularCylinder = (JunCircularCylinder)((Object)object);
        return this.isEqualNumber_to_(this.h(), junCircularCylinder.h());
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        JunCircularCylinder junCircularCylinder = (JunCircularCylinder)((Object)object);
        return this.h() == junCircularCylinder.h();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.CylinderBy_radius_height_(10.0, this.radius(), this.height()).translatedBy_(this.center());
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_(JunCircularCylinder.this.defaultColor());
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public double h() {
        return this.height();
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(40);
        this.center().printOn_(writer);
        writer.write(" circularCylinder: ");
        writer.write(Double.toString(this.radius()));
        writer.write(" height: ");
        writer.write(Double.toString(this.height()));
        writer.write(41);
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" center: ");
        this.center().storeOn_(writer);
        writer.write(" radius: ");
        writer.write(Double.toString(this.radius()));
        writer.write(" height: ");
        writer.write(Double.toString(this.height()));
        writer.write(41);
    }

    public boolean isCircularCylinder() {
        return true;
    }

    public boolean isSphere() {
        return false;
    }

    public int whichSideOf_(JunPlane junPlane) {
        boolean bl;
        boolean bl2;
        int[] nArray = new int[]{new Jun3dCircle(this.center(), this.radius()).whichSideOf_(junPlane), new Jun3dCircle(this.center().plus_(new Jun3dPoint(0.0, 0.0, this.height())), this.radius()).whichSideOf_(junPlane)};
        boolean bl3 = Arrays.binarySearch(nArray, 1) != -1;
        boolean bl4 = bl2 = Arrays.binarySearch(nArray, -1) != -1;
        if (bl3 && bl2) {
            return 0;
        }
        boolean bl5 = bl = Arrays.binarySearch(nArray, 0) != -1;
        if (bl) {
            return 0;
        }
        if (bl2 && !bl3) {
            return -1;
        }
        return 1;
    }

    public void setHeight_(double d) {
        this.height = d;
    }
}

