/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.solid;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.abstracts.JunSolid;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunSphere
extends JunSolid {
    protected double x0;
    protected double y0;
    protected double z0;
    protected double radius;

    protected JunSphere() {
    }

    public JunSphere(JunPoint junPoint, double d) {
        this.setCenter_(junPoint);
        this.setRadius_(d);
    }

    public double area() {
        return Math.PI * 4 * Math.pow(this.radius(), 2.0);
    }

    public Jun3dPoint center() {
        return new Jun3dPoint(this.x0(), this.y0(), this.z0());
    }

    public double radius() {
        return this.radius;
    }

    public double volume() {
        return Math.PI * 4 * Math.pow(this.radius(), 3.0) / 3.0;
    }

    public boolean equal_(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JunSphere junSphere = (JunSphere)((Object)object);
        return this.isEqualNumber_to_(this.x0(), junSphere.x0()) && this.isEqualNumber_to_(this.y0(), junSphere.y0()) && this.isEqualNumber_to_(this.z0(), junSphere.z0()) && this.isEqualNumber_to_(this.r(), junSphere.r());
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JunSphere junSphere = (JunSphere)((Object)object);
        return this.x0() == junSphere.x0() && this.z0() == junSphere.z0() && this.z0() == junSphere.z0() && this.r() == junSphere.r();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Ball_radius_center_(3, this.radius(), this.center());
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_(JunSphere.this.defaultColor());
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public double r() {
        return this.radius();
    }

    public double x0() {
        return this.x0;
    }

    public double y0() {
        return this.y0;
    }

    public double z0() {
        return this.z0;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(40);
        this.center().printOn_(writer);
        writer.write(" sphere: ");
        writer.write(Double.toString(this.radius()));
        writer.write(41);
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" center: ");
        this.center().storeOn_(writer);
        writer.write(" radius: ");
        writer.write(Double.toString(this.radius()));
        writer.write(41);
    }

    public boolean isSphere() {
        return true;
    }

    public int whichSideOf_(JunPlane junPlane) {
        int n = this.center().whichSideOf_(junPlane);
        if (n == 0) {
            return 0;
        }
        if (junPlane.distanceFromPoint_(this.center()) <= this.radius()) {
            return 0;
        }
        return n;
    }

    protected void setCenter_(JunPoint junPoint) {
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(junPoint);
        this.setX0_(jun3dPoint.x());
        this.setY0_(jun3dPoint.y());
        this.setZ0_(jun3dPoint.z());
    }

    protected void setR_(double d) {
        this.setRadius_(d);
    }

    protected void setRadius_(double d) {
        this.radius = d;
    }

    protected void setX0_(double d) {
        this.x0 = d;
    }

    protected void setY0_(double d) {
        this.y0 = d;
    }

    protected void setZ0_(double d) {
        this.z0 = d;
    }
}

