/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.support;

import jp.co.sra.jun.system.framework.JunAbstractObject;

public class JunBSplineFunction
extends JunAbstractObject {
    protected double[] knotVector;
    protected int order;

    public JunBSplineFunction(double[] dArray, int n) {
        this.setKnotVector_order_(dArray, n);
    }

    public double i_t_(int n, double d) {
        double d2 = this.i_k_t_(n, this.order - 1, d * (this.maxT() - this.minT()) + this.minT());
        if (Double.isNaN(d2)) {
            return n == this.knotVector.length - this.order - 1 ? 1.0 : 0.0;
        }
        return d2;
    }

    public JunBSplineFunction reversed() {
        int n = this.knotVector.length;
        double d = this.knotVector[n - 1];
        double[] dArray = new double[n];
        for (int i = 0; i < this.knotVector.length; ++i) {
            dArray[i] = d - this.knotVector[n - 1 - i];
        }
        return new JunBSplineFunction(dArray, this.order);
    }

    protected void setKnotVector_order_(double[] dArray, int n) {
        this.knotVector = dArray;
        this.order = n;
    }

    protected double i_k_t_(int n, int n2, double d) {
        double d2;
        if (n2 == 0) {
            return this.knotVector[n] <= d && d < this.knotVector[n + 1] ? 1.0 : Double.NaN;
        }
        double d3 = this.i_k_t_(n, n2 - 1, d);
        double d4 = Double.isNaN(d3) ? Double.NaN : (d - this.knotVector[n]) * d3 / (this.knotVector[n + n2] - this.knotVector[n]);
        double d5 = this.i_k_t_(n + 1, n2 - 1, d);
        double d6 = d2 = Double.isNaN(d5) ? Double.NaN : (this.knotVector[n + n2 + 1] - d) * d5 / (this.knotVector[n + n2 + 1] - this.knotVector[n + 1]);
        if (Double.isNaN(d4)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d4;
        }
        return d4 + d2;
    }

    protected double maxT() {
        return this.knotVector[this.knotVector.length - this.order];
    }

    protected double minT() {
        return this.knotVector[this.order - 1];
    }
}

