/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunPointSorter
extends JunAbstractObject {
    protected Collection sourcePoints;
    protected Jun3dPoint eyePoint;
    protected Jun3dPoint upVector;
    protected Collection sortedPoints;

    protected static JunPoint[] _AsJunPointArray_(Collection collection) {
        JunPoint[] junPointArray = new JunPoint[collection.size()];
        collection.toArray(junPointArray);
        return junPointArray;
    }

    public JunPointSorter() {
    }

    public JunPointSorter(Collection collection) {
        this(JunPointSorter._AsJunPointArray_(collection));
    }

    public JunPointSorter(JunPoint[] junPointArray) {
        this();
        for (int i = 0; i < junPointArray.length; ++i) {
            this.add_(junPointArray[i]);
        }
    }

    public JunPointSorter(Collection collection, JunPoint junPoint, JunPoint junPoint2) {
        this(collection);
        this.eyePoint_(junPoint);
        this.upVector_(junPoint2);
    }

    public JunPointSorter(JunPoint[] junPointArray, JunPoint junPoint, JunPoint junPoint2) {
        this(junPointArray);
        this.eyePoint_(junPoint);
        this.upVector_(junPoint2);
    }

    public JunPointSorter(JunPoint junPoint, JunPoint junPoint2) {
        this();
        this.eyePoint_(junPoint);
        this.upVector_(junPoint2);
    }

    protected void initialize() {
        super.initialize();
        this.sourcePoints = null;
        this.eyePoint = null;
        this.upVector = null;
        this.sortedPoints = null;
    }

    public Jun3dPoint eyePoint() {
        if (this.eyePoint == null) {
            this.eyePoint = this.defaultEyePoint();
        }
        return this.eyePoint;
    }

    public void eyePoint_(JunPoint junPoint) {
        this.eyePoint = Jun3dPoint.Coerce_(junPoint);
        this.sortedPoints = null;
    }

    public Collection sortedPoints() {
        if (this.sortedPoints == null) {
            this.sortedPoints = this.computeSortedPoints();
        }
        return this.sortedPoints;
    }

    public JunPoint[] _sortedPoints() {
        return JunPointSorter._AsJunPointArray_(this.sortedPoints());
    }

    public Collection sourcePoints() {
        if (this.sourcePoints == null) {
            this.sourcePoints = new ArrayList();
        }
        return this.sourcePoints;
    }

    public JunPoint[] _sourcePoints() {
        return JunPointSorter._AsJunPointArray_(this.sourcePoints());
    }

    public Jun3dPoint upVector() {
        if (this.upVector == null) {
            this.upVector = this.defaultUpVector();
        }
        return this.upVector;
    }

    public void upVector_(JunPoint junPoint) {
        this.upVector = Jun3dPoint.Coerce_(junPoint);
        this.sortedPoints = null;
    }

    public int size() {
        return this.sortedPoints().size();
    }

    public boolean add_(JunPoint junPoint) {
        boolean bl;
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(this.sourcePoints());
        for (bl = false; bl < junPointArray.length; bl += 1) {
            if (!junPointArray[bl].equal_((Object)junPoint)) continue;
            return false;
        }
        bl = this.sourcePoints().add(junPoint);
        this.sortedPoints = null;
        return bl;
    }

    public boolean addAll_(Collection collection) {
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(collection);
        return this.addAll_(junPointArray);
    }

    public boolean addAll_(JunPoint[] junPointArray) {
        boolean bl = false;
        for (int i = 0; i < junPointArray.length; ++i) {
            bl = bl || this.add_(junPointArray[i]);
        }
        return bl;
    }

    public double defaultBigNumber() {
        return 1.0E11;
    }

    public Jun3dPoint defaultEyePoint() {
        return new Jun3dPoint(this.defaultBigNumber(), 0.0, 0.0);
    }

    public Jun3dPoint defaultUpVector() {
        return new Jun3dPoint(0.0, 1.0, 0.0);
    }

    public Object do_(StBlockClosure stBlockClosure) {
        JunPoint[] junPointArray = this._sortedPoints();
        for (int i = 0; i < junPointArray.length; ++i) {
            Object object = stBlockClosure.value_((Object)junPointArray[i]);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object with_do_(Collection collection, StBlockClosure stBlockClosure) {
        Iterator iterator = this.sortedPoints().iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object object = stBlockClosure.value_value_(iterator.next(), iterator2.next());
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected Jun3dPoint computeNearestPoint_fromPoint_(ArrayList arrayList, Jun3dPoint jun3dPoint) {
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(arrayList);
        ArrayList<JunPoint> arrayList2 = new ArrayList<JunPoint>();
        for (int i = 0; i < junPointArray.length; ++i) {
            if (junPointArray[i].equal_((Object)jun3dPoint)) continue;
            arrayList2.add(junPointArray[i]);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        if (arrayList2.size() == 1) {
            return (Jun3dPoint)((Object)arrayList2.get(0));
        }
        double d = Double.NaN;
        Jun3dPoint jun3dPoint2 = null;
        JunPoint[] junPointArray2 = JunPointSorter._AsJunPointArray_(arrayList2);
        for (int i = 0; i < junPointArray2.length; ++i) {
            JunPoint junPoint = junPointArray2[i];
            Jun3dPoint jun3dPoint3 = junPoint.as3dPoint();
            double d2 = jun3dPoint3.distance_(jun3dPoint);
            if (Double.isNaN(d)) {
                d = d2;
                jun3dPoint2 = jun3dPoint3;
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
            jun3dPoint2 = jun3dPoint3;
        }
        return jun3dPoint2;
    }

    protected Jun3dPoint computeNearestPoint_fromPoint_eyePoint_upVector_(ArrayList arrayList, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        JunGeometry junGeometry;
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Jun3dPoint)((Object)arrayList.get(0));
        }
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(arrayList);
        JunPlane junPlane = jun3dPoint.plane_(jun3dPoint3);
        Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint, jun3dPoint.plus_(jun3dPoint2.minus_(jun3dPoint).vectorProduct_(jun3dPoint3)));
        double d = 0.0;
        ArrayList<JunPoint> arrayList2 = null;
        while (true) {
            junGeometry = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(d), jun3dLine);
            JunPlane junPlane2 = junPlane.transform_((Jun3dTransformation)junGeometry);
            arrayList2 = new ArrayList<JunPoint>();
            for (int i = 0; i < junPointArray.length; ++i) {
                if (junPointArray[i].whichSideOf_(junPlane2) == -1) continue;
                arrayList2.add(junPointArray[i]);
            }
            if (!arrayList2.isEmpty() || !(d <= 180.0)) break;
            d += 10.0;
        }
        junGeometry = this.computeNearestPoint_fromPoint_withLine_(arrayList2, jun3dPoint, this.eyePoint.to_(jun3dPoint));
        return junGeometry;
    }

    protected Jun3dPoint computeNearestPoint_fromPoint_previousPoint_(ArrayList arrayList, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        ArrayList<JunPoint> arrayList2;
        JunGeometry junGeometry;
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Jun3dPoint)((Object)arrayList.get(0));
        }
        try {
            junGeometry = new Jun3dLine(jun3dPoint, jun3dPoint2);
            double d = 0.0;
            while (true) {
                JunPlane junPlane = junGeometry.atT_(d).plane_(jun3dPoint.minus_(jun3dPoint2));
                JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(arrayList);
                arrayList2 = new ArrayList<JunPoint>();
                for (int i = 0; i < junPointArray.length; ++i) {
                    if (junPointArray[i].whichSideOf_(junPlane) == -1) continue;
                    arrayList2.add(junPointArray[i]);
                }
                if (arrayList2.isEmpty() && d < 1.0) {
                    d += 0.1;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            arrayList2 = arrayList;
        }
        junGeometry = this.computeNearestPoint_fromPoint_(arrayList2, jun3dPoint);
        return junGeometry;
    }

    protected Jun3dPoint computeNearestPoint_fromPoint_withLine_(ArrayList arrayList, Jun3dPoint jun3dPoint, Jun3dLine jun3dLine) {
        ArrayList<JunPoint> arrayList2 = new ArrayList<JunPoint>();
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(arrayList);
        for (int i = 0; i < junPointArray.length; ++i) {
            if (junPointArray[i].equal_((Object)jun3dPoint)) continue;
            arrayList2.add(junPointArray[i]);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        if (arrayList2.size() == 1) {
            return (Jun3dPoint)((Object)arrayList2.get(0));
        }
        double d = Double.NaN;
        Jun3dPoint jun3dPoint2 = null;
        JunPoint[] junPointArray2 = JunPointSorter._AsJunPointArray_(arrayList2);
        for (int i = 0; i < junPointArray2.length; ++i) {
            Jun3dPoint jun3dPoint3 = (Jun3dPoint)junPointArray2[i];
            double d2 = jun3dLine.nearestPointFromPoint_(jun3dPoint3).distance_(jun3dPoint);
            if (Double.isNaN(d)) {
                d = d2;
                jun3dPoint2 = jun3dPoint3;
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
            jun3dPoint2 = jun3dPoint3;
        }
        return jun3dPoint2;
    }

    protected Collection computeSortedPoints() {
        ArrayList<Jun3dPoint> arrayList = (ArrayList<Jun3dPoint>)this.sourcePoints();
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        if (arrayList.size() == 1) {
            return arrayList;
        }
        boolean bl = ((JunPoint)((Object)arrayList.get(0))).is2d();
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(arrayList);
        arrayList = new ArrayList<Jun3dPoint>();
        for (int i = 0; i < junPointArray.length; ++i) {
            arrayList.add(junPointArray[i].as3dPoint());
        }
        ArrayList<JunPoint> arrayList2 = this.computeSortedPoints_(arrayList);
        JunPoint[] junPointArray2 = this._sourcePoints();
        if (bl) {
            JunPoint[] junPointArray3 = JunPointSorter._AsJunPointArray_(arrayList2);
            arrayList2 = new ArrayList<JunPoint>();
            for (int i = 0; i < junPointArray3.length; ++i) {
                JunPoint junPoint = junPointArray3[i];
                for (int j = 0; j < junPointArray2.length; ++j) {
                    JunPoint junPoint2 = junPointArray2[j];
                    if (junPoint2.x() != junPoint.x() || junPoint2.y() != junPoint.y()) continue;
                    arrayList2.add(junPoint2);
                    break;
                }
                if (arrayList2.size() == i + 1) continue;
                SmalltalkException.Error((String)"notFoundError");
            }
        }
        return arrayList2;
    }

    protected Collection computeSortedPoints_(ArrayList arrayList) {
        int n;
        JunGeometry junGeometry;
        if (arrayList.isEmpty()) {
            return new ArrayList(0);
        }
        if (arrayList.size() == 1) {
            return arrayList;
        }
        ArrayList<JunPoint> arrayList2 = new ArrayList<JunPoint>(arrayList);
        ArrayList<JunGeometry> arrayList3 = new ArrayList<JunGeometry>(arrayList.size());
        Jun3dPoint jun3dPoint = this.computeNearestPoint_fromPoint_(arrayList2, this.eyePoint());
        JunPoint[] junPointArray = JunPointSorter._AsJunPointArray_(arrayList2);
        arrayList2 = new ArrayList();
        for (int i = 0; i < junPointArray.length; ++i) {
            if (junPointArray[i].equal_((Object)jun3dPoint)) continue;
            arrayList2.add(junPointArray[i]);
        }
        arrayList3.add(jun3dPoint);
        if (arrayList2.size() == 1) {
            arrayList3.add((JunGeometry)((Object)arrayList2.get(arrayList2.size() - 1)));
            return arrayList3;
        }
        Jun3dPoint jun3dPoint2 = this.computeNearestPoint_fromPoint_eyePoint_upVector_(arrayList2, jun3dPoint, this.eyePoint(), this.upVector());
        junPointArray = JunPointSorter._AsJunPointArray_(arrayList2);
        arrayList2 = new ArrayList();
        for (int i = 0; i < junPointArray.length; ++i) {
            if (junPointArray[i].equal_((Object)jun3dPoint2)) continue;
            arrayList2.add(junPointArray[i]);
        }
        arrayList3.add(jun3dPoint2);
        Jun3dPoint jun3dPoint3 = jun3dPoint;
        JunGeometry junGeometry2 = jun3dPoint2;
        while (!arrayList2.isEmpty()) {
            junGeometry = this.computeNearestPoint_fromPoint_previousPoint_(arrayList2, (Jun3dPoint)junGeometry2, jun3dPoint3);
            junPointArray = JunPointSorter._AsJunPointArray_(arrayList2);
            arrayList2 = new ArrayList();
            for (n = 0; n < junPointArray.length; ++n) {
                if (junPointArray[n].equal_((Object)junGeometry)) continue;
                arrayList2.add(junPointArray[n]);
            }
            arrayList3.add(junGeometry);
            jun3dPoint3 = junGeometry2;
            junGeometry2 = junGeometry;
        }
        junGeometry = JunPlane.On_normalVector_(jun3dPoint, this.upVector());
        n = jun3dPoint.as3dPoint().plus_(this.upVector()).whichSideOf_((JunPlane)junGeometry);
        int n2 = jun3dPoint2.as3dPoint().whichSideOf_((JunPlane)junGeometry);
        if (!(n == 0 || n2 == 0) && n != n2) {
            JunPoint[] junPointArray2 = JunPointSorter._AsJunPointArray_(arrayList3);
            arrayList3 = new ArrayList(junPointArray2.length);
            for (int i = junPointArray2.length - 1; i >= 0; --i) {
                arrayList3.add(junPointArray2[i]);
            }
        }
        return arrayList3;
    }
}

