/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.JunCircle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun2dCircle
extends JunCircle {
    protected double x0;
    protected double y0;

    private Jun2dCircle() {
    }

    public Jun2dCircle(double d) {
        this(new Jun2dPoint(0.0, 0.0), d);
    }

    public Jun2dCircle(Jun2dPoint jun2dPoint, double d) {
        this.setCenter_(jun2dPoint);
        this.setRadius_(d);
    }

    public Jun2dPoint center() {
        return new Jun2dPoint(this.x0, this.y0);
    }

    protected JunPoint _center() {
        return this.center();
    }

    public boolean equal_(Object object) {
        if (!super.equal_(object)) {
            return false;
        }
        Jun2dCircle jun2dCircle = (Jun2dCircle)((Object)object);
        return this.isEqualNumber_to_(this.x0, jun2dCircle.x0) && this.isEqualNumber_to_(this.y0, jun2dCircle.y0);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Jun2dCircle jun2dCircle = (Jun2dCircle)((Object)object);
        return this.x0() == jun2dCircle.x0() && this.y0() == jun2dCircle.y0();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.CircleBy_radius_(10.0, this.radius()).translatedBy_(Jun3dPoint.Coerce_(this.center()));
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_(Jun2dCircle.this.defaultColor());
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public JunPlane asPlane() {
        Jun3dPoint jun3dPoint = this.center().as3dPoint();
        Jun3dLine jun3dLine = jun3dPoint.to_(new Jun3dPoint(this.center(), 1.0));
        Jun3dPoint jun3dPoint2 = jun3dPoint.plus_(new Jun3dPoint(this.radius(), 0.0, 0.0));
        return new JunPlane(jun3dPoint2, jun3dPoint2.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(120.0), jun3dLine)), jun3dPoint2.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(240.0), jun3dLine)));
    }

    public Jun2dTriangle asTriangle() {
        Jun2dPoint jun2dPoint = this.center();
        Jun2dPoint jun2dPoint2 = jun2dPoint.plus_(new Jun2dPoint(this.radius(), 0.0));
        return new Jun2dTriangle(jun2dPoint2, jun2dPoint2.transform_(Jun2dTransformation.Rotate_around_(JunAngle.FromDeg_(120.0), jun2dPoint)), jun2dPoint2.transform_(Jun2dTransformation.Rotate_around_(JunAngle.FromDeg_(240.0), jun2dPoint)));
    }

    public Jun2dPoint[] trackPointsBy_(int n) {
        Jun3dPoint[] jun3dPointArray = new Jun3dCircle(new Jun3dPoint(this.center().x(), this.center().y(), 0.0), this.radius(), new Jun3dPoint(0.0, 0.0, 1.0)).trackPointsBy_(n);
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun2dPointArray[i] = new Jun2dPoint(jun3dPointArray[i].x(), jun3dPointArray[i].y());
        }
        return jun2dPointArray;
    }

    public double x0() {
        return this.x0;
    }

    public double y0() {
        return this.y0;
    }

    public boolean is2d() {
        return true;
    }

    public Jun2dCircle rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun2dTransformation.Rotate_(junAngle));
    }

    public Jun2dCircle scaledBy_(double d) {
        return this.transform_(Jun2dTransformation.Scale_(d));
    }

    public Jun2dCircle scaledBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Scale_(jun2dPoint));
    }

    public Jun2dCircle transform_(Jun2dTransformation jun2dTransformation) {
        return new Jun2dCircle(this.center().transform_(jun2dTransformation), new Jun2dPoint(0.0, 0.0).to_(new Jun2dPoint(this.radius(), 0.0)).transform_(jun2dTransformation).length());
    }

    public Jun2dCircle translatedBy_(double d) {
        return this.transform_(Jun2dTransformation.Translate_(d));
    }

    public Jun2dCircle translatedBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Translate_(jun2dPoint));
    }

    protected void setCenter_(JunPoint junPoint) {
        Jun2dPoint jun2dPoint = Jun2dPoint.Coerce_(junPoint);
        this.setX0_(jun2dPoint.x());
        this.setY0_(jun2dPoint.y());
    }

    protected void setX0_(double d) {
        this.x0 = d;
    }

    protected void setY0_(double d) {
        this.y0 = d;
    }
}

