/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun3dPolygon
extends JunPlane {
    public static final double ACCURACY = 1.0E-12 * Math.pow(10.0, Math.max(0L, Math.round(Math.log(1.0E12) / Math.log(10.0) / 2.0 - 2.0)));
    protected Jun2dPolygon parameterPolygon = null;
    protected Jun3dBoundingBox boundingBox = null;
    protected Jun3dPoint normalVector = null;

    public static Jun3dPolygon _On_on_on_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        if (jun3dPoint.equals((Object)jun3dPoint2)) {
            return null;
        }
        if (jun3dPoint.equals((Object)jun3dPoint3)) {
            return null;
        }
        if (jun3dPoint2.equals((Object)jun3dPoint3)) {
            return null;
        }
        Jun3dPolygon jun3dPolygon = new Jun3dPolygon();
        jun3dPolygon._initialize(jun3dPoint, jun3dPoint2, jun3dPoint3);
        return jun3dPolygon;
    }

    public static Jun3dPolygon On_on_on_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        return Jun3dPolygon.Vertexes_(new Jun3dPoint[]{jun3dPoint, jun3dPoint2, jun3dPoint3});
    }

    public static Jun3dPolygon Origin_uVector_vVector_parameterPolygon_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Jun2dPolygon jun2dPolygon) {
        Jun3dPoint jun3dPoint4 = jun3dPoint2.vectorProduct_(jun3dPoint3).unitVector();
        Jun3dPoint jun3dPoint5 = jun3dPoint4.vectorProduct_(jun3dPoint2).unitVector();
        Jun3dPolygon jun3dPolygon = Jun3dPolygon._On_on_on_(jun3dPoint, jun3dPoint.plus_(jun3dPoint2), jun3dPoint.plus_(jun3dPoint5));
        if (jun3dPolygon == null) {
            return null;
        }
        jun3dPolygon.setParameterPolygon_(jun2dPolygon);
        return jun3dPolygon;
    }

    public static Jun3dPolygon Origin_uVector_vVector_points_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Jun3dPoint[] jun3dPointArray) {
        Jun3dPoint jun3dPoint4 = jun3dPoint2.vectorProduct_(jun3dPoint3).unitVector();
        Jun3dPoint jun3dPoint5 = jun3dPoint4.vectorProduct_(jun3dPoint2).unitVector();
        Jun3dPolygon jun3dPolygon = Jun3dPolygon._On_on_on_(jun3dPoint, jun3dPoint.plus_(jun3dPoint2), jun3dPoint.plus_(jun3dPoint5));
        if (jun3dPolygon == null) {
            return null;
        }
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[jun3dPointArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun2dPointArray[i] = jun3dPolygon.parameterPointAtPoint_(jun3dPointArray[i]);
        }
        jun3dPolygon.setParameterPolygon_(new Jun2dPolygon(jun2dPointArray));
        return jun3dPolygon;
    }

    public static Jun3dPolygon Points_(Jun3dPoint[] jun3dPointArray) {
        return Jun3dPolygon.Vertexes_(jun3dPointArray);
    }

    public static Jun3dPolygon Vertexes_(Jun3dPoint[] jun3dPointArray) {
        Jun3dPoint[] jun3dPointArray2 = jun3dPointArray;
        int n = jun3dPointArray2.length;
        if (n < 3) {
            return null;
        }
        Jun3dPoint jun3dPoint = jun3dPointArray2[0];
        int n2 = 0;
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 1; i < jun3dPointArray2.length; ++i) {
            double d2 = jun3dPointArray2[i].distance_(jun3dPoint);
            if (!(d < d2)) continue;
            n2 = i;
            d = d2;
        }
        Jun3dPoint jun3dPoint2 = jun3dPointArray2[n2];
        Jun3dPoint jun3dPoint3 = jun3dPoint2.minus_(jun3dPoint).unitVector();
        Jun3dPoint jun3dPoint4 = Jun3dPoint.Zero();
        for (int i = 0; i < n; ++i) {
            Jun3dPoint jun3dPoint5 = jun3dPointArray2[i];
            Jun3dPoint jun3dPoint6 = jun3dPointArray2[(i + 1) % n];
            Jun3dPoint jun3dPoint7 = jun3dPointArray2[(i + 2) % n];
            jun3dPoint4 = jun3dPoint4.plus_(jun3dPoint6.minus_(jun3dPoint5).vectorProduct_(jun3dPoint7.minus_(jun3dPoint6)));
        }
        Jun3dPoint jun3dPoint8 = jun3dPoint4.vectorProduct_(jun3dPoint3).unitVector();
        return Jun3dPolygon.Origin_uVector_vVector_points_(jun3dPoint, jun3dPoint3, jun3dPoint8, jun3dPointArray2);
    }

    public static Jun3dPolygon Vertexes_(Collection collection) {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[collection.size()];
        collection.toArray(jun3dPointArray);
        return Jun3dPolygon.Vertexes_(jun3dPointArray);
    }

    public static Jun3dPolygon Vertices_(Jun3dPoint[] jun3dPointArray) {
        return Jun3dPolygon.Vertexes_(jun3dPointArray);
    }

    public static Jun3dPolygon With_with_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        return Jun3dPolygon.Vertexes_(new Jun3dPoint[]{jun3dPoint, jun3dPoint2, jun3dPoint3});
    }

    public double area() {
        return this.parameterPolygon().area() * this.uVector().length() * this.vVector().length();
    }

    public Jun3dPoint normalVector() {
        if (this.normalVector == null) {
            this.normalVector = this.preferredNormalVector();
        }
        return this.normalVector;
    }

    public int numberOfPoints() {
        return this.pointsSize();
    }

    public Jun3dPoint origin() {
        return this.p1;
    }

    public Jun2dPoint parameterPointAt_(int n) {
        return this.parameterPolygon().pointAt_(n);
    }

    public Jun2dPoint parameterPointAtPoint_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = jun3dPoint.minus_(this.p1);
        Jun3dPoint jun3dPoint3 = this.uVector();
        Jun3dPoint jun3dPoint4 = this.vVector();
        double d = jun3dPoint3.dotProduct_(jun3dPoint2) / jun3dPoint3.dotProduct_(jun3dPoint3);
        double d2 = jun3dPoint4.dotProduct_(jun3dPoint2) / jun3dPoint4.dotProduct_(jun3dPoint4);
        return new Jun2dPoint(d, d2);
    }

    public final Jun2dPolygon parameterPolygon() {
        return this.parameterPolygon;
    }

    public Jun3dPoint pointAt_(int n) {
        return this.pointAtParameterPoint_(this.parameterPolygon().pointAt_(n));
    }

    private Jun3dPoint pointAtParameterPoint_(Jun2dPoint jun2dPoint) {
        return this.pointAtU_v_(jun2dPoint.x(), jun2dPoint.y());
    }

    private Jun3dPoint pointAtU_v_(double d, double d2) {
        return this.p1.plus_(this.uVector().multipliedBy_(d)).plus_(this.vVector().multipliedBy_(d2));
    }

    public final Jun3dPoint[] points() {
        int n = this.pointsSize();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
        for (int i = 0; i < n; ++i) {
            jun3dPointArray[i] = this.pointAt_(i);
        }
        return jun3dPointArray;
    }

    public int pointsSize() {
        return this.parameterPolygon().pointsSize();
    }

    public Jun3dPoint uVector() {
        return this.p2.minus_(this.p1);
    }

    public Jun3dPoint vVector() {
        return this.p3.minus_(this.p1);
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = this.preferredBoundingBox();
        }
        return this.boundingBox;
    }

    public Jun3dBoundingBox preferredBoundingBox() {
        Jun3dPoint[] jun3dPointArray = this.points();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            Jun3dPoint jun3dPoint = jun3dPointArray[i];
            d = Math.min(d, jun3dPoint.x());
            d2 = Math.min(d2, jun3dPoint.y());
            d3 = Math.min(d3, jun3dPoint.z());
            d4 = Math.max(d4, jun3dPoint.x());
            d5 = Math.max(d5, jun3dPoint.y());
            d6 = Math.max(d6, jun3dPoint.z());
        }
        return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(d, d2, d3), new Jun3dPoint(d4, d5, d6));
    }

    public boolean equal_(Object object) {
        if (!super.equal_(object)) {
            return false;
        }
        Jun3dPolygon jun3dPolygon = (Jun3dPolygon)((Object)object);
        return this.parameterPolygon().equal_((Object)jun3dPolygon.parameterPolygon());
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Jun3dPolygon jun3dPolygon = (Jun3dPolygon)((Object)object);
        return this.parameterPolygon().equals((Object)jun3dPolygon.parameterPolygon());
    }

    public Jun3dPolygon[] asArrayOfConvexPolygons() {
        final ArrayList arrayList = new ArrayList();
        this.asConvexPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new Jun3dPolygon[arrayList.size()]);
    }

    public Jun3dLine[] asArrayOfLines() {
        return this.asArrayOf3dLines();
    }

    public Jun3dLine[] asArrayOf3dLines() {
        Jun3dPoint[] jun3dPointArray = this.points();
        boolean bl = jun3dPointArray[0].equal_((Object)jun3dPointArray[jun3dPointArray.length - 1]);
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[bl ? jun3dPointArray.length : jun3dPointArray.length + 1];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray2[i] = new Jun3dPoint(jun3dPointArray[i]);
        }
        if (!bl) {
            jun3dPointArray2[jun3dPointArray2.length - 1] = new Jun3dPoint(jun3dPointArray[0]);
        }
        Jun3dPolyline jun3dPolyline = new Jun3dPolyline(jun3dPointArray2);
        return jun3dPolyline.asArrayOfLines();
    }

    public Jun3dPoint[] asArrayOfPoints() {
        return this.points();
    }

    public Jun3dTriangle[] asArrayOf3dTriangles() {
        int n = this.numberOfPoints();
        if (n == 3) {
            Jun3dPoint[] jun3dPointArray = this.points();
            return new Jun3dTriangle[]{Jun3dTriangle.On_on_on_(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2])};
        }
        Jun3dPolygon[] jun3dPolygonArray = this.asArrayOfConvexPolygons();
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>(n - 2);
        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
            Jun3dPolygon jun3dPolygon = jun3dPolygonArray[i];
            for (int j = 1; j < n - 1; ++j) {
                arrayList.add(Jun3dTriangle.On_on_on_(jun3dPolygon.pointAt_(0), jun3dPolygon.pointAt_(j), jun3dPolygon.pointAt_(j + 1)));
            }
        }
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    public Jun3dPolygon[] asArrayOfTrianglePolygons() {
        int n = this.numberOfPoints();
        if (n == 3) {
            return new Jun3dPolygon[]{this};
        }
        Jun3dPolygon[] jun3dPolygonArray = this.asArrayOfConvexPolygons();
        ArrayList<Jun3dPolygon> arrayList = new ArrayList<Jun3dPolygon>(n - 2);
        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
            Jun3dPolygon jun3dPolygon = jun3dPolygonArray[i];
            for (int j = 1; j < n - 1; ++j) {
                arrayList.add(Jun3dPolygon.Vertexes_(new Jun3dPoint[]{jun3dPolygon.pointAt_(0), jun3dPolygon.pointAt_(j), jun3dPolygon.pointAt_(j + 1)}));
            }
        }
        return arrayList.toArray(new Jun3dPolygon[arrayList.size()]);
    }

    public Jun3dTriangle[] asArrayOfTriangles() {
        if (this.numberOfPoints() == 3) {
            return new Jun3dTriangle[]{new Jun3dTriangle(this.p1(), this.p2(), this.p3())};
        }
        Jun3dPolygon[] jun3dPolygonArray = this.asArrayOfConvexPolygons();
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>(this.numberOfPoints() - 2);
        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
            for (int j = 1; j < jun3dPolygonArray[i].numberOfPoints() - 1; ++j) {
                arrayList.add(new Jun3dTriangle(jun3dPolygonArray[i].pointAt_(0), jun3dPolygonArray[i].pointAt_(j), jun3dPolygonArray[i].pointAt_(j + 1)));
            }
        }
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dObject junOpenGL3dObject = null;
        if (this.isConvex()) {
            junOpenGL3dObject = new JunOpenGL3dPolygon(this.points());
        } else {
            JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
            Jun3dPolygon[] jun3dPolygonArray = this.asArrayOfConvexPolygons();
            for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPolygonArray[i].points()));
            }
            junOpenGL3dObject = junOpenGL3dCompoundObject;
        }
        ((JunOpenGL3dObject)junOpenGL3dObject).objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_alpha_(Jun3dPolygon.this.defaultColor(), Float.NaN);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public Jun3dPolyline asPolyline() {
        return new Jun3dPolyline(this.points());
    }

    public JunPlane reversed() {
        Jun3dPoint[] jun3dPointArray = this.points();
        int n = jun3dPointArray.length;
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[n];
        for (int i = 0; i < n; ++i) {
            jun3dPointArray2[i] = jun3dPointArray[n - i - 1];
        }
        return (Jun3dPolygon)((Object)Jun3dPolygon._New(((Object)((Object)this)).getClass(), (Object[])jun3dPointArray2));
    }

    public Object asConvexPolygonsDo_(final StBlockClosure stBlockClosure) {
        return this.parameterPolygon().asConvexPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPolygon jun2dPolygon = (Jun2dPolygon)((Object)object);
                Jun3dPolygon jun3dPolygon = (Jun3dPolygon)Jun3dPolygon.this.copy();
                jun3dPolygon.setParameterPolygon_(jun2dPolygon);
                return stBlockClosure.value_((Object)jun3dPolygon);
            }
        });
    }

    public void lineSegmentsDo_(StBlockClosure stBlockClosure) {
        int n = this.numberOfPoints();
        for (int i = 0; i < n; ++i) {
            stBlockClosure.value_((Object)new Jun3dLine(this.pointAt_(i), this.pointAt_((i + 1) % n)));
        }
    }

    public void parameterLineSegmentsDo_(StBlockClosure stBlockClosure) {
        int n = this.numberOfPoints();
        for (int i = 0; i < n; ++i) {
            stBlockClosure.value_((Object)new Jun2dLine(this.parameterPointAt_(i), this.parameterPointAt_((i + 1) % n)));
        }
    }

    public Object parameterPointsDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.numberOfPoints(); ++i) {
            Object object = stBlockClosure.value_((Object)this.parameterPointAt_(i));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object pointsDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.pointsSize(); ++i) {
            Object object = stBlockClosure.value_((Object)this.pointAt_(i));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Jun3dPoint intersectingPointWithLine_(Jun3dLine jun3dLine) {
        Jun3dPoint jun3dPoint = super.intersectingPointWithLine_(jun3dLine);
        if (jun3dPoint == null) {
            return null;
        }
        if (this.containsPoint_(jun3dPoint)) {
            return jun3dPoint;
        }
        return null;
    }

    public Jun3dPoint intersectingPointWithLineSegment_(Jun3dLine jun3dLine) {
        if (this.boundingBox().intersectsOrTouches_(jun3dLine.boundingBox())) {
            Jun3dPoint jun3dPoint = super.intersectingPointWithLineSegment_(jun3dLine);
            if (jun3dPoint == null) {
                return null;
            }
            if (this.containsPoint_(jun3dPoint)) {
                return jun3dPoint;
            }
            return null;
        }
        return null;
    }

    public Jun3dPoint nearestPointFromPoint_(Jun3dPoint jun3dPoint) {
        return this.pointAtParameterPoint_(this.parameterPolygon().asPositivePolygon().nearestPointFromPoint_(this.parameterPointAtPoint_(jun3dPoint)));
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(this._className().toString());
        writer.write(40);
        Jun3dPoint[] jun3dPointArray = this.points();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray[i].printOn_(writer);
            writer.write(32);
        }
        writer.write(41);
    }

    public boolean containsLineSegment_(Jun3dLine jun3dLine) {
        return this.containsLineSegmentFrom_to_(jun3dLine.from(), jun3dLine.to());
    }

    public boolean containsLineSegmentFrom_to_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        if (!(this.containsPoint_(jun3dPoint) && this.containsPoint_(jun3dPoint2))) {
            return false;
        }
        return this.parameterPolygon().absContainsLineSegmentFrom_to_(this.parameterPointAtPoint_(jun3dPoint), this.parameterPointAtPoint_(jun3dPoint2));
    }

    public boolean containsPoint_(Jun3dPoint jun3dPoint) {
        if (!super.containsPoint_(jun3dPoint)) {
            return false;
        }
        return this.parameterPolygon().absContainsPoint_(this.parameterPointAtPoint_(jun3dPoint));
    }

    public boolean isConsistent() {
        return this.parameterPolygon().isConsistent();
    }

    public boolean isConvex() {
        return this.parameterPolygon().absIsConvex();
    }

    public int whichSideOf_(JunPlane junPlane) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Jun3dPoint[] jun3dPointArray = this.points();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            int n = jun3dPointArray[i].whichSideOf_(junPlane);
            if (n > 0) {
                bl = true;
                continue;
            }
            if (n < 0) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl && bl2) {
            return 0;
        }
        if (bl3) {
            return 0;
        }
        if (bl2) {
            return -1;
        }
        return 1;
    }

    protected double parameterArea() {
        return this.parameterPolygon().area();
    }

    protected Jun3dPoint preferredNormalVector() {
        Jun3dPoint jun3dPoint = Jun3dPoint.Zero();
        int n = this.pointsSize();
        for (int i = 0; i < n; ++i) {
            Jun3dPoint jun3dPoint2 = this.pointAt_(i);
            Jun3dPoint jun3dPoint3 = this.pointAt_((i + 1) % n);
            Jun3dPoint jun3dPoint4 = this.pointAt_((i + 2) % n);
            jun3dPoint = jun3dPoint.plus_(jun3dPoint3.minus_(jun3dPoint2).vectorProduct_(jun3dPoint4.minus_(jun3dPoint3)));
        }
        return jun3dPoint.unitVector();
    }

    protected void setParameterPolygon_(Jun2dPolygon jun2dPolygon) {
        if (jun2dPolygon.isPositive()) {
            this.parameterPolygon = jun2dPolygon;
        } else {
            Jun3dPoint jun3dPoint;
            this.parameterPolygon = jun2dPolygon.transposed();
            Jun3dPoint jun3dPoint2 = this.p2;
            this.p2 = jun3dPoint = this.p3;
            this.p3 = jun3dPoint2;
        }
    }
}

