/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.button;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.button.JunButtonView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

public class JunButtonController
extends JunAbstractController
implements MouseListener {
    protected boolean _mousePressed = false;
    protected Thread _repeatThread;

    protected JunButtonModel getButtonModel() {
        return (JunButtonModel)this.model();
    }

    protected JunButtonView getButtonView() {
        return (JunButtonView)this.view();
    }

    protected void buildListener(StView stView) {
        stView.toComponent().addMouseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.getButtonModel().isActive()) {
            return;
        }
        this.getButtonModel()._isPressedWithShiftDown(mouseEvent.isShiftDown());
        Graphics graphics = null;
        try {
            graphics = this.getButtonView().toComponent().getGraphics();
            if (!this.getButtonModel().value()) {
                this.getButtonView().displayTrueOn_(graphics);
            }
            graphics.setColor(Color.black);
            Dimension dimension = this.getButtonView().toComponent().getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        if (this.getButtonModel().repeatAction()) {
            this._startRepeatThread();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.getButtonModel().isActive()) {
            return;
        }
        if (this._repeatThread != null) {
            this._stopRepeatThread();
        }
        this.view().toComponent().repaint();
        this.executeAction();
    }

    protected synchronized void executeAction() {
        StBlockClosure stBlockClosure = this.getButtonModel().action();
        switch (stBlockClosure.numArgs()) {
            case 0: {
                stBlockClosure.value();
                break;
            }
            case 1: {
                stBlockClosure.value_((Object)this.getButtonModel());
                break;
            }
            case 2: {
                stBlockClosure.value_value_((Object)this.getButtonModel(), null);
            }
        }
    }

    protected synchronized void _startRepeatThread() {
        this._mousePressed = true;
        final long l = System.currentTimeMillis();
        this._repeatThread = new Thread(){

            public void run() {
                while (JunButtonController.this._mousePressed) {
                    if (JunButtonController.this.getButtonModel().repeatAction() && System.currentTimeMillis() - l > (long)JunButtonController.this.getButtonModel().repeatTick()) {
                        JunButtonController.this.executeAction();
                    }
                    Thread.yield();
                }
            }
        };
        this._repeatThread.setPriority(6);
        this._repeatThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _stopRepeatThread() {
        this._mousePressed = false;
        if (this._repeatThread != null) {
            try {
                this._repeatThread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this._repeatThread = null;
            }
        }
    }
}

