/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.calendar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Iterator;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.calendar.JunCalendarTimeController;
import jp.co.sra.jun.goodies.calendar.JunCalendarTimeModel;
import jp.co.sra.jun.goodies.calendar.JunCalendarTimeView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunCalendarTimeViewSwing
extends JunAbstractViewJPanel
implements JunCalendarTimeView {
    protected Vector frames;

    public JunCalendarTimeViewSwing(JunCalendarTimeModel junCalendarTimeModel) {
        super(junCalendarTimeModel);
    }

    public Vector frames() {
        if (this.frames == null) {
            this.makeFrames();
        }
        return this.frames;
    }

    private void makeFrames() {
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = this.getSize().width / 10;
        int n2 = this.getSize().height / 8;
        StRectangle stRectangle = new StRectangle(0, 0, 12, 16);
        int n3 = n * 0;
        int n4 = n2 * 0;
        StRectangle stRectangle2 = new StRectangle(n3, n4, n * 4, n2);
        stRectangle2 = stRectangle2.insetBy_(StRectangle.Origin_corner_((Point)new Point(8, 0), (Point)new Point(0, 0)));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"label"), JunSystem.$String((String)"hours:"), stRectangle2});
        n3 = n * 5;
        n4 = n2 * 0;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 5, n2));
        stRectangle2 = stRectangle2.insetBy_(StRectangle.Origin_corner_((Point)new Point(stRectangle.width(), 0), (Point)new Point(stRectangle.width() + 8, 0)));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"hours"), stRectangle2});
        stRectangle = stRectangle.align_with_(stRectangle.rightCenter(), stRectangle2.leftCenter());
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"button"), JunCalendarTimeViewSwing.$((String)"hourDown"), stRectangle});
        stRectangle = stRectangle.align_with_(stRectangle.leftCenter(), stRectangle2.rightCenter());
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"button"), JunCalendarTimeViewSwing.$((String)"hourUp"), stRectangle});
        n3 = n * 0;
        n4 = n2 * 1;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 4, n2));
        stRectangle2 = stRectangle2.insetBy_(StRectangle.Origin_corner_((Point)new Point(8, 0), (Point)new Point(0, 0)));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"label"), JunSystem.$String((String)"minutes:"), stRectangle2});
        n3 = n * 5;
        n4 = n2 * 1;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 5, n2));
        stRectangle2 = stRectangle2.insetBy_(StRectangle.Origin_corner_((Point)new Point(stRectangle.width(), 0), (Point)new Point(stRectangle.width() + 8, 0)));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"minutes"), stRectangle2});
        stRectangle = stRectangle.align_with_(stRectangle.rightCenter(), stRectangle2.leftCenter());
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"button"), JunCalendarTimeViewSwing.$((String)"minuteDown"), stRectangle});
        stRectangle = stRectangle.align_with_(stRectangle.leftCenter(), stRectangle2.rightCenter());
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"button"), JunCalendarTimeViewSwing.$((String)"minuteUp"), stRectangle});
        n3 = n * 0;
        n4 = n2 * 2;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 4, n2));
        stRectangle2 = stRectangle2.insetBy_(StRectangle.Origin_corner_((Point)new Point(8, 0), (Point)new Point(0, 0)));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"label"), JunSystem.$String((String)"seconds:"), stRectangle2});
        n3 = n * 5;
        n4 = n2 * 2;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 5, n2));
        stRectangle2 = stRectangle2.insetBy_(StRectangle.Origin_corner_((Point)new Point(stRectangle.width(), 0), (Point)new Point(stRectangle.width() + 8, 0)));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"seconds"), stRectangle2});
        stRectangle = stRectangle.align_with_(stRectangle.rightCenter(), stRectangle2.leftCenter());
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"button"), JunCalendarTimeViewSwing.$((String)"secondDown"), stRectangle});
        stRectangle = stRectangle.align_with_(stRectangle.leftCenter(), stRectangle2.rightCenter());
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"button"), JunCalendarTimeViewSwing.$((String)"secondUp"), stRectangle});
        n3 = n * 0;
        n4 = n2 * 3;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 10, n2 * 5));
        vector.add(new Object[]{JunCalendarTimeViewSwing.$((String)"clock"), stRectangle2});
        this.frames = vector;
    }

    private StBlockClosure rotateBlock() {
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                double d = Math.toRadians((Double)object2 * -1.0);
                double d2 = Math.sin(d);
                double d3 = Math.cos(d);
                double d4 = jun2dPoint.x() * d3 + jun2dPoint.y() * d2;
                double d5 = -1.0 * jun2dPoint.x() * d2 + jun2dPoint.y() * d3;
                return new Jun2dPoint(d4, d5);
            }
        };
        return stBlockClosure;
    }

    public void displayOn_(Graphics graphics) {
        this.displayBordersOn_(graphics);
        this.displayObjectsOn_(graphics);
    }

    public void displayBordersOn_(Graphics graphics) {
        for (int i = 0; i < this.frames().size(); ++i) {
            Object[] objectArray = (Object[])this.frames().get(i);
            StSymbol stSymbol = (StSymbol)objectArray[0];
            StRectangle stRectangle = (StRectangle)objectArray[objectArray.length - 1];
            StRectangle stRectangle2 = new StRectangle(graphics.getClipBounds());
            if (!stRectangle2.intersects_(stRectangle) || stSymbol != JunCalendarTimeViewSwing.$((String)"hours") && stSymbol != JunCalendarTimeViewSwing.$((String)"minutes") && stSymbol != JunCalendarTimeViewSwing.$((String)"seconds") && stSymbol != JunCalendarTimeViewSwing.$((String)"clock")) continue;
            graphics.setColor(veryLightGray);
            graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
            StRectangle stRectangle3 = stRectangle.insetBy_(new StRectangle(1, 1, 2, 2));
            graphics.setColor(veryDarkGray);
            graphics.drawRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"clock")) continue;
            stRectangle3 = stRectangle.insetBy_(new StRectangle(2, 2, 3, 3));
            graphics.setColor(Color.black);
            graphics.drawRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
        }
    }

    public void displayObjectsOn_(Graphics graphics) {
        for (int i = 0; i < this.frames().size(); ++i) {
            Object[] objectArray = (Object[])this.frames().get(i);
            StSymbol stSymbol = (StSymbol)objectArray[0];
            StRectangle stRectangle = (StRectangle)objectArray[objectArray.length - 1];
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"hours")) {
                this.displayOn_hours_clip_(graphics, stSymbol, stRectangle);
            }
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"minutes")) {
                this.displayOn_minutes_clip_(graphics, stSymbol, stRectangle);
            }
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"seconds")) {
                this.displayOn_seconds_clip_(graphics, stSymbol, stRectangle);
            }
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"label")) {
                this.displayOn_label_clip_(graphics, (String)objectArray[1], stRectangle);
            }
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"button")) {
                this.displayOn_button_clip_(graphics, (StSymbol)objectArray[1], stRectangle);
            }
            if (stSymbol != JunCalendarTimeViewSwing.$((String)"clock")) continue;
            this.displayOn_clock_clip_(graphics, stSymbol, stRectangle);
        }
    }

    public void displayOn_hours_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        int n = this.getModel().hours();
        String string = String.valueOf(n);
        if (string.length() < 2) {
            string = "0".concat(string);
        }
        StComposedText stComposedText = new StComposedText(string);
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_minutes_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        int n = this.getModel().minutes();
        String string = String.valueOf(n);
        if (string.length() < 2) {
            string = "0".concat(string);
        }
        StComposedText stComposedText = new StComposedText(string);
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_seconds_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        int n = this.getModel().seconds();
        String string = String.valueOf(n);
        if (string.length() < 2) {
            string = "0".concat(string);
        }
        StComposedText stComposedText = new StComposedText(string);
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_label_clip_(Graphics graphics, String string, StRectangle stRectangle) {
        StComposedText stComposedText = new StComposedText(string);
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.leftCenter(), stRectangle.leftCenter());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_button_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        StRectangle stRectangle2 = stRectangle;
        StRectangle stRectangle3 = new StRectangle(graphics.getClipBounds());
        if (stRectangle3.intersects_(stRectangle2)) {
            Polygon polygon;
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"hourDown") || stSymbol == JunCalendarTimeViewSwing.$((String)"minuteDown") || stSymbol == JunCalendarTimeViewSwing.$((String)"secondDown")) {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
                polygon.addPoint(stRectangle2.bottomRight().x, stRectangle2.bottomRight().y);
                polygon.addPoint(stRectangle2.leftCenter().x, stRectangle2.leftCenter().y);
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
            } else {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
                polygon.addPoint(stRectangle2.bottomLeft().x, stRectangle2.bottomLeft().y);
                polygon.addPoint(stRectangle2.rightCenter().x, stRectangle2.rightCenter().y);
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
            }
            graphics.setColor(veryLightGray);
            graphics.fillPolygon(polygon);
            stRectangle2 = stRectangle2.insetBy_(new StRectangle(1, 1, 2, 2));
            if (stSymbol == JunCalendarTimeViewSwing.$((String)"hourDown") || stSymbol == JunCalendarTimeViewSwing.$((String)"minuteDown") || stSymbol == JunCalendarTimeViewSwing.$((String)"secondDown")) {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
                polygon.addPoint(stRectangle2.bottomRight().x, stRectangle2.bottomRight().y);
                polygon.addPoint(stRectangle2.leftCenter().x, stRectangle2.leftCenter().y);
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
            } else {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
                polygon.addPoint(stRectangle2.bottomLeft().x, stRectangle2.bottomLeft().y);
                polygon.addPoint(stRectangle2.rightCenter().x, stRectangle2.rightCenter().y);
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
            }
            graphics.setColor(veryDarkGray);
            graphics.drawPolygon(polygon);
        }
    }

    public void displayOn_clock_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        this.displayOn_clockBackground_clip_(graphics, stSymbol, stRectangle);
        this.displayOn_clockShortHand_clip_(graphics, stSymbol, stRectangle);
        this.displayOn_clockLongHand_clip_(graphics, stSymbol, stRectangle);
        this.displayOn_clockTickHand_clip_(graphics, stSymbol, stRectangle);
    }

    public void displayOn_clockBackground_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        StRectangle stRectangle2 = new StRectangle(graphics.getClipBounds());
        if (stRectangle2.intersects_(stRectangle)) {
            StComposedText stComposedText;
            graphics.setColor(Color.black);
            Jun2dPoint jun2dPoint = new Jun2dPoint(stRectangle.center());
            double d = Math.min(stRectangle.width(), stRectangle.height()) / 2 - new StComposedText(" ").height();
            StRectangle stRectangle3 = StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(2, 2));
            for (int i = 1; i <= 12; ++i) {
                stComposedText = new StComposedText(String.valueOf(i));
                double d2 = (i - 3) * 30;
                double d3 = Math.cos(Math.toRadians(d2));
                double d4 = Math.sin(Math.toRadians(d2));
                stComposedText.displayOn_at_(graphics, jun2dPoint.plus_(1.0).plus_(new Jun2dPoint(d3, d4).multipliedBy_(d)).minus_(new Jun2dPoint(stComposedText.extent().width, stComposedText.extent().height).dividedBy_(2.0))._toPoint());
                Point point = jun2dPoint.plus_(new Jun2dPoint(d3, d4).multipliedBy_(d - 10.0))._toPoint();
                graphics.fillRect(point.x, point.y, stRectangle3.width(), stRectangle3.height());
            }
            stComposedText = new StComposedText(JunSystem.$String((String)"a.m.", (String)"am"));
            stRectangle3 = new StRectangle(stComposedText.bounds());
            stRectangle3 = stRectangle3.align_with_(stRectangle3.bottomLeft(), stRectangle.insetBy_(8).bottomLeft());
            if (this.getModel().hours() >= 12) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
            stComposedText = new StComposedText(JunSystem.$String((String)"p.m.", (String)"pm"));
            stRectangle3 = new StRectangle(stComposedText.bounds());
            stRectangle3 = stRectangle3.align_with_(stRectangle3.bottomRight(), stRectangle.insetBy_(8).bottomRight());
            if (this.getModel().hours() >= 12) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.lightGray);
            }
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_clockShortHand_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        StRectangle stRectangle2 = new StRectangle(graphics.getClipBounds());
        if (stRectangle2.intersects_(stRectangle)) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(stRectangle.center());
            double d = Math.min(stRectangle.width(), stRectangle.height()) / 2 - new StComposedText(" ").height() - 8;
            double d2 = this.getModel().minutes();
            double d3 = (double)(this.getModel().hours() * 5) + d2 / 12.0;
            double d4 = Math.cos(Math.toRadians(d3 * 6.0 - 90.0));
            double d5 = Math.sin(Math.toRadians(d3 * 6.0 - 90.0));
            Vector<StObject> vector = new Vector<StObject>();
            vector.add(jun2dPoint.plus_((Jun2dPoint)((Object)this.rotateBlock().value_value_((Object)new Jun2dPoint(d4 * 3.0, d5 * 3.0), (Object)new Double(-180.0)))));
            vector.add(jun2dPoint.plus_((Jun2dPoint)((Object)this.rotateBlock().value_value_((Object)new Jun2dPoint(d4 * 3.0, d5 * 3.0), (Object)new Double(-90.0)))));
            vector.add(jun2dPoint.plus_(new Jun2dPoint(d4, d5).multipliedBy_(d * 6.0 / 10.0)));
            vector.add(jun2dPoint.plus_((Jun2dPoint)((Object)this.rotateBlock().value_value_((Object)new Jun2dPoint(d4 * 3.0, d5 * 3.0), (Object)new Double(90.0)))));
            vector.add(((Jun2dPoint)((Object)vector.firstElement())).copy());
            Polygon polygon = new Polygon();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Jun2dPoint jun2dPoint2 = ((Jun2dPoint)((Object)iterator.next())).rounded();
                int n = (int)jun2dPoint2.x();
                int n2 = (int)jun2dPoint2.y();
                polygon.addPoint(n, n2);
            }
            ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 0));
            graphics.setColor(Color.lightGray);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }
    }

    public void displayOn_clockLongHand_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        StRectangle stRectangle2 = new StRectangle(graphics.getClipBounds());
        if (stRectangle2.intersects_(stRectangle)) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(stRectangle.center());
            double d = Math.min(stRectangle.width(), stRectangle.height()) / 2 - new StComposedText(" ").height() - 8;
            double d2 = this.getModel().minutes();
            double d3 = Math.cos(Math.toRadians(d2 * 6.0 - 90.0));
            double d4 = Math.sin(Math.toRadians(d2 * 6.0 - 90.0));
            Vector<StObject> vector = new Vector<StObject>();
            vector.add(jun2dPoint.plus_((Jun2dPoint)((Object)this.rotateBlock().value_value_((Object)new Jun2dPoint(d3 * 3.0, d4 * 3.0), (Object)new Double(-180.0)))));
            vector.add(jun2dPoint.plus_((Jun2dPoint)((Object)this.rotateBlock().value_value_((Object)new Jun2dPoint(d3 * 3.0, d4 * 3.0), (Object)new Double(-90.0)))));
            vector.add(jun2dPoint.plus_(new Jun2dPoint(d3, d4).multipliedBy_(d * 9.0 / 10.0)));
            vector.add(jun2dPoint.plus_((Jun2dPoint)((Object)this.rotateBlock().value_value_((Object)new Jun2dPoint(d3 * 3.0, d4 * 3.0), (Object)new Double(90.0)))));
            vector.add(((Jun2dPoint)((Object)vector.firstElement())).copy());
            Polygon polygon = new Polygon();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Jun2dPoint jun2dPoint2 = ((Jun2dPoint)((Object)iterator.next())).rounded();
                int n = (int)jun2dPoint2.x();
                int n2 = (int)jun2dPoint2.y();
                polygon.addPoint(n, n2);
            }
            ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 0));
            graphics.setColor(Color.lightGray);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }
    }

    public void displayOn_clockTickHand_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        StRectangle stRectangle2 = new StRectangle(graphics.getClipBounds());
        if (stRectangle2.intersects_(stRectangle)) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(stRectangle.center());
            double d = Math.min(stRectangle.width(), stRectangle.height()) / 2 - new StComposedText(" ").height() - 4;
            double d2 = d * 9.5 / 10.0;
            double d3 = this.getModel().seconds();
            double d4 = Math.cos(Math.toRadians(d3 * 6.0 - 90.0));
            double d5 = Math.sin(Math.toRadians(d3 * 6.0 - 90.0));
            ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 0));
            graphics.setColor(Color.black);
            Point point = jun2dPoint._toPoint();
            Point point2 = jun2dPoint.plus_(new Jun2dPoint(d4, d5).multipliedBy_(d2))._toPoint();
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    public void update_(DependentEvent dependentEvent) {
        this.makeFrames();
        if (!this.isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunCalendarTimeViewSwing.$((String)"hours")) {
            this.repaint();
        }
        if (dependentEvent.getAspect() == JunCalendarTimeViewSwing.$((String)"minutes")) {
            this.repaint();
        }
        if (dependentEvent.getAspect() == JunCalendarTimeViewSwing.$((String)"seconds")) {
            this.repaint();
        }
        super.update_(dependentEvent);
    }

    public JunCalendarTimeModel getModel() {
        return (JunCalendarTimeModel)this.model();
    }

    protected StController defaultController() {
        return new JunCalendarTimeController();
    }

    protected void buildComponent() {
        this.setPreferredSize(new Dimension(150, 200));
        this.setMinimumSize(new Dimension(150, 150));
        this.setMaximumSize(new Dimension(300, 300));
    }

    protected StModel defaultModel() {
        return new JunCalendarTimeModel();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.makeFrames();
    }
}

