/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.catalog;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import jp.co.sra.jun.goodies.catalog.JunVisualCatalog;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

public class JunImageCatalog
extends JunVisualCatalog {
    protected int[] visualClip;

    public JunImageCatalog() {
    }

    public JunImageCatalog(File file) {
        super(file);
    }

    public JunImageCatalog(File file, File file2) {
        super(file, file2);
    }

    public static JunVisualCatalog Dive_(File file) {
        return JunImageCatalog._Dive_catalog_(file, new JunImageCatalog());
    }

    public static JunVisualCatalog Dive_block_(File file, StBlockClosure stBlockClosure) {
        return JunImageCatalog._Dive_block_catalog_(file, stBlockClosure, new JunImageCatalog());
    }

    protected void initialize() {
        super.initialize();
        this.visualClip = null;
    }

    public int[] visualClip() {
        return this.visualClip;
    }

    public void visualClip_(int[] nArray) {
        this.visualClip = nArray;
    }

    public void visualClip_(Point point) {
        this.visualClip = new int[]{point.x, point.y};
    }

    public String defaultTitleString() {
        return "Image Catalog";
    }

    public String defaultVisualCatalogDirectoryName() {
        return "ImageCatalog";
    }

    public String defaultVisualClipDirectoryName() {
        return "images";
    }

    public File[] visualClipFiles() {
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            String string = fileArray[i].getName();
            fileArray2[i] = file = new File(this.visualClipDirectory(), string);
        }
        return fileArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeVisualClipFiles() {
        this.progressValue.value_(0.0f);
        int n = 1;
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = this.visualClipFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = JunImageCatalog.$String((String)"Image:") + " " + fileArray2[i].getName();
            this.progressMessage.value_((Object)JunStringUtility._ContractString_to_(string, this.defaultContractLength()));
            if (!fileArray[i].equals(fileArray2[i])) {
                StImage stImage = null;
                JunMoviePlayer junMoviePlayer = null;
                try {
                    junMoviePlayer = new JunMoviePlayer(fileArray[i]);
                    stImage = junMoviePlayer.asImage();
                }
                finally {
                    if (junMoviePlayer != null) {
                        junMoviePlayer.release();
                        junMoviePlayer = null;
                    }
                }
                JunImageAdjuster junImageAdjuster = new JunImageAdjuster();
                Dimension dimension = this.imageClipExtent_(stImage);
                stImage = junImageAdjuster.adjust_extent_(stImage, dimension);
                try {
                    JunImageUtility.WriteImage_to_(stImage, fileArray2[i]);
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
            this.progressValue.value_((float)n / (float)this.numberOfVisuals());
            ++n;
        }
    }

    public boolean incluesExtensions_(String string) {
        String string2 = string.toLowerCase();
        return Arrays.asList(JunSystem.DefaultImageExtensions()).contains(string2);
    }

    protected Dimension imageClipExtent_(StImage stImage) {
        Dimension dimension = null;
        dimension = this.visualClip() == null ? stImage.bounds().getSize() : this.proportionalExtentOfImage_within_(stImage, new Dimension(this.visualClip()[0], this.visualClip()[1]));
        return dimension;
    }
}

