/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunDrawingVisual
extends StModel
implements Transferable,
StDisplayable {
    protected long id;
    protected static final SimpleDateFormat _UniqueNumberDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    protected static long _UniqueNumberGenerationTime = Long.MIN_VALUE;

    public static long GenerateUniqueNumber() {
        long l;
        while (_UniqueNumberGenerationTime >= (l = System.currentTimeMillis())) {
        }
        _UniqueNumberGenerationTime = l;
        return Long.parseLong(_UniqueNumberDateFormat.format(new Date(_UniqueNumberGenerationTime)));
    }

    public JunDrawingVisual() {
        this.initialize();
        this.assignId();
    }

    public JunDrawingVisual(JunLispList junLispList) {
        this.initialize();
        this.fromLispList_(junLispList);
    }

    protected void initialize() {
        this.id = Long.MIN_VALUE;
    }

    public long assignId() {
        this.id = JunDrawingVisual.GenerateUniqueNumber();
        return this.id;
    }

    public long id() {
        if (!this.hasId()) {
            this.assignId();
        }
        return this.id;
    }

    public void id_(long l) {
        this.id = l;
    }

    public Rectangle bounds() {
        return this.preferredBounds();
    }

    public void bounds_(Rectangle rectangle) {
        this.location_(rectangle.getLocation());
        this.extent_(rectangle.getSize());
    }

    public Rectangle preferredBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    public int x() {
        return this.bounds().x;
    }

    public int y() {
        return this.bounds().y;
    }

    public int width() {
        return this.bounds().width;
    }

    public int height() {
        return this.bounds().height;
    }

    public Point location() {
        return this.bounds().getLocation();
    }

    public abstract void location_(Point var1);

    public void location_(int n, int n2) {
        this.location_(new Point(n, n2));
    }

    public Dimension extent() {
        return this.bounds().getSize();
    }

    public Point extentPoint() {
        return this.isRectangular() ? new Point(this.x() + this.width() - 1, this.y() + this.height() - 1) : new Point(this.x() + this.width(), this.y() + this.height());
    }

    public abstract void extent_(Dimension var1);

    public void extent_(int n, int n2) {
        this.extent_(new Dimension(n, n2));
    }

    public Point center() {
        return new Point(this.x() + this.width() / 2, this.y() + this.height() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage asImage() {
        int n = this.width();
        int n2 = this.height();
        StImage stImage = new StImage(n, n2);
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)stImage.image().getGraphics();
            graphics2D.setClip(0, 0, n, n2);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(Color.black);
            this.displayOn_(graphics2D);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
        return stImage;
    }

    public StObject copy() {
        return this.copy(new HashMap());
    }

    public JunDrawingVisual copy(Map map) {
        JunDrawingVisual junDrawingVisual = (JunDrawingVisual)this.shallowCopy();
        map.put(this, junDrawingVisual);
        return junDrawingVisual.postCopy(map);
    }

    public StObject postCopy() {
        return this.postCopy(new HashMap());
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy();
        if (this.hasId()) {
            this.assignId();
        }
        return this;
    }

    public Point defaultLocation() {
        return new Point(0, 0);
    }

    public Dimension defaultExtent() {
        return new Dimension(96, 48);
    }

    public Dimension defaultMinimumExtent() {
        return new Dimension(20, 20);
    }

    public abstract void displayOn_(Graphics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_(Graphics graphics, Point point) {
        graphics.translate(point.x, point.y);
        try {
            this.displayOn_(graphics);
        }
        finally {
            graphics.translate(-point.x, -point.y);
        }
    }

    public Point nearestPointFromPoint_(Point point) {
        Jun2dPoint jun2dPoint;
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(this.center());
        double d = jun2dPoint2.distance_(jun2dPoint = new Jun2dPoint(point));
        if (d < JunGeometry.Accuracy()) {
            return jun2dPoint2._toPoint();
        }
        Jun2dPoint[] jun2dPointArray = new Jun2dBoundingBox(this.bounds()).intersectingPointsWithLine_(new Jun2dLine(jun2dPoint2, jun2dPoint));
        if (jun2dPointArray != null && jun2dPointArray.length > 0) {
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                double d2 = jun2dPointArray[i].distance_(jun2dPoint);
                if (!(d2 < d)) continue;
                return jun2dPointArray[i]._toPoint();
            }
        }
        return point;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("a ");
        writer.write(this._className().toString());
        writer.write("(id=");
        writer.write(String.valueOf(this.id));
        writer.write(")");
    }

    public boolean containsPoint_(Point point) {
        return this.bounds().contains(point);
    }

    public boolean intersects_(Rectangle rectangle) {
        return this.bounds().intersects(rectangle);
    }

    public boolean isComposite() {
        return false;
    }

    public boolean isElement() {
        return false;
    }

    public boolean isImage() {
        return false;
    }

    public boolean isLabel() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public boolean isPath() {
        return false;
    }

    public boolean isRectangular() {
        return false;
    }

    public boolean isVertexes() {
        return false;
    }

    public boolean hasId() {
        return this.id != Long.MIN_VALUE;
    }

    public boolean hasLabel() {
        return false;
    }

    public abstract DataFlavor[] getTransferDataFlavors();

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this;
    }

    public void openProperties() {
    }

    protected StSymbol kindName() {
        return this._className();
    }

    protected JunLispCons lispCons() {
        return JunLispCons.Cell();
    }

    protected JunLispNil lispNil() {
        return JunLispNil.NullList();
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        junLispCons.add_((Object)this.idToLispList());
        return junLispCons;
    }

    protected JunLispCons idToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunDrawingVisual.$((String)"id"));
        junLispCons.tail_(new Long(this.id()));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        this.idFromLispList_(junLispList);
    }

    protected void idFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"id"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.id_(((Number)junLispList2.tail()).longValue());
    }
}

