/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunVertexesElement;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class JunFreehandElement
extends JunVertexesElement {
    protected Point elementLocation;
    protected Dimension elementExtent;
    protected transient Dimension minimumExtent;
    public static DataFlavor DataFlavor = new DataFlavor(JunFreehandElement.class, "JunFreehandElement");

    public JunFreehandElement() {
    }

    public JunFreehandElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.elementLocation = null;
        this.elementExtent = null;
        this.minimumExtent = null;
    }

    public Point location() {
        if (this.elementLocation == null) {
            this.elementLocation = this.points().isEmpty() ? this.defaultLocation() : this.pointBounds().getLocation();
        }
        return this.elementLocation;
    }

    public void location_(Point point) {
        this.elementLocation = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        this.flushBounds();
    }

    public Dimension extent() {
        if (this.elementExtent == null) {
            this.elementExtent = this.points().isEmpty() ? this.defaultExtent() : this.pointBounds().getSize();
        }
        return this.elementExtent;
    }

    public void extent_(Dimension dimension) {
        this.elementExtent = new Dimension(Math.max(dimension.width, this.defaultMinimumExtent().width), Math.max(dimension.height, this.defaultMinimumExtent().height));
        this.flushBounds();
    }

    public void bounds_(Rectangle rectangle) {
        Rectangle rectangle2 = this.preferredBounds();
        int n = rectangle.x - (rectangle2.x - this.location().x);
        int n2 = rectangle.y - (rectangle2.y - this.location().y);
        int n3 = rectangle.width - (rectangle2.width - this.extent().width);
        int n4 = rectangle.height - (rectangle2.height - this.extent().height);
        if (this.defaultMinimumExtent().width >= n3) {
            n = this.location().x;
            n3 = this.extent().width;
        }
        if (this.defaultMinimumExtent().height >= n4) {
            n2 = this.location().y;
            n4 = this.extent().height;
        }
        super.bounds_(new Rectangle(n, n2, n3, n4));
    }

    public HashMap controllPoints() {
        Point point = this.location();
        Point point2 = this.extentPoint();
        HashMap<StSymbol, Point> hashMap = new HashMap<StSymbol, Point>();
        hashMap.put(JunDrawingElement.CONTROLL_POINT_TOP_LEFT, new Point(point.x, point.y));
        hashMap.put(JunDrawingElement.CONTROLL_POINT_TOP_RIGHT, new Point(point2.x, point.y));
        hashMap.put(JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT, new Point(point.x, point2.y));
        hashMap.put(JunDrawingElement.CONTROLL_POINT_BOTTOM_RIGHT, new Point(point2.x, point2.y));
        return hashMap;
    }

    public void controllPointAt_put_(StSymbol stSymbol, Point point) {
        int n;
        Rectangle rectangle = this.bounds();
        Point point2 = this.controllPointAt_(stSymbol);
        boolean bl = stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_RIGHT;
        boolean bl2 = stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT;
        int n2 = Math.max(point.x, 0) - point2.x;
        int n3 = Math.max(point.y, 0) - point2.y;
        int n4 = bl2 ? Math.max(rectangle.x + n2, 0) : rectangle.x;
        int n5 = bl ? Math.max(rectangle.y + n3, 0) : rectangle.y;
        int n6 = bl2 ? rectangle.width + (rectangle.x - n4) : Math.max(rectangle.width + n2, this.defaultMinimumExtent().width);
        int n7 = n = bl ? rectangle.height + (rectangle.y - n5) : Math.max(rectangle.height + n3, this.defaultMinimumExtent().height);
        if (n6 < this.defaultMinimumExtent().width) {
            n4 += n6 - this.defaultMinimumExtent().width;
            n6 = this.defaultMinimumExtent().width;
        }
        if (n < this.defaultMinimumExtent().height) {
            n5 += n - this.defaultMinimumExtent().height;
            n = this.defaultMinimumExtent().height;
        }
        this.bounds_(new Rectangle(n4, n5, n6, n));
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        this.location_(new Point(this.elementLocation));
        this.extent_(new Dimension(this.elementExtent));
        this.minimumExtent = null;
        return this;
    }

    public Dimension defaultMinimumExtent() {
        if (this.minimumExtent == null) {
            int n;
            int n2;
            Rectangle rectangle = this.preferredBounds();
            Rectangle rectangle2 = new Rectangle(this.location(), this.extent());
            int n3 = rectangle.width - rectangle2.width;
            int n4 = rectangle.height - rectangle2.height;
            Rectangle rectangle3 = this.pointBounds();
            if (rectangle3.width > rectangle3.height) {
                double d = 20.0 / (double)rectangle3.width;
                n2 = Math.max(1, Math.min(20, rectangle3.width));
                n = Math.max(1, (int)((double)rectangle3.height * d));
            } else {
                double d = 20.0 / (double)rectangle3.height;
                n2 = Math.max(1, (int)((double)rectangle3.width * d));
                n = Math.max(1, Math.min(20, rectangle3.height));
            }
            this.minimumExtent = new Dimension(n2 + n3, n + n4);
        }
        return this.minimumExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.displayOn_(graphics2D);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    public boolean isRectangular() {
        return true;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor};
    }

    protected Shape[] shapes() {
        if (this.shapes == null) {
            Rectangle rectangle = this.pointBounds();
            Point point = this.location();
            Dimension dimension = this.extent();
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            Point[] pointArray = this._points();
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < pointArray.length; ++i) {
                int n3;
                int n4 = rectangle.width == 1 ? pointArray[i].x - n : point.x + Math.max(Math.round((float)((pointArray[i].x - n - point.x) * dimension.width) / (float)rectangle.width), 0);
                int n5 = n3 = rectangle.height == 1 ? pointArray[i].y - n2 : point.y + Math.max(Math.round((float)((pointArray[i].y - n2 - point.y) * dimension.height) / (float)rectangle.height), 0);
                if (i == 0) {
                    generalPath.moveTo(n4, n3);
                    continue;
                }
                generalPath.lineTo(n4, n3);
            }
            this.shapes = new Shape[]{generalPath};
        }
        return this.shapes;
    }

    protected BasicStroke stroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.lineWidth(), 0, 1);
        }
        return this.stroke;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        junLispCons.add_((Object)this.locationToLispList());
        junLispCons.add_((Object)this.extentToLispList());
        return junLispCons;
    }

    protected JunLispCons locationToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandElement.$((String)"location"));
        junLispCons.tail_((Object)new Jun2dPoint(this.location()));
        return junLispCons;
    }

    protected JunLispCons extentToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunFreehandElement.$((String)"extent"));
        junLispCons.tail_((Object)new Jun2dPoint(this.extent().width, this.extent().height));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.locationFromLispList_(junLispList);
        this.extentFromLispList_(junLispList);
    }

    protected void locationFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"location"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.location_(((Jun2dPoint)((Object)junLispList2.tail()))._toPoint());
    }

    protected void extentFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"extent"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        Point point = ((Jun2dPoint)((Object)junLispList2.tail()))._toPoint();
        this.extent_(new Dimension(point.x, point.y));
    }
}

