/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import jp.co.sra.jun.goodies.drawing.element.JunCompositeElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunLabelElement;
import jp.co.sra.jun.goodies.drawing.element.JunLinkElement;
import jp.co.sra.jun.goodies.drawing.element.JunVertexesElement;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class JunDrawingMap
extends JunDrawingVisual {
    protected ArrayList componentElements;
    protected transient Rectangle preferredBounds;
    protected transient ArrayList selectedElements;
    public static final Color CONTROLL_AREA_BORDER_COLOR = Color.darkGray;
    public static final Color CONTROLL_AREA_DONTMOVE_BORDER_COLOR = Color.lightGray;
    public static final Color CONTROLL_AREA_BACKGROUND_COLOR = Color.white;
    public static DataFlavor DataFlavor = new DataFlavor(JunDrawingMap.class, "JunDrawingMap");

    public JunDrawingMap() {
    }

    public JunDrawingMap(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.componentElements = null;
        this.preferredBounds = null;
        this.selectedElements = null;
    }

    public ArrayList componentElements() {
        if (this.componentElements == null) {
            this.componentElements = new ArrayList();
        }
        return this.componentElements;
    }

    public void componentElements_(ArrayList arrayList) {
        this.componentElements = arrayList;
        this.flushBounds();
    }

    public JunDrawingElement[] _componentElements() {
        JunDrawingElement[] junDrawingElementArray = new JunDrawingElement[this.componentElementSize()];
        this.componentElements().toArray(junDrawingElementArray);
        return junDrawingElementArray;
    }

    public JunDrawingElement componentElementAt_(int n) {
        if (this.componentElements().isEmpty()) {
            return null;
        }
        if (n < 0 || this.componentElementSize() <= n) {
            return null;
        }
        return (JunDrawingElement)this.componentElements().get(n);
    }

    public int componentElementIndexOf_(JunDrawingElement junDrawingElement) {
        return this.componentElements().indexOf(junDrawingElement);
    }

    public int componentElementSize() {
        return this.componentElements().size();
    }

    public ArrayList labelElements() {
        ArrayList<JunDrawingElement> arrayList = new ArrayList<JunDrawingElement>();
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            if (!junDrawingElementArray[i].isLabel()) continue;
            arrayList.add(junDrawingElementArray[i]);
        }
        return arrayList;
    }

    public JunLabelElement[] _labelElements() {
        ArrayList arrayList = this.labelElements();
        return arrayList.toArray(new JunLabelElement[arrayList.size()]);
    }

    public ArrayList linkElements() {
        ArrayList<JunDrawingElement> arrayList = new ArrayList<JunDrawingElement>();
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            if (!junDrawingElementArray[i].isLink()) continue;
            arrayList.add(junDrawingElementArray[i]);
        }
        return arrayList;
    }

    public JunLinkElement[] _linkElements() {
        ArrayList arrayList = this.linkElements();
        return arrayList.toArray(new JunLinkElement[arrayList.size()]);
    }

    public boolean addElement_(JunDrawingElement junDrawingElement) {
        if (junDrawingElement == null || this.componentElements().contains(junDrawingElement)) {
            return false;
        }
        this.flushBounds();
        junDrawingElement.parent_(this);
        return this.componentElements().add(junDrawingElement);
    }

    public void addElement_beforeIndex_(JunDrawingElement junDrawingElement, int n) {
        if (junDrawingElement == null || this.componentElements().contains(junDrawingElement)) {
            return;
        }
        if (0 <= n && n < this.componentElementSize()) {
            this.componentElements().add(n, junDrawingElement);
        } else {
            this.componentElements().add(junDrawingElement);
        }
        junDrawingElement.parent_(this);
        this.flushBounds();
    }

    public void location_(Point point) {
        throw SmalltalkException.ShouldNotImplement();
    }

    public void extent_(Dimension dimension) {
        throw SmalltalkException.ShouldNotImplement();
    }

    public Rectangle preferredBounds() {
        if (this.preferredBounds == null) {
            this.preferredBounds = super.preferredBounds();
            JunDrawingElement[] junDrawingElementArray = this._componentElements();
            for (int i = 0; i < junDrawingElementArray.length; ++i) {
                this.preferredBounds.add(junDrawingElementArray[i].bounds());
                Iterator iterator = junDrawingElementArray[i].controllPointAreas().values().iterator();
                while (iterator.hasNext()) {
                    this.preferredBounds.add((Rectangle)iterator.next());
                }
            }
            this.preferredBounds.setSize(this.preferredBounds.width + 1, this.preferredBounds.height + 1);
        }
        return this.preferredBounds;
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        ArrayList arrayList = new ArrayList();
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            arrayList.add(map.containsKey(junDrawingElementArray[i]) ? map.get(junDrawingElementArray[i]) : junDrawingElementArray[i].copy(map));
        }
        this.componentElements_(arrayList);
        return this;
    }

    public void displayOn_(Graphics graphics) {
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            junDrawingElementArray[i].displayOn_(graphics);
            if (!this.selectedElements().contains(junDrawingElementArray[i])) continue;
            HashMap hashMap = junDrawingElementArray[i].controllPointAreas();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                StSymbol stSymbol = (StSymbol)iterator.next();
                Rectangle rectangle = (Rectangle)hashMap.get(stSymbol);
                graphics.setColor(CONTROLL_AREA_BACKGROUND_COLOR);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (junDrawingElementArray[i].isLink() && (stSymbol == JunVertexesElement.CONTROLL_POINT_BEGIN || stSymbol == JunVertexesElement.CONTROLL_POINT_END)) {
                    graphics.setColor(CONTROLL_AREA_DONTMOVE_BORDER_COLOR);
                } else {
                    graphics.setColor(CONTROLL_AREA_BORDER_COLOR);
                }
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public Object elementsDo_(StBlockClosure stBlockClosure) {
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            stBlockClosure.value_((Object)junDrawingElementArray[i]);
            if (!junDrawingElementArray[i].isComposite()) continue;
            ((JunCompositeElement)junDrawingElementArray[i]).elementsDo_(stBlockClosure);
        }
        return this;
    }

    public JunDrawingElement findElement_(long l) {
        if (l < 0L || this.componentElementSize() == 0) {
            return null;
        }
        Iterator iterator = this.componentElements().iterator();
        while (iterator.hasNext()) {
            JunDrawingElement junDrawingElement = ((JunDrawingElement)iterator.next()).findElement_(l);
            if (junDrawingElement == null) continue;
            return junDrawingElement;
        }
        return null;
    }

    protected void flushBounds() {
        this.preferredBounds = null;
    }

    protected void flushSelectedElements() {
        this.selectedElements = null;
    }

    public boolean removeElement_(JunDrawingElement junDrawingElement) {
        if (!this.componentElements().contains(junDrawingElement)) {
            return false;
        }
        this.removeSelectedElement_(junDrawingElement);
        boolean bl = this.componentElements().remove(junDrawingElement);
        junDrawingElement.parent_(null);
        this.flushBounds();
        return bl;
    }

    public void removeSelectedElements() {
        if (this.selectedElements().isEmpty()) {
            return;
        }
        JunDrawingElement[] junDrawingElementArray = this._selectedElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            this.removeElement_(junDrawingElementArray[i]);
            if (junDrawingElementArray[i].hasLabel()) {
                JunLinkElement junLinkElement = (JunLinkElement)junDrawingElementArray[i];
                JunLabelElement junLabelElement = junLinkElement.labelElement();
                if (this.selectedElements().contains(junLabelElement)) continue;
                junLinkElement.labelElement_(null);
                this.removeElement_(junLabelElement);
                continue;
            }
            if (!junDrawingElementArray[i].isLabel()) continue;
            ((JunLabelElement)junDrawingElementArray[i]).baseElement().labelElement_(null);
        }
        JunLinkElement[] junLinkElementArray = this._linkElements();
        for (int i = 0; i < junLinkElementArray.length; ++i) {
            if (junLinkElementArray[i].checkElement()) continue;
            this.removeElement_(junLinkElementArray[i]);
        }
        JunLabelElement[] junLabelElementArray = this._labelElements();
        for (int i = 0; i < junLabelElementArray.length; ++i) {
            if (junLabelElementArray[i].checkElement()) continue;
            this.removeElement_(junLabelElementArray[i]);
        }
    }

    public JunDrawingElement which_(Point point) {
        ListIterator listIterator = this.componentElements().listIterator(this.componentElementSize());
        while (listIterator.hasPrevious()) {
            JunDrawingElement junDrawingElement = (JunDrawingElement)listIterator.previous();
            if (!junDrawingElement.containsPoint_(point) && (!this.selectedElements().contains(junDrawingElement) || !junDrawingElement.containsPointInControllArea_(point))) continue;
            return junDrawingElement;
        }
        return null;
    }

    public ArrayList selectedElements() {
        if (this.selectedElements == null) {
            this.selectedElements = new ArrayList();
        }
        return this.selectedElements;
    }

    public JunDrawingElement[] _selectedElements() {
        return this.selectedElements().toArray(new JunDrawingElement[this.selectedElements().size()]);
    }

    public boolean addSelectedElement_(JunDrawingElement junDrawingElement) {
        if (this.selectedElements().contains(junDrawingElement)) {
            return false;
        }
        return this.selectedElements().add(junDrawingElement);
    }

    public boolean removeSelectedElement_(JunDrawingElement junDrawingElement) {
        if (!this.selectedElements().contains(junDrawingElement)) {
            return false;
        }
        return this.selectedElements().remove(junDrawingElement);
    }

    public JunDrawingElement currentElement() {
        if (this.selectedElements().isEmpty()) {
            return null;
        }
        return (JunDrawingElement)this.selectedElements().get(this.selectedElements().size() - 1);
    }

    public void clearSelectedElements() {
        this.selectedElements = new ArrayList();
    }

    public void selectAll() {
        this.flushSelectedElements();
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            this.addSelectedElement_(junDrawingElementArray[i]);
        }
    }

    public boolean isComposite() {
        return true;
    }

    public boolean isEmpty() {
        return this.componentElements().isEmpty();
    }

    public boolean isMap() {
        return true;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor};
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        JunLispCons junLispCons2 = this.componentElementsToLispList();
        if (junLispCons2 != null) {
            junLispCons.add_((Object)junLispCons2);
        }
        return junLispCons;
    }

    protected JunLispCons componentElementsToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunDrawingMap.$((String)"componentElements"));
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            junLispCons.add_((Object)junDrawingElementArray[i].toLispList());
        }
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.componentElementsFromLispList_(junLispList);
    }

    protected void componentElementsFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"componentElements"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        Object[] objectArray = ((JunLispList)((Object)junLispList2.tail())).asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            JunDrawingElement junDrawingElement = JunDrawingElement.FromLispList_((JunLispList)((Object)objectArray[i]));
            this.addElement_(junDrawingElement);
        }
    }
}

