/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunLabelElement;
import jp.co.sra.jun.goodies.drawing.element.JunLinkElement;
import jp.co.sra.jun.goodies.drawing.element.JunNodeElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.element.JunVertexesElement;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMap;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModel;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunDrawingMapController
extends JunAbstractController {
    protected transient int dragType;
    protected transient Point startPoint;
    protected transient Point previousPoint;
    protected transient Point popupMenuPoint;
    protected transient Point offsetPoint;
    protected transient Object[][] movingElements;
    protected transient JunLinkElement[] linkedElements;
    protected transient ArrayList trackPoints;
    protected transient StSymbol controllPointSymbol;
    protected transient Jun2dPoint[][] scaleCollection;
    protected transient boolean clickElementFlag;
    protected static final int DRAG_NONE = 0;
    protected static final int DRAG_SELECT_ITEM = 1;
    protected static final int DRAG_MOVE_ITEM = 2;
    protected static final int DRAG_MOVE_POINT = 3;
    protected static final int DRAG_MOVE_LINK_POINT = 4;
    protected static final int DRAG_MOVE_LOCUS_POINT = 5;
    public static final int EDITMODE_SELECT = 0;
    public static final int EDITMODE_ADD_TEXT = 1;
    public static final int EDITMODE_ADD_TEXTBOX = 2;
    public static final int EDITMODE_ADD_IMAGE = 3;
    public static final int EDITMODE_ADD_RECTANGLE = 4;
    public static final int EDITMODE_ADD_ROUND_RECTANGLE = 5;
    public static final int EDITMODE_ADD_ELIPSE = 6;
    public static final int EDITMODE_ADD_PATH = 7;
    public static final int EDITMODE_ADD_FREEHAND = 8;
    public static final int EDITMODE_ADD_LINK = 9;

    public Point startPoint() {
        return this.startPoint;
    }

    public Point popupMenuPoint() {
        return this.popupMenuPoint;
    }

    protected void popupMenuPoint_(Point point) {
        this.popupMenuPoint = point;
    }

    public JunDrawingMapModel getDrawingMapModel() {
        return (JunDrawingMapModel)this.model();
    }

    public JunDrawingMapView getDrawingMapView() {
        Component component = this.view().toComponent();
        while (!(component instanceof JunDrawingMapView)) {
            component = component.getParent();
        }
        return (JunDrawingMapView)((Object)component);
    }

    protected void buildListener(StView stView) {
        Component component = stView.toComponent();
        component.addMouseListener((MouseListener)((Object)this));
        component.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    protected void initializeTemporaryVariables() {
        this.dragType = 0;
        this.startPoint = null;
        this.previousPoint = null;
        this.offsetPoint = null;
        this.movingElements = null;
        this.linkedElements = null;
        this.trackPoints = new ArrayList();
        this.controllPointSymbol = null;
        this.scaleCollection = null;
        this.clickElementFlag = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = this.cursorPointInModel_(mouseEvent.getPoint());
        JunDrawingMap junDrawingMap = this.getDrawingMapModel().mapObject();
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            if (this.startPoint != null) {
                junDrawingMap.changed_(JunDrawingMapController.$((String)"redisplay"));
                this.initializeTemporaryVariables();
            }
            this.popupMenuPoint_(point);
            super.mousePressed(mouseEvent);
            return;
        }
        if (this.dragType == 4) {
            this.addLink_(point);
            this.initializeTemporaryVariables();
            this.getDrawingMapView().editMode_(0);
            return;
        }
        switch (this.getDrawingMapView().editMode()) {
            case 1: {
                this.getDrawingMapModel().addTextElement();
                break;
            }
            case 2: {
                this.getDrawingMapModel().addTextboxElement();
                break;
            }
            case 3: {
                this.getDrawingMapModel().addImageElement();
                break;
            }
            case 6: {
                this.getDrawingMapModel().addEllipseElement();
                break;
            }
            case 4: {
                this.getDrawingMapModel().addRectangleElement();
                break;
            }
            case 5: {
                this.getDrawingMapModel().addRoundRectangleElement();
                break;
            }
            case 7: {
                this.getDrawingMapModel().addPathElement();
                break;
            }
            case 8: {
                this.initializeTemporaryVariables();
                this.getDrawingMapView().createOffScreen();
                this.view().toComponent().setCursor(JunCursors.BrushCursor());
                this.displayLocusPoint_(point);
                return;
            }
            case 9: {
                JunDrawingElement junDrawingElement = junDrawingMap.which_(point);
                if (junDrawingElement == null) {
                    return;
                }
                this.selectActivity_(mouseEvent);
                this.getDrawingMapModel().addLinkElement();
                return;
            }
            case 0: {
                this.initializeTemporaryVariables();
                JunDrawingElement junDrawingElement = junDrawingMap.which_(point);
                if (junDrawingMap.selectedElements().contains(junDrawingElement)) {
                    junDrawingMap.removeSelectedElement_(junDrawingElement);
                    junDrawingMap.addSelectedElement_(junDrawingElement);
                    this.clickElementFlag = true;
                } else {
                    this.selectActivity_(mouseEvent);
                }
                if (junDrawingElement != null) {
                    if (junDrawingElement.containsPointInControllArea_(point)) {
                        StSymbol stSymbol = junDrawingElement.controllPointAreaName_(point);
                        if (junDrawingElement.isLink() && (stSymbol == JunVertexesElement.CONTROLL_POINT_BEGIN || stSymbol == JunVertexesElement.CONTROLL_POINT_END)) {
                            return;
                        }
                        this.view().toComponent().setCursor(JunCursors.Quarters2Cursor());
                        this.movePoint_(mouseEvent);
                        this.dragType = 3;
                    } else {
                        this.view().toComponent().setCursor(JunCursors.HandCursor());
                        this.moveElement_with_(junDrawingElement, point);
                        this.dragType = 2;
                    }
                } else {
                    this.view().toComponent().setCursor(JunCursors.BullCursor());
                    this.selectElements_(point);
                    this.dragType = 1;
                }
                this.startPoint = point;
            }
        }
        this.getDrawingMapView().editMode_(0);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown() || System.getProperty("os.name").toLowerCase().matches(".*mac.*os.*x.*") && mouseEvent.isControlDown()) {
            super.mouseReleased(mouseEvent);
            return;
        }
        if (this.dragType == 4) {
            return;
        }
        if (this.clickElementFlag) {
            this.selectActivity_(mouseEvent);
            this.clickElementFlag = false;
        } else if (this.previousPoint != null && !this.previousPoint.equals(this.startPoint)) {
            switch (this.dragType) {
                case 1: {
                    Point point = this.cursorPointInModel_(mouseEvent.getPoint());
                    Rectangle rectangle = StRectangle.Vertex_vertex_((Point)this.startPoint, (Point)point).toRectangle();
                    rectangle.setSize(rectangle.width + 1, rectangle.height + 1);
                    this.getDrawingMapModel().changed_with_(JunDrawingMapController.$((String)"redisplay"), rectangle);
                    break;
                }
                case 2: {
                    this.getDrawingMapModel().mapObject().flushBounds();
                    this.getDrawingMapModel().mapObject().changed_(JunDrawingMapController.$((String)"location"));
                    break;
                }
                case 3: {
                    this.getDrawingMapModel().mapObject().flushBounds();
                    this.getDrawingMapModel().mapObject().changed_(JunDrawingMapController.$((String)"location"));
                    break;
                }
                case 5: {
                    this.getDrawingMapModel().addFreehandElement((ArrayList)this.trackPoints.clone());
                    this.getDrawingMapView().editMode_(0);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        this.mouseMoved(mouseEvent);
        this.initializeTemporaryVariables();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            this.startPoint = this.cursorPointInModel_(mouseEvent.getPoint());
            super.mouseClicked(mouseEvent);
            return;
        }
        if (this.getDrawingMapView().editMode() == 0 && mouseEvent.getClickCount() == 2) {
            JunDrawingElement junDrawingElement = this.getDrawingMapModel().mapObject().which_(this.cursorPointInModel_(mouseEvent.getPoint()));
            if (junDrawingElement == null) {
                return;
            }
            junDrawingElement.openProperties();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = this.cursorPointInModel_(mouseEvent.getPoint());
        if (this.dragType == 4) {
            this.displayLinkPointFrom_to_(this.startPoint, point);
            return;
        }
        JunDrawingMap junDrawingMap = this.getDrawingMapModel().mapObject();
        JunDrawingElement junDrawingElement = junDrawingMap.which_(point);
        if (junDrawingElement == null) {
            this.view().toComponent().setCursor(Cursor.getPredefinedCursor(0));
        } else if (junDrawingMap.selectedElements().contains(junDrawingElement)) {
            StSymbol stSymbol = junDrawingElement.controllPointAreaName_(point);
            if (stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_BOTTOM_RIGHT) {
                this.view().toComponent().setCursor(JunCursors.AntiObliqueCursor());
            } else if (stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_RIGHT || stSymbol == JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT) {
                this.view().toComponent().setCursor(JunCursors.NormalObliqueCursor());
            } else if (junDrawingElement.isLink() && (stSymbol == JunVertexesElement.CONTROLL_POINT_BEGIN || stSymbol == JunVertexesElement.CONTROLL_POINT_END)) {
                this.view().toComponent().setCursor(Cursor.getPredefinedCursor(0));
            } else if (stSymbol != null) {
                this.view().toComponent().setCursor(JunCursors.QuartersCursor());
            } else {
                this.view().toComponent().setCursor(JunCursors.CrossCursor());
            }
        } else {
            this.view().toComponent().setCursor(JunCursors.CrossCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.cursorPointInModel_(mouseEvent.getPoint());
        if (this.startPoint == null || point.equals(this.previousPoint)) {
            return;
        }
        if (this.previousPoint == null) {
            this.getDrawingMapView().createOffScreen();
        }
        switch (this.dragType) {
            case 1: {
                this.selectElements_(point);
                break;
            }
            case 2: {
                JunDrawingElement junDrawingElement = this.getDrawingMapModel().mapObject().which_(point);
                this.moveElement_with_(junDrawingElement, point);
                break;
            }
            case 3: {
                this.movePoint_(mouseEvent);
                break;
            }
            case 5: {
                this.displayLocusPoint_(point);
            }
        }
        this.clickElementFlag = false;
    }

    protected void selectActivity_(MouseEvent mouseEvent) {
        Point point;
        JunDrawingMapModel junDrawingMapModel = this.getDrawingMapModel();
        JunDrawingMap junDrawingMap = junDrawingMapModel.mapObject();
        JunDrawingElement junDrawingElement = junDrawingMap.which_(point = this.cursorPointInModel_(mouseEvent.getPoint()));
        if (junDrawingElement == null) {
            Rectangle rectangle = this.getDrawingMapView().areaOfElements_(junDrawingMap._selectedElements());
            if (rectangle != null) {
                rectangle.grow(3, 3);
            }
            junDrawingMap.clearSelectedElements();
            junDrawingMap.changed_with_(JunDrawingMapController.$((String)"selection"), rectangle);
        } else {
            Rectangle rectangle = new Rectangle(junDrawingElement.bounds());
            rectangle.grow(3, 3);
            if (mouseEvent.isShiftDown()) {
                if (junDrawingMap.selectedElements().contains(junDrawingElement)) {
                    if (junDrawingElement.containsPointInControllArea_(point)) {
                        junDrawingMap.changed_with_(JunDrawingMapController.$((String)"selection"), rectangle);
                    } else {
                        junDrawingMap.removeSelectedElement_(junDrawingElement);
                        junDrawingMap.changed_with_(JunDrawingMapController.$((String)"selection"), rectangle);
                    }
                } else {
                    junDrawingMap.addSelectedElement_(junDrawingElement);
                    junDrawingMap.changed_with_(JunDrawingMapController.$((String)"selection"), rectangle);
                }
            } else {
                Rectangle rectangle2 = this.getDrawingMapView().areaOfElements_(junDrawingMap._selectedElements());
                junDrawingMap.clearSelectedElements();
                junDrawingMap.addSelectedElement_(junDrawingElement);
                if (rectangle2 != null) {
                    rectangle2.grow(3, 3);
                    rectangle.add(rectangle2);
                }
                junDrawingMap.changed_with_(JunDrawingMapController.$((String)"selection"), rectangle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectElements_(Point point) {
        if (this.startPoint == null) {
            return;
        }
        Rectangle rectangle = this.previousPoint != null ? StRectangle.Vertex_vertex_((Point)this.startPoint, (Point)this.previousPoint).toRectangle() : null;
        Rectangle rectangle2 = StRectangle.Vertex_vertex_((Point)this.startPoint, (Point)point).toRectangle();
        if (rectangle != null && !point.equals(this.previousPoint)) {
            JunDrawingMap junDrawingMap = this.getDrawingMapModel().mapObject();
            Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
            boolean bl = this.getDrawingMapModel().isZooming();
            JunDrawingMapView junDrawingMapView = this.getDrawingMapView();
            Image image = junDrawingMapView.offScreen();
            Graphics2D graphics2D = junDrawingMapView.graphicsWithZoomFrom_(image);
            try {
                if (bl) {
                    if (jun2dPoint.x() < 0.2 || jun2dPoint.y() < 0.2) {
                        rectangle.grow((int)(1.0 / jun2dPoint.x()), (int)(1.0 / jun2dPoint.y()));
                    } else {
                        rectangle.grow(5, 5);
                    }
                }
                graphics2D.setColor(this.view().toComponent().getBackground());
                graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
                junDrawingMapView.displayCanvasOn_(graphics2D);
                ArrayList arrayList = (ArrayList)junDrawingMap.selectedElements().clone();
                JunDrawingElement[] junDrawingElementArray = junDrawingMap._componentElements();
                for (int i = 0; i < junDrawingElementArray.length; ++i) {
                    if (junDrawingElementArray[i].intersects_(rectangle2)) {
                        junDrawingMap.addSelectedElement_(junDrawingElementArray[i]);
                        continue;
                    }
                    junDrawingMap.removeSelectedElement_(junDrawingElementArray[i]);
                }
                if (!arrayList.equals(junDrawingMap.selectedElements())) {
                    junDrawingMap.changed_(JunDrawingMapController.$((String)"selection"));
                }
                Rectangle rectangle3 = new Rectangle(rectangle2);
                if (bl) {
                    rectangle3.grow(5, 5);
                }
                graphics2D.setColor(new Color(0xFF8080));
                graphics2D.setClip(rectangle3.x, rectangle3.y, rectangle3.width + 1, rectangle3.height + 1);
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                    graphics2D = null;
                }
            }
            if (rectangle != null) {
                rectangle2.add(rectangle);
            }
            junDrawingMapView.displayCanvasOn_scaledImage_unscaledClip_(this.view().toComponent().getGraphics(), image, rectangle2);
        }
        this.previousPoint = point;
    }

    protected void moveElement_with_(JunDrawingElement junDrawingElement, Point point) {
        Cloneable cloneable;
        Object[] objectArray;
        Object object;
        Object object2;
        if (this.movingElements == null || this.offsetPoint == null || this.linkedElements == null) {
            int n;
            object2 = this.getDrawingMapModel().mapObject();
            object = new ArrayList(((JunDrawingMap)object2).selectedElements());
            JunDrawingElement[] junDrawingElementArray = ((ArrayList)object).toArray(new JunDrawingElement[((ArrayList)object).size()]);
            for (n = 0; n < junDrawingElementArray.length; ++n) {
                if (junDrawingElement == junDrawingElementArray[n] || !junDrawingElementArray[n].isLabel() || !((JunDrawingMap)object2).selectedElements().contains(((JunLabelElement)junDrawingElementArray[n]).baseElement())) continue;
                ((ArrayList)object).remove(junDrawingElementArray[n]);
            }
            junDrawingElementArray = ((ArrayList)object).toArray(new JunDrawingElement[((ArrayList)object).size()]);
            this.movingElements = new Object[junDrawingElementArray.length][2];
            for (n = 0; n < junDrawingElementArray.length; ++n) {
                if (junDrawingElementArray[n].isLink()) {
                    objectArray = ((JunLinkElement)junDrawingElementArray[n])._points();
                    Point[] pointArray = new Point[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        pointArray[i] = new Point(new Point(((Point)objectArray[i]).x - junDrawingElement.x(), ((Point)objectArray[i]).y - junDrawingElement.y()));
                    }
                    this.movingElements[n] = new Object[]{junDrawingElementArray[n], pointArray};
                    continue;
                }
                this.movingElements[n] = new Object[]{junDrawingElementArray[n], new Point[]{new Point(junDrawingElementArray[n].x() - junDrawingElement.x(), junDrawingElementArray[n].y() - junDrawingElement.y())}};
            }
            this.offsetPoint = new Point(point.x - junDrawingElement.x(), point.y - junDrawingElement.y());
            cloneable = new ArrayList();
            objectArray = ((JunDrawingMap)object2)._linkElements();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!((ArrayList)object).contains(objectArray[i]) && !((ArrayList)object).contains(((JunLinkElement)objectArray[i]).fromElement()) && !((ArrayList)object).contains(((JunLinkElement)objectArray[i]).toElement())) continue;
                ((ArrayList)cloneable).add(objectArray[i]);
            }
            this.linkedElements = ((ArrayList)cloneable).toArray(new JunLinkElement[((ArrayList)cloneable).size()]);
        }
        if (this.previousPoint != null && !point.equals(this.previousPoint)) {
            int n;
            object2 = new Point(point.x - this.offsetPoint.x, point.y - this.offsetPoint.y);
            object = null;
            for (n = 0; n < this.linkedElements.length; ++n) {
                cloneable = new Rectangle(this.linkedElements[n].bounds());
                if (this.linkedElements[n].hasLabel()) {
                    ((Rectangle)cloneable).add(this.linkedElements[n].labelElement().bounds());
                }
                if (object != null) {
                    ((Rectangle)object).add((Rectangle)cloneable);
                    continue;
                }
                object = cloneable;
            }
            for (n = 0; n < this.movingElements.length; ++n) {
                cloneable = (JunDrawingElement)this.movingElements[n][0];
                objectArray = (Point[])this.movingElements[n][1];
                Rectangle rectangle = new Rectangle(((JunDrawingVisual)((Object)cloneable)).bounds());
                if (((JunDrawingVisual)((Object)cloneable)).isLink() && ((JunDrawingVisual)((Object)cloneable)).hasLabel()) {
                    rectangle.add(((JunLinkElement)((Object)cloneable)).labelElement().bounds());
                }
                if (((JunDrawingVisual)((Object)cloneable)).isLink()) {
                    JunLinkElement junLinkElement = (JunLinkElement)((Object)cloneable);
                    if (objectArray.length > 2) {
                        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (i == 0 && i == objectArray.length - 1) {
                                arrayList.add(objectArray[i]);
                                continue;
                            }
                            arrayList.add(new Point(Math.max(((Point)object2).x + ((Point)objectArray[i]).x, 0), Math.max(((Point)object2).y + ((Point)objectArray[i]).y, 0)));
                        }
                        junLinkElement.points_(arrayList);
                    }
                } else {
                    ((JunDrawingVisual)((Object)cloneable)).location_(new Point(((Point)object2).x + ((Point)objectArray[0]).x, ((Point)object2).y + ((Point)objectArray[0]).y));
                }
                rectangle.add(((JunDrawingVisual)((Object)cloneable)).bounds());
                if (((JunDrawingVisual)((Object)cloneable)).isLink() && ((JunLinkElement)((Object)cloneable)).hasLabel()) {
                    rectangle.add(((JunLinkElement)((Object)cloneable)).labelElement().bounds());
                }
                if (object != null) {
                    ((Rectangle)object).add(rectangle);
                    continue;
                }
                object = new Rectangle(rectangle);
            }
            for (n = 0; n < this.linkedElements.length; ++n) {
                this.linkedElements[n].updateFromToPoint();
                cloneable = new Rectangle(this.linkedElements[n].bounds());
                if (this.linkedElements[n].hasLabel()) {
                    ((Rectangle)cloneable).add(this.linkedElements[n].labelElement().bounds());
                }
                ((Rectangle)object).add((Rectangle)cloneable);
            }
            ((Rectangle)object).grow(3, 3);
            this.getDrawingMapView()._invalidateRectangle_repairNow_((Rectangle)object, true);
        }
        this.previousPoint = point;
    }

    protected void movePoint_(MouseEvent mouseEvent) {
        int n;
        StSymbol stSymbol;
        int n2;
        Point point = this.cursorPointInModel_(mouseEvent.getPoint());
        JunDrawingMap junDrawingMap = this.getDrawingMapModel().mapObject();
        JunDrawingElement[] junDrawingElementArray = junDrawingMap._selectedElements();
        ArrayList arrayList = junDrawingMap.selectedElements();
        JunDrawingElement junDrawingElement = junDrawingMap.currentElement();
        if (this.scaleCollection == null) {
            this.scaleCollection = new Jun2dPoint[junDrawingElementArray.length][2];
            boolean bl = mouseEvent.isAltDown() || mouseEvent.isMetaDown();
            for (n2 = 0; n2 < junDrawingElementArray.length; ++n2) {
                stSymbol = junDrawingElementArray[n2];
                this.scaleCollection[n2][0] = bl ? new Jun2dPoint(1.0, 1.0) : new Jun2dPoint((double)stSymbol.x() / (double)junDrawingElement.x(), (double)stSymbol.y() / (double)junDrawingElement.y());
                this.scaleCollection[n2][1] = bl ? new Jun2dPoint(1.0, 1.0) : new Jun2dPoint((double)stSymbol.width() / (double)junDrawingElement.width(), (double)stSymbol.height() / (double)junDrawingElement.height());
            }
        }
        if (this.controllPointSymbol == null && this.linkedElements == null && this.previousPoint != null) {
            HashMap hashMap = junDrawingElement.controllPointAreas();
            Object object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                stSymbol = (StSymbol)object.next();
                Rectangle rectangle = (Rectangle)hashMap.get(stSymbol);
                if (!rectangle.contains(this.previousPoint)) continue;
                this.controllPointSymbol = stSymbol;
            }
            object = new ArrayList();
            stSymbol = junDrawingMap._linkElements();
            for (n = 0; n < ((JunLinkElement[])stSymbol).length; ++n) {
                if (!arrayList.contains(stSymbol[n].fromElement()) && !arrayList.contains(stSymbol[n].toElement())) continue;
                ((ArrayList)object).add(stSymbol[n]);
            }
            this.linkedElements = ((ArrayList)object).toArray(new JunLinkElement[((ArrayList)object).size()]);
        }
        if (this.previousPoint != null && !point.equals(this.previousPoint)) {
            if (junDrawingElement.isLink() || junDrawingElement.isPath()) {
                Rectangle rectangle = new Rectangle(junDrawingElement.bounds());
                if (junDrawingElement.isLink() && junDrawingElement.hasLabel()) {
                    rectangle.add(((JunLinkElement)junDrawingElement).labelElement().bounds());
                }
                junDrawingElement.controllPointAt_put_(this.controllPointSymbol, point);
                if (junDrawingElement.isLink()) {
                    ((JunLinkElement)junDrawingElement).updateFromToPoint();
                }
                rectangle.add(junDrawingElement.bounds());
                if (junDrawingElement.isLink() && junDrawingElement.hasLabel()) {
                    rectangle.add(((JunLinkElement)junDrawingElement).labelElement().bounds());
                }
                rectangle.grow(3, 3);
                this.getDrawingMapView()._invalidateRectangle_repairNow_(rectangle, true);
            } else if (junDrawingElement.isNode()) {
                int n3;
                Rectangle rectangle = null;
                for (n2 = 0; n2 < this.linkedElements.length; ++n2) {
                    if (rectangle != null) {
                        rectangle.add(this.linkedElements[n2].bounds());
                    } else {
                        rectangle = new Rectangle(this.linkedElements[n2].bounds());
                    }
                    if (!this.linkedElements[n2].hasLabel()) continue;
                    rectangle.add(this.linkedElements[n2].labelElement().bounds());
                }
                n2 = this.controllPointSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || this.controllPointSymbol == JunDrawingElement.CONTROLL_POINT_TOP_RIGHT ? 1 : 0;
                boolean bl = this.controllPointSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || this.controllPointSymbol == JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT;
                n = Math.max(point.x, 0) - junDrawingElement.x();
                int n4 = Math.max(point.y, 0) - junDrawingElement.y();
                for (n3 = 0; n3 < junDrawingElementArray.length; ++n3) {
                    int n5;
                    JunDrawingElement junDrawingElement2 = junDrawingElementArray[n3];
                    if (junDrawingElement2.isLink()) continue;
                    Rectangle rectangle2 = junDrawingElement2.bounds();
                    if (rectangle != null) {
                        rectangle.add(rectangle2);
                    } else {
                        rectangle = new Rectangle(rectangle2);
                    }
                    int n6 = bl ? Math.max(rectangle2.x + (int)Math.round((double)n * this.scaleCollection[n3][1].x()), 0) : rectangle2.x;
                    int n7 = n2 != 0 ? Math.max(rectangle2.y + (int)Math.round((double)n4 * this.scaleCollection[n3][1].y()), 0) : rectangle2.y;
                    int n8 = bl ? rectangle2.width + (rectangle2.x - n6) : Math.max((int)Math.round((double)(point.x - junDrawingElement.x()) * this.scaleCollection[n3][1].x()), junDrawingElement2.defaultMinimumExtent().width);
                    int n9 = n5 = n2 != 0 ? rectangle2.height + (rectangle2.y - n7) : Math.max((int)Math.round((double)(point.y - junDrawingElement.y()) * this.scaleCollection[n3][1].y()), junDrawingElement2.defaultMinimumExtent().height);
                    if (n8 < junDrawingElement2.defaultMinimumExtent().width) {
                        n6 += n8 - junDrawingElement2.defaultMinimumExtent().width;
                        n8 = junDrawingElement2.defaultMinimumExtent().width;
                    }
                    if (n5 < junDrawingElement2.defaultMinimumExtent().height) {
                        n7 += n5 - junDrawingElement2.defaultMinimumExtent().height;
                        n5 = junDrawingElement2.defaultMinimumExtent().height;
                    }
                    junDrawingElement2.bounds_(new Rectangle(n6, n7, n8, n5));
                    rectangle.add(junDrawingElement2.bounds());
                }
                for (n3 = 0; n3 < this.linkedElements.length; ++n3) {
                    this.linkedElements[n3].updateFromToPoint();
                    rectangle.add(this.linkedElements[n3].bounds());
                    if (!this.linkedElements[n3].hasLabel()) continue;
                    rectangle.add(this.linkedElements[n3].labelElement().bounds());
                }
                rectangle.grow(3, 3);
                this.getDrawingMapView()._invalidateRectangle_repairNow_(rectangle, true);
            }
        }
        this.previousPoint = point;
    }

    protected void addLink_(Point point) {
        Object object;
        JunDrawingMapModel junDrawingMapModel = this.getDrawingMapModel();
        JunDrawingMap junDrawingMap = junDrawingMapModel.mapObject();
        JunDrawingElement junDrawingElement = junDrawingMap.currentElement();
        JunDrawingElement junDrawingElement2 = junDrawingMap.which_(point);
        if (junDrawingElement == null || junDrawingElement2 == null) {
            junDrawingMap.changed_(JunDrawingMapController.$((String)"redisplay"));
            return;
        }
        if (!junDrawingElement.isNode() || !junDrawingElement2.isNode()) {
            JunDialog.Warn_(JunDrawingMapController.$String((String)"The selected element cannot create a link."));
            junDrawingMap.changed_(JunDrawingMapController.$((String)"redisplay"));
            return;
        }
        JunPathElement junPathElement = null;
        if (junDrawingElement == junDrawingElement2) {
            object = junDrawingElement.center();
            junPathElement = new JunPathElement();
            junPathElement.add_((Point)object);
            junPathElement.add_(new Point(((Point)object).x, junDrawingElement.y() + junDrawingElement.height() + 20));
            junPathElement.add_(new Point(junDrawingElement.x() + junDrawingElement.width() + 20, junDrawingElement.y() + junDrawingElement.height() + 20));
            junPathElement.add_(new Point(junDrawingElement.x() + junDrawingElement.width() + 20, ((Point)object).y));
            junPathElement.add_((Point)object);
            junPathElement.beginStyle_(0);
            junPathElement.beginStyle_(1);
        }
        object = new JunLinkElement((JunNodeElement)junDrawingElement, (JunNodeElement)junDrawingElement2, junPathElement);
        junDrawingMapModel.addElement_((JunDrawingElement)object);
        junDrawingMap.clearSelectedElements();
        junDrawingMap.addSelectedElement_(((JunLinkElement)object).fromElement());
        junDrawingMap.addSelectedElement_(((JunLinkElement)object).toElement());
        junDrawingMap.addSelectedElement_((JunDrawingElement)object);
        junDrawingMap.changed_(JunDrawingMapController.$((String)"redisplay"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayLinkPointFrom_to_(Point point, Point point2) {
        Object object;
        Rectangle rectangle = this.previousPoint != null ? StRectangle.Vertex_vertex_((Point)this.startPoint, (Point)this.previousPoint).toRectangle() : null;
        JunDrawingMapView junDrawingMapView = this.getDrawingMapView();
        Image image = this.previousPoint == null ? junDrawingMapView.createOffScreen() : junDrawingMapView.offScreen();
        Graphics2D graphics2D = junDrawingMapView.graphicsWithZoomFrom_(image);
        try {
            if (rectangle != null) {
                if (this.getDrawingMapModel().isZooming()) {
                    object = this.getDrawingMapModel().scalePoint();
                    if (object.x() < 0.2 || object.y() < 0.2) {
                        rectangle.grow((int)(1.0 / object.x()), (int)(1.0 / object.y()));
                    } else {
                        rectangle.grow(5, 5);
                    }
                }
                graphics2D.setColor(this.view().toComponent().getBackground());
                graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
                junDrawingMapView.displayCanvasOn_(graphics2D);
            }
            object = new Rectangle(point, new Dimension(1, 1));
            ((Rectangle)object).add(point2);
            graphics2D.setClip(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            this.displayOn_lineSegment_(graphics2D, new Point[]{point, point2});
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
        object = StRectangle.Vertex_vertex_((Point)point, (Point)point2).toRectangle();
        if (rectangle != null) {
            ((Rectangle)object).add(rectangle);
        }
        junDrawingMapView.displayCanvasOn_scaledImage_unscaledClip_(this.view().toComponent().getGraphics(), image, (Rectangle)object);
        if (this.previousPoint == null) {
            this.view().toComponent().setCursor(JunCursors.BullCursor());
            this.dragType = 4;
            this.startPoint = point;
        }
        this.previousPoint = point2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayLocusPoint_(Point point) {
        JunDrawingMapView junDrawingMapView = this.getDrawingMapView();
        Image image = junDrawingMapView.createOffScreen();
        Graphics2D graphics2D = junDrawingMapView.graphicsWithZoomFrom_(image);
        if (this.trackPoints.size() == 0 || this.trackPoints.size() > 0 && (Point)this.trackPoints.get(this.trackPoints.size() - 1) != point) {
            this.trackPoints.add(new Point(Math.max(0, point.x), Math.max(0, point.y)));
        }
        Point[] pointArray = this.trackPoints.toArray(new Point[this.trackPoints.size()]);
        try {
            this.displayOn_polyline_(graphics2D, pointArray);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
        Rectangle rectangle = null;
        for (int i = 0; i < pointArray.length; ++i) {
            if (rectangle == null) {
                rectangle = new Rectangle(pointArray[i].x, pointArray[i].y, 1, 1);
                continue;
            }
            rectangle.add(pointArray[i].x, pointArray[i].y);
        }
        junDrawingMapView.displayCanvasOn_scaledImage_unscaledClip_(this.view().toComponent().getGraphics(), image, rectangle);
        if (this.previousPoint == null) {
            this.dragType = 5;
            this.startPoint = pointArray[0];
        }
        this.previousPoint = pointArray[pointArray.length - 1];
    }

    protected void displayOn_lineSegment_(Graphics graphics, Point[] pointArray) {
        if (pointArray != null) {
            graphics.setColor(this.view().toComponent().getBackground());
            graphics.setXORMode(Color.gray);
            for (int i = 0; i < pointArray.length - 1; ++i) {
                graphics.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i + 1].y);
            }
        }
    }

    protected void displayOn_polyline_(Graphics graphics, Point[] pointArray) {
        if (pointArray != null) {
            graphics.setColor(Color.blue);
            int[] nArray = new int[pointArray.length];
            int[] nArray2 = new int[pointArray.length];
            for (int i = 0; i < pointArray.length; ++i) {
                nArray[i] = pointArray[i].x;
                nArray2[i] = pointArray[i].y;
            }
            graphics.drawPolyline(nArray, nArray2, pointArray.length);
        }
    }

    public Point cursorPointInModel() {
        return this.cursorPointInModel_(this.cursorPoint());
    }

    public Point cursorPointInModel_(Point point) {
        return new Point((int)((double)point.x / this.getDrawingMapModel().scalePoint().x()), (int)((double)point.y / this.getDrawingMapModel().scalePoint().y()));
    }
}

