/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.dump;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jp.co.sra.jun.goodies.dump.JunDumpView;
import jp.co.sra.jun.goodies.dump.JunDumpViewAwt;
import jp.co.sra.jun.goodies.dump.JunDumpViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunDumpModel
extends JunApplicationModel {
    protected byte[] byteArray;
    protected int startAddress;
    protected StValueHolder textModel;

    public JunDumpModel(byte[] byArray) {
        this.bytes_start_(byArray, 0);
    }

    public JunDumpModel(File file) {
        this(file, 0, 0);
    }

    public JunDumpModel(File file, int n) {
        this(file, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunDumpModel(File file, int n, int n2) {
        byte[] byArray = null;
        long l = file.length();
        long l2 = n2 <= 0 ? l : Math.min((long)n2, l);
        int n3 = (int)Math.min((long)n, l2);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            outputStream = new ByteArrayOutputStream(1024);
            inputStream.skip(n3);
            int n4 = 0;
            while ((long)n4 < l2 - (long)n3) {
                ((ByteArrayOutputStream)outputStream).write(inputStream.read());
                ++n4;
            }
            byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            byArray = new byte[]{};
        }
        catch (IOException iOException) {
            byArray = new byte[]{};
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((ByteArrayOutputStream)outputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        this.bytes_start_(byArray, n3);
    }

    public byte[] bytes() {
        if (this.byteArray == null) {
            this.byteArray = new byte[0];
        }
        return this.byteArray;
    }

    public StView defaultView() {
        if (JunDumpModel.GetDefaultViewMode() == 0) {
            return new JunDumpViewAwt(this);
        }
        return new JunDumpViewSwing(this);
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (object == this) {
            return true;
        }
        if (!(object instanceof JunDumpModel)) {
            return false;
        }
        if (this.start() != ((JunDumpModel)((Object)object)).start()) {
            return false;
        }
        byte[] byArray2 = this.bytes();
        if (byArray2.length != (byArray = ((JunDumpModel)((Object)object)).bytes()).length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public void printOn_(Writer writer) throws IOException {
        String string = (String)this.textModel().value();
        if (string == null) {
            string = "null";
        }
        writer.write(string);
    }

    public int start() {
        return this.startAddress;
    }

    public int stop() {
        return this.bytes().length;
    }

    public StValueHolder textModel() {
        if (this.textModel == null) {
            this.textModel = new StValueHolder((Object)new String());
        }
        return this.textModel;
    }

    protected String addressString_(int n) {
        StringWriter stringWriter = new StringWriter(9);
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() > 8) {
            string = string.substring(string.length() - 8);
        } else {
            for (int i = 8 - string.length(); i > 0; --i) {
                stringWriter.write(48);
            }
        }
        stringWriter.write(string);
        stringWriter.write(58);
        return stringWriter.toString();
    }

    protected void bytes_start_(byte[] byArray, int n) {
        this.byteArray = byArray;
        this.startAddress = n;
        this.textModel().value_((Object)this.dump());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String dump() {
        StringWriter stringWriter = new StringWriter(1024);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            int n = this.start();
            StringWriter stringWriter2 = new StringWriter(16);
            if (n % 16 != 0) {
                printWriter.write(this.addressString_(n - n % 16));
                for (int i = 0; i < n % 16; ++i) {
                    if (i % 8 == 0) {
                        printWriter.write(32);
                    }
                    if (i % 2 == 0) {
                        printWriter.write(32);
                    }
                    printWriter.write("  ");
                    stringWriter2.write(32);
                }
            }
            byte[] byArray = this.bytes();
            for (int i = 0; i < byArray.length; ++i) {
                if (n % 16 == 0) {
                    printWriter.write(this.addressString_(n));
                }
                if (n % 8 == 0) {
                    printWriter.write(32);
                }
                if (n % 2 == 0) {
                    printWriter.write(32);
                }
                try {
                    String string = Integer.toHexString(byArray[i] & 0xFF).toUpperCase();
                    for (int j = 2 - string.length(); j > 0; --j) {
                        printWriter.write(48);
                    }
                    printWriter.write(string);
                    stringWriter2.write(this.printable_(byArray[i]));
                    continue;
                }
                finally {
                    if (++n % 16 == 0) {
                        printWriter.write("  ");
                        printWriter.println(stringWriter2.toString());
                        stringWriter2 = new StringWriter(16);
                    }
                }
            }
            while (n % 16 != 0) {
                if (n % 8 == 0) {
                    printWriter.write(32);
                }
                if (n % 2 == 0) {
                    printWriter.write(32);
                }
                try {
                    printWriter.write("  ");
                }
                finally {
                    if (++n % 16 != 0) continue;
                    printWriter.write("  ");
                    printWriter.println(stringWriter2.toString());
                    stringWriter2 = new StringWriter(16);
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        return stringWriter.toString();
    }

    protected void initialize() {
        super.initialize();
        this.byteArray = null;
        this.startAddress = 0;
        this.textModel = null;
    }

    protected char printable_(byte by) {
        if (33 <= by && by <= 126) {
            return (char)by;
        }
        return ' ';
    }

    protected String windowTitle() {
        return JunDumpModel.$String((String)"Dump");
    }

    public StView getView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunDumpView) || ((JunDumpView)dependentListenerArray[i]).model() != this) continue;
            return (JunDumpView)dependentListenerArray[i];
        }
        return null;
    }
}

