/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.gauge;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.gauge.JunGaugeView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;

public class JunGaugeController
extends JunAbstractController {
    protected boolean _adjusting;

    public JunGaugeView getGaugeView() {
        return (JunGaugeView)this.view();
    }

    protected void buildListener(StView stView) {
        stView.toComponent().addMouseListener((MouseListener)((Object)this));
        stView.toComponent().addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this._adjusting = this.getGaugeView().gaugeBorder().containsPoint_(point);
        if (this._adjusting) {
            this.setValueAt(point);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._adjusting = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursorAt(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setCursorAt(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.setValueAt(mouseEvent.getPoint());
        Thread.yield();
    }

    protected void setCursorAt(Point point) {
        StRectangle stRectangle = this.getGaugeView().gaugeBorder();
        if (stRectangle.containsPoint_(point)) {
            this.getGaugeView().toComponent().setCursor(JunCursors.CrossCursor());
        } else {
            this.getGaugeView().toComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void setValueAt(Point point) {
        StRectangle stRectangle = this.getGaugeView().gaugeBorder();
        double d = point.y - stRectangle.originY();
        d = 1.0 - d / (double)stRectangle.height();
        this.getGaugeView().getGaugeModel().normalizedValue_(d);
    }
}

