/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.gauge;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import jp.co.sra.jun.goodies.gauge.JunGaugeController;
import jp.co.sra.jun.goodies.gauge.JunGaugeModel;
import jp.co.sra.jun.goodies.gauge.JunGaugeView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewPanel;

public class JunGaugeViewAwt
extends JunAbstractViewCanvas
implements JunGaugeView {
    protected Object[] scalesLayout;

    public static StView _OnBorderedPanel(JunGaugeModel junGaugeModel) {
        return new StViewPanel((StModel)junGaugeModel){
            protected JunGaugeViewAwt gaugeView;

            protected void buildComponent() {
                this.gaugeView = new JunGaugeViewAwt((JunGaugeModel)this.model());
                this.setLayout(new BorderLayout());
                this.add(this.gaugeView._onBorderedPanel(), "Center");
            }

            public void _setupKeyboard(Window window) {
                this.gaugeView._setupKeyboard(window);
            }
        };
    }

    public JunGaugeViewAwt(JunGaugeModel junGaugeModel) {
        super(junGaugeModel);
    }

    public JunGaugeModel getGaugeModel() {
        return (JunGaugeModel)this.model();
    }

    protected StController defaultController() {
        return new JunGaugeController();
    }

    protected void buildComponent() {
        this.setSize(120, 180);
    }

    public StRectangle gaugeBorder() {
        StRectangle stRectangle = new StRectangle(this.getBounds()).insetBy_(this.defaultMargin());
        int n = stRectangle.left() + this.gaugeScalesExtent().width + 13;
        return new StRectangle(n, stRectangle.top(), stRectangle.right(), stRectangle.bottom());
    }

    protected double[][] gaugeScales() {
        return (double[][])this.scalesLayout()[0];
    }

    protected Dimension gaugeScalesExtent() {
        return (Dimension)this.scalesLayout()[1];
    }

    protected String valueString_(double d) {
        return (String)this.getGaugeModel().valueStringBlock().value_((Object)new Double(d));
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayBorderOn_(graphics);
        this.displayScalesOn_(graphics);
        this.displayValueOn_(graphics);
    }

    protected void displayBorderOn_(Graphics graphics) {
        StRectangle stRectangle = this.gaugeBorder();
        graphics.setColor(StColorValue.Brightness_((double)0.75));
        graphics.drawLine(stRectangle.left(), stRectangle.bottom(), stRectangle.right(), stRectangle.bottom());
        graphics.setColor(StColorValue.Brightness_((double)0.75));
        graphics.drawLine(stRectangle.right(), stRectangle.top(), stRectangle.right(), stRectangle.bottom());
        graphics.setColor(StColorValue.Brightness_((double)0.25));
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.right(), stRectangle.top());
        graphics.setColor(StColorValue.Brightness_((double)0.25));
        graphics.drawLine(stRectangle.left(), stRectangle.top(), stRectangle.left(), stRectangle.bottom());
    }

    protected void displayScalesOn_(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.getForeground());
        StRectangle stRectangle = new StRectangle(this.getBounds()).insetBy_(this.defaultMargin());
        Dimension dimension = this.gaugeScalesExtent();
        double[][] dArray = this.gaugeScales();
        for (int i = 0; i < dArray.length; ++i) {
            String string = this.valueString_(dArray[i][0]);
            double d = dArray[i][1];
            int n = stRectangle.left() + dimension.width - fontMetrics.stringWidth(string);
            int n2 = stRectangle.top() + (int)((double)stRectangle.height() * (1.0 - d)) + fontMetrics.getDescent();
            graphics.drawString(string, n, n2);
            n = stRectangle.left() + dimension.width;
            n2 = stRectangle.top() + (int)((double)stRectangle.height() * (1.0 - d));
            graphics.drawLine(n + 3, n2, n + 7, n2);
        }
    }

    protected void displayValueOn_(Graphics graphics) {
        double d = this.getGaugeModel().normalizedValue();
        StRectangle stRectangle = this.gaugeBorder().insetBy_(new StRectangle(1, 1, 0, 0));
        int n = (int)((double)stRectangle.height() * (1.0 - d));
        graphics.setColor(SelectionForegroundColor);
        graphics.fillRect(stRectangle.originX(), stRectangle.originY(), stRectangle.width(), n);
        graphics.setColor(SelectionBackgroundColor);
        graphics.fillRect(stRectangle.originX(), stRectangle.originY() + n, stRectangle.width(), stRectangle.height() - n);
    }

    protected StRectangle defaultMargin() {
        return new StRectangle(10, 10, 10, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] scalesLayout() {
        if (this.scalesLayout == null) {
            Graphics graphics = null;
            try {
                graphics = this.getGraphics();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                JunGaugeModel junGaugeModel = this.getGaugeModel();
                double d = (junGaugeModel.toValue() - junGaugeModel.fromValue()) / junGaugeModel.divideValue();
                ArrayList<double[]> arrayList = new ArrayList<double[]>();
                arrayList.add(new double[]{junGaugeModel.fromValue(), 0.0});
                int n = fontMetrics.stringWidth(this.valueString_(junGaugeModel.fromValue()));
                double d2 = junGaugeModel.fromValue();
                double d3 = 0.0;
                int n2 = 1;
                while ((double)n2 < junGaugeModel.divideValue()) {
                    arrayList.add(new double[]{d2 += d, d3 += 1.0 / junGaugeModel.divideValue()});
                    n = Math.max(n, fontMetrics.stringWidth(this.valueString_(junGaugeModel._doubleValue())));
                    ++n2;
                }
                arrayList.add(new double[]{junGaugeModel.toValue(), 1.0});
                n = Math.max(n, fontMetrics.stringWidth(this.valueString_(junGaugeModel.toValue())));
                this.scalesLayout = new Object[]{arrayList.toArray((T[])new double[arrayList.size()][]), new Dimension(n, fontMetrics.getHeight())};
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
        }
        return this.scalesLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunGaugeViewAwt.$((String)"value")) {
            Graphics graphics = null;
            try {
                graphics = this.getGraphics();
                this.displayValueOn_(graphics);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
        } else if (dependentEvent.getAspect() == JunGaugeViewAwt.$((String)"range")) {
            this.flushScalesLayout();
            this.repaint();
        } else {
            super.update_(dependentEvent);
        }
    }

    protected void flushScalesLayout() {
        this.scalesLayout = null;
    }

    public void _setupKeyboard(final Window window) {
        this.addKeyListener(this.getGaugeModel()._keyListener());
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                Component component = window.getFocusOwner();
                if (component != null && component != JunGaugeViewAwt.this) {
                    JunGaugeViewAwt.this.requestFocus();
                }
            }
        });
    }
}

