/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunSraBmpImageStream;
import jp.co.sra.smalltalk.StImage;

public class JunBmpImageStream
extends JunImageStream {
    public static String DefaultImageExtension = "bmp";

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        String[] stringArray = ImageIO.getReaderFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!DefaultImageExtension.equals(stringArray[i])) continue;
            return JunBmpImageStream.On_((JunImageStream)new JunBmpImageStream(), inputStream);
        }
        return JunBmpImageStream.On_(JunBmpImageStream._CreateImageStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!DefaultImageExtension.equals(stringArray[i])) continue;
            return JunBmpImageStream.On_((JunImageStream)new JunBmpImageStream(), outputStream);
        }
        return JunBmpImageStream.On_(JunBmpImageStream._CreateImageStream(), outputStream);
    }

    protected static JunImageStream _CreateImageStream() {
        JunImageStream junImageStream = null;
        try {
            Class.forName("com.sun.jimi.core.Jimi");
            junImageStream = (JunImageStream)((Object)Class.forName("jp.co.sra.jun.goodies.image.streams.JunJimiBmpImageStream").newInstance());
        }
        catch (Throwable throwable) {
            try {
                Class.forName("com.sun.media.jai.codec.ImageCodec");
                junImageStream = (JunImageStream)((Object)Class.forName("jp.co.sra.jun.goodies.image.streams.JunJaiBmpImageStream").newInstance());
            }
            catch (Throwable throwable2) {
                junImageStream = new JunSraBmpImageStream();
            }
        }
        return junImageStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage nextImage() throws IOException {
        if (this.inStream == null) {
            throw new IIOException("the inStream is null.");
        }
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            imageReader = ImageIO.getImageReadersBySuffix(this.defaultImageExtension()).next();
            imageInputStream = ImageIO.createImageInputStream(this.inStream);
            imageReader.setInput(imageInputStream);
            this.imageObject = new StImage((Image)imageReader.read(0));
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageReader != null) {
                imageReader.reset();
                imageReader.dispose();
            }
        }
        return this.imageObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextPutImage_(StImage stImage) throws IOException {
        if (this.outStream == null) {
            throw new IIOException("the outStream is null.");
        }
        BufferedImage bufferedImage = new BufferedImage(stImage.width(), stImage.height(), 5);
        bufferedImage.setRGB(0, 0, stImage.width(), stImage.height(), stImage.getPixels(), 0, stImage.width());
        ImageWriter imageWriter = null;
        ImageInputStream imageInputStream = null;
        try {
            imageWriter = ImageIO.getImageWritersBySuffix(this.defaultImageExtension()).next();
            imageInputStream = ImageIO.createImageOutputStream(this.outStream);
            imageWriter.setOutput(imageInputStream);
            imageWriter.write(bufferedImage);
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageWriter != null) {
                imageWriter.reset();
                imageWriter.dispose();
            }
        }
    }

    public String defaultImageExtension() {
        return DefaultImageExtension;
    }
}

