/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.smalltalk.StImage;

public class JunDefaultImageStream
extends JunImageStream {
    public static JunImageStream On_(InputStream inputStream) throws IOException {
        return JunDefaultImageStream.On_((JunImageStream)new JunDefaultImageStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        throw new IOException("could not save image");
    }

    public StImage nextImage() throws IOException {
        if (this.inStream != null) {
            Frame frame = new Frame();
            Toolkit toolkit = frame.getToolkit();
            Image image = toolkit.createImage(this.readInputStream());
            MediaTracker mediaTracker = new MediaTracker(frame);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("image load interrupted.");
            }
            int n = mediaTracker.statusAll(false);
            if ((n & 2) != 0 || (n & 4) != 0) {
                throw new IOException("image load interrupted.");
            }
            image.flush();
            this.imageObject = new StImage(image);
        }
        return this.imageObject;
    }

    public void nextPutImage_(StImage stImage) throws IOException {
        throw new IOException("could not save image");
    }

    protected void on_(OutputStream outputStream) throws IOException {
        throw new IOException("could not save image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readInputStream() throws IOException {
        byte[] byArray = null;
        if (this.inStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                int n;
                byteArrayOutputStream = new ByteArrayOutputStream();
                filterOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                byte[] byArray2 = new byte[5120];
                while ((n = this.inStream.read(byArray2, 0, byArray2.length)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray2, 0, n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                    filterOutputStream = null;
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
        }
        return byArray;
    }

    public String defaultImageExtension() {
        return "*";
    }
}

